/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCall
implements LocationInfoProvider {
    protected int typeArguments;
    protected String expression;
    protected List<String> arguments;
    protected LocationInfo locationInfo;
    protected StatementCoverageType coverage = StatementCoverageType.NONE;

    public String getExpression() {
        return this.expression;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public StatementCoverageType getCoverage() {
        return this.coverage;
    }

    public abstract boolean identicalName(AbstractCall var1);

    public abstract String getName();

    public abstract double normalizedNameDistance(AbstractCall var1);

    public abstract AbstractCall update(String var1, String var2);

    public boolean matchesOperation(VariableDeclarationContainer operation, VariableDeclarationContainer callerOperation, UMLModelDiff modelDiff) {
        if (this instanceof OperationInvocation) {
            return ((OperationInvocation)this).matchesOperation(operation, callerOperation, modelDiff);
        }
        return false;
    }

    public boolean compatibleExpression(AbstractCall other) {
        if (this instanceof OperationInvocation && other instanceof OperationInvocation) {
            return ((OperationInvocation)this).compatibleExpression((OperationInvocation)other);
        }
        if (this.expression != null && other.expression != null) {
            return this.expression.equals(other.expression);
        }
        return false;
    }

    public boolean differentExpressionNameAndArguments(AbstractCall other) {
        boolean differentExpression = false;
        if (this.expression == null && other.expression != null) {
            differentExpression = true;
        }
        if (this.expression != null && other.expression == null) {
            differentExpression = true;
        }
        if (this.expression != null && other.expression != null) {
            differentExpression = !this.expression.equals(other.expression) && !this.expression.startsWith(other.expression) && !other.expression.startsWith(this.expression);
        }
        boolean differentName = !this.getName().equals(other.getName());
        LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(this.arguments);
        argumentIntersection.retainAll(other.arguments);
        boolean argumentFoundInExpression = false;
        if (this.expression != null) {
            for (String argument : other.arguments) {
                if (!this.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
            }
        }
        if (other.expression != null) {
            for (String argument : this.arguments) {
                if (!other.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
            }
        }
        boolean differentArguments = !this.arguments.equals(other.arguments) && argumentIntersection.isEmpty() && !argumentFoundInExpression;
        return differentExpression && differentName && differentArguments;
    }

    public String actualString() {
        StringBuilder sb = new StringBuilder();
        if (this.expression != null) {
            sb.append(this.expression).append(".");
        }
        sb.append(this.getName());
        sb.append("(");
        int size = this.arguments.size();
        if (size > 0) {
            for (int i = 0; i < size - 1; ++i) {
                sb.append(this.arguments.get(i)).append(",");
            }
            sb.append(this.arguments.get(size - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean expressionIsNullOrThis() {
        if (this.expression == null) {
            return true;
        }
        return this.expression.equals("this");
    }

    public boolean identicalExpression(AbstractCall call, Set<Replacement> replacements) {
        return this.identicalExpression(call) || this.identicalExpressionAfterTypeReplacements(call, replacements);
    }

    public boolean identicalExpression(AbstractCall call) {
        return this.getExpression() != null && call.getExpression() != null && this.getExpression().equals(call.getExpression()) || this.getExpression() == null && call.getExpression() == null;
    }

    private boolean identicalExpressionAfterTypeReplacements(AbstractCall call, Set<Replacement> replacements) {
        if (this.getExpression() != null && call.getExpression() != null) {
            String expression1 = this.getExpression();
            String expression2 = call.getExpression();
            String expression1AfterReplacements = new String(expression1);
            for (Replacement replacement : replacements) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.TYPE) && (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !Character.isUpperCase(expression1.charAt(0)) || !Character.isUpperCase(expression2.charAt(0)))) continue;
                if (replacement.getBefore().equals(expression1) && replacement.getAfter().equals(expression2)) {
                    return true;
                }
                expression1AfterReplacements = ReplacementUtil.performReplacement(expression1AfterReplacements, expression2, replacement.getBefore(), replacement.getAfter());
            }
            if (expression1AfterReplacements.equals(expression2)) {
                return true;
            }
        }
        return false;
    }

    public boolean staticInvokerExpressionReplaced(AbstractCall call, Set<Replacement> replacements) {
        if (this.getExpression() != null && call.getExpression() != null) {
            String expression1 = this.getExpression();
            String expression2 = call.getExpression();
            for (Replacement replacement : replacements) {
                if (!replacement.getBefore().equals(expression1) || !replacement.getAfter().equals(expression2) || !Character.isUpperCase(expression1.charAt(0)) || !Character.isUpperCase(expression2.charAt(0))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalArgumentsExceptForStringLiterals(AbstractCall call) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        int stringLiterals1 = 0;
        int stringLiterals2 = 0;
        for (int i = 0; i < arguments1.size(); ++i) {
            boolean stringLiteral2;
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean stringLiteral1 = this.isStringLiteral(argument1);
            if (stringLiteral1) {
                ++stringLiterals1;
            }
            if (stringLiteral2 = this.isStringLiteral(argument2)) {
                ++stringLiterals2;
            }
            if (stringLiteral1 && stringLiteral2 || argument1.equals(argument2)) continue;
            return false;
        }
        return stringLiterals1 == stringLiterals2 && stringLiterals1 > 0;
    }

    public boolean isStringLiteral(String argument) {
        return argument.startsWith("\"") && argument.endsWith("\"");
    }

    public boolean equalArguments(AbstractCall call) {
        return this.getArguments().equals(call.getArguments());
    }

    public boolean reorderedArguments(AbstractCall call) {
        return this.getArguments().size() > 1 && this.getArguments().size() == call.getArguments().size() && !this.getArguments().equals(call.getArguments()) && this.getArguments().containsAll(call.getArguments());
    }

    public boolean identicalOrReplacedArguments(AbstractCall call, Set<Replacement> replacements, List<UMLOperationBodyMapper> lambdaMappers) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentReplacement = false;
            for (Replacement replacement : replacements) {
                if (!replacement.getBefore().equals(argument1) || !replacement.getAfter().equals(argument2)) continue;
                argumentReplacement = true;
                break;
            }
            boolean lambdaReplacement = false;
            if (argument1.contains("->") && argument2.contains("->")) {
                for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                    if (lambdaMapper.nonMappedElementsT1() != 0 || lambdaMapper.nonMappedElementsT2() != 0) continue;
                    lambdaReplacement = true;
                    break;
                }
            }
            if (argument1.equals(argument2) || argumentReplacement || lambdaReplacement) continue;
            return false;
        }
        return true;
    }

    public boolean identicalOrConcatenatedArguments(AbstractCall call) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentConcatenated = false;
            if ((argument1.contains("+") || argument2.contains("+")) && !argument1.contains("++") && !argument2.contains("++")) {
                LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(UMLOperationBodyMapper.SPLIT_CONCAT_STRING_PATTERN.split(argument1)));
                LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(UMLOperationBodyMapper.SPLIT_CONCAT_STRING_PATTERN.split(argument2)));
                LinkedHashSet<String> intersection = new LinkedHashSet<String>(tokens1);
                intersection.retainAll(tokens2);
                int size = intersection.size();
                int threshold = Math.max(tokens1.size(), tokens2.size()) - size;
                if (size > 0 && size >= threshold) {
                    argumentConcatenated = true;
                }
            }
            if (argument1.equals(argument2) || argumentConcatenated) continue;
            return false;
        }
        return true;
    }

    public boolean identicalOrWrappedArguments(AbstractCall call) {
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentWrapped = false;
            if (argument1.contains("(" + argument2 + ")") || argument2.contains("(" + argument1 + ")")) {
                argumentWrapped = true;
            }
            if (argument1.equals(argument2) || argumentWrapped) continue;
            return false;
        }
        return true;
    }

    public boolean allArgumentsReplaced(AbstractCall call, Set<Replacement> replacements) {
        int replacedArguments = 0;
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() == arguments2.size()) {
            block0: for (int i = 0; i < arguments1.size(); ++i) {
                String argument1 = arguments1.get(i);
                String argument2 = arguments2.get(i);
                for (Replacement replacement : replacements) {
                    if (!replacement.getBefore().equals(argument1) && !argument1.contains(replacement.getBefore()) || !replacement.getAfter().equals(argument2) && !argument2.contains(replacement.getAfter())) continue;
                    ++replacedArguments;
                    continue block0;
                }
            }
        }
        return replacedArguments > 0 && replacedArguments == arguments1.size();
    }

    public boolean allArgumentsReplaced(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int replacedArguments = 0;
        List<String> arguments1 = this.getArguments();
        List<String> arguments2 = call.getArguments();
        if (arguments1.size() == arguments2.size()) {
            block0: for (int i = 0; i < arguments1.size(); ++i) {
                String argument1 = arguments1.get(i);
                String argument2 = arguments2.get(i);
                for (Replacement replacement : replacements) {
                    if (!replacement.getBefore().equals(argument1) && !replacement.getBefore().equals(parameterToArgumentMap.get(argument1)) || !replacement.getAfter().equals(argument2) && !replacement.getAfter().equals(parameterToArgumentMap.get(argument2))) continue;
                    ++replacedArguments;
                    continue block0;
                }
            }
        }
        return replacedArguments > 0 && replacedArguments == arguments1.size();
    }

    public boolean renamedWithIdenticalExpressionAndArguments(AbstractCall call, Set<Replacement> replacements, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean identicalOrReplacedArguments = this.identicalOrReplacedArguments(call, replacements, lambdaMappers);
        boolean allArgumentsReplaced = this.allArgumentsReplaced(call, replacements);
        return this.getExpression() != null && call.getExpression() != null && this.identicalExpression(call, replacements) && !this.identicalName(call) && (this.equalArguments(call) || this.reorderedArguments(call) || allArgumentsReplaced && this.normalizedNameDistance(call) <= distance || identicalOrReplacedArguments && !allArgumentsReplaced);
    }

    public boolean variableDeclarationInitializersRenamedWithIdenticalArguments(AbstractCall call) {
        return this.coverage.equals((Object)StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL) && call.coverage.equals((Object)StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL) && this.getExpression() != null && call.getExpression() != null && !this.identicalName(call) && (this.equalArguments(call) || this.reorderedArguments(call) || this.getArguments().size() == 0 || call.getArguments().size() == 0);
    }

    public boolean renamedWithDifferentExpressionAndIdenticalArguments(AbstractCall call) {
        return (this.getName().contains(call.getName()) || call.getName().contains(this.getName())) && (this.equalArguments(call) || this.reorderedArguments(call)) && this.arguments.size() > 0 && (this.getExpression() == null && call.getExpression() != null || call.getExpression() == null && this.getExpression() != null);
    }

    public boolean renamedWithIdenticalArgumentsAndNoExpression(AbstractCall call, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (lambdaMapper.allMappingsAreExactMatches()) continue;
            allExactLambdaMappers = false;
            break;
        }
        return !(this.getExpression() != null || call.getExpression() != null || this.identicalName(call) || !(this.normalizedNameDistance(call) <= distance) && !allExactLambdaMappers || !this.equalArguments(call) && !this.reorderedArguments(call));
    }

    public boolean renamedWithIdenticalExpressionAndDifferentArguments(AbstractCall call, Set<Replacement> replacements, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (lambdaMapper.allMappingsAreExactMatches()) continue;
            allExactLambdaMappers = false;
            break;
        }
        return this.getExpression() != null && call.getExpression() != null && this.identicalExpression(call, replacements) && (this.normalizedNameDistance(call) <= distance || allExactLambdaMappers || this.methodNameContainsArgumentName() && call.methodNameContainsArgumentName() || this.argumentIntersectionContainsClassInstanceCreation(call)) && !this.equalArguments(call) && !this.argumentContainsAnonymousClassDeclaration() && !call.argumentContainsAnonymousClassDeclaration();
    }

    private boolean argumentIntersectionContainsClassInstanceCreation(AbstractCall call) {
        for (String argument : this.argumentIntersection(call)) {
            if (!argument.startsWith("new ")) continue;
            return true;
        }
        return false;
    }

    private boolean argumentContainsAnonymousClassDeclaration() {
        for (String argument : this.arguments) {
            if (!argument.contains("{\n")) continue;
            return true;
        }
        return false;
    }

    public boolean methodNameContainsArgumentName() {
        for (String argument : this.arguments) {
            if (!this.getName().toLowerCase().endsWith(argument.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean onlyArgumentsChanged(AbstractCall call, Set<Replacement> replacements) {
        return this.identicalExpression(call, replacements) && this.identicalName(call) && !this.equalArguments(call) && this.getArguments().size() != call.getArguments().size();
    }

    public boolean identicalWithMergedArguments(AbstractCall call, Set<Replacement> replacements) {
        if (this.onlyArgumentsChanged(call, replacements)) {
            ArrayList<String> updatedArguments1 = new ArrayList<String>(this.arguments);
            LinkedHashMap commonVariableReplacementMap = new LinkedHashMap();
            for (Replacement replacement : replacements) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                String key = replacement.getAfter();
                if (commonVariableReplacementMap.containsKey(key)) {
                    ((Set)commonVariableReplacementMap.get(key)).add(replacement);
                    int index = updatedArguments1.indexOf(replacement.getBefore());
                    if (index == -1) continue;
                    updatedArguments1.remove(index);
                    continue;
                }
                LinkedHashSet<Replacement> r = new LinkedHashSet<Replacement>();
                r.add(replacement);
                commonVariableReplacementMap.put(key, r);
                int index = updatedArguments1.indexOf(replacement.getBefore());
                if (index == -1) continue;
                updatedArguments1.remove(index);
                updatedArguments1.add(index, key);
            }
            if (updatedArguments1.equals(call.arguments)) {
                for (String key : commonVariableReplacementMap.keySet()) {
                    Set r = (Set)commonVariableReplacementMap.get(key);
                    if (r.size() <= 1) continue;
                    replacements.removeAll(r);
                    LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                    for (Replacement replacement : r) {
                        mergedVariables.add(replacement.getBefore());
                    }
                    MergeVariableReplacement merge = new MergeVariableReplacement(mergedVariables, key);
                    replacements.add(merge);
                }
                return true;
            }
        }
        return false;
    }

    public boolean identicalWithDifferentNumberOfArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int argumentIntersectionSize;
        return this.onlyArgumentsChanged(call, replacements) && ((argumentIntersectionSize = this.argumentIntersectionSize(call, replacements, parameterToArgumentMap)) > 0 || this.getArguments().size() == 0 || call.getArguments().size() == 0);
    }

    public boolean inlinedStatementBecomesAdditionalArgument(AbstractCall call, Set<Replacement> replacements, List<? extends AbstractCodeFragment> statements) {
        if (this.identicalName(call) && this.arguments.size() < call.arguments.size() && this.argumentIntersection(call).size() > 0) {
            int matchedArguments = 0;
            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements1 = new LinkedHashSet<AbstractCodeFragment>();
            block0: for (String arg : call.arguments) {
                if (this.arguments.contains(arg)) {
                    ++matchedArguments;
                    continue;
                }
                for (AbstractCodeFragment abstractCodeFragment : statements) {
                    VariableDeclaration variableDeclaration;
                    if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || (variableDeclaration = abstractCodeFragment.getVariableDeclarations().get(0)).getInitializer() == null || !arg.equals(variableDeclaration.getInitializer().getExpression())) continue;
                    ++matchedArguments;
                    additionallyMatchedStatements1.add(abstractCodeFragment);
                    continue block0;
                }
            }
            if (matchedArguments == call.arguments.size()) {
                if (additionallyMatchedStatements1.size() > 0) {
                    CompositeReplacement r = new CompositeReplacement(this.actualString(), call.actualString(), additionallyMatchedStatements1, Collections.emptySet());
                    replacements.add(r);
                }
                return true;
            }
        }
        return false;
    }

    public boolean identicalWithInlinedStatements(AbstractCall call, Set<Replacement> replacements, List<AbstractCodeFragment> statements) {
        if (this.identicalExpression(call, replacements) && this.identicalName(call) && this.arguments.size() == call.arguments.size()) {
            LinkedHashSet<Replacement> newReplacements = new LinkedHashSet<Replacement>();
            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements1 = new LinkedHashSet<AbstractCodeFragment>();
            for (int i = 0; i < this.arguments.size(); ++i) {
                String arg2;
                String arg1 = this.arguments.get(i);
                if (arg1.equals(arg2 = call.arguments.get(i))) continue;
                boolean matchingInlineFound = false;
                for (AbstractCodeFragment statement : statements) {
                    VariableReplacementWithMethodInvocation r;
                    VariableDeclaration variableDeclaration;
                    if (statement.getVariableDeclarations().size() <= 0 || !(variableDeclaration = statement.getVariableDeclarations().get(0)).getVariableName().equals(arg1) || variableDeclaration.getInitializer() == null) continue;
                    AbstractCall statementCall = variableDeclaration.getInitializer().invocationCoveringEntireFragment();
                    if (variableDeclaration.getInitializer().getExpression().equals(arg2)) {
                        Replacement r2;
                        matchingInlineFound = true;
                        if (statementCall != null) {
                            r2 = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                            newReplacements.add(r2);
                        } else {
                            r2 = new Replacement(arg1, variableDeclaration.getInitializer().getExpression(), Replacement.ReplacementType.VARIABLE_NAME);
                            newReplacements.add(r2);
                        }
                        additionallyMatchedStatements1.add(statement);
                        break;
                    }
                    if (statementCall == null) continue;
                    String actualString = statementCall.actualString();
                    if (arg2.contains(actualString) || actualString.contains(arg2)) {
                        matchingInlineFound = true;
                        r = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                        newReplacements.add(r);
                        additionallyMatchedStatements1.add(statement);
                        break;
                    }
                    if (!actualString.contains(".") || !arg2.contains(".") || !actualString.substring(actualString.indexOf(".")).equals(arg2.substring(arg2.indexOf(".")))) continue;
                    matchingInlineFound = true;
                    r = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    newReplacements.add(r);
                    additionallyMatchedStatements1.add(statement);
                    String invoker = actualString.substring(0, actualString.indexOf("."));
                    if (!invoker.equals(statementCall.getExpression())) break;
                    String arg2Invoker = arg2.substring(0, arg2.indexOf("."));
                    Replacement rename = new Replacement(invoker, arg2Invoker, Replacement.ReplacementType.VARIABLE_NAME);
                    newReplacements.add(rename);
                    break;
                }
                if (matchingInlineFound) continue;
                return false;
            }
            for (Replacement r : newReplacements) {
                if (replacements.contains(r)) continue;
                replacements.add(r);
            }
            if (additionallyMatchedStatements1.size() > 0) {
                CompositeReplacement r = new CompositeReplacement(this.actualString(), call.actualString(), additionallyMatchedStatements1, Collections.emptySet());
                replacements.add(r);
            }
            return true;
        }
        return false;
    }

    public boolean identical(AbstractCall call, Set<Replacement> replacements, List<UMLOperationBodyMapper> lambdaMappers) {
        return this.identicalExpression(call, replacements) && this.identicalName(call) && (this.equalArguments(call) || this.onlyLambdaArgumentsDiffer(call, lambdaMappers));
    }

    private boolean onlyLambdaArgumentsDiffer(AbstractCall call, List<UMLOperationBodyMapper> lambdaMappers) {
        if (lambdaMappers.size() > 0) {
            List<String> arguments1 = this.getArguments();
            List<String> arguments2 = call.getArguments();
            if (arguments1.size() == arguments2.size()) {
                for (int i = 0; i < arguments1.size(); ++i) {
                    String argument1 = arguments1.get(i);
                    String argument2 = arguments2.get(i);
                    if (argument1.contains("->") && argument2.contains("->")) {
                        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                            if (lambdaMapper.nonMappedElementsT1() <= 0 || lambdaMapper.nonMappedElementsT2() <= 0 || lambdaMapper.containsCallToExtractedMethod() || lambdaMapper.containsCallToInlinedMethod()) continue;
                            return false;
                        }
                        continue;
                    }
                    if (argument1.equals(argument2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Set<String> argumentIntersection(AbstractCall call) {
        List<String> args1 = this.preprocessArguments(this.getArguments());
        List<String> args2 = this.preprocessArguments(call.getArguments());
        LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(args1);
        argumentIntersection.retainAll(args2);
        return argumentIntersection;
    }

    private List<String> preprocessArguments(List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : arguments) {
            if (arg.contains("\n")) {
                args.add(arg.substring(0, arg.indexOf("\n")));
                continue;
            }
            args.add(arg);
        }
        return args;
    }

    private int argumentIntersectionSize(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        Set<String> argumentIntersection = this.argumentIntersection(call);
        int argumentIntersectionSize = argumentIntersection.size();
        for (String parameter : parameterToArgumentMap.keySet()) {
            String argument = parameterToArgumentMap.get(parameter);
            if (!this.getArguments().contains(argument) || !call.getArguments().contains(parameter)) continue;
            ++argumentIntersectionSize;
        }
        for (Replacement r : replacements) {
            if (!r.isLiteral() || !this.getArguments().contains(r.getBefore()) || !call.getArguments().contains(r.getAfter())) continue;
            ++argumentIntersectionSize;
        }
        return argumentIntersectionSize;
    }

    private boolean argumentIsStatement(String statement) {
        if (statement.endsWith(";\n")) {
            for (String argument : this.getArguments()) {
                if (!AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(0, statement.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean argumentIsExpression(String expression) {
        if (!expression.endsWith(";\n")) {
            for (String argument : this.getArguments()) {
                if (!AbstractCall.equalsIgnoringExtraParenthesis(argument, expression)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean argumentIsReturned(String statement) {
        if (statement.startsWith("return ")) {
            for (String argument : this.getArguments()) {
                if (!AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(7, statement.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    public Replacement makeReplacementForReturnedArgument(String statement) {
        if (this.argumentIsReturned(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(this.getArguments().get(0), statement.substring(7, statement.length() - 2), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        if (this.argumentIsStatement(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(this.getArguments().get(0), statement.substring(0, statement.length() - 2), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        if (this.argumentIsExpression(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(this.getArguments().get(0), statement, Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    public Replacement makeReplacementForWrappedCall(String statement) {
        if (this.argumentIsReturned(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(statement.substring(7, statement.length() - 2), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        if (this.argumentIsStatement(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(statement.substring(0, statement.length() - 2), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        if (this.argumentIsExpression(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(statement, this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    public Replacement makeReplacementForWrappedLambda(String statement) {
        if (this.argumentIsLambdaStatement(statement) && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(statement.substring(0, statement.length() - 2), this.getArguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    private boolean argumentIsLambdaStatement(String statement) {
        if (statement.endsWith(";\n")) {
            for (String argument : this.getArguments()) {
                if (!AbstractCall.equalsIgnoringLambdaArrow(argument, statement.substring(0, statement.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    private int argumentIsAssigned(String statement) {
        if (statement.contains("=") && statement.endsWith(";\n")) {
            int index = 0;
            for (String argument : this.getArguments()) {
                if (AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(statement.indexOf("=") + 1, statement.length() - 2))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public Replacement makeReplacementForAssignedArgument(String statement) {
        int index = this.argumentIsAssigned(statement);
        if (index >= 0 && (this.getArguments().size() == 1 || statement.contains("?") && statement.contains(":"))) {
            return new Replacement(statement.substring(statement.indexOf("=") + 1, statement.length() - 2), this.getArguments().get(index), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION);
        }
        return null;
    }

    private static boolean equalsIgnoringExtraParenthesis(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        String parenthesizedS1 = "(" + s1 + ")";
        if (parenthesizedS1.equals(s2)) {
            return true;
        }
        String parenthesizedS2 = "(" + s2 + ")";
        return parenthesizedS2.equals(s1);
    }

    private static boolean equalsIgnoringLambdaArrow(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        String arrowS1 = "() -> " + s1;
        if (arrowS1.equals(s2)) {
            return true;
        }
        String arrowS2 = "() -> " + s2;
        return arrowS2.equals(s1);
    }

    protected void update(AbstractCall newCall, String oldExpression, String newExpression) {
        newCall.typeArguments = this.typeArguments;
        newCall.expression = this.expression != null && this.expression.equals(oldExpression) ? newExpression : this.expression;
        newCall.arguments = new ArrayList<String>();
        for (String argument : this.arguments) {
            newCall.arguments.add(ReplacementUtil.performReplacement(argument, oldExpression, newExpression));
        }
    }

    public Set<String> callChainIntersection(AbstractCall call) {
        if (this instanceof OperationInvocation && call instanceof OperationInvocation) {
            return ((OperationInvocation)this).callChainIntersection((OperationInvocation)call);
        }
        return Collections.emptySet();
    }

    @Override
    public CodeRange codeRange() {
        LocationInfo info = this.getLocationInfo();
        return info.codeRange();
    }

    public static enum StatementCoverageType {
        NONE,
        ONLY_CALL,
        RETURN_CALL,
        THROW_CALL,
        CAST_CALL,
        VARIABLE_DECLARATION_INITIALIZER_CALL;

    }
}

