/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.ClassInstanceCreationWithMethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.IntersectionReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.ObjectCreationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InlineVariableRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.util.PrefixSuffixUtils;

public abstract class AbstractCodeMapping {
    private AbstractCodeFragment fragment1;
    private AbstractCodeFragment fragment2;
    private VariableDeclarationContainer operation1;
    private VariableDeclarationContainer operation2;
    private Set<Replacement> replacements;
    private boolean identicalWithExtractedVariable;
    private boolean identicalWithInlinedVariable;
    private Set<Refactoring> refactorings = new LinkedHashSet<Refactoring>();

    public AbstractCodeMapping(AbstractCodeFragment fragment1, AbstractCodeFragment fragment2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        this.fragment1 = fragment1;
        this.fragment2 = fragment2;
        this.operation1 = operation1;
        this.operation2 = operation2;
        this.replacements = new LinkedHashSet<Replacement>();
    }

    public AbstractCodeFragment getFragment1() {
        return this.fragment1;
    }

    public AbstractCodeFragment getFragment2() {
        return this.fragment2;
    }

    public VariableDeclarationContainer getOperation1() {
        return this.operation1;
    }

    public VariableDeclarationContainer getOperation2() {
        return this.operation2;
    }

    public boolean isIdenticalWithExtractedVariable() {
        return this.identicalWithExtractedVariable;
    }

    public boolean isIdenticalWithInlinedVariable() {
        return this.identicalWithInlinedVariable;
    }

    public void addRefactoring(Refactoring r) {
        this.refactorings.add(r);
    }

    public Set<Refactoring> getRefactorings() {
        return this.refactorings;
    }

    public boolean isExact() {
        return (this.fragment1.getArgumentizedString().equals(this.fragment2.getArgumentizedString()) || this.argumentizedStringExactAfterTypeReplacement() || this.fragment1.getString().equals(this.fragment2.getString()) || this.isExactAfterAbstraction() || this.containsIdenticalOrCompositeReplacement()) && !this.fragment1.isKeyword();
    }

    private boolean argumentizedStringExactAfterTypeReplacement() {
        String s1 = this.fragment1.getArgumentizedString();
        String s2 = this.fragment2.getArgumentizedString();
        for (Replacement r : this.replacements) {
            String temp;
            if (!r.getType().equals((Object)Replacement.ReplacementType.TYPE) || !s1.startsWith(r.getBefore()) || !s2.startsWith(r.getAfter()) || !s1.equals(temp = s2.replace(r.getAfter(), r.getBefore())) && !(s1 + ";\n").equals(temp)) continue;
            return true;
        }
        return false;
    }

    private boolean isExactAfterAbstraction() {
        AbstractCall invocation1 = this.fragment1.invocationCoveringEntireFragment();
        AbstractCall invocation2 = this.fragment2.invocationCoveringEntireFragment();
        if (invocation1 != null && invocation2 != null) {
            return invocation1.actualString().equals(invocation2.actualString());
        }
        ObjectCreation creation1 = this.fragment1.creationCoveringEntireFragment();
        ObjectCreation creation2 = this.fragment2.creationCoveringEntireFragment();
        if (creation1 != null && creation2 != null) {
            return creation1.actualString().equals(creation2.actualString());
        }
        return false;
    }

    private boolean containsIdenticalOrCompositeReplacement() {
        for (Replacement r : this.replacements) {
            if (r.getType().equals((Object)Replacement.ReplacementType.ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS) && r.getBefore().equals(r.getAfter())) {
                return true;
            }
            if (!r.getType().equals((Object)Replacement.ReplacementType.COMPOSITE)) continue;
            return true;
        }
        return false;
    }

    public CompositeReplacement containsCompositeReplacement() {
        for (Replacement r : this.replacements) {
            if (!r.getType().equals((Object)Replacement.ReplacementType.COMPOSITE)) continue;
            return (CompositeReplacement)r;
        }
        return null;
    }

    public void addReplacement(Replacement replacement) {
        this.replacements.add(replacement);
    }

    public void addReplacements(Set<Replacement> replacements) {
        this.replacements.addAll(replacements);
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public boolean containsReplacement(Replacement.ReplacementType type) {
        for (Replacement replacement : this.replacements) {
            if (!replacement.getType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyReplacement(Replacement.ReplacementType type) {
        for (Replacement replacement : this.replacements) {
            if (replacement.getType().equals((Object)type)) continue;
            return false;
        }
        return this.replacements.size() > 0;
    }

    public Set<Replacement.ReplacementType> getReplacementTypes() {
        LinkedHashSet<Replacement.ReplacementType> types = new LinkedHashSet<Replacement.ReplacementType>();
        for (Replacement replacement : this.replacements) {
            types.add(replacement.getType());
        }
        return types;
    }

    public String toString() {
        return this.fragment1.toString() + this.fragment2.toString();
    }

    public void temporaryVariableAssignment(Set<Refactoring> refactorings, boolean insideExtractedOrInlinedMethod) {
        if (this instanceof LeafMapping && this.getFragment1() instanceof AbstractExpression && this.getFragment2() instanceof StatementObject) {
            StatementObject statement = (StatementObject)this.getFragment2();
            List<VariableDeclaration> variableDeclarations = statement.getVariableDeclarations();
            boolean validReplacements = true;
            for (Replacement replacement : this.getReplacements()) {
                if (!(replacement instanceof MethodInvocationReplacement) && !(replacement instanceof ObjectCreationReplacement)) continue;
                validReplacements = false;
                break;
            }
            if (variableDeclarations.size() == 1 && validReplacements) {
                VariableDeclaration variableDeclaration = variableDeclarations.get(0);
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(variableDeclaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                this.processExtractVariableRefactoring(ref, refactorings);
                this.identicalWithExtractedVariable = true;
            }
        }
    }

    public void temporaryVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, UMLAbstractClassDiff classDiff, boolean insideExtractedOrInlinedMethod) {
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            AbstractCall invocation;
            String variableName = declaration.getVariableName();
            AbstractExpression initializer = declaration.getInitializer();
            for (Replacement replacement : this.getReplacements()) {
                if (replacement.getAfter().startsWith(variableName + ".")) {
                    String suffixAfter = replacement.getAfter().substring(variableName.length(), replacement.getAfter().length());
                    if (replacement.getBefore().endsWith(suffixAfter)) {
                        String prefixBefore = replacement.getBefore().substring(0, replacement.getBefore().indexOf(suffixAfter));
                        if (initializer != null && (initializer.toString().equals(prefixBefore) || this.overlappingExtractVariable(initializer, prefixBefore, nonMappedLeavesT2, this.refactorings))) {
                            ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                            this.processExtractVariableRefactoring(ref, this.refactorings);
                            if (this.getReplacements().size() == 1) {
                                this.identicalWithExtractedVariable = true;
                            }
                        }
                    }
                }
                if (!variableName.equals(replacement.getAfter()) || initializer == null || !initializer.toString().equals(replacement.getBefore()) && (!initializer.toString().equals("(" + declaration.getType() + ")" + replacement.getBefore()) || this.containsVariableNameReplacement(variableName)) && !this.ternaryMatch(initializer, replacement.getBefore()) && !this.infixOperandMatch(initializer, replacement.getBefore()) && !this.wrappedAsArgument(initializer, replacement.getBefore()) && !this.reservedTokenMatch(initializer, replacement, replacement.getBefore()) && !this.overlappingExtractVariable(initializer, replacement.getBefore(), nonMappedLeavesT2, this.refactorings)) continue;
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                this.processExtractVariableRefactoring(ref, this.refactorings);
                if (this.getReplacements().size() != 1) continue;
                this.identicalWithExtractedVariable = true;
            }
            if (classDiff == null || initializer == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
            for (Refactoring refactoring : classDiff.getRefactoringsBeforePostProcessing()) {
                if (!(refactoring instanceof RenameOperationRefactoring)) continue;
                RenameOperationRefactoring rename = (RenameOperationRefactoring)refactoring;
                if (!invocation.getName().equals(rename.getRenamedOperation().getName())) continue;
                String initializerBeforeRename = initializer.getString().replace(rename.getRenamedOperation().getName(), rename.getOriginalOperation().getName());
                if (!this.getFragment1().getString().contains(initializerBeforeRename) || !this.getFragment2().getString().contains(variableName)) continue;
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                this.processExtractVariableRefactoring(ref, this.refactorings);
            }
        }
        String argumentizedString = statement.getArgumentizedString();
        if (argumentizedString.contains("=")) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = null;
            initializer = argumentizedString.endsWith(";\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length());
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getAfter()) || !initializer.equals(replacement.getBefore())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation2.getVariableDeclarationsInScope(this.fragment2.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    ExtractVariableRefactoring ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    this.processExtractVariableRefactoring(ref, this.refactorings);
                    if (this.getReplacements().size() != 1) continue;
                    this.identicalWithExtractedVariable = true;
                }
            }
        }
    }

    public void inlinedVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, boolean insideExtractedOrInlinedMethod) {
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            for (Replacement replacement : this.getReplacements()) {
                String variableName = declaration.getVariableName();
                AbstractExpression initializer = declaration.getInitializer();
                if (replacement.getBefore().startsWith(variableName + ".")) {
                    String suffixBefore = replacement.getBefore().substring(variableName.length(), replacement.getBefore().length());
                    if (replacement.getAfter().endsWith(suffixBefore)) {
                        String prefixAfter = replacement.getAfter().substring(0, replacement.getAfter().indexOf(suffixBefore));
                        if (initializer != null && (initializer.toString().equals(prefixAfter) || this.overlappingExtractVariable(initializer, prefixAfter, nonMappedLeavesT2, this.refactorings))) {
                            InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                            this.processInlineVariableRefactoring(ref, this.refactorings);
                            if (this.getReplacements().size() == 1) {
                                this.identicalWithInlinedVariable = true;
                            }
                        }
                    }
                }
                if (!variableName.equals(replacement.getBefore()) || initializer == null || !initializer.toString().equals(replacement.getAfter()) && (!initializer.toString().equals("(" + declaration.getType() + ")" + replacement.getAfter()) || this.containsVariableNameReplacement(variableName)) && !this.ternaryMatch(initializer, replacement.getAfter()) && !this.infixOperandMatch(initializer, replacement.getAfter()) && !this.wrappedAsArgument(initializer, replacement.getAfter()) && !this.reservedTokenMatch(initializer, replacement, replacement.getAfter()) && !this.overlappingExtractVariable(initializer, replacement.getAfter(), nonMappedLeavesT2, this.refactorings)) continue;
                InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                this.processInlineVariableRefactoring(ref, this.refactorings);
                if (this.getReplacements().size() != 1) continue;
                this.identicalWithInlinedVariable = true;
            }
        }
        String argumentizedString = statement.getArgumentizedString();
        if (argumentizedString.contains("=")) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = null;
            initializer = argumentizedString.endsWith(";\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length());
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getBefore()) || !initializer.equals(replacement.getAfter())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation1.getVariableDeclarationsInScope(this.fragment1.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    this.processInlineVariableRefactoring(ref, this.refactorings);
                    if (this.getReplacements().size() != 1) continue;
                    this.identicalWithInlinedVariable = true;
                }
            }
        }
    }

    private boolean wrappedAsArgument(AbstractExpression initializer, String replacedExpression) {
        ObjectCreation creation;
        int replacementCount = 0;
        for (Replacement r : this.replacements) {
            if (!r.getBefore().equals(replacedExpression) && !r.getAfter().equals(replacedExpression)) continue;
            ++replacementCount;
        }
        if (replacementCount > 1) {
            return false;
        }
        AbstractCall invocation = initializer.invocationCoveringEntireFragment();
        if (invocation != null) {
            if (invocation.getArguments().contains(replacedExpression)) {
                return true;
            }
            String expression = invocation.getExpression();
            if (expression != null && (expression.equals(replacedExpression) || ReplacementUtil.contains(expression, replacedExpression))) {
                return true;
            }
        }
        return (creation = initializer.creationCoveringEntireFragment()) != null && creation.getArguments().contains(replacedExpression);
    }

    private boolean infixOperandMatch(AbstractExpression initializer, String replacedExpression) {
        List<String> infixExpressions = initializer.getInfixExpressions();
        for (String infix : infixExpressions) {
            if (!infix.startsWith(replacedExpression) && !infix.endsWith(replacedExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean ternaryMatch(AbstractExpression initializer, String replacedExpression) {
        List<TernaryOperatorExpression> ternaryList = initializer.getTernaryOperatorExpressions();
        for (TernaryOperatorExpression ternary : ternaryList) {
            if (!ternary.getThenExpression().toString().equals(replacedExpression) && !ternary.getElseExpression().toString().equals(replacedExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean containsVariableNameReplacement(String variableName) {
        for (Replacement replacement : this.getReplacements()) {
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !replacement.getBefore().equals(variableName) && !replacement.getAfter().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private boolean reservedTokenMatch(AbstractExpression initializer, Replacement replacement, String replacedExpression) {
        AbstractCall initializerInvocation = initializer.invocationCoveringEntireFragment();
        AbstractCall replacementInvocation = replacement instanceof VariableReplacementWithMethodInvocation ? ((VariableReplacementWithMethodInvocation)replacement).getInvokedOperation() : null;
        boolean methodInvocationMatch = true;
        if (initializerInvocation != null && replacementInvocation != null) {
            if (!initializerInvocation.getName().equals(replacementInvocation.getName())) {
                methodInvocationMatch = false;
            }
        } else if (initializerInvocation != null && replacementInvocation == null) {
            methodInvocationMatch = false;
        } else if (initializerInvocation == null && replacementInvocation != null) {
            methodInvocationMatch = false;
        }
        String initializerReservedTokens = ReplacementUtil.keepReservedTokens(initializer.toString());
        String replacementReservedTokens = ReplacementUtil.keepReservedTokens(replacedExpression);
        return methodInvocationMatch && !initializerReservedTokens.isEmpty() && !initializerReservedTokens.equals("[]") && !initializerReservedTokens.equals(".()") && !initializerReservedTokens.equals(" ()") && initializerReservedTokens.equals(replacementReservedTokens);
    }

    private void processInlineVariableRefactoring(InlineVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                ((InlineVariableRefactoring)refactoring).addReference(this);
                break;
            }
        }
    }

    private void processExtractVariableRefactoring(ExtractVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                ((ExtractVariableRefactoring)refactoring).addReference(this);
                break;
            }
        }
    }

    private boolean overlappingExtractVariable(AbstractExpression initializer, String input, List<? extends AbstractCodeFragment> nonMappedLeavesT2, Set<Refactoring> refactorings) {
        String prefix2;
        String prefix1;
        String output = input;
        for (Refactoring ref : refactorings) {
            ExtractVariableRefactoring extractVariable;
            VariableDeclaration declaration;
            if (!(ref instanceof ExtractVariableRefactoring) || (declaration = (extractVariable = (ExtractVariableRefactoring)ref).getVariableDeclaration()).getInitializer() == null || !input.contains(declaration.getInitializer().toString())) continue;
            output = output.replace(declaration.getInitializer().toString(), declaration.getVariableName());
        }
        if (initializer.toString().equals(output)) {
            return true;
        }
        String longestCommonSuffix = PrefixSuffixUtils.longestCommonSuffix(initializer.toString(), input);
        if (!longestCommonSuffix.isEmpty() && longestCommonSuffix.startsWith(".") && ((prefix1 = initializer.toString().substring(0, initializer.toString().indexOf(longestCommonSuffix))).equals(prefix2 = input.substring(0, input.indexOf(longestCommonSuffix))) || !prefix1.toUpperCase().equals(prefix1) && !prefix2.toUpperCase().equals(prefix2))) {
            return true;
        }
        String longestCommonPrefix = PrefixSuffixUtils.longestCommonPrefix(initializer.toString(), input);
        if (!(longestCommonSuffix.isEmpty() || longestCommonPrefix.isEmpty() || longestCommonPrefix.equals(initializer.toString()) || longestCommonPrefix.equals(input) || longestCommonSuffix.equals(initializer.toString()) || longestCommonSuffix.equals(input) || longestCommonPrefix.length() + longestCommonSuffix.length() >= input.length() || longestCommonPrefix.length() + longestCommonSuffix.length() >= initializer.toString().length())) {
            String s1 = input.substring(longestCommonPrefix.length(), input.lastIndexOf(longestCommonSuffix));
            String s2 = initializer.toString().substring(longestCommonPrefix.length(), initializer.toString().lastIndexOf(longestCommonSuffix));
            for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
                VariableDeclaration variable = abstractCodeFragment.getVariableDeclaration(s2);
                if (variable == null) continue;
                if (variable.getInitializer() != null && variable.getInitializer().toString().equals(s1)) {
                    return true;
                }
                List<TernaryOperatorExpression> ternaryOperators = abstractCodeFragment.getTernaryOperatorExpressions();
                for (TernaryOperatorExpression ternaryOperator : ternaryOperators) {
                    if (!ternaryOperator.getThenExpression().toString().equals(s1) && !ternaryOperator.getElseExpression().toString().equals(s1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Replacement> commonReplacements(AbstractCodeMapping other) {
        LinkedHashSet<Replacement> intersection = new LinkedHashSet<Replacement>(this.replacements);
        intersection.retainAll(other.replacements);
        return intersection;
    }

    public Set<Replacement> getReplacementsInvolvingMethodInvocation() {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (Replacement replacement : this.getReplacements()) {
            if (!AbstractCodeMapping.involvesMethodInvocation(replacement)) continue;
            replacements.add(replacement);
        }
        return replacements;
    }

    private static boolean involvesMethodInvocation(Replacement replacement) {
        return replacement instanceof MethodInvocationReplacement || replacement instanceof VariableReplacementWithMethodInvocation || replacement instanceof ClassInstanceCreationWithMethodInvocationReplacement || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION) || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION) || replacement instanceof IntersectionReplacement || replacement.getType().equals((Object)Replacement.ReplacementType.ANONYMOUS_CLASS_DECLARATION);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragment1 == null ? 0 : this.fragment1.hashCode());
        result = 31 * result + (this.fragment2 == null ? 0 : this.fragment2.hashCode());
        result = 31 * result + (this.operation1 == null ? 0 : this.operation1.hashCode());
        result = 31 * result + (this.operation2 == null ? 0 : this.operation2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCodeMapping other = (AbstractCodeMapping)obj;
        if (this.fragment1 == null ? other.fragment1 != null : !this.fragment1.equals(other.fragment1)) {
            return false;
        }
        if (this.fragment2 == null ? other.fragment2 != null : !this.fragment2.equals(other.fragment2)) {
            return false;
        }
        if (this.operation1 == null ? other.operation1 != null : !this.operation1.equals(other.operation1)) {
            return false;
        }
        return !(this.operation2 == null ? other.operation2 != null : !this.operation2.equals(other.operation2));
    }
}

