/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;

public class AbstractExpression
extends AbstractCodeFragment {
    private String expression;
    private LocationInfo locationInfo;
    private CompositeStatementObject owner;
    private LambdaExpressionObject lambdaOwner;
    private List<String> variables;
    private List<String> types;
    private List<VariableDeclaration> variableDeclarations;
    private Map<String, List<AbstractCall>> methodInvocationMap;
    private List<AnonymousClassDeclarationObject> anonymousClassDeclarations;
    private List<String> stringLiterals;
    private List<String> numberLiterals;
    private List<String> nullLiterals;
    private List<String> booleanLiterals;
    private List<String> typeLiterals;
    private Map<String, List<ObjectCreation>> creationMap;
    private List<String> infixExpressions;
    private List<String> infixOperators;
    private List<String> arrayAccesses;
    private List<String> prefixExpressions;
    private List<String> postfixExpressions;
    private List<String> arguments;
    private List<TernaryOperatorExpression> ternaryOperatorExpressions;
    private List<LambdaExpressionObject> lambdas;

    public AbstractExpression(CompilationUnit cu, String filePath, Expression expression, LocationInfo.CodeElementType codeElementType, VariableDeclarationContainer container) {
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)expression, codeElementType);
        Visitor visitor = new Visitor(cu, filePath, container);
        expression.accept((ASTVisitor)visitor);
        this.variables = visitor.getVariables();
        this.types = visitor.getTypes();
        this.variableDeclarations = visitor.getVariableDeclarations();
        this.methodInvocationMap = visitor.getMethodInvocationMap();
        this.anonymousClassDeclarations = visitor.getAnonymousClassDeclarations();
        this.stringLiterals = visitor.getStringLiterals();
        this.numberLiterals = visitor.getNumberLiterals();
        this.nullLiterals = visitor.getNullLiterals();
        this.booleanLiterals = visitor.getBooleanLiterals();
        this.typeLiterals = visitor.getTypeLiterals();
        this.creationMap = visitor.getCreationMap();
        this.infixExpressions = visitor.getInfixExpressions();
        this.infixOperators = visitor.getInfixOperators();
        this.arrayAccesses = visitor.getArrayAccesses();
        this.prefixExpressions = visitor.getPrefixExpressions();
        this.postfixExpressions = visitor.getPostfixExpressions();
        this.arguments = visitor.getArguments();
        this.ternaryOperatorExpressions = visitor.getTernaryOperatorExpressions();
        this.lambdas = visitor.getLambdas();
        this.expression = expression.toString();
        this.owner = null;
        this.lambdaOwner = null;
    }

    public void setOwner(CompositeStatementObject owner) {
        this.owner = owner;
    }

    public CompositeStatementObject getOwner() {
        return this.owner;
    }

    public LambdaExpressionObject getLambdaOwner() {
        return this.lambdaOwner;
    }

    public void setLambdaOwner(LambdaExpressionObject lambdaOwner) {
        this.lambdaOwner = lambdaOwner;
    }

    @Override
    public CompositeStatementObject getParent() {
        return this.getOwner();
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return this.getExpression().toString();
    }

    @Override
    public List<String> getVariables() {
        return this.variables;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    @Override
    public Map<String, List<AbstractCall>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return this.anonymousClassDeclarations;
    }

    @Override
    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    @Override
    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    @Override
    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    @Override
    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    @Override
    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    @Override
    public Map<String, List<ObjectCreation>> getCreationMap() {
        return this.creationMap;
    }

    @Override
    public List<String> getInfixExpressions() {
        return this.infixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    @Override
    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    @Override
    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    @Override
    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public List<TernaryOperatorExpression> getTernaryOperatorExpressions() {
        return this.ternaryOperatorExpressions;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public VariableDeclaration searchVariableDeclaration(String variableName) {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration(variableName);
        if (variableDeclaration != null) {
            return variableDeclaration;
        }
        if (this.owner != null) {
            return this.owner.searchVariableDeclaration(variableName);
        }
        if (this.lambdaOwner != null) {
            for (VariableDeclaration declaration : this.lambdaOwner.getParameters()) {
                if (!declaration.getVariableName().equals(variableName)) continue;
                return declaration;
            }
        }
        return null;
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }
}

