/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.diff.StringDistance;

public class CompositeStatementObjectMapping
extends AbstractCodeMapping
implements Comparable<CompositeStatementObjectMapping> {
    private double compositeChildMatchingScore;

    public CompositeStatementObjectMapping(CompositeStatementObject statement1, CompositeStatementObject statement2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2, double score) {
        super(statement1, statement2, operation1, operation2);
        this.compositeChildMatchingScore = score;
    }

    public double getCompositeChildMatchingScore() {
        return this.compositeChildMatchingScore;
    }

    @Override
    public int compareTo(CompositeStatementObjectMapping o) {
        int depthDiff2;
        double distance2;
        int distance;
        String s2;
        String s1;
        double distance1;
        if (this.compositeChildMatchingScore >= 2.0 * o.compositeChildMatchingScore) {
            return -Double.compare(this.compositeChildMatchingScore, o.compositeChildMatchingScore);
        }
        if (this.getFragment1().getString().equals(this.getFragment2().getString())) {
            distance1 = 0.0;
        } else {
            s1 = this.getFragment1().getString().toLowerCase();
            s2 = this.getFragment2().getString().toLowerCase();
            distance = StringDistance.editDistance(s1, s2);
            distance1 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (o.getFragment1().getString().equals(o.getFragment2().getString())) {
            distance2 = 0.0;
        } else {
            s1 = o.getFragment1().getString().toLowerCase();
            s2 = o.getFragment2().getString().toLowerCase();
            distance = StringDistance.editDistance(s1, s2);
            distance2 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (distance1 != distance2) {
            if (this.isIdenticalWithExtractedVariable() && !o.isIdenticalWithExtractedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithExtractedVariable() && o.isIdenticalWithExtractedVariable()) {
                return 1;
            }
            if (this.isIdenticalWithInlinedVariable() && !o.isIdenticalWithInlinedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithInlinedVariable() && o.isIdenticalWithInlinedVariable()) {
                return 1;
            }
            return Double.compare(distance1, distance2);
        }
        if (this.compositeChildMatchingScore != o.compositeChildMatchingScore) {
            return -Double.compare(this.compositeChildMatchingScore, o.compositeChildMatchingScore);
        }
        int depthDiff1 = Math.abs(this.getFragment1().getDepth() - this.getFragment2().getDepth());
        if (depthDiff1 != (depthDiff2 = Math.abs(o.getFragment1().getDepth() - o.getFragment2().getDepth()))) {
            return Integer.valueOf(depthDiff1).compareTo(depthDiff2);
        }
        int indexDiff1 = Math.abs(this.getFragment1().getIndex() - this.getFragment2().getIndex());
        int indexDiff2 = Math.abs(o.getFragment1().getIndex() - o.getFragment2().getIndex());
        return Integer.valueOf(indexDiff1).compareTo(indexDiff2);
    }
}

