/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LeafMapping
extends AbstractCodeMapping
implements Comparable<LeafMapping> {
    public LeafMapping(AbstractCodeFragment statement1, AbstractCodeFragment statement2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        super(statement1, statement2, operation1, operation2);
    }

    @Override
    public int compareTo(LeafMapping o) {
        int indexDiff2;
        int depthDiff2;
        double distance2;
        int distance;
        String s2;
        String s1;
        double distance1;
        CompositeReplacement compositeReplacement1 = this.containsCompositeReplacement();
        CompositeReplacement compositeReplacement2 = o.containsCompositeReplacement();
        boolean concatenationReplacement1 = this.containsReplacement(Replacement.ReplacementType.CONCATENATION);
        boolean concatenationReplacement2 = o.containsReplacement(Replacement.ReplacementType.CONCATENATION);
        if (compositeReplacement1 != null || compositeReplacement2 != null) {
            if (compositeReplacement1 != null && compositeReplacement2 == null) {
                return -1;
            }
            if (compositeReplacement1 == null && compositeReplacement2 != null) {
                return 1;
            }
            return -Integer.compare(compositeReplacement1.getTotalAdditionallyMatchedStatements(), compositeReplacement2.getTotalAdditionallyMatchedStatements());
        }
        if (concatenationReplacement1 != concatenationReplacement2) {
            if (concatenationReplacement1 && !concatenationReplacement2) {
                return 1;
            }
            return -1;
        }
        if (this.getFragment1().getString().equals(this.getFragment2().getString())) {
            distance1 = 0.0;
        } else {
            s1 = LeafMapping.removeGenericTypeAfterDot(this.getFragment1().getString().toLowerCase());
            s2 = LeafMapping.removeGenericTypeAfterDot(this.getFragment2().getString().toLowerCase());
            distance = StringDistance.editDistance(s1, s2);
            distance1 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (o.getFragment1().getString().equals(o.getFragment2().getString())) {
            distance2 = 0.0;
        } else {
            s1 = LeafMapping.removeGenericTypeAfterDot(o.getFragment1().getString().toLowerCase());
            s2 = LeafMapping.removeGenericTypeAfterDot(o.getFragment2().getString().toLowerCase());
            distance = StringDistance.editDistance(s1, s2);
            distance2 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (distance1 != distance2) {
            if (this.isIdenticalWithExtractedVariable() && !o.isIdenticalWithExtractedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithExtractedVariable() && o.isIdenticalWithExtractedVariable()) {
                return 1;
            }
            if (this.isIdenticalWithInlinedVariable() && !o.isIdenticalWithInlinedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithInlinedVariable() && o.isIdenticalWithInlinedVariable()) {
                return 1;
            }
            if (this.identicalDepthIndexAndParentType() && !o.identicalDepthIndexAndParentType()) {
                return -1;
            }
            if (!this.identicalDepthIndexAndParentType() && o.identicalDepthIndexAndParentType()) {
                return 1;
            }
            if (this.referencesMapping(o)) {
                return 1;
            }
            if (o.referencesMapping(this)) {
                return -1;
            }
            return Double.compare(distance1, distance2);
        }
        int depthDiff1 = Math.abs(this.getFragment1().getDepth() - this.getFragment2().getDepth());
        if (depthDiff1 != (depthDiff2 = Math.abs(o.getFragment1().getDepth() - o.getFragment2().getDepth()))) {
            return Integer.valueOf(depthDiff1).compareTo(depthDiff2);
        }
        int indexDiff1 = Math.abs(this.getFragment1().getIndex() - this.getFragment2().getIndex());
        if (indexDiff1 != (indexDiff2 = Math.abs(o.getFragment1().getIndex() - o.getFragment2().getIndex()))) {
            return Integer.valueOf(indexDiff1).compareTo(indexDiff2);
        }
        boolean sameVariableDeclarationTypeInParent1 = this.sameVariableDeclarationTypeInParent();
        boolean sameVariableDeclarationTypeInParent2 = o.sameVariableDeclarationTypeInParent();
        double parentEditDistance1 = this.parentEditDistance();
        double parentEditDistance2 = o.parentEditDistance();
        if (parentEditDistance1 >= 0.0 && parentEditDistance2 >= 0.0 && sameVariableDeclarationTypeInParent1 != sameVariableDeclarationTypeInParent2) {
            if (sameVariableDeclarationTypeInParent1 && !sameVariableDeclarationTypeInParent2) {
                return -1;
            }
            if (!sameVariableDeclarationTypeInParent1 && sameVariableDeclarationTypeInParent2) {
                return 1;
            }
        }
        return Double.compare(parentEditDistance1, parentEditDistance2);
    }

    private boolean referencesMapping(LeafMapping o) {
        if (this.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && o.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && o.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment1().equals(o.getFragment1()) && o.getFragment2().getLocationInfo().getEndOffset() < this.getFragment2().getLocationInfo().getStartOffset()) {
            List<VariableDeclaration> variableDeclarations2 = o.getFragment2().getVariableDeclarations();
            Map<String, List<ObjectCreation>> creationMap2 = this.getFragment2().getCreationMap();
            for (VariableDeclaration declaration2 : variableDeclarations2) {
                for (String key : creationMap2.keySet()) {
                    List<ObjectCreation> creations = creationMap2.get(key);
                    for (ObjectCreation creation : creations) {
                        if (creation.getAnonymousClassDeclaration() != null) {
                            return false;
                        }
                        List<String> arguments = creation.getArguments();
                        if (arguments.size() != 1 || !arguments.contains(declaration2.getVariableName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static String removeGenericTypeAfterDot(String s) {
        int indexOfGenericTypeEnd;
        int indexOfGenericTypeStart;
        if (((String)s).contains(".<") && (indexOfGenericTypeStart = ((String)s).indexOf(".<")) < (indexOfGenericTypeEnd = ((String)s).indexOf(">", indexOfGenericTypeStart))) {
            s = ((String)s).substring(0, indexOfGenericTypeStart) + "." + ((String)s).substring(indexOfGenericTypeEnd + 1, ((String)s).length());
        }
        return s;
    }

    private boolean identicalDepthIndexAndParentType() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        if (this.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT)) {
            return false;
        }
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 != null && parent2 != null) {
            return parent1.getLocationInfo().getCodeElementType().equals((Object)parent2.getLocationInfo().getCodeElementType()) && !parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE) && this.getFragment1().getDepth() == this.getFragment2().getDepth() && this.getFragment1().getIndex() == this.getFragment2().getIndex();
        }
        return false;
    }

    private boolean sameVariableDeclarationTypeInParent() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 != null && parent2 != null) {
            List<VariableDeclaration> declarations1 = parent1.getVariableDeclarations();
            List<VariableDeclaration> declarations2 = parent2.getVariableDeclarations();
            if (declarations1.size() == declarations2.size()) {
                for (int i = 0; i < declarations1.size(); ++i) {
                    VariableDeclaration declaration2;
                    VariableDeclaration declaration1 = declarations1.get(i);
                    if (declaration1.equalType(declaration2 = declarations2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private double parentEditDistance() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 == null && parent2 == null) {
            return 0.0;
        }
        if (parent1 == null && parent2 != null) {
            String s2 = parent2.getString();
            int distance = StringDistance.editDistance("{", s2);
            double normalized = (double)distance / (double)Math.max(1, s2.length());
            return normalized;
        }
        if (parent1 != null && parent2 == null) {
            String s1 = parent1.getString();
            int distance = StringDistance.editDistance(s1, "{");
            double normalized = (double)distance / (double)Math.max(s1.length(), 1);
            return normalized;
        }
        String s1 = parent1.getString();
        String s2 = parent2.getString();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public Set<String> callChainIntersection() {
        AbstractCall invocation1 = this.getFragment1().invocationCoveringEntireFragment();
        AbstractCall invocation2 = this.getFragment2().invocationCoveringEntireFragment();
        return invocation1.callChainIntersection(invocation2);
    }
}

