/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Type;

public class ObjectCreation
extends AbstractCall {
    private UMLType type;
    private String anonymousClassDeclaration;
    private boolean isArray = false;
    private volatile int hashCode = 0;

    public ObjectCreation(CompilationUnit cu, String filePath, ClassInstanceCreation creation) {
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)creation, LocationInfo.CodeElementType.CLASS_INSTANCE_CREATION);
        this.type = UMLType.extractTypeObject(cu, filePath, creation.getType(), 0);
        this.typeArguments = creation.arguments().size();
        this.arguments = new ArrayList();
        List args = creation.arguments();
        for (Expression argument : args) {
            this.arguments.add(argument.toString());
        }
        if (creation.getExpression() != null) {
            this.expression = creation.getExpression().toString();
        }
        if (creation.getAnonymousClassDeclaration() != null) {
            this.anonymousClassDeclaration = creation.getAnonymousClassDeclaration().toString();
        }
    }

    public ObjectCreation(CompilationUnit cu, String filePath, ArrayCreation creation) {
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)creation, LocationInfo.CodeElementType.ARRAY_CREATION);
        this.isArray = true;
        this.type = UMLType.extractTypeObject(cu, filePath, (Type)creation.getType(), 0);
        this.typeArguments = creation.dimensions().size();
        this.arguments = new ArrayList();
        List args = creation.dimensions();
        for (Expression argument : args) {
            this.arguments.add(argument.toString());
        }
        if (creation.getInitializer() != null) {
            this.anonymousClassDeclaration = creation.getInitializer().toString();
        }
    }

    @Override
    public String getName() {
        return this.getType().toString();
    }

    public UMLType getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration;
    }

    private ObjectCreation() {
    }

    @Override
    public ObjectCreation update(String oldExpression, String newExpression) {
        ObjectCreation newObjectCreation = new ObjectCreation();
        newObjectCreation.type = this.type;
        newObjectCreation.locationInfo = this.locationInfo;
        this.update(newObjectCreation, oldExpression, newExpression);
        return newObjectCreation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectCreation) {
            ObjectCreation creation = (ObjectCreation)o;
            return this.type.equals(creation.type) && this.isArray == creation.isArray && this.typeArguments == creation.typeArguments;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(this.type);
        sb.append("(");
        if (this.typeArguments > 0) {
            for (int i = 0; i < this.typeArguments - 1; ++i) {
                sb.append("arg" + i).append(", ");
            }
            sb.append("arg" + (this.typeArguments - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.type.hashCode();
            result = 37 * result + (this.isArray ? 1 : 0);
            this.hashCode = result = 37 * result + this.typeArguments;
        }
        return this.hashCode;
    }

    public boolean identicalArrayInitializer(ObjectCreation other) {
        if (this.isArray && other.isArray) {
            if (this.anonymousClassDeclaration != null && other.anonymousClassDeclaration != null) {
                return this.anonymousClassDeclaration.equals(other.anonymousClassDeclaration);
            }
            if (this.anonymousClassDeclaration == null && other.anonymousClassDeclaration == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getType().toString().toLowerCase();
        String s2 = ((ObjectCreation)call).getType().toString().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        return this.getType().equals(((ObjectCreation)call).getType());
    }

    @Override
    public String actualString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(super.actualString());
        return sb.toString();
    }
}

