/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.TryStatementObject;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class OperationBody {
    private CompositeStatementObject compositeStatement;
    private List<String> stringRepresentation;
    private boolean containsAssertion;
    private Set<VariableDeclaration> activeVariableDeclarations;
    private VariableDeclarationContainer container;
    private int bodyHashCode;

    public OperationBody(CompilationUnit cu, String filePath, Block methodBody, VariableDeclarationContainer container) {
        this.compositeStatement = new CompositeStatementObject(cu, filePath, (ASTNode)methodBody, 0, LocationInfo.CodeElementType.BLOCK);
        this.container = container;
        this.bodyHashCode = methodBody.toString().hashCode();
        this.activeVariableDeclarations = new HashSet<VariableDeclaration>();
        this.activeVariableDeclarations.addAll(container != null ? container.getParameterDeclarationList() : Collections.emptyList());
        List statements = methodBody.statements();
        for (Statement statement : statements) {
            this.processStatement(cu, filePath, this.compositeStatement, statement);
        }
        for (AbstractCall invocation : this.getAllOperationInvocations()) {
            if (!invocation.getName().startsWith("assert")) continue;
            this.containsAssertion = true;
            break;
        }
        this.activeVariableDeclarations = null;
    }

    public int statementCount() {
        return this.compositeStatement.statementCount();
    }

    public CompositeStatementObject getCompositeStatement() {
        return this.compositeStatement;
    }

    public boolean containsAssertion() {
        return this.containsAssertion;
    }

    public List<AnonymousClassDeclarationObject> getAllAnonymousClassDeclarations() {
        return new ArrayList<AnonymousClassDeclarationObject>(this.compositeStatement.getAllAnonymousClassDeclarations());
    }

    public List<AbstractCall> getAllOperationInvocations() {
        ArrayList<AbstractCall> invocations = new ArrayList<AbstractCall>();
        Map<String, List<AbstractCall>> invocationMap = this.compositeStatement.getAllMethodInvocations();
        for (String key : invocationMap.keySet()) {
            invocations.addAll((Collection<AbstractCall>)invocationMap.get(key));
        }
        return invocations;
    }

    public List<LambdaExpressionObject> getAllLambdas() {
        return new ArrayList<LambdaExpressionObject>(this.compositeStatement.getAllLambdas());
    }

    public List<String> getAllVariables() {
        return new ArrayList<String>(this.compositeStatement.getAllVariables());
    }

    public List<VariableDeclaration> getAllVariableDeclarations() {
        return new ArrayList<VariableDeclaration>(this.compositeStatement.getAllVariableDeclarations());
    }

    public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        return new ArrayList<VariableDeclaration>(this.compositeStatement.getVariableDeclarationsInScope(location));
    }

    public VariableDeclaration getVariableDeclaration(String variableName) {
        return this.compositeStatement.getVariableDeclaration(variableName);
    }

    private void processStatement(CompilationUnit cu, String filePath, CompositeStatementObject parent, Statement statement) {
        if (statement instanceof Block) {
            Block block = (Block)statement;
            List blockStatements = block.statements();
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)block, parent.getDepth() + 1, LocationInfo.CodeElementType.BLOCK);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
            for (Statement blockStatement : blockStatements) {
                this.processStatement(cu, filePath, child, blockStatement);
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)ifStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.IF_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, ifStatement.getExpression(), LocationInfo.CodeElementType.IF_STATEMENT_CONDITION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            this.processStatement(cu, filePath, child, ifStatement.getThenStatement());
            if (ifStatement.getElseStatement() != null) {
                this.processStatement(cu, filePath, child, ifStatement.getElseStatement());
            }
        } else if (statement instanceof ForStatement) {
            ForStatement forStatement = (ForStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)forStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.FOR_STATEMENT);
            parent.addStatement(child);
            List initializers = forStatement.initializers();
            for (Expression initializer : initializers) {
                AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, initializer, LocationInfo.CodeElementType.FOR_STATEMENT_INITIALIZER, this.container);
                child.addExpression(abstractExpression);
            }
            Expression expression = forStatement.getExpression();
            if (expression != null) {
                AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, expression, LocationInfo.CodeElementType.FOR_STATEMENT_CONDITION, this.container);
                child.addExpression(abstractExpression);
            }
            List updaters = forStatement.updaters();
            for (Expression updater : updaters) {
                AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, updater, LocationInfo.CodeElementType.FOR_STATEMENT_UPDATER, this.container);
                child.addExpression(abstractExpression);
            }
            this.addStatementInVariableScopes(child);
            List<VariableDeclaration> variableDeclarations = child.getVariableDeclarations();
            this.activeVariableDeclarations.addAll(variableDeclarations);
            this.processStatement(cu, filePath, child, forStatement.getBody());
            this.activeVariableDeclarations.removeAll(variableDeclarations);
        } else if (statement instanceof EnhancedForStatement) {
            EnhancedForStatement enhancedForStatement = (EnhancedForStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)enhancedForStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT);
            parent.addStatement(child);
            SingleVariableDeclaration variableDeclaration = enhancedForStatement.getParameter();
            VariableDeclaration vd = new VariableDeclaration(cu, filePath, variableDeclaration, this.container);
            child.addVariableDeclaration(vd);
            AbstractExpression variableDeclarationName = new AbstractExpression(cu, filePath, (Expression)variableDeclaration.getName(), LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT_PARAMETER_NAME, this.container);
            child.addExpression(variableDeclarationName);
            if (variableDeclaration.getInitializer() != null) {
                AbstractExpression variableDeclarationInitializer = new AbstractExpression(cu, filePath, variableDeclaration.getInitializer(), LocationInfo.CodeElementType.VARIABLE_DECLARATION_INITIALIZER, this.container);
                child.addExpression(variableDeclarationInitializer);
            }
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, enhancedForStatement.getExpression(), LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT_EXPRESSION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            List<VariableDeclaration> variableDeclarations = child.getVariableDeclarations();
            this.activeVariableDeclarations.addAll(variableDeclarations);
            this.processStatement(cu, filePath, child, enhancedForStatement.getBody());
            this.activeVariableDeclarations.removeAll(variableDeclarations);
        } else if (statement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)whileStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.WHILE_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, whileStatement.getExpression(), LocationInfo.CodeElementType.WHILE_STATEMENT_CONDITION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            this.processStatement(cu, filePath, child, whileStatement.getBody());
        } else if (statement instanceof DoStatement) {
            DoStatement doStatement = (DoStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)doStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.DO_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, doStatement.getExpression(), LocationInfo.CodeElementType.DO_STATEMENT_CONDITION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            this.processStatement(cu, filePath, child, doStatement.getBody());
        } else if (statement instanceof ExpressionStatement) {
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)expressionStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.EXPRESSION_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof SwitchStatement) {
            SwitchStatement switchStatement = (SwitchStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)switchStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.SWITCH_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, switchStatement.getExpression(), LocationInfo.CodeElementType.SWITCH_STATEMENT_CONDITION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            List switchStatements = switchStatement.statements();
            for (Statement switchStatement2 : switchStatements) {
                this.processStatement(cu, filePath, child, switchStatement2);
            }
        } else if (statement instanceof SwitchCase) {
            SwitchCase switchCase = (SwitchCase)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)switchCase, parent.getDepth() + 1, LocationInfo.CodeElementType.SWITCH_CASE, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof AssertStatement) {
            AssertStatement assertStatement = (AssertStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)assertStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.ASSERT_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof LabeledStatement) {
            LabeledStatement labeledStatement = (LabeledStatement)statement;
            SimpleName label = labeledStatement.getLabel();
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)labeledStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.LABELED_STATEMENT.setName(label.getIdentifier()));
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
            this.processStatement(cu, filePath, child, labeledStatement.getBody());
        } else if (statement instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)returnStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.RETURN_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof SynchronizedStatement) {
            SynchronizedStatement synchronizedStatement = (SynchronizedStatement)statement;
            CompositeStatementObject child = new CompositeStatementObject(cu, filePath, (ASTNode)synchronizedStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.SYNCHRONIZED_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(cu, filePath, synchronizedStatement.getExpression(), LocationInfo.CodeElementType.SYNCHRONIZED_STATEMENT_EXPRESSION, this.container);
            child.addExpression(abstractExpression);
            this.addStatementInVariableScopes(child);
            this.processStatement(cu, filePath, child, (Statement)synchronizedStatement.getBody());
        } else if (statement instanceof ThrowStatement) {
            ThrowStatement throwStatement = (ThrowStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)throwStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.THROW_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)statement;
            TryStatementObject child = new TryStatementObject(cu, filePath, (Statement)tryStatement, parent.getDepth() + 1);
            parent.addStatement(child);
            List resources = tryStatement.resources();
            for (Expression resource : resources) {
                AbstractExpression expression = new AbstractExpression(cu, filePath, resource, LocationInfo.CodeElementType.TRY_STATEMENT_RESOURCE, this.container);
                child.addExpression(expression);
            }
            this.addStatementInVariableScopes(child);
            List<VariableDeclaration> variableDeclarations = child.getVariableDeclarations();
            this.activeVariableDeclarations.addAll(variableDeclarations);
            List tryStatements = tryStatement.getBody().statements();
            for (Object blockStatement : tryStatements) {
                this.processStatement(cu, filePath, child, (Statement)blockStatement);
            }
            this.activeVariableDeclarations.removeAll(variableDeclarations);
            List catchClauses = tryStatement.catchClauses();
            for (CatchClause catchClause : catchClauses) {
                Block catchClauseBody = catchClause.getBody();
                CompositeStatementObject catchClauseStatementObject = new CompositeStatementObject(cu, filePath, (ASTNode)catchClause, parent.getDepth() + 1, LocationInfo.CodeElementType.CATCH_CLAUSE);
                child.addCatchClause(catchClauseStatementObject);
                parent.addStatement(catchClauseStatementObject);
                SingleVariableDeclaration variableDeclaration = catchClause.getException();
                VariableDeclaration vd = new VariableDeclaration(cu, filePath, variableDeclaration, this.container);
                catchClauseStatementObject.addVariableDeclaration(vd);
                AbstractExpression variableDeclarationName = new AbstractExpression(cu, filePath, (Expression)variableDeclaration.getName(), LocationInfo.CodeElementType.CATCH_CLAUSE_EXCEPTION_NAME, this.container);
                catchClauseStatementObject.addExpression(variableDeclarationName);
                if (variableDeclaration.getInitializer() != null) {
                    AbstractExpression variableDeclarationInitializer = new AbstractExpression(cu, filePath, variableDeclaration.getInitializer(), LocationInfo.CodeElementType.VARIABLE_DECLARATION_INITIALIZER, this.container);
                    catchClauseStatementObject.addExpression(variableDeclarationInitializer);
                }
                this.addStatementInVariableScopes(catchClauseStatementObject);
                List<VariableDeclaration> catchClauseVariableDeclarations = catchClauseStatementObject.getVariableDeclarations();
                this.activeVariableDeclarations.addAll(catchClauseVariableDeclarations);
                List blockStatements = catchClauseBody.statements();
                for (Statement blockStatement : blockStatements) {
                    this.processStatement(cu, filePath, catchClauseStatementObject, blockStatement);
                }
                this.activeVariableDeclarations.removeAll(catchClauseVariableDeclarations);
            }
            Block finallyBlock = tryStatement.getFinally();
            if (finallyBlock != null) {
                CompositeStatementObject finallyClauseStatementObject = new CompositeStatementObject(cu, filePath, (ASTNode)finallyBlock, parent.getDepth() + 1, LocationInfo.CodeElementType.FINALLY_BLOCK);
                child.setFinallyClause(finallyClauseStatementObject);
                parent.addStatement(finallyClauseStatementObject);
                this.addStatementInVariableScopes(finallyClauseStatementObject);
                List blockStatements = finallyBlock.statements();
                for (Statement blockStatement : blockStatements) {
                    this.processStatement(cu, filePath, finallyClauseStatementObject, blockStatement);
                }
            }
        } else if (statement instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)variableDeclarationStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
            this.activeVariableDeclarations.addAll(child.getVariableDeclarations());
        } else if (statement instanceof ConstructorInvocation) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)constructorInvocation, parent.getDepth() + 1, LocationInfo.CodeElementType.CONSTRUCTOR_INVOCATION, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)superConstructorInvocation, parent.getDepth() + 1, LocationInfo.CodeElementType.SUPER_CONSTRUCTOR_INVOCATION, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof BreakStatement) {
            BreakStatement breakStatement = (BreakStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)breakStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.BREAK_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof ContinueStatement) {
            ContinueStatement continueStatement = (ContinueStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)continueStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.CONTINUE_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        } else if (statement instanceof EmptyStatement) {
            EmptyStatement emptyStatement = (EmptyStatement)statement;
            StatementObject child = new StatementObject(cu, filePath, (Statement)emptyStatement, parent.getDepth() + 1, LocationInfo.CodeElementType.EMPTY_STATEMENT, this.container);
            parent.addStatement(child);
            this.addStatementInVariableScopes(child);
        }
    }

    private void addStatementInVariableScopes(AbstractStatement statement) {
        for (VariableDeclaration variableDeclaration : this.activeVariableDeclarations) {
            variableDeclaration.addStatementInScope(statement);
            if (this.container == null) continue;
            for (AnonymousClassDeclarationObject anonymous : statement.getAnonymousClassDeclarations()) {
                UMLAnonymousClass anonymousClass = this.container.findAnonymousClass(anonymous);
                for (UMLOperation operation : anonymousClass.getOperations()) {
                    if (operation.getBody() == null) continue;
                    CompositeStatementObject compositeStatementObject = operation.getBody().getCompositeStatement();
                    for (AbstractStatement abstractStatement : compositeStatementObject.getInnerNodes()) {
                        variableDeclaration.addStatementInScope(abstractStatement);
                    }
                    for (AbstractCodeFragment abstractCodeFragment : compositeStatementObject.getLeaves()) {
                        variableDeclaration.addStatementInScope(abstractCodeFragment);
                    }
                }
            }
            for (LambdaExpressionObject lambda : statement.getLambdas()) {
                AbstractExpression lambdaExpression;
                OperationBody lambdaBody = lambda.getBody();
                if (lambdaBody != null) {
                    CompositeStatementObject composite = lambdaBody.getCompositeStatement();
                    for (AbstractStatement abstractStatement : composite.getInnerNodes()) {
                        variableDeclaration.addStatementInScope(abstractStatement);
                    }
                    for (AbstractCodeFragment abstractCodeFragment : composite.getLeaves()) {
                        variableDeclaration.addStatementInScope(abstractCodeFragment);
                    }
                }
                if ((lambdaExpression = lambda.getExpression()) == null) continue;
                variableDeclaration.addStatementInScope(lambdaExpression);
            }
        }
    }

    public Map<String, Set<String>> aliasedVariables() {
        return this.compositeStatement.aliasedVariables();
    }

    public Map<String, Set<String>> aliasedAttributes() {
        return this.compositeStatement.aliasedAttributes();
    }

    public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        return this.compositeStatement.loopWithVariables(currentElementName, collectionName);
    }

    public int getBodyHashCode() {
        return this.bodyHashCode;
    }

    public List<String> stringRepresentation() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.compositeStatement.stringRepresentation();
        }
        return this.stringRepresentation;
    }
}

