/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;

public class TernaryOperatorExpression {
    private AbstractExpression condition;
    private AbstractExpression thenExpression;
    private AbstractExpression elseExpression;
    private String expression;

    public TernaryOperatorExpression(CompilationUnit cu, String filePath, ConditionalExpression expression, VariableDeclarationContainer container) {
        this.condition = new AbstractExpression(cu, filePath, expression.getExpression(), LocationInfo.CodeElementType.TERNARY_OPERATOR_CONDITION, container);
        this.thenExpression = new AbstractExpression(cu, filePath, expression.getThenExpression(), LocationInfo.CodeElementType.TERNARY_OPERATOR_THEN_EXPRESSION, container);
        this.elseExpression = new AbstractExpression(cu, filePath, expression.getElseExpression(), LocationInfo.CodeElementType.TERNARY_OPERATOR_ELSE_EXPRESSION, container);
        this.expression = expression.toString();
    }

    public AbstractExpression getCondition() {
        return this.condition;
    }

    public AbstractExpression getThenExpression() {
        return this.thenExpression;
    }

    public AbstractExpression getElseExpression() {
        return this.elseExpression;
    }

    public String getExpression() {
        return this.expression;
    }

    public Replacement makeReplacementWithTernaryOnTheRight(String statement) {
        if (this.getElseExpression().getString().equals(statement)) {
            return new Replacement(statement, this.getExpression(), Replacement.ReplacementType.EXPRESSION_REPLACED_WITH_TERNARY_ELSE);
        }
        if (this.getThenExpression().getString().equals(statement)) {
            return new Replacement(statement, this.getExpression(), Replacement.ReplacementType.EXPRESSION_REPLACED_WITH_TERNARY_THEN);
        }
        return null;
    }

    public Replacement makeReplacementWithTernaryOnTheLeft(String statement) {
        if (this.getElseExpression().getString().equals(statement)) {
            return new Replacement(this.getExpression(), statement, Replacement.ReplacementType.EXPRESSION_REPLACED_WITH_TERNARY_ELSE);
        }
        if (this.getThenExpression().getString().equals(statement)) {
            return new Replacement(this.getExpression(), statement, Replacement.ReplacementType.EXPRESSION_REPLACED_WITH_TERNARY_THEN);
        }
        return null;
    }
}

