/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReferenceExtractor;
import gr.uom.java.xmi.decomposition.VariableScope;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.decomposition.replacement.ConsistentReplacementDetector;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.SplitVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.VariableDeclarationReplacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.AddVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddVariableModifierRefactoring;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.CandidateMergeVariableRefactoring;
import gr.uom.java.xmi.diff.CandidateSplitVariableRefactoring;
import gr.uom.java.xmi.diff.ChangeVariableTypeRefactoring;
import gr.uom.java.xmi.diff.ExtractAttributeRefactoring;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InlineAttributeRefactoring;
import gr.uom.java.xmi.diff.InlineVariableRefactoring;
import gr.uom.java.xmi.diff.MergeVariableRefactoring;
import gr.uom.java.xmi.diff.ModifyVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveVariableModifierRefactoring;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.SplitVariableRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLParameterDiff;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.util.PrefixSuffixUtils;

public class VariableReplacementAnalysis {
    private UMLOperationBodyMapper mapper;
    private Set<AbstractCodeMapping> mappings;
    private List<AbstractCodeFragment> nonMappedLeavesT1;
    private List<AbstractCodeFragment> nonMappedLeavesT2;
    private List<CompositeStatementObject> nonMappedInnerNodesT1;
    private List<CompositeStatementObject> nonMappedInnerNodesT2;
    private VariableDeclarationContainer operation1;
    private VariableDeclarationContainer operation2;
    private List<UMLOperationBodyMapper> childMappers;
    private Set<Refactoring> refactorings;
    private VariableDeclarationContainer callSiteOperation;
    private UMLOperationDiff operationDiff;
    private UMLAbstractClassDiff classDiff;
    private Set<VariableDeclaration> removedVariables = new LinkedHashSet<VariableDeclaration>();
    private Set<VariableDeclaration> removedVariablesStoringTheReturnOfInlinedMethod = new LinkedHashSet<VariableDeclaration>();
    private Set<VariableDeclaration> removedVariablesInAnonymousClassDeclarations = new LinkedHashSet<VariableDeclaration>();
    private Set<VariableDeclaration> addedVariables = new LinkedHashSet<VariableDeclaration>();
    private Set<VariableDeclaration> addedVariablesStoringTheReturnOfExtractedMethod = new LinkedHashSet<VariableDeclaration>();
    private Set<VariableDeclaration> addedVariablesInAnonymousClassDeclarations = new LinkedHashSet<VariableDeclaration>();
    private Set<Pair<VariableDeclaration, VariableDeclaration>> matchedVariables = new LinkedHashSet<Pair<VariableDeclaration, VariableDeclaration>>();
    private Set<Pair<VariableDeclaration, VariableDeclaration>> movedVariables = new LinkedHashSet<Pair<VariableDeclaration, VariableDeclaration>>();
    private Set<RenameVariableRefactoring> variableRenames = new LinkedHashSet<RenameVariableRefactoring>();
    private Set<MergeVariableRefactoring> variableMerges = new LinkedHashSet<MergeVariableRefactoring>();
    private Set<SplitVariableRefactoring> variableSplits = new LinkedHashSet<SplitVariableRefactoring>();
    private Set<CandidateAttributeRefactoring> candidateAttributeRenames = new LinkedHashSet<CandidateAttributeRefactoring>();
    private Set<CandidateMergeVariableRefactoring> candidateAttributeMerges = new LinkedHashSet<CandidateMergeVariableRefactoring>();
    private Set<CandidateSplitVariableRefactoring> candidateAttributeSplits = new LinkedHashSet<CandidateSplitVariableRefactoring>();
    private boolean insideExtractedOrInlinedMethod = false;
    private Map<String, Set<String>> aliasedVariablesInOriginalMethod;
    private Map<String, Set<String>> aliasedVariablesInNextMethod;

    public VariableReplacementAnalysis(UMLOperationBodyMapper mapper, Set<Refactoring> refactorings, UMLAbstractClassDiff classDiff, Set<Pair<VariableDeclaration, VariableDeclaration>> previouslyMatchedVariables) {
        this.mapper = mapper;
        this.mappings = mapper.getMappings();
        this.nonMappedLeavesT1 = mapper.getNonMappedLeavesT1();
        this.nonMappedLeavesT2 = mapper.getNonMappedLeavesT2();
        this.nonMappedInnerNodesT1 = mapper.getNonMappedInnerNodesT1();
        this.nonMappedInnerNodesT2 = mapper.getNonMappedInnerNodesT2();
        this.operation1 = mapper.getContainer1();
        this.operation2 = mapper.getContainer2();
        this.aliasedVariablesInOriginalMethod = this.operation1.aliasedVariables();
        this.aliasedVariablesInNextMethod = this.operation2.aliasedVariables();
        this.childMappers = new ArrayList<UMLOperationBodyMapper>();
        this.childMappers.addAll(mapper.getChildMappers());
        UMLOperationBodyMapper parentMapper = mapper.getParentMapper();
        if (parentMapper != null) {
            this.childMappers.addAll(parentMapper.getChildMappers());
        }
        this.refactorings = refactorings;
        this.callSiteOperation = mapper.getCallSiteOperation();
        this.operationDiff = mapper.getOperationSignatureDiff().isPresent() ? mapper.getOperationSignatureDiff().get() : null;
        this.classDiff = classDiff;
        if (!(parentMapper == null || parentMapper.getContainer1().equals(mapper.getContainer1()) && parentMapper.getContainer2().equals(mapper.getContainer2()))) {
            this.insideExtractedOrInlinedMethod = true;
        }
        if (parentMapper != null) {
            this.removedVariables.addAll(this.operation1.getBody() != null ? this.operation1.getBody().getAllVariableDeclarations() : Collections.emptySet());
            this.addedVariables.addAll(this.operation2.getBody() != null ? this.operation2.getBody().getAllVariableDeclarations() : Collections.emptySet());
        } else {
            List<VariableDeclaration> allVariableDeclarations;
            this.removedVariables.addAll(this.operation1.getAllVariableDeclarations());
            for (UMLAnonymousClass uMLAnonymousClass : this.operation1.getAnonymousClassList()) {
                for (UMLOperation operation : uMLAnonymousClass.getOperations()) {
                    allVariableDeclarations = operation.getAllVariableDeclarations();
                    this.removedVariables.addAll(allVariableDeclarations);
                    this.removedVariablesInAnonymousClassDeclarations.addAll(allVariableDeclarations);
                }
            }
            this.addedVariables.addAll(this.operation2.getAllVariableDeclarations());
            for (UMLAnonymousClass uMLAnonymousClass : this.operation2.getAnonymousClassList()) {
                for (UMLOperation operation : uMLAnonymousClass.getOperations()) {
                    allVariableDeclarations = operation.getAllVariableDeclarations();
                    this.addedVariables.addAll(allVariableDeclarations);
                    this.addedVariablesInAnonymousClassDeclarations.addAll(allVariableDeclarations);
                }
            }
        }
        for (Pair pair : previouslyMatchedVariables) {
            this.removedVariables.remove(pair.getLeft());
            this.addedVariables.remove(pair.getRight());
            this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
            if (((VariableDeclaration)pair.getLeft()).getVariableName().equals(((VariableDeclaration)pair.getRight()).getVariableName())) continue;
            Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.mappings);
            RenameVariableRefactoring ref = new RenameVariableRefactoring((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.operation1, this.operation2, variableReferences, this.insideExtractedOrInlinedMethod);
            this.variableRenames.add(ref);
            this.getVariableRefactorings((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.operation1, this.operation2, variableReferences, ref);
        }
        this.processIdenticalAnonymousAndLambdas();
        this.findVariableSplits();
        this.findVariableMerges();
        this.findConsistentVariableRenames();
        this.findAttributeExtractions();
        this.findTypeChanges();
        this.findMatchingVariablesWithoutVariableDeclarationMapping();
        this.findMovedVariablesToExtractedFromInlinedMethods();
        this.findMatchingVariablesWithoutReferenceMapping();
    }

    private void processIdenticalAnonymousAndLambdas() {
        List<UMLAnonymousClass> anonymousClassList1 = this.operation1.getAnonymousClassList();
        List<UMLAnonymousClass> anonymousClassList2 = this.operation2.getAnonymousClassList();
        if (anonymousClassList1.size() == anonymousClassList2.size()) {
            for (int i = 0; i < anonymousClassList1.size(); ++i) {
                UMLAnonymousClass anonymous1 = anonymousClassList1.get(i);
                UMLAnonymousClass anonymous2 = anonymousClassList2.get(i);
                List<UMLOperation> operations1 = anonymous1.getOperations();
                List<UMLOperation> operations2 = anonymous2.getOperations();
                if (operations1.size() != operations2.size()) continue;
                for (int j = 0; j < operations1.size(); ++j) {
                    UMLOperation op1 = operations1.get(j);
                    UMLOperation op2 = operations2.get(j);
                    OperationBody body1 = op1.getBody();
                    OperationBody body2 = op2.getBody();
                    if (body1 == null || body2 == null) continue;
                    List<VariableDeclaration> declarations1 = op1.getParameterDeclarationList();
                    List<VariableDeclaration> declarations2 = op2.getParameterDeclarationList();
                    if (declarations1.toString().equals(declarations2.toString())) {
                        this.processVariableDeclarationsInIdenticalOperations(declarations1, declarations2);
                    }
                    if (body1.getBodyHashCode() != body2.getBodyHashCode()) continue;
                    this.processVariableDeclarationsInIdenticalOperations(body1.getAllVariableDeclarations(), body2.getAllVariableDeclarations());
                }
            }
        }
        List<LambdaExpressionObject> lambdas1 = this.operation1.getAllLambdas();
        List<LambdaExpressionObject> lambdas2 = this.operation2.getAllLambdas();
        if (lambdas1.size() == lambdas2.size()) {
            for (int i = 0; i < lambdas1.size(); ++i) {
                LambdaExpressionObject lambda1 = lambdas1.get(i);
                LambdaExpressionObject lambda2 = lambdas2.get(i);
                OperationBody body1 = lambda1.getBody();
                OperationBody body2 = lambda2.getBody();
                if (body1 == null || body2 == null || body1.getBodyHashCode() != body2.getBodyHashCode()) continue;
                this.processVariableDeclarationsInIdenticalOperations(body1.getAllVariableDeclarations(), body2.getAllVariableDeclarations());
            }
        }
    }

    private void processVariableDeclarationsInIdenticalOperations(List<VariableDeclaration> declarations1, List<VariableDeclaration> declarations2) {
        Iterator<VariableDeclaration> removedVariableIterator = declarations1.iterator();
        Iterator<VariableDeclaration> addedVariableIterator = declarations2.iterator();
        while (removedVariableIterator.hasNext() && addedVariableIterator.hasNext()) {
            VariableDeclaration addedVariable;
            VariableDeclaration removedVariable = removedVariableIterator.next();
            Pair pair = Pair.of((Object)removedVariable, (Object)(addedVariable = addedVariableIterator.next()));
            if (this.matchedVariables.contains(pair) || !removedVariable.getVariableName().equals(addedVariable.getVariableName())) continue;
            this.removedVariables.remove(removedVariable);
            this.addedVariables.remove(addedVariable);
            this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
        }
    }

    private void findMatchingVariablesWithoutReferenceMapping() {
        LinkedHashSet<VariableDeclaration> removedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        LinkedHashSet<VariableDeclaration> addedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        if (this.removedVariables.toString().equals(this.addedVariables.toString())) {
            Iterator<VariableDeclaration> removedVariableIterator = this.removedVariables.iterator();
            Iterator<VariableDeclaration> addedVariableIterator = this.addedVariables.iterator();
            while (removedVariableIterator.hasNext() && addedVariableIterator.hasNext()) {
                VariableDeclaration addedVariable;
                VariableDeclaration removedVariable = removedVariableIterator.next();
                Pair pair = Pair.of((Object)removedVariable, (Object)(addedVariable = addedVariableIterator.next()));
                if (this.matchedVariables.contains(pair) || !removedVariable.getVariableName().equals(addedVariable.getVariableName())) continue;
                removedVariablesToBeRemoved.add(removedVariable);
                addedVariablesToBeRemoved.add(addedVariable);
                this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
            }
        } else if (this.operation1.getBody() != null && this.operation2.getBody() != null && this.operation1.getBodyHashCode() == this.operation2.getBodyHashCode()) {
            if (this.removedVariables.size() <= this.addedVariables.size()) {
                for (VariableDeclaration removedVariable : this.removedVariables) {
                    if (removedVariablesToBeRemoved.contains(removedVariable)) continue;
                    for (VariableDeclaration addedVariable : this.addedVariables) {
                        Pair pair;
                        if (addedVariablesToBeRemoved.contains(addedVariable) || this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !addedVariable.getVariableName().equals(removedVariable.getVariableName()) || !addedVariable.equalType(removedVariable)) continue;
                        removedVariablesToBeRemoved.add(removedVariable);
                        addedVariablesToBeRemoved.add(addedVariable);
                        this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                        this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                    }
                }
            } else {
                for (VariableDeclaration addedVariable : this.addedVariables) {
                    if (addedVariablesToBeRemoved.contains(addedVariable)) continue;
                    for (VariableDeclaration removedVariable : this.removedVariables) {
                        Pair pair;
                        if (removedVariablesToBeRemoved.contains(removedVariable) || this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !addedVariable.getVariableName().equals(removedVariable.getVariableName()) || !addedVariable.equalType(removedVariable)) continue;
                        removedVariablesToBeRemoved.add(removedVariable);
                        addedVariablesToBeRemoved.add(addedVariable);
                        this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                        this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                    }
                }
            }
        } else if (this.removedVariables.size() <= this.addedVariables.size()) {
            for (VariableDeclaration removedVariable : this.removedVariables) {
                if (removedVariablesToBeRemoved.contains(removedVariable) || !removedVariable.isParameter()) continue;
                for (VariableDeclaration addedVariable : this.addedVariables) {
                    Pair pair;
                    if (addedVariablesToBeRemoved.contains(addedVariable) || removedVariablesToBeRemoved.contains(removedVariable) || !addedVariable.isParameter() || this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !addedVariable.getVariableName().equals(removedVariable.getVariableName()) || !addedVariable.equalType(removedVariable)) continue;
                    removedVariablesToBeRemoved.add(removedVariable);
                    addedVariablesToBeRemoved.add(addedVariable);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                    this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                }
            }
        } else {
            for (VariableDeclaration addedVariable : this.addedVariables) {
                if (addedVariablesToBeRemoved.contains(addedVariable) || !addedVariable.isParameter()) continue;
                for (VariableDeclaration removedVariable : this.removedVariables) {
                    Pair pair;
                    if (removedVariablesToBeRemoved.contains(removedVariable) || addedVariablesToBeRemoved.contains(addedVariable) || !removedVariable.isParameter() || this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !addedVariable.getVariableName().equals(removedVariable.getVariableName()) || !addedVariable.equalType(removedVariable)) continue;
                    removedVariablesToBeRemoved.add(removedVariable);
                    addedVariablesToBeRemoved.add(addedVariable);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                    this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                }
            }
        }
        this.removedVariables.removeAll(removedVariablesToBeRemoved);
        this.addedVariables.removeAll(addedVariablesToBeRemoved);
    }

    private void findMovedVariablesToExtractedFromInlinedMethods() {
        LinkedHashSet<VariableDeclaration> removedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        for (VariableDeclaration removedVariable : this.removedVariables) {
            block1: for (UMLOperationBodyMapper childMapper : this.childMappers) {
                Set<Pair<VariableDeclaration, VariableDeclaration>> pairs = childMapper.getMatchedVariables();
                for (Pair<VariableDeclaration, VariableDeclaration> pair : pairs) {
                    if (!removedVariable.equals(pair.getKey())) continue;
                    removedVariablesToBeRemoved.add(removedVariable);
                    this.movedVariables.add(pair);
                    continue block1;
                }
            }
        }
        this.removedVariables.removeAll(removedVariablesToBeRemoved);
        LinkedHashSet<VariableDeclaration> addedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        for (VariableDeclaration addedVariable : this.addedVariables) {
            block4: for (UMLOperationBodyMapper childMapper : this.childMappers) {
                Set<Pair<VariableDeclaration, VariableDeclaration>> pairs = childMapper.getMatchedVariables();
                for (Pair<VariableDeclaration, VariableDeclaration> pair : pairs) {
                    if (!addedVariable.equals(pair.getValue())) continue;
                    addedVariablesToBeRemoved.add(addedVariable);
                    this.movedVariables.add(pair);
                    continue block4;
                }
            }
        }
        this.addedVariables.removeAll(addedVariablesToBeRemoved);
    }

    private void findMatchingVariablesWithoutVariableDeclarationMapping() {
        LinkedHashSet<VariableDeclaration> removedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        LinkedHashSet<VariableDeclaration> addedVariablesToBeRemoved = new LinkedHashSet<VariableDeclaration>();
        if (this.removedVariables.size() <= this.addedVariables.size()) {
            for (VariableDeclaration removedVariable : this.removedVariables) {
                if (!removedVariablesToBeRemoved.contains(removedVariable) && this.callsInlinedMethod(removedVariable)) {
                    this.removedVariablesStoringTheReturnOfInlinedMethod.add(removedVariable);
                    removedVariablesToBeRemoved.add(removedVariable);
                }
                for (VariableDeclaration addedVariable : this.addedVariables) {
                    Pair pair;
                    if (!addedVariablesToBeRemoved.contains(addedVariable) && this.callsExtractedMethod(addedVariable)) {
                        this.addedVariablesStoringTheReturnOfExtractedMethod.add(addedVariable);
                        addedVariablesToBeRemoved.add(addedVariable);
                    }
                    if (this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !removedVariable.getVariableName().equals(addedVariable.getVariableName()) || this.bothCatchExceptionVariables(removedVariable, addedVariable) || this.containerElementRelationship(removedVariable, addedVariable) || !this.mappedStatementWithinVariableScopes(removedVariable, addedVariable)) continue;
                    removedVariablesToBeRemoved.add(removedVariable);
                    addedVariablesToBeRemoved.add(addedVariable);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                    this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                }
            }
        } else {
            for (VariableDeclaration addedVariable : this.addedVariables) {
                if (!addedVariablesToBeRemoved.contains(addedVariable) && this.callsExtractedMethod(addedVariable)) {
                    this.addedVariablesStoringTheReturnOfExtractedMethod.add(addedVariable);
                    addedVariablesToBeRemoved.add(addedVariable);
                }
                for (VariableDeclaration removedVariable : this.removedVariables) {
                    Pair pair;
                    if (!removedVariablesToBeRemoved.contains(removedVariable) && this.callsInlinedMethod(removedVariable)) {
                        this.removedVariablesStoringTheReturnOfInlinedMethod.add(removedVariable);
                        removedVariablesToBeRemoved.add(removedVariable);
                    }
                    if (this.matchedVariables.contains(pair = Pair.of((Object)removedVariable, (Object)addedVariable)) || !removedVariable.getVariableName().equals(addedVariable.getVariableName()) || this.bothCatchExceptionVariables(removedVariable, addedVariable) || this.containerElementRelationship(removedVariable, addedVariable) || !this.mappedStatementWithinVariableScopes(removedVariable, addedVariable)) continue;
                    removedVariablesToBeRemoved.add(removedVariable);
                    addedVariablesToBeRemoved.add(addedVariable);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)pair);
                    this.getVariableRefactorings(removedVariable, addedVariable, this.operation1, this.operation2, Collections.emptySet(), null);
                }
            }
        }
        this.removedVariables.removeAll(removedVariablesToBeRemoved);
        this.addedVariables.removeAll(addedVariablesToBeRemoved);
    }

    private boolean containerElementRelationship(VariableDeclaration removedVariable, VariableDeclaration addedVariable) {
        UMLType type1 = removedVariable.getType();
        UMLType type2 = addedVariable.getType();
        return type1 != null && type2 != null && !type1.equals(type2) && !removedVariable.sameKind(addedVariable) && type1.equalClassType(type2) && type1.getArrayDimension() != type2.getArrayDimension();
    }

    private boolean bothCatchExceptionVariables(VariableDeclaration removedVariable, VariableDeclaration addedVariable) {
        boolean isRemovedVariableCatchException = false;
        for (CompositeStatementObject composite : this.nonMappedInnerNodesT1) {
            if (!composite.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE) || !composite.getVariableDeclarations().contains(removedVariable)) continue;
            isRemovedVariableCatchException = true;
            break;
        }
        boolean isAddedVariableCatchException = false;
        for (CompositeStatementObject composite : this.nonMappedInnerNodesT2) {
            if (!composite.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE) || !composite.getVariableDeclarations().contains(addedVariable)) continue;
            isAddedVariableCatchException = true;
            break;
        }
        return isRemovedVariableCatchException && isAddedVariableCatchException;
    }

    private boolean mappedStatementWithinVariableScopes(VariableDeclaration removedVariable, VariableDeclaration addedVariable) {
        if (this.removedVariablesInAnonymousClassDeclarations.contains(removedVariable) && this.addedVariablesInAnonymousClassDeclarations.contains(addedVariable)) {
            return false;
        }
        if (this.removedVariablesInAnonymousClassDeclarations.contains(removedVariable) != this.addedVariablesInAnonymousClassDeclarations.contains(addedVariable)) {
            return false;
        }
        List<AbstractCodeFragment> statementsInScope1 = removedVariable.getStatementsInScopeUsingVariable();
        List<AbstractCodeFragment> statementsInScope2 = addedVariable.getStatementsInScopeUsingVariable();
        for (AbstractCodeMapping mapping : this.mappings) {
            boolean variableDeclarationFound;
            boolean referenceFound;
            Refactoring ref;
            if (statementsInScope1.contains(mapping.getFragment1()) && statementsInScope2.contains(mapping.getFragment2())) {
                return true;
            }
            if (statementsInScope1.contains(mapping.getFragment1())) {
                for (Refactoring refactoring : this.refactorings) {
                    if (!(refactoring instanceof ExtractVariableRefactoring)) continue;
                    ref = (ExtractVariableRefactoring)refactoring;
                    referenceFound = false;
                    for (AbstractCodeMapping abstractCodeMapping : ((ExtractVariableRefactoring)ref).getReferences()) {
                        if (!mapping.equals(abstractCodeMapping)) continue;
                        referenceFound = true;
                        break;
                    }
                    variableDeclarationFound = false;
                    for (AbstractCodeFragment fragment : statementsInScope2) {
                        if (!fragment.getVariableDeclarations().contains(((ExtractVariableRefactoring)ref).getVariableDeclaration())) continue;
                        variableDeclarationFound = true;
                        break;
                    }
                    if (!referenceFound || !variableDeclarationFound) continue;
                    return true;
                }
            }
            if (statementsInScope2.contains(mapping.getFragment2())) {
                for (Refactoring refactoring : this.refactorings) {
                    if (!(refactoring instanceof InlineVariableRefactoring)) continue;
                    ref = (InlineVariableRefactoring)refactoring;
                    referenceFound = false;
                    for (AbstractCodeMapping abstractCodeMapping : ((InlineVariableRefactoring)ref).getReferences()) {
                        if (!mapping.equals(abstractCodeMapping)) continue;
                        referenceFound = true;
                        break;
                    }
                    variableDeclarationFound = false;
                    for (AbstractCodeFragment fragment : statementsInScope1) {
                        if (!fragment.getVariableDeclarations().contains(((InlineVariableRefactoring)ref).getVariableDeclaration())) continue;
                        variableDeclarationFound = true;
                        break;
                    }
                    if (!referenceFound || !variableDeclarationFound) continue;
                    return true;
                }
            }
            boolean statementInScopeInsideLambda1 = this.statementInScopeInsideLambda(removedVariable, statementsInScope1, mapping.getFragment1());
            boolean statementInScopeInsideLambda2 = this.statementInScopeInsideLambda(addedVariable, statementsInScope2, mapping.getFragment2());
            if (!statementInScopeInsideLambda1 || !statementInScopeInsideLambda2) continue;
            return true;
        }
        for (UMLOperationBodyMapper childMapper : this.childMappers) {
            for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                if (mapping.getFragment1().getVariableDeclarations().contains(removedVariable) || mapping.getFragment2().getVariableDeclarations().contains(addedVariable)) break;
                if (statementsInScope1.contains(mapping.getFragment1()) && this.containCallToOperation(statementsInScope2, childMapper.getContainer2(), this.operation2)) {
                    return true;
                }
                if (!statementsInScope2.contains(mapping.getFragment2()) || !this.containCallToOperation(statementsInScope1, childMapper.getContainer1(), this.operation1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containCallToOperation(List<AbstractCodeFragment> statementsInScope, VariableDeclarationContainer calledOperation, VariableDeclarationContainer callerOperation) {
        UMLModelDiff modelDiff = this.classDiff != null ? this.classDiff.getModelDiff() : null;
        for (AbstractCodeFragment statement : statementsInScope) {
            Map<String, List<AbstractCall>> map = statement.getMethodInvocationMap();
            for (String key : map.keySet()) {
                List<AbstractCall> invocationList = map.get(key);
                for (AbstractCall invocation : invocationList) {
                    if (!invocation.matchesOperation(calledOperation, callerOperation, modelDiff)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean statementInScopeInsideLambda(VariableDeclaration variable, List<AbstractCodeFragment> statementsInScope, AbstractCodeFragment fragment) {
        List<LambdaExpressionObject> lambdas = fragment.getLambdas();
        if (lambdas.size() > 0) {
            for (LambdaExpressionObject lambda : lambdas) {
                List<AbstractStatement> statements;
                OperationBody lambdaBody = lambda.getBody();
                if (lambdaBody == null || !lambdaBody.getAllVariableDeclarations().contains(variable) || !(statements = lambdaBody.getCompositeStatement().getStatements()).containsAll(statementsInScope)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean callsExtractedMethod(VariableDeclaration addedVariable) {
        AbstractCall invocation;
        UMLModelDiff modelDiff = this.classDiff != null ? this.classDiff.getModelDiff() : null;
        AbstractExpression initializer = addedVariable.getInitializer();
        if (initializer != null && (invocation = initializer.invocationCoveringEntireFragment()) != null) {
            for (UMLOperationBodyMapper childMapper : this.childMappers) {
                if (!invocation.matchesOperation(childMapper.getContainer2(), this.operation2, modelDiff)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean callsInlinedMethod(VariableDeclaration removedVariable) {
        AbstractCall invocation;
        UMLModelDiff modelDiff = this.classDiff != null ? this.classDiff.getModelDiff() : null;
        AbstractExpression initializer = removedVariable.getInitializer();
        if (initializer != null && (invocation = initializer.invocationCoveringEntireFragment()) != null) {
            for (UMLOperationBodyMapper childMapper : this.childMappers) {
                if (!invocation.matchesOperation(childMapper.getContainer1(), this.operation1, modelDiff)) continue;
                return true;
            }
        }
        return false;
    }

    private void findTypeChanges() {
        for (AbstractCodeMapping mapping : this.mappings) {
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            List<VariableDeclaration> declarations1 = fragment1.getVariableDeclarations();
            List<VariableDeclaration> declarations2 = fragment2.getVariableDeclarations();
            if (declarations1.size() == declarations2.size()) {
                for (int i = 0; i < declarations1.size(); ++i) {
                    VariableDeclaration declaration1 = declarations1.get(i);
                    VariableDeclaration declaration2 = declarations2.get(i);
                    if (!declaration1.getVariableName().equals(declaration2.getVariableName())) continue;
                    if (declaration1.equalType(declaration2) && declaration1.equalQualifiedType(declaration2)) {
                        this.removedVariables.remove(declaration1);
                        this.addedVariables.remove(declaration2);
                        this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)declaration1, (Object)declaration2));
                        this.getVariableRefactorings(declaration1, declaration2, mapping.getOperation1(), mapping.getOperation2(), Collections.emptySet(), null);
                        continue;
                    }
                    if (this.containsVariableDeclarationWithSameNameAndType(declaration1, declarations2) || this.containsVariableDeclarationWithSameNameAndType(declaration2, declarations1)) continue;
                    Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(declaration1, declaration2, this.mappings);
                    this.removedVariables.remove(declaration1);
                    this.addedVariables.remove(declaration2);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)declaration1, (Object)declaration2));
                    this.getVariableRefactorings(declaration1, declaration2, mapping.getOperation1(), mapping.getOperation2(), variableReferences, null);
                }
                continue;
            }
            if (declarations1.size() <= 0 || declarations2.size() <= 0) continue;
            VariableDeclaration declaration1 = declarations1.get(0);
            VariableDeclaration declaration2 = declarations2.get(0);
            if (!declaration1.getVariableName().equals(declaration2.getVariableName())) continue;
            if (declaration1.equalType(declaration2) && declaration1.equalQualifiedType(declaration2)) {
                this.removedVariables.remove(declaration1);
                this.addedVariables.remove(declaration2);
                this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)declaration1, (Object)declaration2));
                this.getVariableRefactorings(declaration1, declaration2, mapping.getOperation1(), mapping.getOperation2(), Collections.emptySet(), null);
                continue;
            }
            if (this.containsVariableDeclarationWithSameNameAndType(declaration1, declarations2) || this.containsVariableDeclarationWithSameNameAndType(declaration2, declarations1)) continue;
            Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(declaration1, declaration2, this.mappings);
            this.removedVariables.remove(declaration1);
            this.addedVariables.remove(declaration2);
            this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)declaration1, (Object)declaration2));
            this.getVariableRefactorings(declaration1, declaration2, mapping.getOperation1(), mapping.getOperation2(), variableReferences, null);
        }
    }

    private boolean containsVariableDeclarationWithSameNameAndType(VariableDeclaration declaration, List<VariableDeclaration> declarations) {
        for (VariableDeclaration d : declarations) {
            if (!d.getVariableName().equals(declaration.getVariableName()) || !d.equalType(declaration) || !d.equalQualifiedType(declaration)) continue;
            return true;
        }
        return false;
    }

    private void findAttributeExtractions() {
        if (this.classDiff != null) {
            for (AbstractCodeMapping mapping : this.mappings) {
                for (Replacement replacement : mapping.getReplacements()) {
                    Refactoring refactoring;
                    VariableDeclaration variableDeclaration;
                    if (!replacement.involvesVariable()) continue;
                    block2: for (UMLAttribute addedAttribute : this.classDiff.getAddedAttributes()) {
                        variableDeclaration = addedAttribute.getVariableDeclaration();
                        if (!addedAttribute.getName().equals(replacement.getAfter()) || !this.extractInlineCondition(variableDeclaration, replacement, replacement.getBefore())) continue;
                        refactoring = new ExtractAttributeRefactoring(addedAttribute, this.classDiff.getOriginalClass(), this.classDiff.getNextClass(), this.insideExtractedOrInlinedMethod);
                        if (this.refactorings.contains(refactoring)) {
                            for (Refactoring ref : this.refactorings) {
                                if (!ref.equals(refactoring)) continue;
                                ((ExtractAttributeRefactoring)ref).addReference(mapping);
                                continue block2;
                            }
                            continue;
                        }
                        ((ExtractAttributeRefactoring)refactoring).addReference(mapping);
                        this.refactorings.add(refactoring);
                    }
                    block4: for (UMLAttribute removedAttribute : this.classDiff.getRemovedAttributes()) {
                        variableDeclaration = removedAttribute.getVariableDeclaration();
                        if (!removedAttribute.getName().equals(replacement.getBefore()) || !this.extractInlineCondition(variableDeclaration, replacement, replacement.getAfter())) continue;
                        refactoring = new InlineAttributeRefactoring(removedAttribute, this.classDiff.getOriginalClass(), this.classDiff.getNextClass(), this.insideExtractedOrInlinedMethod);
                        if (this.refactorings.contains(refactoring)) {
                            for (Refactoring ref : this.refactorings) {
                                if (!ref.equals(refactoring)) continue;
                                ((InlineAttributeRefactoring)ref).addReference(mapping);
                                continue block4;
                            }
                            continue;
                        }
                        ((InlineAttributeRefactoring)refactoring).addReference(mapping);
                        this.refactorings.add(refactoring);
                    }
                }
            }
        }
    }

    private boolean extractInlineCondition(VariableDeclaration variableDeclaration, Replacement replacement, String replacementAsString) {
        if (variableDeclaration.getInitializer() != null) {
            if (variableDeclaration.getInitializer().getString().equals(replacementAsString)) {
                return true;
            }
            if (replacement instanceof VariableReplacementWithMethodInvocation) {
                VariableReplacementWithMethodInvocation r = (VariableReplacementWithMethodInvocation)replacement;
                Map<String, List<AbstractCall>> map = variableDeclaration.getInitializer().getMethodInvocationMap();
                for (String key : map.keySet()) {
                    List<AbstractCall> list = map.get(key);
                    for (AbstractCall call : list) {
                        if (!call.identicalName(r.getInvokedOperation())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Set<RenameVariableRefactoring> getVariableRenames() {
        return this.variableRenames;
    }

    public Set<MergeVariableRefactoring> getVariableMerges() {
        return this.variableMerges;
    }

    public Set<SplitVariableRefactoring> getVariableSplits() {
        return this.variableSplits;
    }

    public Set<Pair<VariableDeclaration, VariableDeclaration>> getMatchedVariables() {
        return this.matchedVariables;
    }

    public Set<Pair<VariableDeclaration, VariableDeclaration>> getMovedVariables() {
        return this.movedVariables;
    }

    public Set<VariableDeclaration> getRemovedVariables() {
        return this.removedVariables;
    }

    public Set<VariableDeclaration> getRemovedVariablesStoringTheReturnOfInlinedMethod() {
        return this.removedVariablesStoringTheReturnOfInlinedMethod;
    }

    public Set<VariableDeclaration> getAddedVariables() {
        return this.addedVariables;
    }

    public Set<VariableDeclaration> getAddedVariablesStoringTheReturnOfExtractedMethod() {
        return this.addedVariablesStoringTheReturnOfExtractedMethod;
    }

    public Set<CandidateAttributeRefactoring> getCandidateAttributeRenames() {
        return this.candidateAttributeRenames;
    }

    public Set<CandidateMergeVariableRefactoring> getCandidateAttributeMerges() {
        return this.candidateAttributeMerges;
    }

    public Set<CandidateSplitVariableRefactoring> getCandidateAttributeSplits() {
        return this.candidateAttributeSplits;
    }

    private void findVariableSplits() {
        LinkedHashMap splitMap = new LinkedHashMap();
        LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap = new LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>>();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (replacement instanceof SplitVariableReplacement) {
                    SplitVariableReplacement split = (SplitVariableReplacement)replacement;
                    if (splitMap.containsKey(split)) {
                        ((Set)splitMap.get(split)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                    mappings.add(mapping);
                    splitMap.put(split, mappings);
                    continue;
                }
                if (replacement instanceof VariableReplacementWithMethodInvocation) {
                    VariableReplacementWithMethodInvocation variableReplacement = (VariableReplacementWithMethodInvocation)replacement;
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                for (AbstractCodeFragment statement : this.nonMappedLeavesT1) {
                    AbstractCall invocation;
                    AbstractExpression initializer;
                    VariableDeclaration variableDeclaration = statement.getVariableDeclaration(replacement.getBefore());
                    if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
                    VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(initializer.getString(), replacement.getAfter(), invocation, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                }
            }
        }
        for (AbstractCodeFragment statement : this.nonMappedLeavesT1) {
            for (String parameterName : this.operation2.getParameterNameList()) {
                String expression;
                AbstractCall invocation;
                Object initializer;
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(parameterName);
                if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = ((AbstractCodeFragment)initializer).invocationCoveringEntireFragment()) == null || (expression = invocation.getExpression()) == null) continue;
                VariableReplacementWithMethodInvocation variableReplacement = new VariableReplacementWithMethodInvocation(((AbstractExpression)initializer).getString(), parameterName, invocation, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                this.processVariableReplacementWithMethodInvocation(variableReplacement, null, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
            }
        }
        for (String key : variableInvocationExpressionMap.keySet()) {
            Map map = (Map)variableInvocationExpressionMap.get(key);
            LinkedHashSet mappings = new LinkedHashSet();
            LinkedHashSet splitVariables = new LinkedHashSet();
            for (VariableReplacementWithMethodInvocation replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getAfter()))) continue;
                splitVariables.add(replacement.getAfter());
                mappings.addAll((Collection)map.get(replacement));
            }
            if (splitVariables.size() <= 0) continue;
            SplitVariableReplacement split = new SplitVariableReplacement(key, splitVariables);
            splitMap.put(split, mappings);
        }
        for (SplitVariableReplacement split : splitMap.keySet()) {
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> oldVariable;
            LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<VariableDeclarationContainer> splitVariableOperations = new LinkedHashSet<VariableDeclarationContainer>();
            for (String variableName : split.getSplitVariables()) {
                AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> declaration = this.getVariableDeclaration2(split, variableName);
                if (declaration == null) continue;
                splitVariables.add(declaration.getKey());
                splitVariableOperations.add(declaration.getValue());
            }
            Set<AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>> oldVariables = this.getVariableDeclaration1(split);
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> simpleEntry = oldVariable = !oldVariables.isEmpty() ? oldVariables.iterator().next() : null;
            if (splitVariables.size() > 1 && splitVariables.size() == split.getSplitVariables().size() && oldVariable != null) {
                VariableDeclarationContainer operationAfter = (VariableDeclarationContainer)splitVariableOperations.iterator().next();
                SplitVariableRefactoring refactoring = new SplitVariableRefactoring(oldVariable.getKey(), splitVariables, oldVariable.getValue(), operationAfter, (Set)splitMap.get(split), this.insideExtractedOrInlinedMethod);
                if (this.existsConflictingExtractVariableRefactoring(refactoring) || this.existsConflictingParameterRenameInOperationDiff(refactoring)) continue;
                block9: for (VariableDeclaration removedVariable : this.removedVariables) {
                    for (VariableDeclaration addedVariable : splitVariables) {
                        if (!removedVariable.getVariableName().equals(addedVariable.getVariableName()) || !removedVariable.equalType(addedVariable)) continue;
                        Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(removedVariable, addedVariable, this.mappings);
                        this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)removedVariable, (Object)addedVariable));
                        this.getVariableRefactorings(removedVariable, addedVariable, oldVariable.getValue(), operationAfter, variableReferences, null);
                        continue block9;
                    }
                }
                for (VariableDeclaration addedVariable : this.addedVariables) {
                    VariableDeclaration removedVariable = oldVariable.getKey();
                    if (!removedVariable.getVariableName().equals(addedVariable.getVariableName()) || !removedVariable.equalType(addedVariable)) continue;
                    Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(removedVariable, addedVariable, this.mappings);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)removedVariable, (Object)addedVariable));
                    this.getVariableRefactorings(removedVariable, addedVariable, oldVariable.getValue(), operationAfter, variableReferences, null);
                    break;
                }
                this.variableSplits.add(refactoring);
                this.removedVariables.remove(oldVariable.getKey());
                this.addedVariables.removeAll(splitVariables);
                continue;
            }
            CandidateSplitVariableRefactoring candidate = new CandidateSplitVariableRefactoring(split.getBefore(), split.getSplitVariables(), this.operation1, this.operation2, (Set)splitMap.get(split));
            this.candidateAttributeSplits.add(candidate);
        }
    }

    private void processVariableReplacementWithMethodInvocation(VariableReplacementWithMethodInvocation variableReplacement, AbstractCodeMapping mapping, Map<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction direction) {
        String expression = variableReplacement.getInvokedOperation().getExpression();
        if (expression != null && variableReplacement.getDirection().equals((Object)direction)) {
            if (variableInvocationExpressionMap.containsKey(expression)) {
                Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>> map = variableInvocationExpressionMap.get(expression);
                if (map.containsKey(variableReplacement)) {
                    if (mapping != null) {
                        map.get(variableReplacement).add(mapping);
                    }
                } else {
                    LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                    if (mapping != null) {
                        mappings.add(mapping);
                    }
                    map.put(variableReplacement, mappings);
                }
            } else {
                LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                if (mapping != null) {
                    mappings.add(mapping);
                }
                LinkedHashMap<VariableReplacementWithMethodInvocation, LinkedHashSet<AbstractCodeMapping>> map = new LinkedHashMap<VariableReplacementWithMethodInvocation, LinkedHashSet<AbstractCodeMapping>>();
                map.put(variableReplacement, mappings);
                variableInvocationExpressionMap.put(expression, map);
            }
        }
    }

    private void findVariableMerges() {
        Object merge;
        VariableReplacementWithMethodInvocation variableReplacement;
        AbstractCall invocation;
        LinkedHashMap mergeMap = new LinkedHashMap();
        LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap = new LinkedHashMap<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>>();
        LinkedHashMap variableInvocationVariableMap = new LinkedHashMap();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (replacement instanceof MergeVariableReplacement) {
                    MergeVariableReplacement mergeVariableReplacement = (MergeVariableReplacement)replacement;
                    if (mergeMap.containsKey(mergeVariableReplacement)) {
                        ((Set)mergeMap.get(mergeVariableReplacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings2 = new LinkedHashSet<AbstractCodeMapping>();
                    mappings2.add(mapping);
                    mergeMap.put(mergeVariableReplacement, mappings2);
                    continue;
                }
                if (replacement instanceof VariableReplacementWithMethodInvocation) {
                    VariableReplacementWithMethodInvocation variableReplacementWithMethodInvocation = (VariableReplacementWithMethodInvocation)replacement;
                    this.processVariableReplacementWithMethodInvocation(variableReplacementWithMethodInvocation, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    continue;
                }
                if (replacement instanceof MethodInvocationReplacement) {
                    AbstractCall invocationAfter;
                    MethodInvocationReplacement methodInvocationReplacement = (MethodInvocationReplacement)replacement;
                    AbstractCall invocationBefore = methodInvocationReplacement.getInvokedOperationBefore();
                    if (!invocationBefore.identicalName(invocationAfter = methodInvocationReplacement.getInvokedOperationAfter()) || !invocationBefore.identicalExpression(invocationAfter) || invocationBefore.equalArguments(invocationAfter)) continue;
                    LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(invocationBefore.getArguments());
                    argumentIntersection.retainAll(invocationAfter.getArguments());
                    LinkedHashSet<String> arguments1WithoutCommon = new LinkedHashSet<String>(invocationBefore.getArguments());
                    arguments1WithoutCommon.removeAll(argumentIntersection);
                    LinkedHashSet<String> arguments2WithoutCommon = new LinkedHashSet<String>(invocationAfter.getArguments());
                    arguments2WithoutCommon.removeAll(argumentIntersection);
                    if (arguments1WithoutCommon.size() <= arguments2WithoutCommon.size() || arguments2WithoutCommon.size() != 1) continue;
                    MergeVariableReplacement merge3 = new MergeVariableReplacement(arguments1WithoutCommon, (String)arguments2WithoutCommon.iterator().next());
                    if (mergeMap.containsKey(merge3)) {
                        ((Set)mergeMap.get(merge3)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings3 = new LinkedHashSet<AbstractCodeMapping>();
                    mappings3.add(mapping);
                    mergeMap.put(merge3, mappings3);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                for (AbstractCodeFragment statement : this.nonMappedLeavesT2) {
                    AbstractExpression initializer;
                    VariableDeclaration variableDeclaration = statement.getVariableDeclaration(replacement.getBefore());
                    if (variableDeclaration == null || (initializer = variableDeclaration.getInitializer()) == null || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
                    variableReplacement = new VariableReplacementWithMethodInvocation(replacement.getBefore(), initializer.getString(), invocation, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    this.processVariableReplacementWithMethodInvocation(variableReplacement, mapping, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                }
                if (!replacement.getAfter().contains(".")) continue;
                String string = replacement.getAfter().substring(0, replacement.getAfter().indexOf("."));
                if (variableInvocationVariableMap.containsKey(string)) {
                    Map map = (Map)variableInvocationVariableMap.get(string);
                    if (map.containsKey(replacement)) {
                        if (mapping == null) continue;
                        ((Set)map.get(replacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> mappings4 = new LinkedHashSet<AbstractCodeMapping>();
                    if (mapping != null) {
                        mappings4.add(mapping);
                    }
                    map.put(replacement, mappings4);
                    continue;
                }
                LinkedHashSet<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
                if (mapping != null) {
                    mappings.add(mapping);
                }
                LinkedHashMap<Replacement, LinkedHashSet<AbstractCodeMapping>> map = new LinkedHashMap<Replacement, LinkedHashSet<AbstractCodeMapping>>();
                map.put(replacement, mappings);
                variableInvocationVariableMap.put(string, map);
            }
        }
        for (AbstractCodeFragment statement : this.nonMappedLeavesT2) {
            AbstractExpression initializer;
            boolean matchingParameterFound = false;
            for (String string : this.operation1.getParameterNameList()) {
                AbstractCall invocation2;
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(string);
                if (variableDeclaration == null) continue;
                matchingParameterFound = true;
                initializer = variableDeclaration.getInitializer();
                if (initializer == null || (invocation2 = initializer.invocationCoveringEntireFragment()) == null) continue;
                VariableReplacementWithMethodInvocation variableReplacement3 = new VariableReplacementWithMethodInvocation(string, initializer.getString(), invocation2, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                this.processVariableReplacementWithMethodInvocation(variableReplacement3, null, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
            }
            if (matchingParameterFound || statement.getVariableDeclarations().size() <= 0) continue;
            VariableDeclaration variableDeclaration = statement.getVariableDeclarations().get(0);
            for (Object parameterDeclaration : this.operation1.getParameterDeclarationList()) {
                if (!variableDeclaration.equalType((VariableDeclaration)parameterDeclaration)) continue;
                initializer = variableDeclaration.getInitializer();
                Iterator<VariableDeclaration> parameterType = ((VariableDeclaration)parameterDeclaration).getType();
                if (initializer == null || parameterType == null || !initializer.getString().startsWith("(" + (UMLType)((Object)parameterType) + ")") || (invocation = initializer.invocationCoveringEntireFragment()) == null) continue;
                variableReplacement = new VariableReplacementWithMethodInvocation(((VariableDeclaration)parameterDeclaration).getVariableName(), initializer.getString(), invocation, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                this.processVariableReplacementWithMethodInvocation(variableReplacement, null, variableInvocationExpressionMap, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
            }
        }
        for (String key : variableInvocationExpressionMap.keySet()) {
            Map map = (Map)variableInvocationExpressionMap.get(key);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
            for (Replacement replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getBefore())) && !((VariableReplacementWithMethodInvocation)replacement).getInvokedOperation().getCoverage().equals((Object)AbstractCall.StatementCoverageType.CAST_CALL)) continue;
                linkedHashSet2.add(replacement.getBefore());
                linkedHashSet.addAll((Collection)map.get(replacement));
            }
            if (linkedHashSet2.size() <= 0) continue;
            merge = new MergeVariableReplacement(linkedHashSet2, key);
            mergeMap.put(merge, linkedHashSet);
        }
        for (String key : variableInvocationVariableMap.keySet()) {
            Map map = (Map)variableInvocationVariableMap.get(key);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
            for (Replacement replacement : map.keySet()) {
                if (PrefixSuffixUtils.normalize(key).equals(PrefixSuffixUtils.normalize(replacement.getBefore()))) continue;
                linkedHashSet3.add(replacement.getBefore());
                linkedHashSet.addAll((Collection)map.get(replacement));
            }
            if (linkedHashSet3.size() <= 0) continue;
            merge = new MergeVariableReplacement(linkedHashSet3, key);
            mergeMap.put(merge, linkedHashSet);
        }
        for (MergeVariableReplacement merge4 : mergeMap.keySet()) {
            LinkedHashSet<VariableDeclaration> mergedVariables2 = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<VariableDeclarationContainer> linkedHashSet = new LinkedHashSet<VariableDeclarationContainer>();
            for (String variableName : merge4.getMergedVariables()) {
                AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> declaration = this.getVariableDeclaration1(merge4, variableName);
                if (declaration == null) continue;
                mergedVariables2.add(declaration.getKey());
                linkedHashSet.add(declaration.getValue());
            }
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> simpleEntry = this.getVariableDeclaration2(merge4);
            if (mergedVariables2.size() > 1 && mergedVariables2.size() == merge4.getMergedVariables().size() && simpleEntry != null) {
                Refactoring ref;
                VariableDeclarationContainer operationBefore = (VariableDeclarationContainer)linkedHashSet.iterator().next();
                MergeVariableRefactoring refactoring = new MergeVariableRefactoring(mergedVariables2, simpleEntry.getKey(), operationBefore, simpleEntry.getValue(), (Set)mergeMap.get(merge4), this.insideExtractedOrInlinedMethod);
                if (this.existsConflictingInlineVariableRefactoring(refactoring) || this.existsConflictingParameterRenameInOperationDiff(refactoring, variableInvocationExpressionMap)) continue;
                for (VariableDeclaration removedVariable : this.removedVariables) {
                    Iterator addedVariable = simpleEntry.getKey();
                    if (!removedVariable.getVariableName().equals(((VariableDeclaration)((Object)addedVariable)).getVariableName()) || !removedVariable.equalType((VariableDeclaration)((Object)addedVariable))) continue;
                    Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(removedVariable, (VariableDeclaration)((Object)addedVariable), this.mappings);
                    this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)removedVariable, (Object)addedVariable));
                    this.getVariableRefactorings(removedVariable, (VariableDeclaration)((Object)addedVariable), operationBefore, simpleEntry.getValue(), variableReferences, null);
                    break;
                }
                block13: for (VariableDeclaration addedVariable : this.addedVariables) {
                    for (VariableDeclaration removedVariable : mergedVariables2) {
                        if (!removedVariable.getVariableName().equals(addedVariable.getVariableName()) || !removedVariable.equalType(addedVariable)) continue;
                        Set<AbstractCodeMapping> variableReferences = VariableReferenceExtractor.findReferences(removedVariable, addedVariable, this.mappings);
                        this.matchedVariables.add((Pair<VariableDeclaration, VariableDeclaration>)Pair.of((Object)removedVariable, (Object)addedVariable));
                        this.getVariableRefactorings(removedVariable, addedVariable, operationBefore, simpleEntry.getValue(), variableReferences, null);
                        continue block13;
                    }
                }
                this.variableMerges.add(refactoring);
                this.removedVariables.removeAll(mergedVariables2);
                this.addedVariables.remove(simpleEntry.getKey());
                VariableDeclaration firstMergedVariable = null;
                boolean allMergedVariablesHaveEqualAnnotations = true;
                for (VariableDeclaration mergedVariable : mergedVariables2) {
                    if (firstMergedVariable == null) {
                        firstMergedVariable = mergedVariable;
                        continue;
                    }
                    if (firstMergedVariable.getAnnotations().equals(mergedVariable.getAnnotations())) continue;
                    allMergedVariablesHaveEqualAnnotations = false;
                    break;
                }
                if (!allMergedVariablesHaveEqualAnnotations) continue;
                UMLAnnotationListDiff annotationListDiff = new UMLAnnotationListDiff(firstMergedVariable.getAnnotations(), simpleEntry.getKey().getAnnotations());
                for (UMLAnnotation annotation : annotationListDiff.getAddedAnnotations()) {
                    ref = new AddVariableAnnotationRefactoring(annotation, firstMergedVariable, simpleEntry.getKey(), operationBefore, simpleEntry.getValue(), this.insideExtractedOrInlinedMethod);
                    this.refactorings.add(ref);
                }
                for (UMLAnnotation annotation : annotationListDiff.getRemovedAnnotations()) {
                    ref = new RemoveVariableAnnotationRefactoring(annotation, firstMergedVariable, simpleEntry.getKey(), operationBefore, simpleEntry.getValue(), this.insideExtractedOrInlinedMethod);
                    this.refactorings.add(ref);
                }
                for (UMLAnnotationDiff annotationDiff : annotationListDiff.getAnnotationDiffs()) {
                    ref = new ModifyVariableAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), firstMergedVariable, simpleEntry.getKey(), operationBefore, simpleEntry.getValue(), this.insideExtractedOrInlinedMethod);
                    this.refactorings.add(ref);
                }
                continue;
            }
            CandidateMergeVariableRefactoring candidate = new CandidateMergeVariableRefactoring(merge4.getMergedVariables(), merge4.getAfter(), this.operation1, this.operation2, (Set)mergeMap.get(merge4));
            this.candidateAttributeMerges.add(candidate);
        }
    }

    private void findConsistentVariableRenames() {
        Set<AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>> v1s;
        Map<Replacement, Set<AbstractCodeMapping>> variableDeclarationReplacementOccurrenceMap = this.getVariableDeclarationReplacementOccurrenceMap();
        Set<Replacement> allConsistentVariableDeclarationRenames = this.allConsistentRenames(variableDeclarationReplacementOccurrenceMap);
        for (Replacement replacement : allConsistentVariableDeclarationRenames) {
            RenameVariableRefactoring ref;
            VariableDeclarationReplacement vdReplacement = (VariableDeclarationReplacement)replacement;
            Set<AbstractCodeMapping> variableReferences = variableDeclarationReplacementOccurrenceMap.get(vdReplacement);
            VariableDeclaration variableDeclaration1 = vdReplacement.getVariableDeclaration1();
            VariableDeclaration variableDeclaration2 = vdReplacement.getVariableDeclaration2();
            VariableDeclarationContainer operation1 = vdReplacement.getOperation1();
            VariableDeclarationContainer operation2 = vdReplacement.getOperation2();
            if (variableReferences.size() > 1 && this.consistencyCheck(variableDeclaration1, variableDeclaration2, variableReferences) || variableReferences.size() == 1 && this.replacementInLocalVariableDeclaration(vdReplacement.getVariableNameReplacement(), variableReferences)) {
                ref = new RenameVariableRefactoring(variableDeclaration1, variableDeclaration2, operation1, operation2, variableReferences, this.insideExtractedOrInlinedMethod);
                if (this.existsConflictingExtractVariableRefactoring(ref) || this.existsConflictingMergeVariableRefactoring(ref) || this.existsConflictingSplitVariableRefactoring(ref) || this.existsConflictingParameter(ref)) continue;
                this.variableRenames.add(ref);
                this.removedVariables.remove(variableDeclaration1);
                this.addedVariables.remove(variableDeclaration2);
                this.getVariableRefactorings(variableDeclaration1, variableDeclaration2, operation1, operation2, variableReferences, ref);
                continue;
            }
            ref = new RenameVariableRefactoring(variableDeclaration1, variableDeclaration2, operation1, operation2, variableReferences, this.insideExtractedOrInlinedMethod);
            if (!this.refactorings.contains(ref)) continue;
            this.refactorings.remove(ref);
        }
        Map<Replacement, Set<AbstractCodeMapping>> replacementOccurrenceMap = this.getReplacementOccurrenceMap(Replacement.ReplacementType.VARIABLE_NAME);
        Set<Replacement> allConsistentRenames = this.allConsistentRenames(replacementOccurrenceMap);
        LinkedHashMap<Replacement, Object> finalConsistentRenames = new LinkedHashMap<Replacement, Object>();
        for (Replacement replacement : allConsistentRenames) {
            v1s = this.getVariableDeclaration1(replacement);
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> v1 = !v1s.isEmpty() ? v1s.iterator().next() : null;
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> v2 = this.getVariableDeclaration2(replacement);
            Set<AbstractCodeMapping> set = replacementOccurrenceMap.get(replacement);
            if (set.size() > 1 && v1 != null && v2 != null && this.consistencyCheck(v1.getKey(), v2.getKey(), set) || this.potentialParameterRename(replacement, set) || v1 == null || v2 == null || set.size() == 1 && this.replacementInLocalVariableDeclaration(replacement, set)) {
                finalConsistentRenames.put(replacement, set);
            }
            if (v1 == null || v1.getKey().isParameter() || v2 == null || !v2.getKey().isParameter() || !this.consistencyCheck(v1.getKey(), v2.getKey(), set) || this.operation1.getParameterNameList().contains(v2.getKey().getVariableName())) continue;
            finalConsistentRenames.put(replacement, set);
        }
        for (Replacement replacement : finalConsistentRenames.keySet()) {
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> simpleEntry;
            v1s = this.getVariableDeclaration1(replacement);
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> v2 = this.getVariableDeclaration2(replacement);
            Set variableReferences = (Set)finalConsistentRenames.get(replacement);
            if (!v1s.isEmpty() && v2 != null) {
                for (AbstractMap.SimpleEntry simpleEntry2 : v1s) {
                    VariableDeclaration variableDeclaration1 = (VariableDeclaration)simpleEntry2.getKey();
                    VariableDeclaration variableDeclaration2 = v2.getKey();
                    VariableDeclarationContainer operation1 = (VariableDeclarationContainer)simpleEntry2.getValue();
                    VariableDeclarationContainer operation2 = v2.getValue();
                    LinkedHashSet<AbstractCodeMapping> actualReferences = new LinkedHashSet<AbstractCodeMapping>();
                    for (AbstractCodeMapping mapping : variableReferences) {
                        if (!variableDeclaration1.getScope().subsumes(mapping.getFragment1().getLocationInfo()) || !variableDeclaration2.getScope().subsumes(mapping.getFragment2().getLocationInfo())) continue;
                        actualReferences.add(mapping);
                    }
                    RenameVariableRefactoring ref = new RenameVariableRefactoring(variableDeclaration1, variableDeclaration2, operation1, operation2, actualReferences, this.insideExtractedOrInlinedMethod);
                    if (this.existsConflictingExtractVariableRefactoring(ref) || this.existsConflictingMergeVariableRefactoring(ref) || this.existsConflictingSplitVariableRefactoring(ref) || this.existsConflictingParameter(ref) || variableDeclaration1.isVarargsParameter() != variableDeclaration2.isVarargsParameter()) continue;
                    this.variableRenames.add(ref);
                    this.removedVariables.remove(variableDeclaration1);
                    this.addedVariables.remove(variableDeclaration2);
                    this.getVariableRefactorings(variableDeclaration1, variableDeclaration2, operation1, operation2, actualReferences, ref);
                }
                continue;
            }
            if (PrefixSuffixUtils.normalize(replacement.getBefore()).equals(PrefixSuffixUtils.normalize(replacement.getAfter())) || this.operation1.getAllVariables().contains(replacement.getAfter()) && !VariableReplacementAnalysis.cyclicRename(finalConsistentRenames.keySet(), replacement) || this.operation2.getAllVariables().contains(replacement.getBefore()) && !VariableReplacementAnalysis.cyclicRename(finalConsistentRenames.keySet(), replacement) || this.fieldAssignmentWithPreviouslyExistingParameter(replacementOccurrenceMap.get(replacement)) || this.fieldAssignmentToPreviouslyExistingAttribute(replacementOccurrenceMap.get(replacement))) continue;
            CandidateAttributeRefactoring candidate = new CandidateAttributeRefactoring(replacement.getBefore(), replacement.getAfter(), this.operation1, this.operation2, replacementOccurrenceMap.get(replacement));
            AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> simpleEntry3 = simpleEntry = !v1s.isEmpty() ? v1s.iterator().next() : null;
            if (simpleEntry != null) {
                candidate.setOriginalVariableDeclaration(simpleEntry.getKey());
            }
            if (v2 != null) {
                candidate.setRenamedVariableDeclaration(v2.getKey());
            }
            this.candidateAttributeRenames.add(candidate);
        }
    }

    private void getVariableRefactorings(VariableDeclaration variableDeclaration1, VariableDeclaration variableDeclaration2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2, Set<AbstractCodeMapping> variableReferences, RenameVariableRefactoring ref) {
        Refactoring refactoring;
        int subsumedReferences;
        block0: for (UMLAnonymousClass uMLAnonymousClass : operation1.getAnonymousClassList()) {
            for (UMLOperation operation : uMLAnonymousClass.getOperations()) {
                subsumedReferences = 0;
                for (AbstractCodeMapping mapping : variableReferences) {
                    if (!operation.getLocationInfo().subsumes(mapping.getFragment1().getLocationInfo())) continue;
                    ++subsumedReferences;
                }
                if (subsumedReferences <= 0 || subsumedReferences != variableReferences.size() || !operation.getAllVariableDeclarations().contains(variableDeclaration1)) continue;
                operation1 = operation;
                for (VariableDeclaration parameter : operation1.getParameterDeclarationList()) {
                    if (!parameter.equals(variableDeclaration1)) continue;
                    variableDeclaration1 = parameter;
                }
                continue block0;
            }
        }
        block4: for (UMLAnonymousClass uMLAnonymousClass : operation2.getAnonymousClassList()) {
            for (UMLOperation operation : uMLAnonymousClass.getOperations()) {
                subsumedReferences = 0;
                for (AbstractCodeMapping mapping : variableReferences) {
                    if (!operation.getLocationInfo().subsumes(mapping.getFragment2().getLocationInfo())) continue;
                    ++subsumedReferences;
                }
                if (subsumedReferences <= 0 || subsumedReferences != variableReferences.size() || !operation.getAllVariableDeclarations().contains(variableDeclaration2)) continue;
                operation2 = operation;
                for (VariableDeclaration parameter : operation2.getParameterDeclarationList()) {
                    if (!parameter.equals(variableDeclaration2)) continue;
                    variableDeclaration2 = parameter;
                }
                continue block4;
            }
        }
        if (ref == null && variableDeclaration1.isParameter() != variableDeclaration2.isParameter()) {
            RenameVariableRefactoring refactoring2 = new RenameVariableRefactoring(variableDeclaration1, variableDeclaration2, operation1, operation2, variableReferences, this.insideExtractedOrInlinedMethod);
            this.refactorings.add(refactoring2);
        }
        if (!(variableDeclaration1.getType() == null || variableDeclaration2.getType() == null || variableDeclaration1.equalType(variableDeclaration2) && variableDeclaration1.equalQualifiedType(variableDeclaration2))) {
            ChangeVariableTypeRefactoring refactoring2 = new ChangeVariableTypeRefactoring(variableDeclaration1, variableDeclaration2, operation1, operation2, variableReferences, this.insideExtractedOrInlinedMethod);
            if (ref != null) {
                refactoring2.addRelatedRefactoring(ref);
            }
            this.refactorings.add(refactoring2);
        }
        UMLAnnotationListDiff annotationListDiff = new UMLAnnotationListDiff(variableDeclaration1.getAnnotations(), variableDeclaration2.getAnnotations());
        for (UMLAnnotation annotation : annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddVariableAnnotationRefactoring(annotation, variableDeclaration1, variableDeclaration2, operation1, operation2, this.insideExtractedOrInlinedMethod);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveVariableAnnotationRefactoring(annotation, variableDeclaration1, variableDeclaration2, operation1, operation2, this.insideExtractedOrInlinedMethod);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyVariableAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), variableDeclaration1, variableDeclaration2, operation1, operation2, this.insideExtractedOrInlinedMethod);
            this.refactorings.add(refactoring);
        }
        if (variableDeclaration1.isFinal() != variableDeclaration2.isFinal()) {
            if (variableDeclaration2.isFinal()) {
                AddVariableModifierRefactoring addVariableModifierRefactoring = new AddVariableModifierRefactoring("final", variableDeclaration1, variableDeclaration2, operation1, operation2, this.insideExtractedOrInlinedMethod);
                this.refactorings.add(addVariableModifierRefactoring);
            } else if (variableDeclaration1.isFinal()) {
                RemoveVariableModifierRefactoring removeVariableModifierRefactoring = new RemoveVariableModifierRefactoring("final", variableDeclaration1, variableDeclaration2, operation1, operation2, this.insideExtractedOrInlinedMethod);
                this.refactorings.add(removeVariableModifierRefactoring);
            }
        }
    }

    private boolean fieldAssignmentToPreviouslyExistingAttribute(Set<AbstractCodeMapping> mappings) {
        if (mappings.size() == 1) {
            AbstractCodeMapping mapping = mappings.iterator().next();
            String fragment1 = mapping.getFragment1().getString();
            String fragment2 = mapping.getFragment2().getString();
            if (fragment1.contains("=") && fragment1.endsWith(";\n") && fragment2.contains("=") && fragment2.endsWith(";\n")) {
                String value1 = fragment1.substring(fragment1.indexOf("=") + 1, fragment1.lastIndexOf(";\n"));
                String value2 = fragment2.substring(fragment2.indexOf("=") + 1, fragment2.lastIndexOf(";\n"));
                String attribute1 = PrefixSuffixUtils.normalize(fragment1.substring(0, fragment1.indexOf("=")));
                String attribute2 = PrefixSuffixUtils.normalize(fragment2.substring(0, fragment2.indexOf("=")));
                if (value1.equals(attribute1) && this.classDiff != null && this.classDiff.getOriginalClass().containsAttributeWithName(attribute1) && this.classDiff.getNextClass().containsAttributeWithName(attribute1)) {
                    return true;
                }
                if (value2.equals(attribute2) && this.classDiff != null && this.classDiff.getOriginalClass().containsAttributeWithName(attribute2) && this.classDiff.getNextClass().containsAttributeWithName(attribute2)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean fieldAssignmentWithPreviouslyExistingParameter(Set<AbstractCodeMapping> mappings) {
        if (mappings.size() == 1) {
            AbstractCodeMapping mapping = mappings.iterator().next();
            String fragment1 = mapping.getFragment1().getString();
            String fragment2 = mapping.getFragment2().getString();
            if (fragment1.contains("=") && fragment1.endsWith(";\n") && fragment2.contains("=") && fragment2.endsWith(";\n")) {
                String value1 = fragment1.substring(fragment1.indexOf("=") + 1, fragment1.lastIndexOf(";\n"));
                String value2 = fragment2.substring(fragment2.indexOf("=") + 1, fragment2.lastIndexOf(";\n"));
                if (this.operation1.getParameterNameList().contains(value1) && this.operation2.getParameterNameList().contains(value1) && this.operationDiff != null) {
                    for (UMLParameter addedParameter : this.operationDiff.getAddedParameters()) {
                        if (!addedParameter.getName().equals(value2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private Map<Replacement, Set<AbstractCodeMapping>> getReplacementOccurrenceMap(Replacement.ReplacementType type) {
        LinkedHashMap<Replacement, Set<AbstractCodeMapping>> map = new LinkedHashMap<Replacement, Set<AbstractCodeMapping>>();
        for (AbstractCodeMapping mapping : this.mappings) {
            for (Replacement replacement : mapping.getReplacements()) {
                if (replacement.getType().equals((Object)type) && !this.returnVariableMapping(mapping, replacement) && !mapping.containsReplacement(Replacement.ReplacementType.CONCATENATION) && !this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) && this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) {
                    if (map.containsKey(replacement)) {
                        ((Set)map.get(replacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(replacement, list);
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS)) {
                    String before = replacement.getBefore().contains("[") ? replacement.getBefore().substring(0, replacement.getBefore().indexOf("[")) : replacement.getBefore();
                    String after = replacement.getAfter().contains("[") ? replacement.getAfter().substring(0, replacement.getAfter().indexOf("[")) : replacement.getAfter();
                    Replacement variableReplacement = new Replacement(before, after, Replacement.ReplacementType.VARIABLE_NAME);
                    if (this.returnVariableMapping(mapping, replacement) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) continue;
                    if (map.containsKey(variableReplacement)) {
                        ((Set)map.get(variableReplacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(variableReplacement, list);
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.METHOD_INVOCATION)) continue;
                MethodInvocationReplacement methodInvocationReplacement = (MethodInvocationReplacement)replacement;
                AbstractCall invocation1 = methodInvocationReplacement.getInvokedOperationBefore();
                AbstractCall invocation2 = methodInvocationReplacement.getInvokedOperationAfter();
                if (!invocation1.getName().equals(invocation2.getName()) || invocation1.getArguments().size() != invocation2.getArguments().size()) continue;
                for (int i = 0; i < invocation1.getArguments().size(); ++i) {
                    String after;
                    String argument1 = invocation1.getArguments().get(i);
                    String argument2 = invocation2.getArguments().get(i);
                    if (!argument1.contains("[") && !argument2.contains("[")) continue;
                    String before = argument1.contains("[") ? argument1.substring(0, argument1.indexOf("[")) : argument1;
                    String string = after = argument2.contains("[") ? argument2.substring(0, argument2.indexOf("[")) : argument2;
                    if (before.equals(after)) continue;
                    Replacement variableReplacement = new Replacement(before, after, Replacement.ReplacementType.VARIABLE_NAME);
                    if (this.returnVariableMapping(mapping, replacement) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(mapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(mapping, replacement)) continue;
                    if (map.containsKey(variableReplacement)) {
                        ((Set)map.get(variableReplacement)).add(mapping);
                        continue;
                    }
                    LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                    list.add(mapping);
                    map.put(variableReplacement, list);
                }
            }
        }
        return map;
    }

    private Map<Replacement, Set<AbstractCodeMapping>> getVariableDeclarationReplacementOccurrenceMap() {
        LinkedHashMap<Replacement, Set<AbstractCodeMapping>> map = new LinkedHashMap<Replacement, Set<AbstractCodeMapping>>();
        for (AbstractCodeMapping abstractCodeMapping : this.mappings) {
            for (Replacement replacement : abstractCodeMapping.getReplacements()) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || this.returnVariableMapping(abstractCodeMapping, replacement) || abstractCodeMapping.containsReplacement(Replacement.ReplacementType.CONCATENATION) || this.containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(abstractCodeMapping.getReplacements()) || !this.replacementNotInsideMethodSignatureOfAnonymousClass(abstractCodeMapping, replacement)) continue;
                AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> v1 = this.getVariableDeclaration1(replacement, abstractCodeMapping);
                AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> v2 = this.getVariableDeclaration2(replacement, abstractCodeMapping);
                if (v1 == null || v2 == null) continue;
                VariableDeclarationReplacement r = new VariableDeclarationReplacement((VariableDeclaration)v1.getKey(), v2.getKey(), (VariableDeclarationContainer)v1.getValue(), v2.getValue());
                if (map.containsKey(r)) {
                    ((Set)map.get(r)).add(abstractCodeMapping);
                    continue;
                }
                LinkedHashSet<AbstractCodeMapping> list = new LinkedHashSet<AbstractCodeMapping>();
                list.add(abstractCodeMapping);
                map.put(r, list);
            }
        }
        if (this.operationDiff != null) {
            ArrayList<UMLParameterDiff> allParameterDiffs = new ArrayList<UMLParameterDiff>();
            for (UMLParameterDiff uMLParameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!uMLParameterDiff.isNameChanged()) continue;
                allParameterDiffs.add(uMLParameterDiff);
            }
            ArrayList<UMLParameterDiff> arrayList = new ArrayList<UMLParameterDiff>();
            block3: for (UMLParameterDiff uMLParameterDiff : allParameterDiffs) {
                for (Replacement replacement : map.keySet()) {
                    VariableDeclarationReplacement vdR = (VariableDeclarationReplacement)replacement;
                    if (!uMLParameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) || !uMLParameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) continue;
                    arrayList.add(uMLParameterDiff);
                    continue block3;
                }
            }
            LinkedHashSet<VariableDeclarationReplacement> linkedHashSet = new LinkedHashSet<VariableDeclarationReplacement>();
            for (UMLParameterDiff parameterDiff : arrayList) {
                for (Replacement replacement : map.keySet()) {
                    VariableDeclarationReplacement vdR = (VariableDeclarationReplacement)replacement;
                    if (parameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) && !parameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) {
                        linkedHashSet.add(vdR);
                        continue;
                    }
                    if (parameterDiff.getRemovedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration1()) || !parameterDiff.getAddedParameter().getVariableDeclaration().equals(vdR.getVariableDeclaration2())) continue;
                    linkedHashSet.add(vdR);
                }
            }
            for (VariableDeclarationReplacement key : linkedHashSet) {
                map.remove(key);
            }
        }
        return map;
    }

    private boolean returnVariableMapping(AbstractCodeMapping mapping, Replacement replacement) {
        if (!this.operation1.isDeclaredInAnonymousClass() && !this.operation2.isDeclaredInAnonymousClass()) {
            return mapping.getFragment1().getString().equals("return " + replacement.getBefore() + ";\n") && mapping.getFragment2().getString().equals("return " + replacement.getAfter() + ";\n");
        }
        return false;
    }

    private boolean containsMethodInvocationReplacementWithDifferentExpressionNameAndArguments(Set<Replacement> replacements) {
        for (Replacement replacement : replacements) {
            MethodInvocationReplacement r;
            if (!(replacement instanceof MethodInvocationReplacement) || !(r = (MethodInvocationReplacement)replacement).differentExpressionNameAndArguments()) continue;
            return true;
        }
        return false;
    }

    private boolean replacementNotInsideMethodSignatureOfAnonymousClass(AbstractCodeMapping mapping, Replacement replacement) {
        AbstractCodeFragment fragment1 = mapping.getFragment1();
        AbstractCodeFragment fragment2 = mapping.getFragment2();
        List<AnonymousClassDeclarationObject> anonymousClassDeclarations1 = fragment1.getAnonymousClassDeclarations();
        List<AnonymousClassDeclarationObject> anonymousClassDeclarations2 = fragment2.getAnonymousClassDeclarations();
        if (anonymousClassDeclarations1.size() > 0 && anonymousClassDeclarations2.size() > 0) {
            String[] lines2;
            String[] lines1;
            boolean replacementBeforeNotFoundInMethodSignature = false;
            for (String line : lines1 = fragment1.getString().split("\\n")) {
                if (Visitor.METHOD_SIGNATURE_PATTERN.matcher(line = VariableReplacementAnalysis.prepareLine(line)).matches() || !ReplacementUtil.contains(line, replacement.getBefore())) continue;
                replacementBeforeNotFoundInMethodSignature = true;
                break;
            }
            boolean replacementAfterNotFoundInMethodSignature = false;
            for (String line : lines2 = fragment2.getString().split("\\n")) {
                if (Visitor.METHOD_SIGNATURE_PATTERN.matcher(line = VariableReplacementAnalysis.prepareLine(line)).matches() || !ReplacementUtil.contains(line, replacement.getAfter())) continue;
                replacementAfterNotFoundInMethodSignature = true;
                break;
            }
            return replacementBeforeNotFoundInMethodSignature && replacementAfterNotFoundInMethodSignature;
        }
        return true;
    }

    public static String prepareLine(String line) {
        if ((line = line.trim()).startsWith("@Nullable")) {
            line = line.substring(9, line.length());
            line = line.trim();
        }
        if (line.startsWith("@Override")) {
            line = line.substring(9, line.length());
            line = line.trim();
        }
        if (line.contains("throws ")) {
            line = line.substring(0, line.indexOf("throws "));
        }
        return line;
    }

    private static boolean cyclicRename(Set<Replacement> finalConsistentRenames, Replacement replacement) {
        for (Replacement r : finalConsistentRenames) {
            if (replacement.getAfter().equals(r.getBefore())) {
                return true;
            }
            if (!replacement.getBefore().equals(r.getAfter())) continue;
            return true;
        }
        return false;
    }

    private Set<Replacement> allConsistentRenames(Map<Replacement, Set<AbstractCodeMapping>> replacementOccurrenceMap) {
        Set<Replacement> renames = replacementOccurrenceMap.keySet();
        LinkedHashSet<Replacement> allConsistentRenames = new LinkedHashSet<Replacement>();
        LinkedHashSet allInconsistentRenames = new LinkedHashSet();
        ConsistentReplacementDetector.updateRenames(allConsistentRenames, allInconsistentRenames, this.aliasedVariablesInOriginalMethod, this.aliasedVariablesInNextMethod, renames);
        allConsistentRenames.removeAll(allInconsistentRenames);
        return allConsistentRenames;
    }

    private boolean replacementInLocalVariableDeclaration(Replacement replacement, Set<AbstractCodeMapping> set) {
        VariableDeclaration v1 = null;
        for (AbstractCodeMapping abstractCodeMapping : this.mappings) {
            if (!abstractCodeMapping.getReplacements().contains(replacement)) continue;
            v1 = abstractCodeMapping.getFragment1().searchVariableDeclaration(replacement.getBefore());
            break;
        }
        VariableDeclaration v2 = null;
        for (AbstractCodeMapping mapping : this.mappings) {
            if (!mapping.getReplacements().contains(replacement)) continue;
            v2 = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter());
            break;
        }
        LinkedHashSet<VariableDeclaration> linkedHashSet = new LinkedHashSet<VariableDeclaration>();
        LinkedHashSet<VariableDeclaration> allVariableDeclarations2 = new LinkedHashSet<VariableDeclaration>();
        boolean onlyOneFragmentIncludesDeclarationInReferences = false;
        for (AbstractCodeMapping referenceMapping : set) {
            AbstractCodeFragment statement1 = referenceMapping.getFragment1();
            AbstractCodeFragment statement2 = referenceMapping.getFragment2();
            if (set.size() == 1) {
                if (statement1.getVariableDeclarations().contains(v1) && !statement2.getVariableDeclarations().contains(v2) && v2 != null && v2.getInitializer() == null) {
                    onlyOneFragmentIncludesDeclarationInReferences = true;
                }
                if (!statement1.getVariableDeclarations().contains(v1) && statement2.getVariableDeclarations().contains(v2) && v1 != null && v1.getInitializer() == null) {
                    onlyOneFragmentIncludesDeclarationInReferences = true;
                }
            }
            if (statement1 instanceof CompositeStatementObject && statement2 instanceof CompositeStatementObject && statement1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT)) {
                CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
                CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
                linkedHashSet.addAll(comp1.getAllVariableDeclarations());
                allVariableDeclarations2.addAll(comp2.getAllVariableDeclarations());
                continue;
            }
            if (statement1 instanceof AbstractExpression && statement2 instanceof AbstractExpression && statement1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY) && statement2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY)) {
                AbstractExpression expr1 = (AbstractExpression)statement1;
                AbstractExpression expr2 = (AbstractExpression)statement2;
                if (expr1.getLambdaOwner() != null) {
                    linkedHashSet.addAll(expr1.getLambdaOwner().getParameters());
                }
                if (expr2.getLambdaOwner() == null) continue;
                allVariableDeclarations2.addAll(expr2.getLambdaOwner().getParameters());
                continue;
            }
            boolean parentMappingFound = false;
            for (AbstractCodeMapping mapping : this.mappings) {
                AbstractCodeFragment s1 = mapping.getFragment1();
                AbstractCodeFragment s2 = mapping.getFragment2();
                if (!(s1 instanceof CompositeStatementObject) || !(s2 instanceof CompositeStatementObject)) continue;
                CompositeStatementObject comp1 = (CompositeStatementObject)s1;
                CompositeStatementObject comp2 = (CompositeStatementObject)s2;
                if (!comp1.getStatements().contains(statement1) || !comp2.getStatements().contains(statement2)) continue;
                parentMappingFound = true;
                linkedHashSet.addAll(comp1.getAllVariableDeclarations());
                allVariableDeclarations2.addAll(comp2.getAllVariableDeclarations());
                break;
            }
            if (parentMappingFound) continue;
            linkedHashSet.addAll(this.operation1.getAllVariableDeclarations());
            allVariableDeclarations2.addAll(this.operation2.getAllVariableDeclarations());
            break;
        }
        return v1 != null && v2 != null && v1.equalVariableDeclarationType(v2) && !onlyOneFragmentIncludesDeclarationInReferences && !VariableReplacementAnalysis.containsVariableDeclarationWithName(v1, linkedHashSet, v2) && (!VariableReplacementAnalysis.containsVariableDeclarationWithName(v2, allVariableDeclarations2, v1) || this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) != null) && this.consistencyCheck(v1, v2, set);
    }

    private boolean consistencyCheck(VariableDeclaration v1, VariableDeclaration v2, Set<AbstractCodeMapping> set) {
        return !this.variableAppearsInExtractedMethod(v1, v2) && !this.variableAppearsInTheInitializerOfTheOtherVariable(v1, v2) && !this.inconsistentVariableMapping(v1, v2, set);
    }

    private boolean variableAppearsInTheInitializerOfTheOtherVariable(VariableDeclaration v1, VariableDeclaration v2) {
        TernaryOperatorExpression ternary;
        if (v1.getInitializer() != null) {
            if (v1.getInitializer().getString().equals(v2.getVariableName())) {
                return true;
            }
            if (v1.getInitializer().getTernaryOperatorExpressions().size() == 1 && ((ternary = v1.getInitializer().getTernaryOperatorExpressions().get(0)).getThenExpression().getVariables().contains(v2.getVariableName()) || ternary.getElseExpression().getVariables().contains(v2.getVariableName()))) {
                boolean v2InitializerContainsThisReference = false;
                if (v2.getInitializer() != null && v2.getInitializer().getVariables().contains("this." + v2.getVariableName())) {
                    v2InitializerContainsThisReference = true;
                }
                if (!v2InitializerContainsThisReference) {
                    return true;
                }
            }
        }
        if (v2.getInitializer() != null) {
            if (v2.getInitializer().getString().equals(v1.getVariableName())) {
                return true;
            }
            if (v2.getInitializer().getTernaryOperatorExpressions().size() == 1 && ((ternary = v2.getInitializer().getTernaryOperatorExpressions().get(0)).getThenExpression().getVariables().contains(v1.getVariableName()) || ternary.getElseExpression().getVariables().contains(v1.getVariableName()))) {
                boolean v1InitializerContainsThisReference = false;
                if (v1.getInitializer() != null && v1.getInitializer().getVariables().contains("this." + v1.getVariableName())) {
                    v1InitializerContainsThisReference = true;
                }
                if (!v1InitializerContainsThisReference) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean traditionalForToEnhancedForMapping(AbstractCodeMapping mapping) {
        if (mapping.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT) && mapping.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT)) {
            return true;
        }
        return mapping.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT) && mapping.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT);
    }

    private boolean inconsistentVariableMapping(VariableDeclaration v1, VariableDeclaration v2, Set<AbstractCodeMapping> set) {
        if (v1 != null && v2 != null) {
            for (AbstractCodeMapping mapping : this.mappings) {
                List<VariableDeclaration> variableDeclarations1 = mapping.getFragment1().getVariableDeclarations();
                List<VariableDeclaration> variableDeclarations2 = mapping.getFragment2().getVariableDeclarations();
                if (variableDeclarations1.contains(v1) && (variableDeclarations2.size() > 0 && !variableDeclarations2.contains(v2) ? !this.traditionalForToEnhancedForMapping(mapping) : variableDeclarations2.size() == 0 && v1.getInitializer() != null && mapping.getFragment2().getString().startsWith(v1.getInitializer().getString()))) {
                    return true;
                }
                if (variableDeclarations2.contains(v2) && (variableDeclarations1.size() > 0 && !variableDeclarations1.contains(v1) ? !this.traditionalForToEnhancedForMapping(mapping) : variableDeclarations1.size() == 0 && v2.getInitializer() != null && mapping.getFragment1().getString().startsWith(v2.getInitializer().getString()))) {
                    return true;
                }
                if (!mapping.isExact()) continue;
                for (AbstractCodeMapping referenceMapping : set) {
                    VariableScope v2Scope;
                    VariableScope otherV2Scope;
                    VariableDeclaration otherV2;
                    VariableScope v1Scope;
                    VariableScope otherV1Scope;
                    VariableDeclaration otherV1;
                    AbstractCodeFragment statement1 = referenceMapping.getFragment1();
                    AbstractCodeFragment statement2 = referenceMapping.getFragment2();
                    boolean containsMapping = true;
                    if (statement1 instanceof CompositeStatementObject && statement2 instanceof CompositeStatementObject && statement1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT)) {
                        CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
                        CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
                        boolean bl = containsMapping = comp1.contains(mapping.getFragment1()) && comp2.contains(mapping.getFragment2());
                    }
                    if (!containsMapping || this.operation2.loopWithVariables(v1.getVariableName(), v2.getVariableName()) != null) continue;
                    if (VariableReplacementAnalysis.bothFragmentsUseVariable(v1, mapping) && ((otherV1 = mapping.getFragment1().getVariableDeclaration(v1.getVariableName())) != null ? (otherV1Scope = otherV1.getScope()).overlaps(v1Scope = v1.getScope()) : set.size() == 1)) {
                        return true;
                    }
                    if (!VariableReplacementAnalysis.bothFragmentsUseVariable(v2, mapping) || !((otherV2 = mapping.getFragment2().getVariableDeclaration(v2.getVariableName())) != null ? (otherV2Scope = otherV2.getScope()).overlaps(v2Scope = v2.getScope()) : set.size() == 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean bothFragmentsUseVariable(VariableDeclaration v1, AbstractCodeMapping mapping) {
        return mapping.getFragment1().getVariables().contains(v1.getVariableName()) && mapping.getFragment2().getVariables().contains(v1.getVariableName());
    }

    private static boolean containsVariableDeclarationWithName(VariableDeclaration variableDeclaration, Set<VariableDeclaration> variableDeclarations, VariableDeclaration other) {
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(other.getVariableName()) || !declaration.equalVariableDeclarationType(other) || VariableReplacementAnalysis.invokingExpressionOrWrappedAsArgument(declaration.getInitializer(), variableDeclaration)) continue;
            return true;
        }
        return false;
    }

    private static boolean invokingExpressionOrWrappedAsArgument(AbstractExpression initializer, VariableDeclaration variableDeclaration) {
        if (initializer != null) {
            ObjectCreation creation;
            AbstractCall invocation = initializer.invocationCoveringEntireFragment();
            if (invocation != null) {
                if (invocation.getArguments().contains(variableDeclaration.getVariableName())) {
                    return true;
                }
                if (invocation.getExpression() != null && invocation.getExpression().equals(variableDeclaration.getVariableName())) {
                    return true;
                }
            }
            if ((creation = initializer.creationCoveringEntireFragment()) != null && creation.getArguments().contains(variableDeclaration.getVariableName())) {
                return true;
            }
        }
        return false;
    }

    private Set<AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>> getVariableDeclaration1(Replacement replacement) {
        LinkedHashSet<AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>> set = new LinkedHashSet<AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>>();
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd;
            if (!mapping.getReplacements().contains(replacement) || (vd = mapping.getFragment1().searchVariableDeclaration(replacement.getBefore())) == null) continue;
            set.add(new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation1()));
        }
        for (VariableDeclaration parameter : this.operation1.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(replacement.getBefore())) continue;
            set.add(new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation1));
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(replacement.getBefore())) continue;
                set.add(new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation));
            }
        }
        return set;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration1(MergeVariableReplacement replacement, String variableName) {
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd;
            LinkedHashSet<String> foundMergedVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getMergedVariables().contains(r.getBefore())) continue;
                foundMergedVariables.add(r.getBefore());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundMergedVariables.equals(replacement.getMergedVariables()) || (vd = mapping.getFragment1().searchVariableDeclaration(variableName)) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation1());
        }
        for (VariableDeclaration parameter : this.operation1.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(variableName)) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation1);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(variableName)) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration2(Replacement replacement) {
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd;
            if (!mapping.getReplacements().contains(replacement) || (vd = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter())) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation2());
        }
        for (VariableDeclaration parameter : this.operation2.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration2(SplitVariableReplacement replacement, String variableName) {
        for (AbstractCodeMapping mapping : this.mappings) {
            VariableDeclaration vd;
            if (!mapping.getReplacements().contains(replacement)) continue;
            LinkedHashSet<String> foundSplitVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getSplitVariables().contains(r.getAfter())) continue;
                foundSplitVariables.add(r.getAfter());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundSplitVariables.equals(replacement.getSplitVariables()) || (vd = mapping.getFragment2().searchVariableDeclaration(variableName)) == null) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation2());
        }
        for (VariableDeclaration parameter : this.operation2.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(variableName)) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(variableName)) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration2(MergeVariableReplacement replacement) {
        for (AbstractCodeMapping mapping : this.mappings) {
            LinkedHashSet<String> foundMergedVariables = new LinkedHashSet<String>();
            for (Replacement r : mapping.getReplacements()) {
                if (!replacement.getMergedVariables().contains(r.getBefore())) continue;
                foundMergedVariables.add(r.getBefore());
            }
            if (!mapping.getReplacements().contains(replacement) && !foundMergedVariables.equals(replacement.getMergedVariables())) continue;
            VariableDeclaration vd = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter());
            if (vd != null) {
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation2());
            }
            for (Replacement r : mapping.getReplacements()) {
                if (!r.getBefore().equals(replacement.getAfter()) || (vd = mapping.getFragment2().searchVariableDeclaration(r.getAfter())) == null) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation2());
            }
        }
        for (VariableDeclaration parameter : this.operation2.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }

    private boolean variableAppearsInExtractedMethod(VariableDeclaration v1, VariableDeclaration v2) {
        if (v1 != null) {
            UMLModelDiff modelDiff = this.classDiff != null ? this.classDiff.getModelDiff() : null;
            for (UMLOperationBodyMapper mapper : this.childMappers) {
                if (mapper.equals(this.mapper)) continue;
                for (AbstractCodeMapping mapping : mapper.getMappings()) {
                    if (!mapping.getFragment1().getVariableDeclarations().contains(v1)) continue;
                    boolean identicalNonMappedStatementInParentMapper = false;
                    for (AbstractCodeFragment fragment2 : this.nonMappedLeavesT2) {
                        if (!fragment2.getString().equals(mapping.getFragment2().getString())) continue;
                        identicalNonMappedStatementInParentMapper = true;
                        break;
                    }
                    if (v2 != null && v2.getInitializer() != null) {
                        VariableDeclarationContainer extractedMethod = mapper.getContainer2();
                        Map<String, List<AbstractCall>> methodInvocationMap = v2.getInitializer().getMethodInvocationMap();
                        for (String key : methodInvocationMap.keySet()) {
                            for (AbstractCall invocation : methodInvocationMap.get(key)) {
                                if (invocation.matchesOperation(extractedMethod, this.operation2, modelDiff)) {
                                    return false;
                                }
                                List<String> initializerVariables = v2.getInitializer().getVariables();
                                for (String variable : initializerVariables) {
                                    for (VariableDeclaration declaration : this.operation2.getAllVariableDeclarations()) {
                                        if (!declaration.getVariableName().equals(variable) || declaration.getInitializer() == null) continue;
                                        Map<String, List<AbstractCall>> methodInvocationMap2 = declaration.getInitializer().getMethodInvocationMap();
                                        for (String key2 : methodInvocationMap2.keySet()) {
                                            for (AbstractCall invocation2 : methodInvocationMap2.get(key2)) {
                                                if (!invocation2.matchesOperation(extractedMethod, this.operation2, modelDiff)) continue;
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (identicalNonMappedStatementInParentMapper) continue;
                    return true;
                }
                for (AbstractCodeFragment nonMappedStatement : mapper.getNonMappedLeavesT2()) {
                    VariableDeclaration variableDeclaration2 = nonMappedStatement.getVariableDeclaration(v1.getVariableName());
                    if (variableDeclaration2 == null || !variableDeclaration2.equalType(v1)) continue;
                    for (AbstractCodeMapping mapping : mapper.getMappings()) {
                        if (!mapping.getFragment2().equals(nonMappedStatement.getParent()) || !(mapping.getFragment1() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject composite1 = (CompositeStatementObject)mapping.getFragment1();
                        List<AbstractCodeFragment> leaves1 = composite1.getLeaves();
                        for (AbstractCodeFragment leaf1 : leaves1) {
                            VariableDeclaration variableDeclaration1 = leaf1.getVariableDeclaration(variableDeclaration2.getVariableName());
                            if (variableDeclaration1 == null) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean existsConflictingParameterRenameInOperationDiff(MergeVariableRefactoring ref, Map<String, Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>>> variableInvocationExpressionMap) {
        if (this.operationDiff != null) {
            for (UMLParameterDiff parameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!ref.getMergedVariables().contains(parameterDiff.getRemovedParameter().getVariableDeclaration()) || !ref.getNewVariable().equals(parameterDiff.getAddedParameter().getVariableDeclaration())) continue;
                boolean castInvocation = false;
                String variableName = ref.getNewVariable().getVariableName();
                if (variableInvocationExpressionMap.containsKey(variableName)) {
                    Map<VariableReplacementWithMethodInvocation, Set<AbstractCodeMapping>> map = variableInvocationExpressionMap.get(variableName);
                    for (VariableReplacementWithMethodInvocation replacement : map.keySet()) {
                        if (!replacement.getBefore().equals(variableName) || !replacement.getInvokedOperation().getCoverage().equals((Object)AbstractCall.StatementCoverageType.CAST_CALL)) continue;
                        castInvocation = true;
                        break;
                    }
                }
                if (castInvocation) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsConflictingParameterRenameInOperationDiff(SplitVariableRefactoring ref) {
        if (this.operationDiff != null) {
            for (UMLParameterDiff parameterDiff : this.operationDiff.getParameterDiffList()) {
                if (!ref.getSplitVariables().contains(parameterDiff.getAddedParameter().getVariableDeclaration()) || !ref.getOldVariable().equals(parameterDiff.getRemovedParameter().getVariableDeclaration())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsConflictingExtractVariableRefactoring(RenameVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            ExtractVariableRefactoring extractVariableRef;
            if (!(refactoring instanceof ExtractVariableRefactoring) || !(extractVariableRef = (ExtractVariableRefactoring)refactoring).getVariableDeclaration().equals(ref.getRenamedVariable()) || !extractVariableRef.getOperationAfter().equals(ref.getOperationAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingExtractVariableRefactoring(SplitVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            if (!(refactoring instanceof ExtractVariableRefactoring)) continue;
            ExtractVariableRefactoring extractVariableRef = (ExtractVariableRefactoring)refactoring;
            if (!ref.getSplitVariables().contains(extractVariableRef.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingInlineVariableRefactoring(MergeVariableRefactoring ref) {
        for (Refactoring refactoring : this.refactorings) {
            if (!(refactoring instanceof InlineVariableRefactoring)) continue;
            InlineVariableRefactoring inlineVariableRef = (InlineVariableRefactoring)refactoring;
            if (!ref.getMergedVariables().contains(inlineVariableRef.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingMergeVariableRefactoring(RenameVariableRefactoring ref) {
        for (MergeVariableRefactoring merge : this.variableMerges) {
            if (!merge.getOperationBefore().equals(ref.getOperationBefore()) || !merge.getOperationAfter().equals(ref.getOperationAfter()) || !merge.getMergedVariables().contains(ref.getOriginalVariable()) || !merge.getNewVariable().equals(ref.getRenamedVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingSplitVariableRefactoring(RenameVariableRefactoring ref) {
        for (SplitVariableRefactoring split : this.variableSplits) {
            if (!split.getOperationBefore().equals(ref.getOperationBefore()) || !split.getOperationAfter().equals(ref.getOperationAfter()) || !split.getSplitVariables().contains(ref.getRenamedVariable()) || !split.getOldVariable().equals(ref.getOriginalVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean existsConflictingParameter(RenameVariableRefactoring ref) {
        VariableDeclaration originalVariable;
        VariableDeclaration renamedVariable = ref.getRenamedVariable();
        if (renamedVariable.isParameter()) {
            for (VariableDeclaration parameter : this.operation1.getParameterDeclarationList()) {
                if (!renamedVariable.getVariableName().equals(parameter.getVariableName()) || !renamedVariable.equalType(parameter)) continue;
                return true;
            }
        }
        if ((originalVariable = ref.getOriginalVariable()).isParameter()) {
            for (VariableDeclaration parameter : this.operation2.getParameterDeclarationList()) {
                if (!originalVariable.getVariableName().equals(parameter.getVariableName()) || !originalVariable.equalType(parameter)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean potentialParameterRename(Replacement replacement, Set<AbstractCodeMapping> set) {
        int index2;
        int index1 = this.operation1.getParameterNameList().indexOf(replacement.getBefore());
        if (index1 == -1 && this.callSiteOperation != null) {
            index1 = this.callSiteOperation.getParameterNameList().indexOf(replacement.getBefore());
        }
        if ((index2 = this.operation2.getParameterNameList().indexOf(replacement.getAfter())) == -1 && this.callSiteOperation != null) {
            index2 = this.callSiteOperation.getParameterNameList().indexOf(replacement.getAfter());
        }
        if (this.fieldAssignmentToPreviouslyExistingAttribute(set)) {
            return false;
        }
        if (this.fieldAssignmentWithPreviouslyExistingParameter(set)) {
            return false;
        }
        return index1 >= 0 && index1 == index2;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration1(Replacement replacement, AbstractCodeMapping mapping) {
        VariableDeclaration vd;
        if (mapping.getReplacements().contains(replacement) && (vd = mapping.getFragment1().searchVariableDeclaration(replacement.getBefore())) != null) {
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation1());
        }
        for (VariableDeclaration parameter : this.operation1.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(replacement.getBefore())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation1);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(replacement.getBefore())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }

    private AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer> getVariableDeclaration2(Replacement replacement, AbstractCodeMapping mapping) {
        VariableDeclaration vd;
        if (mapping.getReplacements().contains(replacement) && (vd = mapping.getFragment2().searchVariableDeclaration(replacement.getAfter())) != null) {
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(vd, mapping.getOperation2());
        }
        for (VariableDeclaration parameter : this.operation2.getParameterDeclarationList()) {
            if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
            return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.operation2);
        }
        if (this.callSiteOperation != null) {
            for (VariableDeclaration parameter : this.callSiteOperation.getParameterDeclarationList()) {
                if (!parameter.getVariableName().equals(replacement.getAfter())) continue;
                return new AbstractMap.SimpleEntry<VariableDeclaration, VariableDeclarationContainer>(parameter, this.callSiteOperation);
            }
        }
        return null;
    }
}

