/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class VariableScope {
    private String filePath;
    private int startOffset;
    private int endOffset;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    private List<AbstractCodeFragment> statementsInScope = new ArrayList<AbstractCodeFragment>();
    private List<AbstractCodeFragment> statementsInScopeUsingVariable = new ArrayList<AbstractCodeFragment>();
    private String parentSignature = "";

    public VariableScope(CompilationUnit cu, String filePath, int startOffset, int endOffset) {
        this.filePath = filePath;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.startLine = cu.getLineNumber(startOffset);
        this.endLine = cu.getLineNumber(endOffset);
        this.startColumn = cu.getColumnNumber(startOffset);
        if (this.startColumn > 0) {
            ++this.startColumn;
        }
        this.endColumn = cu.getColumnNumber(endOffset);
        if (this.endColumn > 0) {
            ++this.endColumn;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endOffset;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableScope other = (VariableScope)obj;
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.startLine).append(":").append(this.startColumn);
        sb.append("-");
        sb.append(this.endLine).append(":").append(this.endColumn);
        return sb.toString();
    }

    public void addStatement(AbstractCodeFragment statement) {
        this.statementsInScope.add(statement);
    }

    public void addStatementUsingVariable(AbstractCodeFragment statement) {
        this.statementsInScopeUsingVariable.add(statement);
    }

    public List<AbstractCodeFragment> getStatementsInScope() {
        return this.statementsInScope;
    }

    public List<AbstractCodeFragment> getStatementsInScopeUsingVariable() {
        return this.statementsInScopeUsingVariable;
    }

    public boolean subsumes(LocationInfo other) {
        return this.filePath.equals(other.getFilePath()) && this.startOffset <= other.getStartOffset() && this.endOffset >= other.getEndOffset();
    }

    public boolean overlaps(VariableScope other) {
        return this.filePath.equals(other.filePath) && this.startOffset <= other.endOffset && this.endOffset >= other.startOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getParentSignature() {
        return this.parentSignature;
    }

    public void setParentSignature(String parentSignature) {
        this.parentSignature = parentSignature;
    }
}

