/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.MethodReference;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

public class Visitor
extends ASTVisitor {
    public static final Pattern METHOD_INVOCATION_PATTERN = Pattern.compile("!(\\w|\\.)*@\\w*");
    public static final Pattern METHOD_SIGNATURE_PATTERN = Pattern.compile("(public|protected|private|static|\\s) +[\\w\\<\\>\\[\\]]+\\s+(\\w+) *\\([^\\)]*\\) *(\\{?|[^;])");
    private CompilationUnit cu;
    private String filePath;
    private VariableDeclarationContainer container;
    private List<String> variables = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();
    private Map<String, List<AbstractCall>> methodInvocationMap = new LinkedHashMap<String, List<AbstractCall>>();
    private List<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
    private List<AnonymousClassDeclarationObject> anonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
    private List<String> stringLiterals = new ArrayList<String>();
    private List<String> numberLiterals = new ArrayList<String>();
    private List<String> nullLiterals = new ArrayList<String>();
    private List<String> booleanLiterals = new ArrayList<String>();
    private List<String> typeLiterals = new ArrayList<String>();
    private Map<String, List<ObjectCreation>> creationMap = new LinkedHashMap<String, List<ObjectCreation>>();
    private List<String> infixExpressions = new ArrayList<String>();
    private List<String> infixOperators = new ArrayList<String>();
    private List<String> arrayAccesses = new ArrayList<String>();
    private List<String> prefixExpressions = new ArrayList<String>();
    private List<String> postfixExpressions = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private List<TernaryOperatorExpression> ternaryOperatorExpressions = new ArrayList<TernaryOperatorExpression>();
    private List<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode current = this.root = new DefaultMutableTreeNode();

    public Visitor(CompilationUnit cu, String filePath, VariableDeclarationContainer container) {
        this.cu = cu;
        this.filePath = filePath;
        this.container = container;
    }

    public boolean visit(ArrayAccess node) {
        this.arrayAccesses.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getArrayAccesses().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        this.prefixExpressions.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPrefixExpressions().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        this.postfixExpressions.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPostfixExpressions().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(ConditionalExpression node) {
        TernaryOperatorExpression ternary = new TernaryOperatorExpression(this.cu, this.filePath, node, this.container);
        this.ternaryOperatorExpressions.add(ternary);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTernaryOperatorExpressions().add(ternary);
        }
        return super.visit(node);
    }

    public boolean visit(InfixExpression node) {
        this.infixExpressions.add(node.toString());
        this.infixOperators.add(node.getOperator().toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getInfixExpressions().add(node.toString());
            anonymous.getInfixOperators().add(node.getOperator().toString());
        }
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        ObjectCreation creation = new ObjectCreation(this.cu, this.filePath, node);
        String nodeAsString = node.toString();
        if (this.creationMap.containsKey(nodeAsString)) {
            this.creationMap.get(nodeAsString).add(creation);
        } else {
            ArrayList<ObjectCreation> list = new ArrayList<ObjectCreation>();
            list.add(creation);
            this.creationMap.put(nodeAsString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<ObjectCreation>> anonymousCreationMap = anonymous.getCreationMap();
            if (anonymousCreationMap.containsKey(nodeAsString)) {
                anonymousCreationMap.get(nodeAsString).add(creation);
            } else {
                ArrayList<ObjectCreation> list = new ArrayList<ObjectCreation>();
                list.add(creation);
                anonymousCreationMap.put(nodeAsString, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(ArrayCreation node) {
        List expressions;
        ArrayInitializer initializer;
        ObjectCreation creation = new ObjectCreation(this.cu, this.filePath, node);
        String nodeAsString = node.toString();
        if (this.creationMap.containsKey(nodeAsString)) {
            this.creationMap.get(nodeAsString).add(creation);
        } else {
            ArrayList<ObjectCreation> list = new ArrayList<ObjectCreation>();
            list.add(creation);
            this.creationMap.put(nodeAsString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<ObjectCreation>> anonymousCreationMap = anonymous.getCreationMap();
            if (anonymousCreationMap.containsKey(nodeAsString)) {
                anonymousCreationMap.get(nodeAsString).add(creation);
            } else {
                ArrayList<ObjectCreation> list = new ArrayList<ObjectCreation>();
                list.add(creation);
                anonymousCreationMap.put(nodeAsString, list);
            }
        }
        if ((initializer = node.getInitializer()) != null && (expressions = initializer.expressions()).size() > 10) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (!(node.getParent() instanceof LambdaExpression)) {
            VariableDeclaration variableDeclaration = new VariableDeclaration(this.cu, this.filePath, node, this.container);
            this.variableDeclarations.add(variableDeclaration);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariableDeclarations().add(variableDeclaration);
            }
        }
        return super.visit(node);
    }

    public boolean visit(SingleVariableDeclaration node) {
        VariableDeclaration variableDeclaration = new VariableDeclaration(this.cu, this.filePath, node, this.container, node.isVarargs());
        this.variableDeclarations.add(variableDeclaration);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getVariableDeclarations().add(variableDeclaration);
        }
        return super.visit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        DefaultMutableTreeNode childNode = this.insertNode(node);
        AnonymousClassDeclarationObject childAnonymous = (AnonymousClassDeclarationObject)childNode.getUserObject();
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            currentAnonymous.getAnonymousClassDeclarations().add(childAnonymous);
        }
        this.anonymousClassDeclarations.add(childAnonymous);
        this.current = childNode;
        return super.visit(node);
    }

    public void endVisit(AnonymousClassDeclaration node) {
        DefaultMutableTreeNode parentNode = this.deleteNode(node);
        this.removeAnonymousData();
        this.current = parentNode;
    }

    private void removeAnonymousData() {
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Visitor.removeLast(this.variables, anonymous.getVariables());
            Visitor.removeLast(this.types, anonymous.getTypes());
            for (String key : anonymous.getMethodInvocationMap().keySet()) {
                this.methodInvocationMap.remove(key, anonymous.getMethodInvocationMap().get(key));
            }
            for (String key : anonymous.getCreationMap().keySet()) {
                this.creationMap.remove(key, anonymous.getCreationMap().get(key));
            }
            this.variableDeclarations.removeAll(anonymous.getVariableDeclarations());
            Visitor.removeLast(this.stringLiterals, anonymous.getStringLiterals());
            Visitor.removeLast(this.nullLiterals, anonymous.getNullLiterals());
            Visitor.removeLast(this.booleanLiterals, anonymous.getBooleanLiterals());
            Visitor.removeLast(this.typeLiterals, anonymous.getTypeLiterals());
            Visitor.removeLast(this.numberLiterals, anonymous.getNumberLiterals());
            Visitor.removeLast(this.infixExpressions, anonymous.getInfixExpressions());
            Visitor.removeLast(this.infixOperators, anonymous.getInfixOperators());
            Visitor.removeLast(this.postfixExpressions, anonymous.getPostfixExpressions());
            Visitor.removeLast(this.prefixExpressions, anonymous.getPrefixExpressions());
            Visitor.removeLast(this.arguments, anonymous.getArguments());
            this.ternaryOperatorExpressions.removeAll(anonymous.getTernaryOperatorExpressions());
            this.anonymousClassDeclarations.removeAll(anonymous.getAnonymousClassDeclarations());
            this.lambdas.removeAll(anonymous.getLambdas());
            this.arrayAccesses.removeAll(anonymous.getArrayAccesses());
        }
    }

    private static void removeLast(List<String> parentList, List<String> childList) {
        for (int i = childList.size() - 1; i >= 0; --i) {
            String element = childList.get(i);
            int lastIndex = parentList.lastIndexOf(element);
            parentList.remove(lastIndex);
        }
    }

    private DefaultMutableTreeNode deleteNode(AnonymousClassDeclaration childAnonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        DefaultMutableTreeNode childNode = this.findNode(childAnonymous);
        DefaultMutableTreeNode parentNode = this.root;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !this.isParent((ASTNode)childAnonymous, (ASTNode)currentAnonymous.getAstNode())) continue;
            parentNode = currentNode;
            break;
        }
        parentNode.remove(childNode);
        AnonymousClassDeclarationObject childAnonymousObject = (AnonymousClassDeclarationObject)childNode.getUserObject();
        childAnonymousObject.setAstNode(null);
        return parentNode;
    }

    private DefaultMutableTreeNode insertNode(AnonymousClassDeclaration childAnonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        AnonymousClassDeclarationObject anonymousObject = new AnonymousClassDeclarationObject(this.cu, this.filePath, childAnonymous);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(anonymousObject);
        DefaultMutableTreeNode parentNode = this.root;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !this.isParent((ASTNode)childAnonymous, (ASTNode)currentAnonymous.getAstNode())) continue;
            parentNode = currentNode;
            break;
        }
        parentNode.add(childNode);
        return childNode;
    }

    private DefaultMutableTreeNode findNode(AnonymousClassDeclaration anonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !currentAnonymous.getAstNode().equals((Object)anonymous)) continue;
            return currentNode;
        }
        return null;
    }

    private boolean isParent(ASTNode child, ASTNode parent) {
        ASTNode current = child;
        while (current.getParent() != null) {
            if (current.getParent().equals((Object)parent)) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.stringLiterals.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getStringLiterals().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(NumberLiteral node) {
        this.numberLiterals.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getNumberLiterals().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(NullLiteral node) {
        this.nullLiterals.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getNullLiterals().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(BooleanLiteral node) {
        this.booleanLiterals.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getBooleanLiterals().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(TypeLiteral node) {
        this.typeLiterals.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypeLiterals().add(node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(ThisExpression node) {
        if (!(node.getParent() instanceof FieldAccess)) {
            this.variables.add(node.toString());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(node.toString());
            }
        }
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        if (node.getParent() instanceof FieldAccess && ((FieldAccess)node.getParent()).getExpression() instanceof ThisExpression) {
            FieldAccess fieldAccess = (FieldAccess)node.getParent();
            this.variables.add(fieldAccess.toString());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(fieldAccess.toString());
            }
        } else if (!(node.getParent() instanceof MethodInvocation && ((MethodInvocation)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof SuperMethodInvocation && ((SuperMethodInvocation)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof Type || node.getParent() instanceof MarkerAnnotation && ((MarkerAnnotation)node.getParent()).getTypeName().equals((Object)node) || node.getParent() instanceof MethodDeclaration && ((MethodDeclaration)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration || node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause || node.getParent() instanceof QualifiedName && (node.getParent().getParent() instanceof QualifiedName || node.getParent().getParent() instanceof MethodInvocation || node.getParent().getParent() instanceof SuperMethodInvocation || node.getParent().getParent() instanceof ClassInstanceCreation))) {
            this.variables.add(node.getIdentifier());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(node.getIdentifier());
            }
        }
        return super.visit(node);
    }

    public boolean visit(ArrayType node) {
        this.types.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(node.toString());
        }
        return false;
    }

    public boolean visit(ParameterizedType node) {
        this.types.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(node.toString());
        }
        return false;
    }

    public boolean visit(WildcardType node) {
        this.types.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(node.toString());
        }
        return false;
    }

    public boolean visit(QualifiedType node) {
        this.types.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(node.toString());
        }
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.types.add(node.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(node.toString());
        }
        return false;
    }

    public boolean visit(SimpleType node) {
        Name name = node.getName();
        this.types.add(name.getFullyQualifiedName());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(name.getFullyQualifiedName());
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        String methodInvocation = null;
        methodInvocation = METHOD_INVOCATION_PATTERN.matcher(node.toString()).matches() ? Visitor.processMethodInvocation(node) : node.toString();
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node);
        if (this.methodInvocationMap.containsKey(methodInvocation)) {
            this.methodInvocationMap.get(methodInvocation).add(invocation);
        } else {
            ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
            list.add(invocation);
            this.methodInvocationMap.put(methodInvocation, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(methodInvocation)) {
                anonymousMethodInvocationMap.get(methodInvocation).add(invocation);
            } else {
                ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
                list.add(invocation);
                anonymousMethodInvocationMap.put(methodInvocation, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(ExpressionMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node);
        String referenceString = node.toString();
        if (this.methodInvocationMap.containsKey(referenceString)) {
            this.methodInvocationMap.get(referenceString).add(reference);
        } else {
            ArrayList<MethodReference> list = new ArrayList<MethodReference>();
            list.add(reference);
            this.methodInvocationMap.put(referenceString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(referenceString)) {
                anonymousMethodInvocationMap.get(referenceString).add(reference);
            } else {
                ArrayList<MethodReference> list = new ArrayList<MethodReference>();
                list.add(reference);
                anonymousMethodInvocationMap.put(referenceString, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node);
        String referenceString = node.toString();
        if (this.methodInvocationMap.containsKey(referenceString)) {
            this.methodInvocationMap.get(referenceString).add(reference);
        } else {
            ArrayList<MethodReference> list = new ArrayList<MethodReference>();
            list.add(reference);
            this.methodInvocationMap.put(referenceString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(referenceString)) {
                anonymousMethodInvocationMap.get(referenceString).add(reference);
            } else {
                ArrayList<MethodReference> list = new ArrayList<MethodReference>();
                list.add(reference);
                anonymousMethodInvocationMap.put(referenceString, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(TypeMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node);
        String referenceString = node.toString();
        if (this.methodInvocationMap.containsKey(referenceString)) {
            this.methodInvocationMap.get(referenceString).add(reference);
        } else {
            ArrayList<MethodReference> list = new ArrayList<MethodReference>();
            list.add(reference);
            this.methodInvocationMap.put(referenceString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(referenceString)) {
                anonymousMethodInvocationMap.get(referenceString).add(reference);
            } else {
                ArrayList<MethodReference> list = new ArrayList<MethodReference>();
                list.add(reference);
                anonymousMethodInvocationMap.put(referenceString, list);
            }
        }
        return super.visit(node);
    }

    public static String processMethodInvocation(MethodInvocation node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getName().getIdentifier());
        sb.append("(");
        List arguments = node.arguments();
        if (arguments.size() > 0) {
            for (int i = 0; i < arguments.size() - 1; ++i) {
                sb.append(((Expression)arguments.get(i)).toString()).append(", ");
            }
            sb.append(((Expression)arguments.get(arguments.size() - 1)).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String processClassInstanceCreation(ClassInstanceCreation node) {
        StringBuilder sb = new StringBuilder();
        sb.append("new").append(" ");
        sb.append(node.getType().toString());
        List arguments = node.arguments();
        if (arguments.size() > 0) {
            for (int i = 0; i < arguments.size() - 1; ++i) {
                sb.append(((Expression)arguments.get(i)).toString()).append(", ");
            }
            sb.append(((Expression)arguments.get(arguments.size() - 1)).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean visit(SuperMethodInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node);
        String nodeAsString = node.toString();
        if (this.methodInvocationMap.containsKey(nodeAsString)) {
            this.methodInvocationMap.get(nodeAsString).add(invocation);
        } else {
            ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
            list.add(invocation);
            this.methodInvocationMap.put(nodeAsString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(nodeAsString)) {
                anonymousMethodInvocationMap.get(nodeAsString).add(invocation);
            } else {
                ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
                list.add(invocation);
                anonymousMethodInvocationMap.put(nodeAsString, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node);
        String nodeAsString = node.toString();
        if (this.methodInvocationMap.containsKey(nodeAsString)) {
            this.methodInvocationMap.get(nodeAsString).add(invocation);
        } else {
            ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
            list.add(invocation);
            this.methodInvocationMap.put(nodeAsString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(nodeAsString)) {
                anonymousMethodInvocationMap.get(nodeAsString).add(invocation);
            } else {
                ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
                list.add(invocation);
                anonymousMethodInvocationMap.put(nodeAsString, list);
            }
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node);
        String nodeAsString = node.toString();
        if (this.methodInvocationMap.containsKey(nodeAsString)) {
            this.methodInvocationMap.get(nodeAsString).add(invocation);
        } else {
            ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
            list.add(invocation);
            this.methodInvocationMap.put(nodeAsString, list);
        }
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Map<String, List<AbstractCall>> anonymousMethodInvocationMap = anonymous.getMethodInvocationMap();
            if (anonymousMethodInvocationMap.containsKey(nodeAsString)) {
                anonymousMethodInvocationMap.get(nodeAsString).add(invocation);
            } else {
                ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
                list.add(invocation);
                anonymousMethodInvocationMap.put(nodeAsString, list);
            }
        }
        return super.visit(node);
    }

    private void processArgument(Expression argument) {
        LambdaExpressionObject lambda;
        if (argument instanceof SuperMethodInvocation || argument instanceof Name || argument instanceof StringLiteral || argument instanceof BooleanLiteral || argument instanceof NumberLiteral || argument instanceof FieldAccess && ((FieldAccess)argument).getExpression() instanceof ThisExpression || argument instanceof ArrayAccess && Visitor.invalidArrayAccess((ArrayAccess)argument) || argument instanceof InfixExpression && Visitor.invalidInfix((InfixExpression)argument) || this.castExpressionInParenthesizedExpression(argument)) {
            return;
        }
        if (argument instanceof ExpressionMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (ExpressionMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        } else if (argument instanceof SuperMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (SuperMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        } else if (argument instanceof TypeMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (TypeMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        }
        this.arguments.add(argument.toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getArguments().add(argument.toString());
        }
    }

    private boolean castExpressionInParenthesizedExpression(Expression argument) {
        CastExpression castExpression;
        Expression parenthesizedExpression;
        return argument instanceof ParenthesizedExpression && (parenthesizedExpression = ((ParenthesizedExpression)argument).getExpression()) instanceof CastExpression && (castExpression = (CastExpression)parenthesizedExpression).getExpression() instanceof SimpleName;
    }

    public boolean visit(QualifiedName node) {
        Name qualifier = node.getQualifier();
        if (Character.isUpperCase(qualifier.getFullyQualifiedName().charAt(0))) {
            AnonymousClassDeclarationObject anonymous;
            this.types.add(qualifier.getFullyQualifiedName());
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getTypes().add(qualifier.getFullyQualifiedName());
            }
            this.variables.add(node.toString());
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(node.toString());
            }
        } else if (qualifier instanceof SimpleName && !(node.getParent() instanceof QualifiedName)) {
            EnhancedForStatement enhancedFor;
            String qualifierIdentifier = ((SimpleName)qualifier).getIdentifier();
            MethodDeclaration parentMethodDeclaration = this.findParentMethodDeclaration((ASTNode)node);
            if (parentMethodDeclaration != null) {
                boolean qualifierIsParameter = false;
                List parameters = parentMethodDeclaration.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    if (!parameter.getName().getIdentifier().equals(qualifierIdentifier)) continue;
                    qualifierIsParameter = true;
                    break;
                }
                if (qualifierIsParameter) {
                    this.variables.add(node.toString());
                    if (this.current.getUserObject() != null) {
                        AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                        anonymous.getVariables().add(node.toString());
                    }
                }
            }
            if ((enhancedFor = this.findParentEnhancedForStatement((ASTNode)node)) != null && enhancedFor.getParameter().getName().getIdentifier().equals(qualifierIdentifier)) {
                this.variables.add(node.toString());
                if (this.current.getUserObject() != null) {
                    AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                    anonymous.getVariables().add(node.toString());
                }
            }
        }
        return super.visit(node);
    }

    private EnhancedForStatement findParentEnhancedForStatement(ASTNode node) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnhancedForStatement)) continue;
            return (EnhancedForStatement)parent;
        }
        return null;
    }

    private MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MethodDeclaration)) continue;
            return (MethodDeclaration)parent;
        }
        return null;
    }

    public boolean visit(CastExpression node) {
        Expression castExpression = node.getExpression();
        if (castExpression instanceof SimpleName) {
            this.variables.add(node.toString());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(node.toString());
            }
        }
        return super.visit(node);
    }

    public boolean visit(LambdaExpression node) {
        LambdaExpressionObject lambda = new LambdaExpressionObject(this.cu, this.filePath, node, this.container);
        this.lambdas.add(lambda);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getLambdas().add(lambda);
        }
        return false;
    }

    public Map<String, List<AbstractCall>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return this.anonymousClassDeclarations;
    }

    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    public Map<String, List<ObjectCreation>> getCreationMap() {
        return this.creationMap;
    }

    public List<String> getInfixExpressions() {
        return this.infixExpressions;
    }

    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<TernaryOperatorExpression> getTernaryOperatorExpressions() {
        return this.ternaryOperatorExpressions;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    private static boolean invalidArrayAccess(ArrayAccess e) {
        return e.getArray() instanceof SimpleName && Visitor.simpleNameOrNumberLiteral(e.getIndex());
    }

    private static boolean invalidInfix(InfixExpression e) {
        return Visitor.simpleNameOrNumberLiteral(e.getLeftOperand()) && Visitor.simpleNameOrNumberLiteral(e.getRightOperand());
    }

    private static boolean simpleNameOrNumberLiteral(Expression e) {
        return e instanceof SimpleName || e instanceof NumberLiteral;
    }
}

