/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition.replacement;

import gr.uom.java.xmi.decomposition.replacement.Replacement;
import java.util.LinkedHashSet;
import java.util.Set;

public class SplitVariableReplacement
extends Replacement {
    private Set<String> splitVariables;

    public SplitVariableReplacement(String oldVariable, Set<String> newVariables) {
        super(oldVariable, newVariables.toString(), Replacement.ReplacementType.SPLIT_VARIABLE);
        this.splitVariables = newVariables;
    }

    public Set<String> getSplitVariables() {
        return this.splitVariables;
    }

    public boolean equal(SplitVariableReplacement other) {
        return this.getBefore().equals(other.getBefore()) && this.splitVariables.containsAll(other.splitVariables) && other.splitVariables.containsAll(this.splitVariables);
    }

    public boolean commonBefore(SplitVariableReplacement other) {
        LinkedHashSet<String> interestion = new LinkedHashSet<String>(this.splitVariables);
        interestion.retainAll(other.splitVariables);
        return this.getBefore().equals(other.getBefore()) && interestion.size() == 0;
    }

    public boolean subsumes(SplitVariableReplacement other) {
        return this.getBefore().equals(other.getBefore()) && this.splitVariables.containsAll(other.splitVariables) && this.splitVariables.size() > other.splitVariables.size();
    }
}

