/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import java.util.ArrayList;
import java.util.List;

public class CallTreeNode {
    private VariableDeclarationContainer originalOperation;
    private UMLOperation invokedOperation;
    private AbstractCall invocation;
    private CallTreeNode parent;
    private List<CallTreeNode> children = new ArrayList<CallTreeNode>();

    public CallTreeNode(VariableDeclarationContainer originalOperation, UMLOperation invokedOperation, AbstractCall invocation) {
        this.originalOperation = originalOperation;
        this.invokedOperation = invokedOperation;
        this.invocation = invocation;
    }

    public CallTreeNode(CallTreeNode parent, VariableDeclarationContainer originalOperation, UMLOperation invokedOperation, AbstractCall invocation) {
        this(originalOperation, invokedOperation, invocation);
        this.parent = parent;
    }

    public VariableDeclarationContainer getOriginalOperation() {
        return this.originalOperation;
    }

    public UMLOperation getInvokedOperation() {
        return this.invokedOperation;
    }

    public AbstractCall getInvocation() {
        return this.invocation;
    }

    public void addChild(CallTreeNode node) {
        this.children.add(node);
    }

    public CallTreeNode getParent() {
        return this.parent;
    }

    public List<CallTreeNode> getChildren() {
        return this.children;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
        result = 31 * result + (this.invokedOperation == null ? 0 : this.invokedOperation.hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallTreeNode other = (CallTreeNode)obj;
        if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
            return false;
        }
        if (this.invokedOperation == null ? other.invokedOperation != null : !this.invokedOperation.equals(other.invokedOperation)) {
            return false;
        }
        return !(this.originalOperation == null ? other.originalOperation != null : !this.originalOperation.equals(other.originalOperation));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.invokedOperation);
        sb.append(" called from ");
        sb.append(this.originalOperation);
        return sb.toString();
    }
}

