/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.diff.ExtractClassRefactoring;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;

public class CandidateExtractClassRefactoring
implements Comparable<CandidateExtractClassRefactoring> {
    private UMLClassBaseDiff classDiff;
    private ExtractClassRefactoring refactoring;

    public CandidateExtractClassRefactoring(UMLClassBaseDiff classDiff, ExtractClassRefactoring refactoring) {
        this.classDiff = classDiff;
        this.refactoring = refactoring;
    }

    public boolean innerClassExtract() {
        return this.refactoring.getExtractedClass().getName().startsWith(this.refactoring.getOriginalClass().getName() + ".");
    }

    public boolean subclassExtract() {
        UMLType thisSuperType = this.refactoring.getExtractedClass().getSuperclass();
        return thisSuperType != null && this.classDiff.getNextClassName().endsWith("." + thisSuperType.getClassType());
    }

    public UMLClassBaseDiff getClassDiff() {
        return this.classDiff;
    }

    public ExtractClassRefactoring getRefactoring() {
        return this.refactoring;
    }

    @Override
    public int compareTo(CandidateExtractClassRefactoring o) {
        double sourceFolderDistance2;
        double sourceFolderDistance1 = this.refactoring.getExtractedClass().normalizedSourceFolderDistance(this.classDiff.getNextClass());
        if (sourceFolderDistance1 != (sourceFolderDistance2 = o.refactoring.getExtractedClass().normalizedSourceFolderDistance(o.classDiff.getNextClass()))) {
            return Double.compare(sourceFolderDistance1, sourceFolderDistance2);
        }
        if (this.innerClassExtract()) {
            return -1;
        }
        if (o.innerClassExtract()) {
            return 1;
        }
        if (this.subclassExtract()) {
            return -1;
        }
        if (o.subclassExtract()) {
            return 1;
        }
        return this.classDiff.compareTo(o.classDiff);
    }
}

