/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeAttributeTypeRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private UMLAttribute originalAttribute;
    private UMLAttribute changedTypeAttribute;
    private String classNameBefore;
    private String classNameAfter;
    private Set<AbstractCodeMapping> attributeReferences;
    private Set<Refactoring> relatedRefactorings;

    public ChangeAttributeTypeRefactoring(UMLAttribute originalAttribute, UMLAttribute changedTypeAttribute, Set<AbstractCodeMapping> attributeReferences) {
        this.originalAttribute = originalAttribute;
        this.changedTypeAttribute = changedTypeAttribute;
        this.classNameBefore = originalAttribute.getClassName();
        this.classNameAfter = changedTypeAttribute.getClassName();
        this.attributeReferences = attributeReferences;
        this.relatedRefactorings = new LinkedHashSet<Refactoring>();
    }

    public void addRelatedRefactoring(Refactoring refactoring) {
        this.relatedRefactorings.add(refactoring);
    }

    public Set<Refactoring> getRelatedRefactorings() {
        return this.relatedRefactorings;
    }

    public UMLAttribute getOriginalAttribute() {
        return this.originalAttribute;
    }

    public UMLAttribute getChangedTypeAttribute() {
        return this.changedTypeAttribute;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.attributeReferences;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_ATTRIBUTE_TYPE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        VariableDeclaration changedTypeVariableDeclaration;
        StringBuilder sb = new StringBuilder();
        VariableDeclaration originalVariableDeclaration = this.originalAttribute.getVariableDeclaration();
        boolean qualified = originalVariableDeclaration.equalType(changedTypeVariableDeclaration = this.changedTypeAttribute.getVariableDeclaration()) && !originalVariableDeclaration.equalQualifiedType(changedTypeVariableDeclaration);
        sb.append(this.getName()).append("\t");
        sb.append(qualified ? originalVariableDeclaration.toQualifiedString() : originalVariableDeclaration.toString());
        sb.append(" to ");
        sb.append(qualified ? changedTypeVariableDeclaration.toQualifiedString() : changedTypeVariableDeclaration.toString());
        sb.append(" in class ").append(this.classNameAfter);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedTypeAttribute == null || this.changedTypeAttribute.getVariableDeclaration() == null ? 0 : this.changedTypeAttribute.getVariableDeclaration().hashCode());
        result = 31 * result + (this.classNameAfter == null ? 0 : this.classNameAfter.hashCode());
        result = 31 * result + (this.classNameBefore == null ? 0 : this.classNameBefore.hashCode());
        result = 31 * result + (this.originalAttribute == null || this.originalAttribute.getVariableDeclaration() == null ? 0 : this.originalAttribute.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeAttributeTypeRefactoring other = (ChangeAttributeTypeRefactoring)obj;
        if (this.changedTypeAttribute == null ? other.changedTypeAttribute != null : (this.changedTypeAttribute.getVariableDeclaration() == null ? other.changedTypeAttribute.getVariableDeclaration() != null : !this.changedTypeAttribute.getVariableDeclaration().equals(other.changedTypeAttribute.getVariableDeclaration()))) {
            return false;
        }
        if (this.classNameAfter == null ? other.classNameAfter != null : !this.classNameAfter.equals(other.classNameAfter)) {
            return false;
        }
        if (this.classNameBefore == null ? other.classNameBefore != null : !this.classNameBefore.equals(other.classNameBefore)) {
            return false;
        }
        return !(this.originalAttribute == null ? other.originalAttribute != null : (this.originalAttribute.getVariableDeclaration() == null ? other.originalAttribute.getVariableDeclaration() != null : !this.originalAttribute.getVariableDeclaration().equals(other.originalAttribute.getVariableDeclaration())));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getChangedTypeAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalAttribute.getVariableDeclaration().codeRange().setDescription("original attribute declaration").setCodeElement(this.originalAttribute.getVariableDeclaration().toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.changedTypeAttribute.getVariableDeclaration().codeRange().setDescription("changed-type attribute declaration").setCodeElement(this.changedTypeAttribute.getVariableDeclaration().toString()));
        return ranges;
    }
}

