/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import java.util.Set;

public class CodeRange {
    private String filePath;
    private int startLine;
    private int endLine;
    private int startColumn;
    private int endColumn;
    private LocationInfo.CodeElementType codeElementType;
    private String description;
    private String codeElement;

    public CodeRange(String filePath, int startLine, int endLine, int startColumn, int endColumn, LocationInfo.CodeElementType codeElementType) {
        this.filePath = filePath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.codeElementType = codeElementType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public LocationInfo.CodeElementType getCodeElementType() {
        return this.codeElementType;
    }

    public String getDescription() {
        return this.description;
    }

    public CodeRange setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCodeElement() {
        return this.codeElement;
    }

    public CodeRange setCodeElement(String codeElement) {
        this.codeElement = codeElement;
        return this;
    }

    public boolean subsumes(CodeRange other) {
        return this.filePath.equals(other.filePath) && this.startLine <= other.startLine && this.endLine >= other.endLine;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        this.encodeStringProperty(sb, "filePath", this.filePath, false);
        this.encodeIntProperty(sb, "startLine", this.startLine, false);
        this.encodeIntProperty(sb, "endLine", this.endLine, false);
        this.encodeIntProperty(sb, "startColumn", this.startColumn, false);
        this.encodeIntProperty(sb, "endColumn", this.endColumn, false);
        this.encodeStringProperty(sb, "codeElementType", this.codeElementType.name(), false);
        this.encodeStringProperty(sb, "description", this.description, false);
        this.encodeStringProperty(sb, "codeElement", this.escapeQuotes(this.codeElement), true);
        sb.append("}");
        return sb.toString();
    }

    private String escapeQuotes(String s) {
        if (s != null) {
            StringBuilder sb = new StringBuilder();
            JsonStringEncoder encoder = JsonStringEncoder.getInstance();
            encoder.quoteAsString((CharSequence)s, sb);
            return sb.toString();
        }
        return s;
    }

    private void encodeStringProperty(StringBuilder sb, String propertyName, String value, boolean last) {
        if (value != null) {
            sb.append("\t").append("\t").append("\"" + propertyName + "\": \"" + value + "\"");
        } else {
            sb.append("\t").append("\t").append("\"" + propertyName + "\": " + value);
        }
        this.insertNewLine(sb, last);
    }

    private void encodeIntProperty(StringBuilder sb, String propertyName, int value, boolean last) {
        sb.append("\t").append("\t").append("\"" + propertyName + "\": " + value);
        this.insertNewLine(sb, last);
    }

    private void insertNewLine(StringBuilder sb, boolean last) {
        if (last) {
            sb.append("\n");
        } else {
            sb.append(",").append("\n");
        }
    }

    public static CodeRange computeRange(Set<AbstractCodeFragment> codeFragments) {
        String filePath = null;
        int minStartLine = 0;
        int maxEndLine = 0;
        int startColumn = 0;
        int endColumn = 0;
        for (AbstractCodeFragment fragment : codeFragments) {
            LocationInfo info = fragment.getLocationInfo();
            filePath = info.getFilePath();
            if (minStartLine == 0 || info.getStartLine() < minStartLine) {
                minStartLine = info.getStartLine();
                startColumn = info.getStartColumn();
            }
            if (info.getEndLine() <= maxEndLine) continue;
            maxEndLine = info.getEndLine();
            endColumn = info.getEndColumn();
        }
        return new CodeRange(filePath, minStartLine, maxEndLine, startColumn, endColumn, LocationInfo.CodeElementType.LIST_OF_STATEMENTS);
    }
}

