/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class CollapseHierarchyRefactoring
implements Refactoring {
    private UMLClass collapsedClass;
    private UMLClass superclassAfterCollapse;

    public CollapseHierarchyRefactoring(UMLClass collapsedClass, UMLClass superclassAfterCollapse) {
        this.collapsedClass = collapsedClass;
        this.superclassAfterCollapse = superclassAfterCollapse;
    }

    private UMLClass getCollapsedClass() {
        return this.collapsedClass;
    }

    private UMLClass getSuperclassAfterCollapse() {
        return this.superclassAfterCollapse;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.collapsedClass.codeRange().setDescription("collapsed class").setCodeElement(this.collapsedClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.superclassAfterCollapse.codeRange().setDescription("superclass after collapse").setCodeElement(this.superclassAfterCollapse.getName()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.COLLAPSE_HIERARCHY;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getCollapsedClass().getLocationInfo().getFilePath(), (Object)this.getCollapsedClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSuperclassAfterCollapse().getLocationInfo().getFilePath(), (Object)this.getSuperclassAfterCollapse().getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.collapsedClass);
        sb.append(" to ");
        sb.append(this.superclassAfterCollapse);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collapsedClass == null ? 0 : this.collapsedClass.hashCode());
        result = 31 * result + (this.superclassAfterCollapse == null ? 0 : this.superclassAfterCollapse.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollapseHierarchyRefactoring other = (CollapseHierarchyRefactoring)obj;
        if (this.collapsedClass == null ? other.collapsedClass != null : !this.collapsedClass.equals(other.collapsedClass)) {
            return false;
        }
        return !(this.superclassAfterCollapse == null ? other.superclassAfterCollapse != null : !this.superclassAfterCollapse.equals(other.superclassAfterCollapse));
    }
}

