/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ConvertAnonymousClassToTypeRefactoring
implements Refactoring {
    private UMLAnonymousClass anonymousClass;
    private UMLClass addedClass;

    public ConvertAnonymousClassToTypeRefactoring(UMLAnonymousClass anonymousClass, UMLClass addedClass) {
        this.anonymousClass = anonymousClass;
        this.addedClass = addedClass;
    }

    public UMLAnonymousClass getAnonymousClass() {
        return this.anonymousClass;
    }

    public UMLClass getAddedClass() {
        return this.addedClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.anonymousClass);
        sb.append(" was converted to ");
        sb.append(this.addedClass);
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CONVERT_ANONYMOUS_CLASS_TO_TYPE;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAnonymousClass().getLocationInfo().getFilePath(), (Object)this.getAnonymousClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAddedClass().getLocationInfo().getFilePath(), (Object)this.getAddedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.anonymousClass.codeRange().setDescription("anonymous class declaration").setCodeElement(this.anonymousClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.addedClass.codeRange().setDescription("added type declaration").setCodeElement(this.addedClass.getName()));
        return ranges;
    }
}

