/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ExtractClassRefactoring
implements Refactoring {
    private UMLClass extractedClass;
    private UMLClassBaseDiff classDiff;
    private Map<UMLOperation, UMLOperation> extractedOperations;
    private Map<UMLAttribute, UMLAttribute> extractedAttributes;
    private UMLAttribute attributeOfExtractedClassTypeInOriginalClass;

    public ExtractClassRefactoring(UMLClass extractedClass, UMLClassBaseDiff classDiff, Map<UMLOperation, UMLOperation> extractedOperations, Map<UMLAttribute, UMLAttribute> extractedAttributes, UMLAttribute attributeOfExtractedClassType) {
        this.extractedClass = extractedClass;
        this.classDiff = classDiff;
        this.extractedOperations = extractedOperations;
        this.extractedAttributes = extractedAttributes;
        this.attributeOfExtractedClassTypeInOriginalClass = attributeOfExtractedClassType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.extractedClass);
        sb.append(" from class ");
        sb.append(this.classDiff.getOriginalClass());
        return sb.toString();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.extractedClass.isSubTypeOf(this.classDiff.getOriginalClass()) || this.extractedClass.isSubTypeOf(this.classDiff.getNextClass())) {
            return RefactoringType.EXTRACT_SUBCLASS;
        }
        return RefactoringType.EXTRACT_CLASS;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLClass getExtractedClass() {
        return this.extractedClass;
    }

    public UMLClass getOriginalClass() {
        return this.classDiff.getOriginalClass();
    }

    public Map<UMLOperation, UMLOperation> getExtractedOperations() {
        return this.extractedOperations;
    }

    public Map<UMLAttribute, UMLAttribute> getExtractedAttributes() {
        return this.extractedAttributes;
    }

    public UMLAttribute getAttributeOfExtractedClassTypeInOriginalClass() {
        return this.attributeOfExtractedClassTypeInOriginalClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.classDiff.getNextClass().getLocationInfo().getFilePath(), (Object)this.classDiff.getNextClass().getName()));
        pairs.add(new ImmutablePair((Object)this.getExtractedClass().getLocationInfo().getFilePath(), (Object)this.getExtractedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classDiff.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(this.classDiff.getOriginalClass().getName()));
        for (UMLOperation extractedOperation : this.extractedOperations.keySet()) {
            ranges.add(extractedOperation.codeRange().setDescription("original method declaration").setCodeElement(extractedOperation.toString()));
        }
        for (UMLAttribute extractedAttribute : this.extractedAttributes.keySet()) {
            ranges.add(extractedAttribute.codeRange().setDescription("original attribute declaration").setCodeElement(extractedAttribute.toString()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classDiff.getNextClass().codeRange().setDescription("type declaration after extraction").setCodeElement(this.classDiff.getNextClass().getName()));
        ranges.add(this.extractedClass.codeRange().setDescription("extracted type declaration").setCodeElement(this.extractedClass.getName()));
        for (UMLOperation extractedOperation : this.extractedOperations.values()) {
            ranges.add(extractedOperation.codeRange().setDescription("extracted method declaration").setCodeElement(extractedOperation.toString()));
        }
        for (UMLAttribute extractedAttribute : this.extractedAttributes.values()) {
            ranges.add(extractedAttribute.codeRange().setDescription("extracted attribute declaration").setCodeElement(extractedAttribute.toString()));
        }
        return ranges;
    }
}

