/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ExtractOperationRefactoring
implements Refactoring {
    private UMLOperation extractedOperation;
    private VariableDeclarationContainer sourceOperationBeforeExtraction;
    private VariableDeclarationContainer sourceOperationAfterExtraction;
    private List<AbstractCall> extractedOperationInvocations;
    private Set<Replacement> replacements;
    private Set<AbstractCodeFragment> extractedCodeFragmentsFromSourceOperation;
    private Set<AbstractCodeFragment> extractedCodeFragmentsToExtractedOperation;
    private UMLOperationBodyMapper bodyMapper;

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, VariableDeclarationContainer sourceOperationAfterExtraction, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = bodyMapper.getOperation2();
        this.sourceOperationBeforeExtraction = bodyMapper.getContainer1();
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, UMLOperation extractedOperation, VariableDeclarationContainer sourceOperationBeforeExtraction, VariableDeclarationContainer sourceOperationAfterExtraction, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = extractedOperation;
        this.sourceOperationBeforeExtraction = sourceOperationBeforeExtraction;
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    public void updateMapperInfo() {
        this.replacements = this.bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation.clear();
        this.extractedCodeFragmentsToExtractedOperation.clear();
        for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.extractedOperation);
        sb.append(" extracted from ");
        sb.append(this.sourceOperationBeforeExtraction);
        sb.append(" in class ");
        sb.append(this.getClassName());
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            sb.append(" & moved to class ");
            sb.append(this.extractedOperation.getClassName());
        }
        return sb.toString();
    }

    private String getClassName() {
        String targetClassName;
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            return this.getSourceOperationBeforeExtraction().getClassName();
        }
        String sourceClassName = this.getSourceOperationBeforeExtraction().getClassName();
        return sourceClassName.equals(targetClassName = this.getSourceOperationAfterExtraction().getClassName()) ? sourceClassName : targetClassName;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getExtractedOperation() {
        return this.extractedOperation;
    }

    public VariableDeclarationContainer getSourceOperationBeforeExtraction() {
        return this.sourceOperationBeforeExtraction;
    }

    public VariableDeclarationContainer getSourceOperationAfterExtraction() {
        return this.sourceOperationAfterExtraction;
    }

    public List<AbstractCall> getExtractedOperationInvocations() {
        return this.extractedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsFromSourceOperation() {
        return this.extractedCodeFragmentsFromSourceOperation;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsToExtractedOperation() {
        return this.extractedCodeFragmentsToExtractedOperation;
    }

    public CodeRange getSourceOperationCodeRangeBeforeExtraction() {
        return this.sourceOperationBeforeExtraction.codeRange();
    }

    public CodeRange getSourceOperationCodeRangeAfterExtraction() {
        return this.sourceOperationAfterExtraction.codeRange();
    }

    public CodeRange getExtractedOperationCodeRange() {
        return this.extractedOperation.codeRange();
    }

    public CodeRange getExtractedCodeRangeFromSourceOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsFromSourceOperation);
    }

    public CodeRange getExtractedCodeRangeToExtractedOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsToExtractedOperation);
    }

    public Set<CodeRange> getExtractedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (AbstractCall invocation : this.extractedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getSourceOperationAfterExtraction().getClassName().equals(this.getExtractedOperation().getClassName())) {
            return RefactoringType.EXTRACT_AND_MOVE_OPERATION;
        }
        return RefactoringType.EXTRACT_OPERATION;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationBeforeExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationBeforeExtraction().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationAfterExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationAfterExtraction().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getExtractedOperation().getLocationInfo().getFilePath(), (Object)this.getExtractedOperation().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getSourceOperationCodeRangeBeforeExtraction().setDescription("source method declaration before extraction").setCodeElement(this.sourceOperationBeforeExtraction.toString()));
        for (AbstractCodeFragment extractedCodeFragment : this.extractedCodeFragmentsFromSourceOperation) {
            ranges.add(extractedCodeFragment.codeRange().setDescription("extracted code from source method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getExtractedOperationCodeRange().setDescription("extracted method declaration").setCodeElement(this.extractedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.extractedCodeFragmentsToExtractedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("extracted code to extracted method declaration"));
        }
        ranges.add(this.getSourceOperationCodeRangeAfterExtraction().setDescription("source method declaration after extraction").setCodeElement(this.sourceOperationAfterExtraction.toString()));
        for (AbstractCall abstractCall : this.extractedOperationInvocations) {
            ranges.add(abstractCall.codeRange().setDescription("extracted method invocation").setCodeElement(abstractCall.actualString()));
        }
        for (AbstractCodeFragment abstractCodeFragment : this.bodyMapper.getNonMappedLeavesT2()) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("added statement in extracted method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT2()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("added statement in extracted method declaration"));
        }
        return ranges;
    }
}

