/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ExtractSuperclassRefactoring
implements Refactoring {
    private UMLClass extractedClass;
    private Set<UMLClass> subclassSetBefore;
    private Set<UMLClass> subclassSetAfter;

    public ExtractSuperclassRefactoring(UMLClass extractedClass, Set<UMLClass> subclassSetBefore, Set<UMLClass> subclassSetAfter) {
        this.extractedClass = extractedClass;
        this.subclassSetBefore = subclassSetBefore;
        this.subclassSetAfter = subclassSetAfter;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.extractedClass);
        sb.append(" from classes ");
        sb.append(this.subclassSetBefore);
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.extractedClass.isInterface()) {
            return RefactoringType.EXTRACT_INTERFACE;
        }
        return RefactoringType.EXTRACT_SUPERCLASS;
    }

    public UMLClass getExtractedClass() {
        return this.extractedClass;
    }

    public Set<String> getSubclassSetBefore() {
        LinkedHashSet<String> subclassSet = new LinkedHashSet<String>();
        for (UMLClass umlClass : this.subclassSetBefore) {
            subclassSet.add(umlClass.getName());
        }
        return subclassSet;
    }

    public Set<UMLClass> getUMLSubclassSetBefore() {
        return new LinkedHashSet<UMLClass>(this.subclassSetBefore);
    }

    public Set<String> getSubclassSetAfter() {
        LinkedHashSet<String> subclassSet = new LinkedHashSet<String>();
        for (UMLClass umlClass : this.subclassSetAfter) {
            subclassSet.add(umlClass.getName());
        }
        return subclassSet;
    }

    public Set<UMLClass> getUMLSubclassSetAfter() {
        return new LinkedHashSet<UMLClass>(this.subclassSetAfter);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLClass umlClass : this.subclassSetBefore) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)umlClass.getLocationInfo().getFilePath(), (Object)umlClass.getName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLClass umlClass : this.subclassSetAfter) {
            pairs.add(new ImmutablePair((Object)umlClass.getLocationInfo().getFilePath(), (Object)umlClass.getName()));
        }
        pairs.add(new ImmutablePair((Object)this.getExtractedClass().getLocationInfo().getFilePath(), (Object)this.getExtractedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLClass subclass : this.subclassSetBefore) {
            ranges.add(subclass.codeRange().setDescription("original sub-type declaration").setCodeElement(subclass.getName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLClass subclass : this.subclassSetAfter) {
            ranges.add(subclass.codeRange().setDescription("sub-type declaration after extraction").setCodeElement(subclass.getName()));
        }
        ranges.add(this.extractedClass.codeRange().setDescription("extracted super-type declaration").setCodeElement(this.extractedClass.getName()));
        return ranges;
    }
}

