/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CallTree;
import gr.uom.java.xmi.diff.CallTreeNode;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class InlineOperationDetection {
    private UMLOperationBodyMapper mapper;
    private List<UMLOperation> removedOperations;
    private UMLAbstractClassDiff classDiff;
    private UMLModelDiff modelDiff;
    private List<AbstractCall> operationInvocations;
    private Map<CallTreeNode, CallTree> callTreeMap = new LinkedHashMap<CallTreeNode, CallTree>();

    public InlineOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> removedOperations, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        this.mapper = mapper;
        this.removedOperations = removedOperations;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        this.operationInvocations = this.getInvocationsInTargetOperationBeforeInline(mapper);
    }

    public List<InlineOperationRefactoring> check(UMLOperation removedOperation) throws RefactoringMinerTimedOutException {
        List<AbstractCall> removedOperationInvocations;
        ArrayList<InlineOperationRefactoring> refactorings = new ArrayList<InlineOperationRefactoring>();
        if (!(this.mapper.getNonMappedLeavesT2().isEmpty() && this.mapper.getNonMappedInnerNodesT2().isEmpty() && this.mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || (removedOperationInvocations = this.matchingInvocations(removedOperation, this.operationInvocations, this.mapper.getContainer1())).size() <= 0 || this.invocationMatchesWithAddedOperation(removedOperationInvocations.get(0), this.mapper.getContainer1(), this.mapper.getContainer2().getAllOperationInvocations()))) {
            AbstractCall removedOperationInvocation = removedOperationInvocations.get(0);
            CallTreeNode root = new CallTreeNode(this.mapper.getContainer1(), removedOperation, removedOperationInvocation);
            CallTree callTree = null;
            if (this.callTreeMap.containsKey(root)) {
                callTree = this.callTreeMap.get(root);
            } else {
                callTree = new CallTree(root);
                this.generateCallTree(removedOperation, root, callTree);
                this.callTreeMap.put(root, callTree);
            }
            UMLOperationBodyMapper operationBodyMapper = this.createMapperForInlinedMethod(this.mapper, removedOperation, removedOperationInvocation);
            List<CallTreeNode> nodesInBreadthFirstOrder = callTree.getNodesInBreadthFirstOrder();
            for (int i = 1; i < nodesInBreadthFirstOrder.size(); ++i) {
                UMLOperationBodyMapper nestedMapper;
                CallTreeNode node = nodesInBreadthFirstOrder.get(i);
                if (this.matchingInvocations(node.getInvokedOperation(), this.operationInvocations, this.mapper.getContainer1()).size() != 0 || !this.inlineMatchCondition(nestedMapper = this.createMapperForInlinedMethod(this.mapper, node.getInvokedOperation(), node.getInvocation()), this.mapper)) continue;
                List<AbstractCall> nestedMatchingInvocations = this.matchingInvocations(node.getInvokedOperation(), node.getOriginalOperation().getAllOperationInvocations(), node.getOriginalOperation());
                InlineOperationRefactoring nestedRefactoring = new InlineOperationRefactoring(nestedMapper, this.mapper.getContainer1(), nestedMatchingInvocations);
                refactorings.add(nestedRefactoring);
                operationBodyMapper.addChildMapper(nestedMapper);
            }
            if (this.inlineMatchCondition(operationBodyMapper, this.mapper)) {
                InlineOperationRefactoring inlineOperationRefactoring = new InlineOperationRefactoring(operationBodyMapper, this.mapper.getContainer1(), removedOperationInvocations);
                refactorings.add(inlineOperationRefactoring);
            }
        }
        return refactorings;
    }

    private List<AbstractCall> matchingInvocations(UMLOperation removedOperation, List<AbstractCall> operationInvocations, VariableDeclarationContainer callerOperation) {
        ArrayList<AbstractCall> removedOperationInvocations = new ArrayList<AbstractCall>();
        for (AbstractCall invocation : operationInvocations) {
            if (!invocation.matchesOperation(removedOperation, callerOperation, this.modelDiff)) continue;
            removedOperationInvocations.add(invocation);
        }
        return removedOperationInvocations;
    }

    private UMLOperationBodyMapper createMapperForInlinedMethod(UMLOperationBodyMapper mapper, UMLOperation removedOperation, AbstractCall removedOperationInvocation) throws RefactoringMinerTimedOutException {
        List<String> arguments = removedOperationInvocation.getArguments();
        List<String> parameters = removedOperation.getParameterNameList();
        LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
        int size = Math.min(arguments.size(), parameters.size());
        for (int i = 0; i < size; ++i) {
            parameterToArgumentMap.put(parameters.get(i), arguments.get(i));
        }
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, mapper, parameterToArgumentMap, new LinkedHashMap<String, String>(), this.classDiff);
        return operationBodyMapper;
    }

    private void generateCallTree(UMLOperation operation, CallTreeNode parent, CallTree callTree) {
        List<AbstractCall> invocations = operation.getAllOperationInvocations();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (AbstractCall invocation : invocations) {
                if (!invocation.matchesOperation(removedOperation, operation, this.modelDiff) || callTree.containsInPathToRootOrSibling(parent, removedOperation)) continue;
                CallTreeNode node = new CallTreeNode(parent, operation, removedOperation, invocation);
                parent.addChild(node);
                this.generateCallTree(removedOperation, node, callTree);
            }
        }
    }

    private List<AbstractCall> getInvocationsInTargetOperationBeforeInline(UMLOperationBodyMapper mapper) {
        List<AbstractCall> operationInvocations = mapper.getContainer1().getAllOperationInvocations();
        for (AbstractCodeFragment statement : mapper.getNonMappedLeavesT1()) {
            ExtractOperationDetection.addStatementInvocations(operationInvocations, statement);
            if (this.classDiff == null) continue;
            for (UMLAnonymousClass anonymousClass : this.classDiff.getRemovedAnonymousClasses()) {
                if (!statement.getLocationInfo().subsumes(anonymousClass.getLocationInfo())) continue;
                for (UMLOperation anonymousOperation : anonymousClass.getOperations()) {
                    for (AbstractCall anonymousInvocation : anonymousOperation.getAllOperationInvocations()) {
                        if (ExtractOperationDetection.containsInvocation(operationInvocations, anonymousInvocation)) continue;
                        operationInvocations.add(anonymousInvocation);
                    }
                }
            }
        }
        return operationInvocations;
    }

    private boolean inlineMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper) {
        int delegateStatements = 0;
        for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT1()) {
            AbstractCall invocation = statement.invocationCoveringEntireFragment();
            if (invocation == null || !invocation.matchesOperation(operationBodyMapper.getContainer1(), parentMapper.getContainer1(), this.modelDiff)) continue;
            ++delegateStatements;
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - delegateStatements;
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        List<AbstractCodeMapping> exactMatchListWithoutMatchesInNestedContainers = operationBodyMapper.getExactMatchesWithoutMatchesInNestedContainers();
        int exactMatches = exactMatchList.size();
        int exactMatchesWithoutMatchesInNestedContainers = exactMatchListWithoutMatchesInNestedContainers.size();
        return mappings > 0 && (mappings > nonMappedElementsT1 || exactMatchesWithoutMatchesInNestedContainers == 1 && !exactMatchListWithoutMatchesInNestedContainers.get(0).getFragment1().throwsNewException() && nonMappedElementsT1 - exactMatchesWithoutMatchesInNestedContainers < 10 || exactMatches > 1 && nonMappedElementsT1 - exactMatches < 20);
    }

    private boolean invocationMatchesWithAddedOperation(AbstractCall removedOperationInvocation, VariableDeclarationContainer callerOperation, List<AbstractCall> operationInvocationsInNewMethod) {
        if (operationInvocationsInNewMethod.contains(removedOperationInvocation) && this.classDiff != null) {
            for (UMLOperation addedOperation : this.classDiff.getAddedOperations()) {
                if (!removedOperationInvocation.matchesOperation(addedOperation, callerOperation, this.modelDiff)) continue;
                return true;
            }
        }
        return false;
    }
}

