/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class InlineOperationRefactoring
implements Refactoring {
    private UMLOperation inlinedOperation;
    private VariableDeclarationContainer targetOperationAfterInline;
    private VariableDeclarationContainer targetOperationBeforeInline;
    private List<AbstractCall> inlinedOperationInvocations;
    private Set<Replacement> replacements;
    private Set<AbstractCodeFragment> inlinedCodeFragmentsFromInlinedOperation;
    private Set<AbstractCodeFragment> inlinedCodeFragmentsInTargetOperation;
    private UMLOperationBodyMapper bodyMapper;

    public InlineOperationRefactoring(UMLOperationBodyMapper bodyMapper, VariableDeclarationContainer targetOperationBeforeInline, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.inlinedOperation = bodyMapper.getOperation1();
        this.targetOperationAfterInline = bodyMapper.getContainer2();
        this.targetOperationBeforeInline = targetOperationBeforeInline;
        this.inlinedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.inlinedCodeFragmentsFromInlinedOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.inlinedCodeFragmentsInTargetOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.inlinedCodeFragmentsFromInlinedOperation.add(mapping.getFragment1());
            this.inlinedCodeFragmentsInTargetOperation.add(mapping.getFragment2());
        }
    }

    public void updateMapperInfo() {
        this.replacements = this.bodyMapper.getReplacements();
        this.inlinedCodeFragmentsFromInlinedOperation.clear();
        this.inlinedCodeFragmentsInTargetOperation.clear();
        for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
            this.inlinedCodeFragmentsFromInlinedOperation.add(mapping.getFragment1());
            this.inlinedCodeFragmentsInTargetOperation.add(mapping.getFragment2());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.inlinedOperation);
        if (this.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION)) {
            sb.append(" inlined to ");
            sb.append(this.targetOperationAfterInline);
            sb.append(" in class ");
            sb.append(this.getClassName());
        } else if (this.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION)) {
            sb.append(" moved from class ");
            sb.append(this.inlinedOperation.getClassName());
            sb.append(" to class ");
            sb.append(this.getTargetOperationAfterInline().getClassName());
            sb.append(" & inlined to ");
            sb.append(this.getTargetOperationAfterInline());
        }
        return sb.toString();
    }

    private String getClassName() {
        return this.targetOperationAfterInline.getClassName();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getTargetOperationBeforeInline().getClassName().equals(this.getInlinedOperation().getClassName())) {
            return RefactoringType.MOVE_AND_INLINE_OPERATION;
        }
        return RefactoringType.INLINE_OPERATION;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getInlinedOperation() {
        return this.inlinedOperation;
    }

    public VariableDeclarationContainer getTargetOperationAfterInline() {
        return this.targetOperationAfterInline;
    }

    public VariableDeclarationContainer getTargetOperationBeforeInline() {
        return this.targetOperationBeforeInline;
    }

    public List<AbstractCall> getInlinedOperationInvocations() {
        return this.inlinedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public Set<AbstractCodeFragment> getInlinedCodeFragments() {
        return this.inlinedCodeFragmentsInTargetOperation;
    }

    public CodeRange getTargetOperationCodeRangeBeforeInline() {
        return this.targetOperationBeforeInline.codeRange();
    }

    public CodeRange getTargetOperationCodeRangeAfterInline() {
        return this.targetOperationAfterInline.codeRange();
    }

    public CodeRange getInlinedOperationCodeRange() {
        return this.inlinedOperation.codeRange();
    }

    public CodeRange getInlinedCodeRangeFromInlinedOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsFromInlinedOperation);
    }

    public CodeRange getInlinedCodeRangeInTargetOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsInTargetOperation);
    }

    public Set<CodeRange> getInlinedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (AbstractCall invocation : this.inlinedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getInlinedOperation().getLocationInfo().getFilePath(), (Object)this.getInlinedOperation().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getTargetOperationBeforeInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationBeforeInline().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getTargetOperationAfterInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationAfterInline().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getInlinedOperationCodeRange().setDescription("inlined method declaration").setCodeElement(this.inlinedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.inlinedCodeFragmentsFromInlinedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("inlined code from inlined method declaration"));
        }
        ranges.add(this.getTargetOperationCodeRangeBeforeInline().setDescription("target method declaration before inline").setCodeElement(this.targetOperationBeforeInline.toString()));
        for (AbstractCall abstractCall : this.inlinedOperationInvocations) {
            ranges.add(abstractCall.codeRange().setDescription("inlined method invocation").setCodeElement(abstractCall.actualString()));
        }
        for (AbstractCodeFragment abstractCodeFragment : this.bodyMapper.getNonMappedLeavesT1()) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT1()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getTargetOperationCodeRangeAfterInline().setDescription("target method declaration after inline").setCodeElement(this.targetOperationAfterInline.toString()));
        for (AbstractCodeFragment inlinedCodeFragment : this.inlinedCodeFragmentsInTargetOperation) {
            ranges.add(inlinedCodeFragment.codeRange().setDescription("inlined code in target method declaration"));
        }
        return ranges;
    }
}

