/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class InlineVariableRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private VariableDeclaration variableDeclaration;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private Set<AbstractCodeMapping> references;
    private boolean insideExtractedOrInlinedMethod;

    public InlineVariableRefactoring(VariableDeclaration variableDeclaration, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, boolean insideExtractedOrInlinedMethod) {
        this.variableDeclaration = variableDeclaration;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.references = new LinkedHashSet<AbstractCodeMapping>();
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public void addReference(AbstractCodeMapping mapping) {
        this.references.add(mapping);
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.INLINE_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.references;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.variableDeclaration);
        String elementType = this.operationBefore.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationBefore);
        sb.append(" from class ");
        sb.append(this.operationBefore.getClassName());
        return sb.toString();
    }

    public CodeRange getInlinedVariableDeclarationCodeRange() {
        return this.variableDeclaration.codeRange();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.variableDeclaration == null ? 0 : this.variableDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlineVariableRefactoring other = (InlineVariableRefactoring)obj;
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.variableDeclaration == null ? other.variableDeclaration != null : !this.variableDeclaration.equals(other.variableDeclaration));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.variableDeclaration.codeRange().setDescription("inlined variable declaration").setCodeElement(this.variableDeclaration.toString()));
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment1().codeRange().setDescription("statement with the name of the inlined variable"));
        }
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment2().codeRange().setDescription("statement with the initializer of the inlined variable"));
        }
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with inlined variable").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

