/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import gr.uom.java.xmi.diff.UMLClassMergeDiff;
import gr.uom.java.xmi.diff.UMLClassRenameDiff;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.PrefixSuffixUtils;

public class MergeClassRefactoring
implements PackageLevelRefactoring {
    private Set<UMLClass> mergedClasses = new LinkedHashSet<UMLClass>();
    private UMLClass newClass;

    public MergeClassRefactoring(UMLClassMergeDiff mergeDiff) {
        for (UMLClassRenameDiff renameDiff : mergeDiff.getClassRenameDiffs()) {
            if (this.newClass == null) {
                this.newClass = renameDiff.getRenamedClass();
            }
            this.mergedClasses.add(renameDiff.getOriginalClass());
        }
    }

    public Set<UMLClass> getMergedClasses() {
        return this.mergedClasses;
    }

    public UMLClass getNewClass() {
        return this.newClass;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLClass mergedClass : this.mergedClasses) {
            ranges.add(mergedClass.codeRange().setDescription("original type declaration").setCodeElement(mergedClass.getName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newClass.codeRange().setDescription("new type declaration").setCodeElement(this.newClass.getName()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MERGE_CLASS;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLClass mergedClass : this.mergedClasses) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)mergedClass.getLocationInfo().getFilePath(), (Object)mergedClass.getName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.newClass.getLocationInfo().getFilePath(), (Object)this.newClass.getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.mergedClasses);
        sb.append(" merged to ");
        sb.append(this.newClass);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mergedClasses == null ? 0 : this.mergedClasses.hashCode());
        result = 31 * result + (this.newClass == null ? 0 : this.newClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeClassRefactoring other = (MergeClassRefactoring)obj;
        if (this.mergedClasses == null ? other.mergedClasses != null : !this.mergedClasses.equals(other.mergedClasses)) {
            return false;
        }
        return !(this.newClass == null ? other.newClass != null : !this.newClass.equals(other.newClass));
    }

    @Override
    public RenamePattern getRenamePattern() {
        UMLClass renamedClass = this.newClass;
        UMLClass originalClass = this.mergedClasses.iterator().next();
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('.', originalClass.getPackageName(), renamedClass.getPackageName());
        if (separatorPos == -1) {
            return new RenamePattern(originalClass.getPackageName(), renamedClass.getPackageName());
        }
        String originalPath = originalClass.getName().substring(0, originalClass.getName().length() - separatorPos);
        String movedPath = renamedClass.getName().substring(0, renamedClass.getName().length() - separatorPos);
        return new RenamePattern(originalPath, movedPath);
    }

    @Override
    public UMLClass getOriginalClass() {
        return this.mergedClasses.iterator().next();
    }

    @Override
    public UMLClass getMovedClass() {
        return this.newClass;
    }

    @Override
    public String getOriginalClassName() {
        return this.mergedClasses.iterator().next().getName();
    }

    @Override
    public String getMovedClassName() {
        return this.newClass.getName();
    }
}

