/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePackageRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MergePackageRefactoring
implements Refactoring {
    private Set<String> mergedPackages;
    private String newPackage;
    private Set<RenamePackageRefactoring> renamePackageRefactorings;

    public MergePackageRefactoring(Set<RenamePackageRefactoring> renamePackageRefactorings) {
        this.renamePackageRefactorings = renamePackageRefactorings;
        this.mergedPackages = new TreeSet<String>();
        for (RenamePackageRefactoring refactoring : renamePackageRefactorings) {
            RenamePattern pattern = refactoring.getPattern();
            if (this.newPackage == null) {
                this.newPackage = pattern.getAfter();
            }
            this.mergedPackages.add(pattern.getBefore());
        }
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                ranges.add(ref.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(ref.getOriginalClass().getName()));
            }
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                ranges.add(ref.getMovedClass().codeRange().setDescription("moved type declaration").setCodeElement(ref.getMovedClass().getName()));
            }
        }
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MERGE_PACKAGE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getOriginalClass().getLocationInfo().getFilePath(), (Object)ref.getOriginalClassName()));
            }
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getMovedClass().getLocationInfo().getFilePath(), (Object)ref.getMovedClassName()));
            }
        }
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        LinkedHashSet<String> mergedPaths = new LinkedHashSet<String>();
        for (String mergePackage : this.mergedPackages) {
            String mergePath = mergePackage.endsWith(".") ? mergePackage.substring(0, mergePackage.length() - 1) : mergePackage;
            mergedPaths.add(mergePath);
        }
        sb.append(mergedPaths);
        sb.append(" to ");
        String newPath = this.newPackage.endsWith(".") ? this.newPackage.substring(0, this.newPackage.length() - 1) : this.newPackage;
        sb.append(newPath);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mergedPackages == null ? 0 : this.mergedPackages.hashCode());
        result = 31 * result + (this.newPackage == null ? 0 : this.newPackage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergePackageRefactoring other = (MergePackageRefactoring)obj;
        if (this.mergedPackages == null ? other.mergedPackages != null : !this.mergedPackages.equals(other.mergedPackages)) {
            return false;
        }
        return !(this.newPackage == null ? other.newPackage != null : !this.newPackage.equals(other.newPackage));
    }
}

