/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MergeVariableRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private Set<VariableDeclaration> mergedVariables;
    private VariableDeclaration newVariable;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private Set<AbstractCodeMapping> variableReferences;
    private boolean insideExtractedOrInlinedMethod;

    public MergeVariableRefactoring(Set<VariableDeclaration> mergedVariables, VariableDeclaration newVariable, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, Set<AbstractCodeMapping> variableReferences, boolean insideExtractedOrInlinedMethod) {
        this.mergedVariables = mergedVariables;
        this.newVariable = newVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public Set<VariableDeclaration> getMergedVariables() {
        return this.mergedVariables;
    }

    public VariableDeclaration getNewVariable() {
        return this.newVariable;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.variableReferences;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    private boolean allVariablesAreParameters() {
        for (VariableDeclaration declaration : this.mergedVariables) {
            if (declaration.isParameter()) continue;
            return false;
        }
        return this.newVariable.isParameter();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.allVariablesAreParameters()) {
            return RefactoringType.MERGE_PARAMETER;
        }
        return RefactoringType.MERGE_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.mergedVariables);
        sb.append(" to ");
        sb.append(this.newVariable);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mergedVariables == null ? 0 : this.mergedVariables.hashCode());
        result = 31 * result + (this.newVariable == null ? 0 : this.newVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeVariableRefactoring other = (MergeVariableRefactoring)obj;
        if (this.mergedVariables == null ? other.mergedVariables != null : !this.mergedVariables.equals(other.mergedVariables)) {
            return false;
        }
        if (this.newVariable == null ? other.newVariable != null : !this.newVariable.equals(other.newVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        return !(this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore));
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration mergedVariable : this.mergedVariables) {
            ranges.add(mergedVariable.codeRange().setDescription("merged variable declaration").setCodeElement(mergedVariable.toString()));
        }
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newVariable.codeRange().setDescription("new variable declaration").setCodeElement(this.newVariable.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with merged variables").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

