/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ModifyAttributeAnnotationRefactoring
implements Refactoring {
    private UMLAnnotation annotationBefore;
    private UMLAnnotation annotationAfter;
    private UMLAttribute attributeBefore;
    private UMLAttribute attributeAfter;

    public ModifyAttributeAnnotationRefactoring(UMLAnnotation annotationBefore, UMLAnnotation annotationAfter, UMLAttribute attributeBefore, UMLAttribute attributeAfter) {
        this.annotationBefore = annotationBefore;
        this.annotationAfter = annotationAfter;
        this.attributeBefore = attributeBefore;
        this.attributeAfter = attributeAfter;
    }

    public UMLAnnotation getAnnotationBefore() {
        return this.annotationBefore;
    }

    public UMLAnnotation getAnnotationAfter() {
        return this.annotationAfter;
    }

    public UMLAttribute getAttributeBefore() {
        return this.attributeBefore;
    }

    public UMLAttribute getAttributeAfter() {
        return this.attributeAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationBefore.codeRange().setDescription("original annotation").setCodeElement(this.annotationBefore.toString()));
        ranges.add(this.attributeBefore.codeRange().setDescription("original attribute declaration").setCodeElement(this.attributeBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationAfter.codeRange().setDescription("modified annotation").setCodeElement(this.annotationAfter.toString()));
        ranges.add(this.attributeAfter.codeRange().setDescription("attribute declaration with modified annotation").setCodeElement(this.attributeAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MODIFY_ATTRIBUTE_ANNOTATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAttributeBefore().getLocationInfo().getFilePath(), (Object)this.getAttributeBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAttributeAfter().getLocationInfo().getFilePath(), (Object)this.getAttributeAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.annotationBefore);
        sb.append(" to ");
        sb.append(this.annotationAfter);
        if (this.attributeAfter instanceof UMLEnumConstant) {
            sb.append(" in enum constant ");
        } else {
            sb.append(" in attribute ");
        }
        sb.append(this.attributeAfter);
        sb.append(" from class ");
        sb.append(this.attributeAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationAfter == null ? 0 : this.annotationAfter.hashCode());
        result = 31 * result + (this.annotationBefore == null ? 0 : this.annotationBefore.hashCode());
        result = 31 * result + (this.attributeAfter == null || this.attributeAfter.getVariableDeclaration() == null ? 0 : this.attributeAfter.getVariableDeclaration().hashCode());
        result = 31 * result + (this.attributeBefore == null || this.attributeBefore.getVariableDeclaration() == null ? 0 : this.attributeBefore.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyAttributeAnnotationRefactoring other = (ModifyAttributeAnnotationRefactoring)obj;
        if (this.annotationAfter == null ? other.annotationAfter != null : !this.annotationAfter.equals(other.annotationAfter)) {
            return false;
        }
        if (this.annotationBefore == null ? other.annotationBefore != null : !this.annotationBefore.equals(other.annotationBefore)) {
            return false;
        }
        if (this.attributeBefore == null ? other.attributeBefore != null : (this.attributeBefore.getVariableDeclaration() == null ? other.attributeBefore.getVariableDeclaration() != null : !this.attributeBefore.getVariableDeclaration().equals(other.attributeBefore.getVariableDeclaration()))) {
            return false;
        }
        return !(this.attributeAfter == null ? other.attributeAfter != null : (this.attributeAfter.getVariableDeclaration() == null ? other.attributeAfter.getVariableDeclaration() != null : !this.attributeAfter.getVariableDeclaration().equals(other.attributeAfter.getVariableDeclaration())));
    }
}

