/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ModifyClassAnnotationRefactoring
implements Refactoring {
    private UMLAnnotation annotationBefore;
    private UMLAnnotation annotationAfter;
    private UMLAbstractClass classBefore;
    private UMLAbstractClass classAfter;

    public ModifyClassAnnotationRefactoring(UMLAnnotation annotationBefore, UMLAnnotation annotationAfter, UMLAbstractClass classBefore, UMLAbstractClass classAfter) {
        this.annotationBefore = annotationBefore;
        this.annotationAfter = annotationAfter;
        this.classBefore = classBefore;
        this.classAfter = classAfter;
    }

    public UMLAnnotation getAnnotationBefore() {
        return this.annotationBefore;
    }

    public UMLAnnotation getAnnotationAfter() {
        return this.annotationAfter;
    }

    public UMLAbstractClass getClassBefore() {
        return this.classBefore;
    }

    public UMLAbstractClass getClassAfter() {
        return this.classAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationBefore.codeRange().setDescription("original annotation").setCodeElement(this.annotationBefore.toString()));
        ranges.add(this.classBefore.codeRange().setDescription("original class declaration").setCodeElement(this.classBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationAfter.codeRange().setDescription("modified annotation").setCodeElement(this.annotationAfter.toString()));
        ranges.add(this.classAfter.codeRange().setDescription("class declaration with modified annotation").setCodeElement(this.classAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MODIFY_CLASS_ANNOTATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassBefore().getLocationInfo().getFilePath(), (Object)this.getClassBefore().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassAfter().getLocationInfo().getFilePath(), (Object)this.getClassAfter().getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.annotationBefore);
        sb.append(" to ");
        sb.append(this.annotationAfter);
        sb.append(" in class ");
        sb.append(this.classAfter.getName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationAfter == null ? 0 : this.annotationAfter.hashCode());
        result = 31 * result + (this.annotationBefore == null ? 0 : this.annotationBefore.hashCode());
        result = 31 * result + (this.classAfter == null ? 0 : this.classAfter.hashCode());
        result = 31 * result + (this.classBefore == null ? 0 : this.classBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyClassAnnotationRefactoring other = (ModifyClassAnnotationRefactoring)obj;
        if (this.annotationAfter == null ? other.annotationAfter != null : !this.annotationAfter.equals(other.annotationAfter)) {
            return false;
        }
        if (this.annotationBefore == null ? other.annotationBefore != null : !this.annotationBefore.equals(other.annotationBefore)) {
            return false;
        }
        if (this.classAfter == null ? other.classAfter != null : !this.classAfter.equals(other.classAfter)) {
            return false;
        }
        return !(this.classBefore == null ? other.classBefore != null : !this.classBefore.equals(other.classBefore));
    }
}

