/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ModifyMethodAnnotationRefactoring
implements Refactoring {
    private UMLAnnotation annotationBefore;
    private UMLAnnotation annotationAfter;
    private UMLOperation operationBefore;
    private UMLOperation operationAfter;

    public ModifyMethodAnnotationRefactoring(UMLAnnotation annotationBefore, UMLAnnotation annotationAfter, UMLOperation operationBefore, UMLOperation operationAfter) {
        this.annotationBefore = annotationBefore;
        this.annotationAfter = annotationAfter;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public UMLAnnotation getAnnotationBefore() {
        return this.annotationBefore;
    }

    public UMLAnnotation getAnnotationAfter() {
        return this.annotationAfter;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationBefore.codeRange().setDescription("original annotation").setCodeElement(this.annotationBefore.toString()));
        ranges.add(this.operationBefore.codeRange().setDescription("original method declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationAfter.codeRange().setDescription("modified annotation").setCodeElement(this.annotationAfter.toString()));
        ranges.add(this.operationAfter.codeRange().setDescription("method declaration with modified annotation").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MODIFY_METHOD_ANNOTATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.annotationBefore);
        sb.append(" to ");
        sb.append(this.annotationAfter);
        sb.append(" in method ");
        sb.append(this.operationAfter);
        sb.append(" from class ");
        sb.append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationAfter == null ? 0 : this.annotationAfter.hashCode());
        result = 31 * result + (this.annotationBefore == null ? 0 : this.annotationBefore.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyMethodAnnotationRefactoring other = (ModifyMethodAnnotationRefactoring)obj;
        if (this.annotationAfter == null ? other.annotationAfter != null : !this.annotationAfter.equals(other.annotationAfter)) {
            return false;
        }
        if (this.annotationBefore == null ? other.annotationBefore != null : !this.annotationBefore.equals(other.annotationBefore)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        return !(this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore));
    }
}

