/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.PrefixSuffixUtils;

public class MoveAndRenameClassRefactoring
implements PackageLevelRefactoring {
    private UMLClass originalClass;
    private UMLClass renamedClass;

    public MoveAndRenameClassRefactoring(UMLClass originalClass, UMLClass renamedClass) {
        this.originalClass = originalClass;
        this.renamedClass = renamedClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalClass.getName());
        sb.append(" moved and renamed to ");
        sb.append(this.renamedClass.getName());
        return sb.toString();
    }

    @Override
    public RenamePattern getRenamePattern() {
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('.', this.originalClass.getPackageName(), this.renamedClass.getPackageName());
        if (separatorPos == -1) {
            return new RenamePattern(this.originalClass.getPackageName(), this.renamedClass.getPackageName());
        }
        String originalPath = this.originalClass.getName().substring(0, this.originalClass.getName().length() - separatorPos);
        String movedPath = this.renamedClass.getName().substring(0, this.renamedClass.getName().length() - separatorPos);
        return new RenamePattern(originalPath, movedPath);
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_RENAME_CLASS;
    }

    @Override
    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    public String getRenamedClassName() {
        return this.renamedClass.getName();
    }

    @Override
    public String getMovedClassName() {
        return this.getRenamedClassName();
    }

    @Override
    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getRenamedClass() {
        return this.renamedClass;
    }

    @Override
    public UMLClass getMovedClass() {
        return this.getRenamedClass();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRenamedClass().getLocationInfo().getFilePath(), (Object)this.getRenamedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedClass.codeRange().setDescription("moved and renamed type declaration").setCodeElement(this.renamedClass.getName()));
        return ranges;
    }
}

