/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.MovedClassToAnotherSourceFolder;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MoveSourceFolderRefactoring
implements Refactoring {
    private List<MovedClassToAnotherSourceFolder> movedClassesToAnotherSourceFolder = new ArrayList<MovedClassToAnotherSourceFolder>();
    private Map<String, String> identicalFilePaths = new HashMap<String, String>();
    private RenamePattern pattern;

    public MoveSourceFolderRefactoring(RenamePattern pattern) {
        this.pattern = pattern;
    }

    public MoveSourceFolderRefactoring(MovedClassToAnotherSourceFolder movedClassToAnotherSourceFolder) {
        this.movedClassesToAnotherSourceFolder.add(movedClassToAnotherSourceFolder);
        this.pattern = movedClassToAnotherSourceFolder.getRenamePattern();
    }

    public void putIdenticalFilePaths(String filePathBefore, String filePathAfter) {
        this.identicalFilePaths.put(filePathBefore, filePathAfter);
    }

    public void addMovedClassToAnotherSourceFolder(MovedClassToAnotherSourceFolder movedClassToAnotherSourceFolder) {
        this.movedClassesToAnotherSourceFolder.add(movedClassToAnotherSourceFolder);
    }

    public List<MovedClassToAnotherSourceFolder> getMovedClassesToAnotherSourceFolder() {
        return this.movedClassesToAnotherSourceFolder;
    }

    public Map<String, String> getIdenticalFilePaths() {
        return this.identicalFilePaths;
    }

    public RenamePattern getPattern() {
        return this.pattern;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String originalPath = this.pattern.getBefore().endsWith("/") ? this.pattern.getBefore().substring(0, this.pattern.getBefore().length() - 1) : this.pattern.getBefore();
        sb.append(originalPath);
        sb.append(" to ");
        String movedPath = this.pattern.getAfter().endsWith("/") ? this.pattern.getAfter().substring(0, this.pattern.getAfter().length() - 1) : this.pattern.getAfter();
        sb.append(movedPath);
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_SOURCE_FOLDER;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (MovedClassToAnotherSourceFolder ref : this.movedClassesToAnotherSourceFolder) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getOriginalClass().getLocationInfo().getFilePath(), (Object)ref.getOriginalClassName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (MovedClassToAnotherSourceFolder ref : this.movedClassesToAnotherSourceFolder) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getMovedClass().getLocationInfo().getFilePath(), (Object)ref.getMovedClassName()));
        }
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (MovedClassToAnotherSourceFolder ref : this.movedClassesToAnotherSourceFolder) {
            ranges.add(ref.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(ref.getOriginalClass().getName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (MovedClassToAnotherSourceFolder ref : this.movedClassesToAnotherSourceFolder) {
            ranges.add(ref.getMovedClass().codeRange().setDescription("moved type declaration").setCodeElement(ref.getMovedClass().getName()));
        }
        return ranges;
    }
}

