/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.RenamePattern;
import org.refactoringminer.util.PrefixSuffixUtils;

public class MovedClassToAnotherSourceFolder {
    private UMLClass originalClass;
    private UMLClass movedClass;
    private String originalPath;
    private String movedPath;

    public MovedClassToAnotherSourceFolder(UMLClass originalClass, UMLClass movedClass, String originalPath, String movedPath) {
        this.originalClass = originalClass;
        this.movedClass = movedClass;
        this.originalPath = originalPath;
        this.movedPath = movedPath;
    }

    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    public String getMovedClassName() {
        return this.movedClass.getName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getMovedClass() {
        return this.movedClass;
    }

    public RenamePattern getRenamePattern() {
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('/', this.originalPath, this.movedPath);
        if (separatorPos == -1) {
            return new RenamePattern(this.originalPath, this.movedPath);
        }
        String original = this.originalPath.substring(0, this.originalPath.length() - separatorPos);
        String moved = this.movedPath.substring(0, this.movedPath.length() - separatorPos);
        return new RenamePattern(original, moved);
    }
}

