/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class RenameClassRefactoring
implements Refactoring {
    private UMLClass originalClass;
    private UMLClass renamedClass;

    public RenameClassRefactoring(UMLClass originalClass, UMLClass renamedClass) {
        this.originalClass = originalClass;
        this.renamedClass = renamedClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalClass.getName());
        sb.append(" renamed to ");
        sb.append(this.renamedClass.getName());
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.RENAME_CLASS;
    }

    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    public String getRenamedClassName() {
        return this.renamedClass.getName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getRenamedClass() {
        return this.renamedClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRenamedClass().getLocationInfo().getFilePath(), (Object)this.getRenamedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedClass.codeRange().setDescription("renamed type declaration").setCodeElement(this.renamedClass.getName()));
        return ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalClass == null ? 0 : this.originalClass.hashCode());
        result = 31 * result + (this.renamedClass == null ? 0 : this.renamedClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameClassRefactoring other = (RenameClassRefactoring)obj;
        if (this.originalClass == null ? other.originalClass != null : !this.originalClass.equals(other.originalClass)) {
            return false;
        }
        return !(this.renamedClass == null ? other.renamedClass != null : !this.renamedClass.equals(other.renamedClass));
    }
}

