/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class RenameVariableRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private VariableDeclaration originalVariable;
    private VariableDeclaration renamedVariable;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private Set<AbstractCodeMapping> variableReferences;
    private boolean insideExtractedOrInlinedMethod;

    public RenameVariableRefactoring(VariableDeclaration originalVariable, VariableDeclaration renamedVariable, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, Set<AbstractCodeMapping> variableReferences, boolean insideExtractedOrInlinedMethod) {
        this.originalVariable = originalVariable;
        this.renamedVariable = renamedVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.originalVariable.isParameter() && this.renamedVariable.isParameter()) {
            return RefactoringType.RENAME_PARAMETER;
        }
        if (this.originalVariable.isAttribute() && this.renamedVariable.isParameter()) {
            return RefactoringType.PARAMETERIZE_ATTRIBUTE;
        }
        if (!this.originalVariable.isParameter() && this.renamedVariable.isParameter()) {
            return RefactoringType.PARAMETERIZE_VARIABLE;
        }
        if (!this.originalVariable.isAttribute() && this.renamedVariable.isAttribute()) {
            return RefactoringType.REPLACE_VARIABLE_WITH_ATTRIBUTE;
        }
        if (this.originalVariable.isAttribute() && !this.renamedVariable.isAttribute()) {
            return RefactoringType.REPLACE_ATTRIBUTE_WITH_VARIABLE;
        }
        if (this.originalVariable.isParameter() && this.renamedVariable.isLocalVariable()) {
            return RefactoringType.LOCALIZE_PARAMETER;
        }
        return RefactoringType.RENAME_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getOriginalVariable() {
        return this.originalVariable;
    }

    public VariableDeclaration getRenamedVariable() {
        return this.renamedVariable;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.variableReferences;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalVariable);
        sb.append(" to ");
        sb.append(this.renamedVariable);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalVariable == null ? 0 : this.originalVariable.hashCode());
        result = 31 * result + (this.renamedVariable == null ? 0 : this.renamedVariable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameVariableRefactoring other = (RenameVariableRefactoring)obj;
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.originalVariable == null ? other.originalVariable != null : !this.originalVariable.equals(other.originalVariable)) {
            return false;
        }
        return !(this.renamedVariable == null ? other.renamedVariable != null : !this.renamedVariable.equals(other.renamedVariable));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalVariable.codeRange().setDescription("original variable declaration").setCodeElement(this.originalVariable.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedVariable.codeRange().setDescription("renamed variable declaration").setCodeElement(this.renamedVariable.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with renamed variable").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

