/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ReplaceAnonymousWithLambdaRefactoring
implements Refactoring {
    private UMLAnonymousClass anonymousClass;
    private LambdaExpressionObject lambda;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;

    public ReplaceAnonymousWithLambdaRefactoring(UMLAnonymousClass anonymousClass, LambdaExpressionObject lambda, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.anonymousClass = anonymousClass;
        this.lambda = lambda;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public UMLAnonymousClass getAnonymousClass() {
        return this.anonymousClass;
    }

    public LambdaExpressionObject getLambda() {
        return this.lambda;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.anonymousClass.codeRange().setDescription("anonymous class declaration").setCodeElement(this.anonymousClass.getCodePath()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        String string = this.lambda.toString();
        String lambdaString = string.contains("\n") ? string.substring(0, string.indexOf("\n")) : string;
        ranges.add(this.lambda.codeRange().setDescription("lambda expression").setCodeElement(lambdaString));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with introduced lambda").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.REPLACE_ANONYMOUS_WITH_LAMBDA;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.anonymousClass.getCodePath());
        sb.append(" with ");
        String string = this.lambda.toString();
        sb.append(string.contains("\n") ? string.substring(0, string.indexOf("\n")) : string);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ");
        sb.append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anonymousClass == null ? 0 : this.anonymousClass.getLocationInfo().hashCode());
        result = 31 * result + (this.lambda == null ? 0 : this.lambda.getLocationInfo().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceAnonymousWithLambdaRefactoring other = (ReplaceAnonymousWithLambdaRefactoring)obj;
        if (this.anonymousClass == null ? other.anonymousClass != null : !this.anonymousClass.getLocationInfo().equals(other.anonymousClass.getLocationInfo())) {
            return false;
        }
        return !(this.lambda == null ? other.lambda != null : !this.lambda.getLocationInfo().equals(other.lambda.getLocationInfo()));
    }
}

