/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ReplaceLoopWithPipelineRefactoring
implements Refactoring {
    private Set<AbstractCodeFragment> codeFragmentsBefore;
    private Set<AbstractCodeFragment> codeFragmentsAfter;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;

    public ReplaceLoopWithPipelineRefactoring(Set<AbstractCodeFragment> codeFragmentsBefore, Set<AbstractCodeFragment> codeFragmentsAfter, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.codeFragmentsBefore = codeFragmentsBefore;
        this.codeFragmentsAfter = codeFragmentsAfter;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public Set<AbstractCodeFragment> getCodeFragmentsBefore() {
        return this.codeFragmentsBefore;
    }

    public Set<AbstractCodeFragment> getCodeFragmentsAfter() {
        return this.codeFragmentsAfter;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        for (AbstractCodeFragment fragment : this.codeFragmentsBefore) {
            if (!fragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT) && !fragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT) && !fragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.WHILE_STATEMENT) && !fragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.DO_STATEMENT)) continue;
            sb.append(fragment.getString());
            break;
        }
        sb.append(" with ");
        String pipeline = this.codeFragmentsAfter.iterator().next().getString();
        sb.append(pipeline.contains("\n") ? pipeline.substring(0, pipeline.indexOf("\n")) : pipeline);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ");
        sb.append(this.operationAfter.getClassName());
        return sb.toString();
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeFragment fragment : this.codeFragmentsBefore) {
            ranges.add(fragment.codeRange().setDescription("original code").setCodeElement(fragment.getString()));
        }
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeFragment fragment : this.codeFragmentsAfter) {
            ranges.add(fragment.codeRange().setDescription("pipeline code").setCodeElement(fragment.getString()));
        }
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with introduced pipeline").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.REPLACE_LOOP_WITH_PIPELINE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codeFragmentsAfter == null ? 0 : this.codeFragmentsAfter.hashCode());
        result = 31 * result + (this.codeFragmentsBefore == null ? 0 : this.codeFragmentsBefore.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceLoopWithPipelineRefactoring other = (ReplaceLoopWithPipelineRefactoring)obj;
        if (this.codeFragmentsAfter == null ? other.codeFragmentsAfter != null : !this.codeFragmentsAfter.equals(other.codeFragmentsAfter)) {
            return false;
        }
        if (this.codeFragmentsBefore == null ? other.codeFragmentsBefore != null : !this.codeFragmentsBefore.equals(other.codeFragmentsBefore)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        return !(this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore));
    }
}

