/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Patch;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class StringDistance {
    private static final int MAX_STRING_LENGTH = 10000;
    private static final Pattern COMMENT_LINE = Pattern.compile("^\\s*(//|\\*|import\\s).*");

    public static int editDistance(String a, String b, int threshold) {
        return new LevenshteinDistance(Integer.valueOf(threshold)).apply((CharSequence)a, (CharSequence)b);
    }

    public static int editDistance(String a, String b) {
        int length1 = a.length();
        int length2 = b.length();
        if (length1 > 10000 || length2 > 10000) {
            return Math.max(length1, length2);
        }
        return new LevenshteinDistance().apply((CharSequence)a, (CharSequence)b);
    }

    public static boolean trivialCommentChange(String fileBefore, String fileAfter) throws IOException {
        if (fileBefore.length() == fileAfter.length()) {
            List original = IOUtils.readLines((Reader)new StringReader(fileBefore));
            List revised = IOUtils.readLines((Reader)new StringReader(fileAfter));
            Patch patch = DiffUtils.diff((List)original, (List)revised);
            List deltas = patch.getDeltas();
            for (AbstractDelta delta : deltas) {
                Chunk source = delta.getSource();
                if (source.getLines().size() > 0 && !((String)source.getLines().get(0)).isBlank() && !COMMENT_LINE.matcher((CharSequence)source.getLines().get(0)).matches()) {
                    return false;
                }
                Chunk target = delta.getTarget();
                if (target.getLines().size() <= 0 || ((String)target.getLines().get(0)).isBlank() || COMMENT_LINE.matcher((CharSequence)target.getLines().get(0)).matches()) continue;
                return false;
            }
            return true;
        }
        List original = IOUtils.readLines((Reader)new StringReader(fileBefore));
        List revised = IOUtils.readLines((Reader)new StringReader(fileAfter));
        if (original.size() == revised.size()) {
            Patch patch = DiffUtils.diff((List)original, (List)revised);
            List deltas = patch.getDeltas();
            for (AbstractDelta delta : deltas) {
                Chunk source = delta.getSource();
                if (source.getLines().size() > 0 && !((String)source.getLines().get(0)).isBlank() && !COMMENT_LINE.matcher((CharSequence)source.getLines().get(0)).matches()) {
                    return false;
                }
                Chunk target = delta.getTarget();
                if (target.getLines().size() <= 0 || ((String)target.getLines().get(0)).isBlank() || COMMENT_LINE.matcher((CharSequence)target.getLines().get(0)).matches()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

