/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UMLAnnotationDiff {
    private UMLAnnotation removedAnnotation;
    private UMLAnnotation addedAnnotation;
    private boolean typeNameChanged = false;
    private boolean valueChanged = false;
    private boolean valueRemoved = false;
    private boolean valueAdded = false;
    private List<AbstractMap.SimpleEntry<String, AbstractExpression>> removedMemberValuePairs;
    private List<AbstractMap.SimpleEntry<String, AbstractExpression>> addedMemberValuePairs;
    private Map<AbstractMap.SimpleEntry<String, AbstractExpression>, AbstractMap.SimpleEntry<String, AbstractExpression>> matchedMemberValuePairsWithDifferentExpressions;

    public UMLAnnotationDiff(UMLAnnotation removedAnnotation, UMLAnnotation addedAnnotation) {
        this.removedAnnotation = removedAnnotation;
        this.addedAnnotation = addedAnnotation;
        this.removedMemberValuePairs = new ArrayList<AbstractMap.SimpleEntry<String, AbstractExpression>>();
        this.addedMemberValuePairs = new ArrayList<AbstractMap.SimpleEntry<String, AbstractExpression>>();
        this.matchedMemberValuePairsWithDifferentExpressions = new LinkedHashMap<AbstractMap.SimpleEntry<String, AbstractExpression>, AbstractMap.SimpleEntry<String, AbstractExpression>>();
        LinkedHashMap<AbstractMap.SimpleEntry<String, AbstractExpression>, AbstractMap.SimpleEntry<String, AbstractExpression>> matchedMemberValuePairs = new LinkedHashMap<AbstractMap.SimpleEntry<String, AbstractExpression>, AbstractMap.SimpleEntry<String, AbstractExpression>>();
        if (!removedAnnotation.getTypeName().equals(addedAnnotation.getTypeName())) {
            this.typeNameChanged = true;
        }
        AbstractExpression value1 = removedAnnotation.getValue();
        AbstractExpression value2 = addedAnnotation.getValue();
        if (value1 != null && value2 != null) {
            if (!value1.getExpression().equals(value2.getExpression())) {
                this.valueChanged = true;
            }
        } else if (value1 != null && value2 == null) {
            this.valueRemoved = true;
        } else if (value1 == null && value2 != null) {
            this.valueAdded = true;
        }
        Map<String, AbstractExpression> memberValuePairs1 = removedAnnotation.getMemberValuePairs();
        Map<String, AbstractExpression> memberValuePairs2 = addedAnnotation.getMemberValuePairs();
        if (!memberValuePairs1.isEmpty() || !memberValuePairs2.isEmpty()) {
            for (String key1 : memberValuePairs1.keySet()) {
                if (memberValuePairs2.containsKey(key1)) {
                    matchedMemberValuePairs.put(new AbstractMap.SimpleEntry<String, AbstractExpression>(key1, memberValuePairs1.get(key1)), new AbstractMap.SimpleEntry<String, AbstractExpression>(key1, memberValuePairs2.get(key1)));
                    continue;
                }
                this.removedMemberValuePairs.add(new AbstractMap.SimpleEntry<String, AbstractExpression>(key1, memberValuePairs1.get(key1)));
            }
            for (String key2 : memberValuePairs2.keySet()) {
                if (memberValuePairs1.containsKey(key2)) {
                    matchedMemberValuePairs.put(new AbstractMap.SimpleEntry<String, AbstractExpression>(key2, memberValuePairs1.get(key2)), new AbstractMap.SimpleEntry<String, AbstractExpression>(key2, memberValuePairs2.get(key2)));
                    continue;
                }
                this.addedMemberValuePairs.add(new AbstractMap.SimpleEntry<String, AbstractExpression>(key2, memberValuePairs2.get(key2)));
            }
        }
        for (AbstractMap.SimpleEntry key : matchedMemberValuePairs.keySet()) {
            AbstractMap.SimpleEntry value = (AbstractMap.SimpleEntry)matchedMemberValuePairs.get(key);
            if (((AbstractExpression)key.getValue()).getExpression().equals(((AbstractExpression)value.getValue()).getExpression())) continue;
            this.matchedMemberValuePairsWithDifferentExpressions.put(key, value);
        }
    }

    public UMLAnnotation getRemovedAnnotation() {
        return this.removedAnnotation;
    }

    public UMLAnnotation getAddedAnnotation() {
        return this.addedAnnotation;
    }

    public boolean isEmpty() {
        return !this.typeNameChanged && !this.valueChanged && !this.valueAdded && !this.valueRemoved && this.removedMemberValuePairs.isEmpty() && this.addedMemberValuePairs.isEmpty() && this.matchedMemberValuePairsWithDifferentExpressions.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.addedAnnotation, this.removedAnnotation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLAnnotationDiff other = (UMLAnnotationDiff)obj;
        return Objects.equals(this.addedAnnotation, other.addedAnnotation) && Objects.equals(this.removedAnnotation, other.removedAnnotation);
    }

    public String toString() {
        return this.removedAnnotation + "\t->\t" + this.addedAnnotation;
    }
}

