/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReferenceExtractor;
import gr.uom.java.xmi.diff.AddAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddAttributeModifierRefactoring;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.ChangeAttributeAccessModifierRefactoring;
import gr.uom.java.xmi.diff.ChangeAttributeTypeRefactoring;
import gr.uom.java.xmi.diff.EncapsulateAttributeRefactoring;
import gr.uom.java.xmi.diff.ModifyAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeModifierRefactoring;
import gr.uom.java.xmi.diff.RenameAttributeRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class UMLAttributeDiff {
    private UMLAttribute removedAttribute;
    private UMLAttribute addedAttribute;
    private boolean visibilityChanged;
    private boolean typeChanged;
    private boolean qualifiedTypeChanged;
    private boolean renamed;
    private boolean staticChanged;
    private boolean finalChanged;
    private boolean volatileChanged;
    private boolean transientChanged;
    private List<UMLOperationBodyMapper> operationBodyMapperList;
    private UMLAnnotationListDiff annotationListDiff;
    private UMLOperation addedGetter;
    private UMLOperation addedSetter;
    private UMLOperationBodyMapper mapper;
    private UMLAbstractClassDiff classDiff;
    private UMLModelDiff modelDiff;

    public UMLAttributeDiff(UMLAttribute removedAttribute, UMLAttribute addedAttribute, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) throws RefactoringMinerTimedOutException {
        UMLOperation removedSetter;
        UMLOperation removedGetter;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        this.init(removedAttribute, addedAttribute, classDiff.getOperationBodyMapperList());
        this.addedGetter = this.findMethod(classDiff.getAddedOperations(), addedAttribute, this.getterCondition(addedAttribute));
        if (this.addedGetter != null && !removedAttribute.getName().equals(addedAttribute.getName()) && (removedGetter = this.findMethod(classDiff.getRemovedOperations(), removedAttribute, this.getterCondition(removedAttribute))) != null) {
            this.addedGetter = null;
        }
        this.addedSetter = this.findMethod(classDiff.getAddedOperations(), addedAttribute, this.setterCondition(addedAttribute));
        if (this.addedSetter != null && !removedAttribute.getName().equals(addedAttribute.getName()) && (removedSetter = this.findMethod(classDiff.getRemovedOperations(), removedAttribute, this.setterCondition(removedAttribute))) != null) {
            this.addedSetter = null;
        }
    }

    private Function<UMLOperation, Boolean> getterCondition(UMLAttribute attribute) {
        return operation -> {
            UMLParameter returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                return operation.isGetter() && (returnParameter.getType().equals(attribute.getType()) || returnParameter.getType().getClassType().equalsIgnoreCase(attribute.getType().getClassType()));
            }
            return false;
        };
    }

    private Function<UMLOperation, Boolean> setterCondition(UMLAttribute attribute) {
        return operation -> operation.isSetter() && (operation.getParameterTypeList().get(0).equals(attribute.getType()) || operation.getParameterTypeList().get(0).getClassType().equalsIgnoreCase(attribute.getType().getClassType()));
    }

    private UMLOperation findMethod(List<UMLOperation> operations, UMLAttribute attribute, Function<UMLOperation, Boolean> condition) {
        for (UMLOperation operation : operations) {
            List<String> variables;
            if (operation.isConstructor() || operation.hasOverrideAnnotation() || !condition.apply(operation).booleanValue() || !(variables = operation.getAllVariables()).contains(attribute.getName()) && !variables.contains("this." + attribute.getName())) continue;
            return operation;
        }
        return null;
    }

    public UMLAttributeDiff(UMLAttribute removedAttribute, UMLAttribute addedAttribute, List<UMLOperationBodyMapper> operationBodyMapperList) throws RefactoringMinerTimedOutException {
        this.init(removedAttribute, addedAttribute, operationBodyMapperList);
    }

    private void init(UMLAttribute removedAttribute, UMLAttribute addedAttribute, List<UMLOperationBodyMapper> operationBodyMapperList) throws RefactoringMinerTimedOutException {
        this.removedAttribute = removedAttribute;
        this.addedAttribute = addedAttribute;
        this.operationBodyMapperList = operationBodyMapperList;
        this.visibilityChanged = false;
        this.typeChanged = false;
        this.renamed = false;
        this.staticChanged = false;
        this.finalChanged = false;
        if (!removedAttribute.getName().equals(addedAttribute.getName())) {
            this.renamed = true;
        }
        if (!removedAttribute.getVisibility().equals(addedAttribute.getVisibility())) {
            this.visibilityChanged = true;
        }
        if (!removedAttribute.getType().equals(addedAttribute.getType())) {
            this.typeChanged = true;
        } else if (!removedAttribute.getType().equalsQualified(addedAttribute.getType())) {
            this.qualifiedTypeChanged = true;
        }
        if (removedAttribute.isStatic() != addedAttribute.isStatic()) {
            this.staticChanged = true;
        }
        if (removedAttribute.isFinal() != addedAttribute.isFinal()) {
            this.finalChanged = true;
        }
        if (removedAttribute.isVolatile() != addedAttribute.isVolatile()) {
            this.volatileChanged = true;
        }
        if (removedAttribute.isTransient() != addedAttribute.isTransient()) {
            this.transientChanged = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedAttribute.getAnnotations(), addedAttribute.getAnnotations());
        AbstractExpression initializer1 = removedAttribute.getVariableDeclaration().getInitializer();
        AbstractExpression initializer2 = addedAttribute.getVariableDeclaration().getInitializer();
        if (initializer1 != null && initializer2 != null) {
            this.mapper = new UMLOperationBodyMapper(removedAttribute, addedAttribute, this.classDiff, this.modelDiff);
        }
    }

    public UMLAttribute getRemovedAttribute() {
        return this.removedAttribute;
    }

    public UMLAttribute getAddedAttribute() {
        return this.addedAttribute;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isVisibilityChanged() {
        return this.visibilityChanged;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isQualifiedTypeChanged() {
        return this.qualifiedTypeChanged;
    }

    public Set<AbstractCodeMapping> getInitializerMappings() {
        if (this.mapper != null) {
            return this.mapper.getMappings();
        }
        return Collections.emptySet();
    }

    public boolean isEmpty() {
        return !this.visibilityChanged && !this.staticChanged && !this.finalChanged && !this.volatileChanged && !this.transientChanged && !this.typeChanged && !this.renamed && !this.qualifiedTypeChanged && this.annotationListDiff.isEmpty() && this.addedGetter == null && this.addedSetter == null && (this.mapper == null || this.mapper != null && this.mapper.getRefactoringsAfterPostProcessing().isEmpty());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedAttribute).append("\n");
        }
        if (this.renamed) {
            sb.append("\t").append("renamed from " + this.removedAttribute.getName() + " to " + this.addedAttribute.getName()).append("\n");
        }
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from " + this.removedAttribute.getVisibility() + " to " + this.addedAttribute.getVisibility()).append("\n");
        }
        if (this.typeChanged || this.qualifiedTypeChanged) {
            sb.append("\t").append("type changed from " + this.removedAttribute.getType() + " to " + this.addedAttribute.getType()).append("\n");
        }
        if (this.staticChanged) {
            sb.append("\t").append("modifier changed from " + (this.removedAttribute.isStatic() ? "static" : "non-static") + " to " + (this.addedAttribute.isStatic() ? "static" : "non-static")).append("\n");
        }
        if (this.finalChanged) {
            sb.append("\t").append("modifier changed from " + (this.removedAttribute.isFinal() ? "final" : "non-final") + " to " + (this.addedAttribute.isFinal() ? "final" : "non-final")).append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    private Set<Refactoring> getAnnotationRefactorings() {
        Refactoring refactoring;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddAttributeAnnotationRefactoring(annotation, this.removedAttribute, this.addedAttribute);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveAttributeAnnotationRefactoring(annotation, this.removedAttribute, this.addedAttribute);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyAttributeAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.removedAttribute, this.addedAttribute);
            refactorings.add(refactoring);
        }
        return refactorings;
    }

    public Set<Refactoring> getRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        if (this.changeTypeCondition()) {
            ChangeAttributeTypeRefactoring ref = new ChangeAttributeTypeRefactoring(this.removedAttribute, this.addedAttribute, VariableReferenceExtractor.findReferences(this.removedAttribute.getVariableDeclaration(), this.addedAttribute.getVariableDeclaration(), this.operationBodyMapperList));
            refactorings.add(ref);
        }
        refactorings.addAll(this.getModifierRefactorings());
        refactorings.addAll(this.getAnnotationRefactorings());
        if (this.mapper != null) {
            refactorings.addAll(this.mapper.getRefactoringsAfterPostProcessing());
        }
        return refactorings;
    }

    private Set<Refactoring> getModifierRefactorings() {
        Refactoring ref;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        if (this.isVisibilityChanged()) {
            ref = new ChangeAttributeAccessModifierRefactoring(this.removedAttribute.getVisibility(), this.addedAttribute.getVisibility(), this.removedAttribute, this.addedAttribute);
            refactorings.add(ref);
        }
        if (this.encapsulationCondition()) {
            ref = new EncapsulateAttributeRefactoring(this.removedAttribute, this.addedAttribute, this.addedGetter, this.addedSetter);
            refactorings.add(ref);
        }
        if (this.finalChanged) {
            if (this.addedAttribute.isFinal()) {
                ref = new AddAttributeModifierRefactoring("final", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            } else if (this.removedAttribute.isFinal()) {
                ref = new RemoveAttributeModifierRefactoring("final", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            }
        }
        if (this.staticChanged) {
            if (this.addedAttribute.isStatic()) {
                ref = new AddAttributeModifierRefactoring("static", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            } else if (this.removedAttribute.isStatic()) {
                ref = new RemoveAttributeModifierRefactoring("static", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            }
        }
        if (this.transientChanged) {
            if (this.addedAttribute.isTransient()) {
                ref = new AddAttributeModifierRefactoring("transient", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            } else if (this.removedAttribute.isTransient()) {
                ref = new RemoveAttributeModifierRefactoring("transient", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            }
        }
        if (this.volatileChanged) {
            if (this.addedAttribute.isVolatile()) {
                ref = new AddAttributeModifierRefactoring("volatile", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            } else if (this.removedAttribute.isVolatile()) {
                ref = new RemoveAttributeModifierRefactoring("volatile", this.removedAttribute, this.addedAttribute);
                refactorings.add(ref);
            }
        }
        return refactorings;
    }

    public Set<Refactoring> getRefactorings(Set<CandidateAttributeRefactoring> set) {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        RenameAttributeRefactoring rename = null;
        if (this.isRenamed()) {
            rename = new RenameAttributeRefactoring(this.removedAttribute, this.addedAttribute, set);
            refactorings.add(rename);
        }
        if (this.changeTypeCondition()) {
            ChangeAttributeTypeRefactoring ref = new ChangeAttributeTypeRefactoring(this.removedAttribute, this.addedAttribute, VariableReferenceExtractor.findReferences(this.removedAttribute.getVariableDeclaration(), this.addedAttribute.getVariableDeclaration(), this.operationBodyMapperList));
            refactorings.add(ref);
            if (rename != null) {
                ref.addRelatedRefactoring(rename);
            }
        }
        refactorings.addAll(this.getModifierRefactorings());
        refactorings.addAll(this.getAnnotationRefactorings());
        if (this.mapper != null) {
            refactorings.addAll(this.mapper.getRefactoringsAfterPostProcessing());
        }
        return refactorings;
    }

    private boolean encapsulationCondition() {
        return this.addedSetter != null || this.addedGetter != null;
    }

    private boolean changeTypeCondition() {
        return (this.isTypeChanged() || this.isQualifiedTypeChanged()) && !this.enumConstantsDeclaredInTheSameEnumDeclarationType();
    }

    private boolean enumConstantsDeclaredInTheSameEnumDeclarationType() {
        VariableDeclaration removedVariableDeclaration = this.removedAttribute.getVariableDeclaration();
        VariableDeclaration addedVariableDeclaration = this.addedAttribute.getVariableDeclaration();
        return removedVariableDeclaration.isEnumConstant() && addedVariableDeclaration.isEnumConstant() && removedVariableDeclaration.equalType(addedVariableDeclaration);
    }
}

