/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.ConsistentReplacementDetector;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.diff.AddClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddClassModifierRefactoring;
import gr.uom.java.xmi.diff.ChangeClassAccessModifierRefactoring;
import gr.uom.java.xmi.diff.CodeFragmentComparator;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.InlineOperationDetection;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.ModifyClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import gr.uom.java.xmi.diff.RemoveClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveClassModifierRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLEnumConstantDiff;
import gr.uom.java.xmi.diff.UMLImportListDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLTypeParameterListDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public abstract class UMLClassBaseDiff
extends UMLAbstractClassDiff
implements Comparable<UMLClassBaseDiff> {
    private static final int MAXIMUM_NUMBER_OF_COMPARED_METHODS = 30;
    public static final double MAX_OPERATION_NAME_DISTANCE = 0.4;
    private boolean visibilityChanged = false;
    private String oldVisibility;
    private String newVisibility;
    private boolean abstractionChanged = false;
    private boolean oldAbstraction;
    private boolean newAbstraction;
    private boolean staticChanged;
    private boolean finalChanged;
    private boolean superclassChanged = false;
    private UMLType oldSuperclass;
    private UMLType newSuperclass;
    private List<UMLType> addedImplementedInterfaces = new ArrayList<UMLType>();
    private List<UMLType> removedImplementedInterfaces = new ArrayList<UMLType>();
    private UMLAnnotationListDiff annotationListDiff;
    private UMLImportListDiff importDiffList;
    private UMLTypeParameterListDiff typeParameterDiffList;
    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> consistentMethodInvocationRenames;

    public UMLClassBaseDiff(UMLClass originalClass, UMLClass nextClass, UMLModelDiff modelDiff) {
        super(originalClass, nextClass, modelDiff);
    }

    @Override
    public UMLClass getOriginalClass() {
        return (UMLClass)this.originalClass;
    }

    @Override
    public UMLClass getNextClass() {
        return (UMLClass)this.nextClass;
    }

    @Override
    public void process() throws RefactoringMinerTimedOutException {
        this.processImports();
        this.processInitializers();
        this.processModifiers();
        this.processTypeParameters();
        this.processAnnotations();
        this.processEnumConstants();
        this.processInheritance();
        this.processOperations();
        this.createBodyMappers();
        this.processAnonymousClasses();
        this.checkForOperationSignatureChanges();
        this.processAttributes();
        this.checkForAttributeChanges();
        this.checkForInlinedOperations();
        this.checkForExtractedOperations();
    }

    private void processTypeParameters() {
        this.typeParameterDiffList = new UMLTypeParameterListDiff(this.getOriginalClass().getTypeParameters(), this.getNextClass().getTypeParameters());
    }

    private void processImports() {
        if (this.originalClass.isTopLevel() && this.nextClass.isTopLevel()) {
            this.importDiffList = new UMLImportListDiff(this.originalClass.getImportedTypes(), this.nextClass.getImportedTypes());
        }
    }

    public boolean hasBothAddedAndRemovedImports() {
        if (this.importDiffList != null) {
            return this.importDiffList.getAddedImports().size() > 0 && this.importDiffList.getRemovedImports().size() > 0;
        }
        return false;
    }

    public void findImportChanges(String nameBefore, String nameAfter) {
        if (this.importDiffList != null) {
            this.importDiffList.findImportChanges(nameBefore, nameAfter);
        }
    }

    public UMLImportListDiff getImportDiffList() {
        return this.importDiffList;
    }

    public UMLAnnotationListDiff getAnnotationListDiff() {
        return this.annotationListDiff;
    }

    public UMLTypeParameterListDiff getTypeParameterDiffList() {
        return this.typeParameterDiffList;
    }

    protected void processInitializers() throws RefactoringMinerTimedOutException {
        for (UMLInitializer initializer1 : this.originalClass.getInitializers()) {
            for (UMLInitializer initializer2 : this.nextClass.getInitializers()) {
                UMLOperationBodyMapper mapper;
                int mappings;
                if (initializer1.isStatic() != initializer2.isStatic() || (mappings = (mapper = new UMLOperationBodyMapper(initializer1, initializer2, (UMLAbstractClassDiff)this)).mappingsWithoutBlocks()) <= 0) continue;
                int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                if (mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) continue;
                this.operationBodyMapperList.add(mapper);
            }
        }
    }

    private void processModifiers() {
        Refactoring refactoring;
        if (!this.originalClass.getVisibility().equals(this.nextClass.getVisibility())) {
            this.setVisibilityChanged(true);
            this.setOldVisibility(this.originalClass.getVisibility());
            this.setNewVisibility(this.nextClass.getVisibility());
            refactoring = new ChangeClassAccessModifierRefactoring(this.oldVisibility, this.newVisibility, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        if (!this.originalClass.isInterface() && !this.nextClass.isInterface() && this.originalClass.isAbstract() != this.nextClass.isAbstract()) {
            this.setAbstractionChanged(true);
            this.setOldAbstraction(this.originalClass.isAbstract());
            this.setNewAbstraction(this.nextClass.isAbstract());
            if (this.nextClass.isAbstract()) {
                refactoring = new AddClassModifierRefactoring("abstract", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isAbstract()) {
                refactoring = new RemoveClassModifierRefactoring("abstract", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
        if (this.originalClass.isFinal() != this.nextClass.isFinal()) {
            this.finalChanged = true;
            if (this.nextClass.isFinal()) {
                refactoring = new AddClassModifierRefactoring("final", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isFinal()) {
                refactoring = new RemoveClassModifierRefactoring("final", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
        if (this.originalClass.isStatic() != this.nextClass.isStatic()) {
            this.staticChanged = true;
            if (this.nextClass.isStatic()) {
                refactoring = new AddClassModifierRefactoring("static", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isStatic()) {
                refactoring = new RemoveClassModifierRefactoring("static", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
    }

    private void processAnnotations() {
        Refactoring refactoring;
        this.annotationListDiff = new UMLAnnotationListDiff(this.originalClass.getAnnotations(), this.nextClass.getAnnotations());
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddClassAnnotationRefactoring(annotation, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveClassAnnotationRefactoring(annotation, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyClassAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (mapper.getOperation1() == null || !mapper.getOperation1().equalSignature(operation1) || mapper.getOperation2() == null || !mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignature2(UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (mapper.getOperation2() == null || !mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    public Set<UMLType> nextClassCommonInterfaces(UMLClassBaseDiff other) {
        LinkedHashSet<UMLType> common = new LinkedHashSet<UMLType>(this.nextClass.getImplementedInterfaces());
        common.retainAll(other.nextClass.getImplementedInterfaces());
        return common;
    }

    @Override
    protected void checkForAttributeChanges() throws RefactoringMinerTimedOutException {
    }

    @Override
    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
    }

    protected void processAnonymousClasses() {
        for (UMLAnonymousClass umlAnonymousClass : this.originalClass.getAnonymousClassList()) {
            if (this.nextClass.containsAnonymousWithSameAttributesAndOperations(umlAnonymousClass)) continue;
            this.removedAnonymousClasses.add(umlAnonymousClass);
        }
        for (UMLAnonymousClass umlAnonymousClass : this.nextClass.getAnonymousClassList()) {
            if (this.originalClass.containsAnonymousWithSameAttributesAndOperations(umlAnonymousClass)) continue;
            this.addedAnonymousClasses.add(umlAnonymousClass);
        }
    }

    protected void processEnumConstants() {
        UMLEnumConstantDiff enumConstantDiff;
        UMLEnumConstant matchingEnumConstant;
        for (UMLEnumConstant enumConstant : this.originalClass.getEnumConstants()) {
            matchingEnumConstant = this.nextClass.containsEnumConstant(enumConstant);
            if (matchingEnumConstant == null) {
                this.removedEnumConstants.add(enumConstant);
                continue;
            }
            enumConstantDiff = new UMLEnumConstantDiff(enumConstant, matchingEnumConstant);
            if (enumConstantDiff.isEmpty()) continue;
            this.refactorings.addAll(enumConstantDiff.getRefactorings());
            this.enumConstantDiffList.add(enumConstantDiff);
        }
        for (UMLEnumConstant enumConstant : this.nextClass.getEnumConstants()) {
            matchingEnumConstant = this.originalClass.containsEnumConstant(enumConstant);
            if (matchingEnumConstant == null) {
                this.addedEnumConstants.add(enumConstant);
                continue;
            }
            enumConstantDiff = new UMLEnumConstantDiff(matchingEnumConstant, enumConstant);
            if (enumConstantDiff.isEmpty()) continue;
            this.refactorings.addAll(enumConstantDiff.getRefactorings());
            this.enumConstantDiffList.add(enumConstantDiff);
        }
    }

    protected void processAttributes() throws RefactoringMinerTimedOutException {
        UMLAttributeDiff attributeDiff;
        UMLAttribute attributeWithTheSameName;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            attributeWithTheSameName = this.nextClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.removedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attribute, attributeWithTheSameName) || (attributeDiff = new UMLAttributeDiff(attribute, attributeWithTheSameName, this, this.modelDiff)).isEmpty()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
            this.attributeDiffList.add(attributeDiff);
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            attributeWithTheSameName = this.originalClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.addedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attributeWithTheSameName, attribute) || (attributeDiff = new UMLAttributeDiff(attributeWithTheSameName, attribute, this, this.modelDiff)).isEmpty()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
            this.attributeDiffList.add(attributeDiff);
        }
    }

    protected void processOperations() throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper mapper;
        UMLOperation operationWithTheSameSignature;
        for (UMLOperation operation : this.originalClass.getOperations()) {
            operationWithTheSameSignature = this.nextClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.removedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operation, operationWithTheSameSignature)) continue;
            mapper = new UMLOperationBodyMapper(operation, operationWithTheSameSignature, (UMLAbstractClassDiff)this);
            this.operationBodyMapperList.add(mapper);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            operationWithTheSameSignature = this.originalClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.addedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operationWithTheSameSignature, operation)) continue;
            mapper = new UMLOperationBodyMapper(operationWithTheSameSignature, operation, (UMLAbstractClassDiff)this);
            this.operationBodyMapperList.add(mapper);
        }
    }

    private boolean attributeDiffListContainsAttribute(UMLAttribute attribute1, UMLAttribute attribute2) {
        for (UMLAttributeDiff diff : this.attributeDiffList) {
            if (!diff.getRemovedAttribute().equals(attribute1) && !diff.getAddedAttribute().equals(attribute2)) continue;
            return true;
        }
        return false;
    }

    private boolean mapperListContainsOperation(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (!mapper.getContainer1().equals(operation1) && !mapper.getContainer2().equals(operation2)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String className) {
        return this.originalClass.getName().equals(className) || this.nextClass.getName().equals(className);
    }

    public boolean matches(UMLType type) {
        return this.originalClass.getName().endsWith("." + type.getClassType()) || this.nextClass.getName().endsWith("." + type.getClassType());
    }

    public boolean isInnerClassMove(UMLClassBaseDiff classDiff) {
        return this.originalClass.isInnerClass(classDiff.originalClass) && this.nextClass.isInnerClass(classDiff.nextClass);
    }

    public boolean nextClassImportsType(String targetClass) {
        return this.nextClass.importsType(targetClass);
    }

    public boolean originalClassImportsType(String targetClass) {
        return this.originalClass.importsType(targetClass);
    }

    public List<UMLAttribute> nextClassAttributesOfType(String targetClass) {
        return this.nextClass.attributesOfType(targetClass);
    }

    public List<UMLAttribute> originalClassAttributesOfType(String targetClass) {
        return this.originalClass.attributesOfType(targetClass);
    }

    private void reportAddedImplementedInterface(UMLType implementedInterface) {
        this.addedImplementedInterfaces.add(implementedInterface);
    }

    private void reportRemovedImplementedInterface(UMLType implementedInterface) {
        this.removedImplementedInterfaces.add(implementedInterface);
    }

    private void setVisibilityChanged(boolean visibilityChanged) {
        this.visibilityChanged = visibilityChanged;
    }

    private void setOldVisibility(String oldVisibility) {
        this.oldVisibility = oldVisibility;
    }

    private void setNewVisibility(String newVisibility) {
        this.newVisibility = newVisibility;
    }

    private void setAbstractionChanged(boolean abstractionChanged) {
        this.abstractionChanged = abstractionChanged;
    }

    private void setOldAbstraction(boolean oldAbstraction) {
        this.oldAbstraction = oldAbstraction;
    }

    private void setNewAbstraction(boolean newAbstraction) {
        this.newAbstraction = newAbstraction;
    }

    private void setSuperclassChanged(boolean superclassChanged) {
        this.superclassChanged = superclassChanged;
    }

    private void setOldSuperclass(UMLType oldSuperclass) {
        this.oldSuperclass = oldSuperclass;
    }

    private void setNewSuperclass(UMLType newSuperclass) {
        this.newSuperclass = newSuperclass;
    }

    public UMLType getSuperclass() {
        if (!this.superclassChanged && this.oldSuperclass != null && this.newSuperclass != null) {
            return this.oldSuperclass;
        }
        return null;
    }

    public UMLType getOldSuperclass() {
        return this.oldSuperclass;
    }

    public UMLType getNewSuperclass() {
        return this.newSuperclass;
    }

    public List<UMLType> getAddedImplementedInterfaces() {
        return this.addedImplementedInterfaces;
    }

    public List<UMLType> getRemovedImplementedInterfaces() {
        return this.removedImplementedInterfaces;
    }

    public boolean containsOperationWithTheSameSignatureInOriginalClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.originalClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameSignatureInNextClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.nextClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConcreteOperationWithTheSameSignatureInNextClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.nextClass.getOperations()) {
            if (originalOperation.getBody() == null || !originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public UMLOperation containsAddedOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation addedOperation : this.addedOperations) {
            if (!addedOperation.equalSignature(operation)) continue;
            return addedOperation;
        }
        return null;
    }

    public UMLOperation containsRemovedOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation removedOperation : this.removedOperations) {
            if (!removedOperation.equalSignature(operation)) continue;
            return removedOperation;
        }
        return null;
    }

    public UMLAttribute containsAddedAttributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute addedAttribute : this.addedAttributes) {
            if (!addedAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return addedAttribute;
        }
        return null;
    }

    public UMLAttribute containsRemovedAttributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute removedAttribute : this.removedAttributes) {
            if (!removedAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return removedAttribute;
        }
        return null;
    }

    private void processInheritance() {
        if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() != null) {
            if (!this.originalClass.getSuperclass().equals(this.nextClass.getSuperclass())) {
                this.setSuperclassChanged(true);
            }
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() == null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() == null && this.nextClass.getSuperclass() != null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        }
        for (UMLType implementedInterface : this.originalClass.getImplementedInterfaces()) {
            if (this.nextClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportRemovedImplementedInterface(implementedInterface);
        }
        for (UMLType implementedInterface : this.nextClass.getImplementedInterfaces()) {
            if (this.originalClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportAddedImplementedInterface(implementedInterface);
        }
    }

    private int computeAbsoluteDifferenceInPositionWithinClass(UMLOperation removedOperation, UMLOperation addedOperation) {
        int index1 = this.originalClass.getOperations().indexOf(removedOperation);
        int index2 = this.nextClass.getOperations().indexOf(addedOperation);
        return Math.abs(index1 - index2);
    }

    private void checkForOperationSignatureChanges() throws RefactoringMinerTimedOutException {
        RenameOperationRefactoring rename;
        UMLOperationBodyMapper bestMapper;
        List<UMLOperation> operationsInsideAnonymousClass;
        UMLOperation addedOperation2;
        TreeSet<UMLOperationBodyMapper> mapperSet;
        UMLOperation removedOperation;
        Iterator removedOperationIterator;
        this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
        int initialNumberOfRemovedOperations = this.removedOperations.size();
        int initialNumberOfAddedOperations = this.addedOperations.size();
        if (this.removedOperations.size() <= this.addedOperations.size()) {
            removedOperationIterator = this.removedOperations.iterator();
            while (removedOperationIterator.hasNext()) {
                removedOperation = (UMLOperation)removedOperationIterator.next();
                mapperSet = new TreeSet<UMLOperationBodyMapper>();
                for (UMLOperation addedOperation2 : this.addedOperations) {
                    if (this.containsMapperForOperation1(removedOperation) || this.containsMapperForOperation2(addedOperation2)) continue;
                    int maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation2.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation2, maxDifferenceInPosition);
                    operationsInsideAnonymousClass = addedOperation2.getOperationsInsideAnonymousClass(this.addedAnonymousClasses);
                    for (UMLOperation operationInsideAnonymousClass : operationsInsideAnonymousClass) {
                        this.updateMapperSet(mapperSet, removedOperation, operationInsideAnonymousClass, addedOperation2, maxDifferenceInPosition);
                    }
                    if (initialNumberOfRemovedOperations < 30 || initialNumberOfAddedOperations < 30 || mapperSet.size() <= 0 || !removedOperation.getName().equals(addedOperation2.getName())) continue;
                    break;
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation = bestMapper.getOperation1();
                addedOperation2 = bestMapper.getOperation2();
                this.addedOperations.remove(addedOperation2);
                removedOperationIterator.remove();
                if (!(removedOperation.getName().equals(addedOperation2.getName()) || removedOperation.isConstructor() && addedOperation2.isConstructor())) {
                    Set<MethodInvocationReplacement> callReferences = this.getCallReferences(removedOperation, addedOperation2);
                    rename = new RenameOperationRefactoring(bestMapper, callReferences);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(bestMapper);
                this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
            }
        } else {
            Iterator addedOperationIterator = this.addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation removedOperation22;
                UMLOperation addedOperation3 = (UMLOperation)addedOperationIterator.next();
                mapperSet = new TreeSet();
                for (UMLOperation removedOperation22 : this.removedOperations) {
                    if (this.containsMapperForOperation1(removedOperation22) || this.containsMapperForOperation2(addedOperation3)) continue;
                    int maxDifferenceInPosition = removedOperation22.hasTestAnnotation() && addedOperation3.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation22, addedOperation3, maxDifferenceInPosition);
                    operationsInsideAnonymousClass = addedOperation3.getOperationsInsideAnonymousClass(this.addedAnonymousClasses);
                    for (UMLOperation operationInsideAnonymousClass : operationsInsideAnonymousClass) {
                        this.updateMapperSet(mapperSet, removedOperation22, operationInsideAnonymousClass, addedOperation3, maxDifferenceInPosition);
                    }
                    if (initialNumberOfRemovedOperations < 30 || initialNumberOfAddedOperations < 30 || mapperSet.size() <= 0 || !removedOperation22.getName().equals(addedOperation3.getName())) continue;
                    break;
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation22 = bestMapper.getOperation1();
                addedOperation3 = bestMapper.getOperation2();
                this.removedOperations.remove(removedOperation22);
                addedOperationIterator.remove();
                if (!(removedOperation22.getName().equals(addedOperation3.getName()) || removedOperation22.isConstructor() && addedOperation3.isConstructor())) {
                    Set<MethodInvocationReplacement> callReferences = this.getCallReferences(removedOperation22, addedOperation3);
                    rename = new RenameOperationRefactoring(bestMapper, callReferences);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(bestMapper);
                this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
            }
        }
        removedOperationIterator = this.removedOperations.iterator();
        while (removedOperationIterator.hasNext()) {
            removedOperation = (UMLOperation)removedOperationIterator.next();
            AbstractCall removedOperationInvocation = removedOperation.isDelegate();
            if (removedOperationInvocation == null) continue;
            Iterator addedOperationIterator = this.addedOperations.iterator();
            block7: while (addedOperationIterator.hasNext()) {
                addedOperation2 = (UMLOperation)addedOperationIterator.next();
                AbstractCall addedOperationInvocation = addedOperation2.isDelegate();
                if (addedOperationInvocation == null) continue;
                for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (!removedOperationInvocation.matchesOperation(mapper.getContainer1(), removedOperation, this.modelDiff) || !addedOperationInvocation.matchesOperation(mapper.getContainer2(), addedOperation2, this.modelDiff) || !removedOperation.getParameterTypeList().equals(addedOperation2.getParameterTypeList())) continue;
                    addedOperationIterator.remove();
                    removedOperationIterator.remove();
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation2);
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    if (removedOperation.getName().equals(addedOperation2.getName()) || removedOperation.isConstructor() && addedOperation2.isConstructor()) continue block7;
                    RenameOperationRefactoring rename2 = new RenameOperationRefactoring(removedOperation, addedOperation2);
                    this.refactorings.add(rename2);
                    continue block7;
                }
            }
        }
    }

    private Set<MethodInvocationReplacement> getCallReferences(UMLOperation removedOperation, UMLOperation addedOperation) {
        LinkedHashSet<MethodInvocationReplacement> callReferences = new LinkedHashSet<MethodInvocationReplacement>();
        for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
            UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
            if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this.modelDiff)) continue;
            callReferences.add(replacement);
        }
        return callReferences;
    }

    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> findConsistentMethodInvocationRenames() {
        HashMap<MethodInvocationReplacement, UMLOperationBodyMapper> map = new HashMap<MethodInvocationReplacement, UMLOperationBodyMapper>();
        LinkedHashSet allConsistentMethodInvocationRenames = new LinkedHashSet();
        LinkedHashSet allInconsistentMethodInvocationRenames = new LinkedHashSet();
        for (UMLOperationBodyMapper bodyMapper : this.operationBodyMapperList) {
            Set<MethodInvocationReplacement> methodInvocationRenames = bodyMapper.getMethodInvocationRenameReplacements();
            for (MethodInvocationReplacement replacement : methodInvocationRenames) {
                map.put(replacement, bodyMapper);
            }
            ConsistentReplacementDetector.updateRenames(allConsistentMethodInvocationRenames, allInconsistentMethodInvocationRenames, methodInvocationRenames);
        }
        map.keySet().removeAll(allInconsistentMethodInvocationRenames);
        return map;
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        int absoluteDifferenceInPosition;
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
        ArrayList<AbstractCodeMapping> totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0 || removedOperation.getName().equals(addedOperation.getName()) && removedOperation.getBody() != null && addedOperation.getBody() != null) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.exactMappings(operationBodyMapper)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition) && removedOperation.testMethodCheck(addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodExtracted(removedOperation, addedOperation) || this.isPartOfMethodMovedToExistingMethod(removedOperation, addedOperation)) && removedOperation.testMethodCheck(addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodInlined(removedOperation, addedOperation) || this.isPartOfMethodMovedFromExistingMethod(removedOperation, addedOperation)) && removedOperation.testMethodCheck(addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else {
                for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                    UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                    if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this.modelDiff)) continue;
                    mapperSet.add(operationBodyMapper);
                    break;
                }
            }
        } else {
            for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this.modelDiff)) continue;
                mapperSet.add(operationBodyMapper);
                break;
            }
            if (this.matchingGetterSetterWithSameRenamePattern(removedOperation, addedOperation) && this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation) <= differenceInPosition) {
                mapperSet.add(operationBodyMapper);
            }
        }
        if (totalMappings.size() > 0) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.singleUnmatchedStatementCallsAddedOperation(operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            }
        }
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation operationInsideAnonymousClass, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, operationInsideAnonymousClass, (UMLAbstractClassDiff)this);
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0) {
            int absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.exactMappings(operationBodyMapper)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodExtracted(removedOperation, addedOperation) || this.isPartOfMethodMovedToExistingMethod(removedOperation, addedOperation))) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodInlined(removedOperation, addedOperation) || this.isPartOfMethodMovedFromExistingMethod(removedOperation, addedOperation))) {
                mapperSet.add(operationBodyMapper);
            } else {
                for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                    UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                    if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this.modelDiff)) continue;
                    mapperSet.add(operationBodyMapper);
                    break;
                }
            }
        }
    }

    private boolean matchingGetterSetterWithSameRenamePattern(UMLOperation removedOperation, UMLOperation addedOperation) {
        block3: {
            String getPrefix;
            String setPrefix;
            block2: {
                setPrefix = "set";
                getPrefix = "get";
                if (!removedOperation.getName().startsWith(setPrefix) || !addedOperation.getName().startsWith(setPrefix)) break block2;
                String removedOperationSuffix = removedOperation.getName().substring(setPrefix.length());
                String addedOperationSuffix = addedOperation.getName().substring(setPrefix.length());
                for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (!mapper.getContainer1().getName().startsWith(getPrefix) || !mapper.getContainer2().getName().startsWith(getPrefix)) continue;
                    String container1Suffix = mapper.getContainer1().getName().substring(getPrefix.length());
                    String container2Suffix = mapper.getContainer2().getName().substring(getPrefix.length());
                    if (!container1Suffix.equals(removedOperationSuffix) || !container2Suffix.equals(addedOperationSuffix)) continue;
                    return true;
                }
                break block3;
            }
            if (!removedOperation.getName().startsWith(getPrefix) || !addedOperation.getName().startsWith(getPrefix)) break block3;
            String removedOperationSuffix = removedOperation.getName().substring(getPrefix.length());
            String addedOperationSuffix = addedOperation.getName().substring(getPrefix.length());
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (!mapper.getContainer1().getName().startsWith(setPrefix) || !mapper.getContainer2().getName().startsWith(setPrefix)) continue;
                String container1Suffix = mapper.getContainer1().getName().substring(setPrefix.length());
                String container2Suffix = mapper.getContainer2().getName().substring(setPrefix.length());
                if (!container1Suffix.equals(removedOperationSuffix) || !container2Suffix.equals(addedOperationSuffix)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean exactMappings(UMLOperationBodyMapper operationBodyMapper) {
        if (operationBodyMapper.allMappingsAreExactMatches()) {
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                return true;
            }
            if (operationBodyMapper.nonMappedElementsT1() > 0 && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                VariableDeclarationContainer addedOperation = operationBodyMapper.getContainer2();
                ArrayList<String> nonMappedLeavesT1 = new ArrayList<String>();
                for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!abstractCodeFragment.countableStatement()) continue;
                    nonMappedLeavesT1.add(abstractCodeFragment.getString());
                    for (String string : addedOperation.getParameterNameList()) {
                        if (abstractCodeFragment.getVariableDeclaration(string) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                int nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation = 0;
                for (UMLOperation operation : this.addedOperations) {
                    if (operation.equals(addedOperation) || operation.getBody() == null) continue;
                    for (AbstractCodeFragment statement : operation.getBody().getCompositeStatement().getLeaves()) {
                        if (!nonMappedLeavesT1.contains(statement.getString())) continue;
                        ++nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation;
                    }
                }
                return (countableStatements == parameterizedVariableDeclarationStatements || countableStatements == nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation + parameterizedVariableDeclarationStatements) && countableStatements > 0;
            }
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() > 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                VariableDeclarationContainer removedOperation = operationBodyMapper.getContainer1();
                for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statement.countableStatement()) continue;
                    for (String parameterName : removedOperation.getParameterNameList()) {
                        if (statement.getVariableDeclaration(parameterName) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                return countableStatements == parameterizedVariableDeclarationStatements && countableStatements > 0;
            }
            if ((operationBodyMapper.nonMappedElementsT1() == 1 || operationBodyMapper.nonMappedElementsT2() == 1) && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                AbstractCodeFragment statementUsingParameterAsInvoker1 = null;
                VariableDeclarationContainer removedOperation = operationBodyMapper.getContainer1();
                block6: for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statement.countableStatement()) continue;
                    for (String string : removedOperation.getParameterNameList()) {
                        AbstractCall invocation = statement.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker1 = statement;
                        continue block6;
                    }
                }
                AbstractCodeFragment statementUsingParameterAsInvoker2 = null;
                VariableDeclarationContainer addedOperation = operationBodyMapper.getContainer2();
                block8: for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!abstractCodeFragment.countableStatement()) continue;
                    for (String string : addedOperation.getParameterNameList()) {
                        AbstractCall invocation = abstractCodeFragment.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker2 = abstractCodeFragment;
                        continue block8;
                    }
                }
                if (statementUsingParameterAsInvoker1 != null && statementUsingParameterAsInvoker2 != null) {
                    for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
                        if (!(abstractCodeMapping.getFragment1() instanceof CompositeStatementObject) || !(abstractCodeMapping.getFragment2() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject parent1 = (CompositeStatementObject)abstractCodeMapping.getFragment1();
                        CompositeStatementObject compositeStatementObject = (CompositeStatementObject)abstractCodeMapping.getFragment2();
                        if (!parent1.getLeaves().contains(statementUsingParameterAsInvoker1) || !compositeStatementObject.getLeaves().contains(statementUsingParameterAsInvoker2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        List<CompositeReplacement> composites = operationBodyMapper.getCompositeReplacements();
        int additionallyMatchedStatements1 = 0;
        int additionallyMatchedStatements2 = 0;
        for (CompositeReplacement composite : composites) {
            additionallyMatchedStatements1 += composite.getAdditionallyMatchedStatements1().size();
            additionallyMatchedStatements2 += composite.getAdditionallyMatchedStatements2().size();
        }
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - additionallyMatchedStatements1;
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2() - additionallyMatchedStatements2;
        int exactMappings = operationBodyMapper.exactMatches();
        return (mappings += additionallyMatchedStatements1 + additionallyMatchedStatements2) > nonMappedElementsT1 && mappings > nonMappedElementsT2 || nonMappedElementsT1 == 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) || nonMappedElementsT1 == 0 && (double)exactMappings >= Math.floor((double)nonMappedElementsT2 / 2.0) || mappings == 1 && nonMappedElementsT1 + nonMappedElementsT2 == 1 && operationBodyMapper.getContainer1().getName().equals(operationBodyMapper.getContainer2().getName());
    }

    private boolean mappedElementsMoreThanNonMappedT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(this.addedOperations);
        int nonMappedElementsT2WithoutThoseCallingAddedOperation = nonMappedElementsT2 - nonMappedElementsT2CallingAddedOperation;
        return mappings > nonMappedElementsT2 || mappings >= nonMappedElementsT2WithoutThoseCallingAddedOperation && nonMappedElementsT2CallingAddedOperation >= nonMappedElementsT2WithoutThoseCallingAddedOperation || operationBodyMapper.getMappings().size() > nonMappedElementsT2 && nonMappedElementsT2CallingAddedOperation > 0 && operationBodyMapper.getContainer1().getClassName().equals(operationBodyMapper.getContainer2().getClassName());
    }

    private boolean mappedElementsMoreThanNonMappedT1(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT1CallingRemovedOperation = operationBodyMapper.nonMappedElementsT1CallingRemovedOperation(this.removedOperations);
        int nonMappedElementsT1WithoutThoseCallingRemovedOperation = nonMappedElementsT1 - nonMappedElementsT1CallingRemovedOperation;
        return mappings > nonMappedElementsT1 || mappings >= nonMappedElementsT1WithoutThoseCallingRemovedOperation && nonMappedElementsT1CallingRemovedOperation >= nonMappedElementsT1WithoutThoseCallingRemovedOperation;
    }

    private UMLOperationBodyMapper findBestMapper(TreeSet<UMLOperationBodyMapper> mapperSet) {
        ArrayList<UMLOperationBodyMapper> mapperList = new ArrayList<UMLOperationBodyMapper>(mapperSet);
        UMLOperationBodyMapper bestMapper = mapperSet.first();
        VariableDeclarationContainer bestMapperOperation1 = bestMapper.getContainer1();
        VariableDeclarationContainer bestMapperOperation2 = bestMapper.getContainer2();
        boolean identicalBodyWithOperation1OfTheBestMapper = this.identicalBodyWithAnotherAddedMethod(bestMapper);
        boolean identicalBodyWithOperation2OfTheBestMapper = this.identicalBodyWithAnotherRemovedMethod(bestMapper);
        if (this.equalSignatureWithCommonParameterTypes(bestMapperOperation1, bestMapperOperation2) && !identicalBodyWithOperation1OfTheBestMapper && !identicalBodyWithOperation2OfTheBestMapper) {
            return bestMapper;
        }
        for (int i = 1; i < mapperList.size(); ++i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperList.get(i);
            if (mapper.getMappings().size() <= 0) continue;
            VariableDeclarationContainer operation2 = mapper.getContainer2();
            List<AbstractCall> operationInvocations2 = operation2.getAllOperationInvocations();
            boolean anotherMapperCallsOperation2OfTheBestMapper = false;
            for (AbstractCall invocation : operationInvocations2) {
                if (!invocation.matchesOperation(bestMapper.getContainer2(), operation2, this.modelDiff) || invocation.matchesOperation(bestMapper.getContainer1(), operation2, this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.removedOperations)) continue;
                anotherMapperCallsOperation2OfTheBestMapper = true;
                break;
            }
            VariableDeclarationContainer operation1 = mapper.getContainer1();
            List<AbstractCall> operationInvocations1 = operation1.getAllOperationInvocations();
            boolean anotherMapperCallsOperation1OfTheBestMapper = false;
            for (AbstractCall invocation : operationInvocations1) {
                if (!invocation.matchesOperation(bestMapper.getContainer1(), operation1, this.modelDiff) || invocation.matchesOperation(bestMapper.getContainer2(), operation1, this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.addedOperations)) continue;
                anotherMapperCallsOperation1OfTheBestMapper = true;
                break;
            }
            boolean nextMapperMatchesConsistentRename = this.matchesConsistentMethodInvocationRename(mapper, this.consistentMethodInvocationRenames.keySet());
            boolean bestMapperMismatchesConsistentRename = this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames.keySet());
            if (bestMapperMismatchesConsistentRename && nextMapperMatchesConsistentRename) {
                return mapper;
            }
            if (!anotherMapperCallsOperation2OfTheBestMapper && !anotherMapperCallsOperation1OfTheBestMapper) continue;
            return mapper;
        }
        if (this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames.keySet()) && !this.exactMappings(bestMapper)) {
            return null;
        }
        if (identicalBodyWithOperation2OfTheBestMapper || identicalBodyWithOperation1OfTheBestMapper) {
            return null;
        }
        return bestMapper;
    }

    private boolean equalSignatureWithCommonParameterTypes(VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        return operation1.equalReturnParameter(operation2) && operation1.getName().equals(operation2.getName()) && operation1.commonParameterTypes(operation2).size() > 0;
    }

    private boolean identicalBodyWithAnotherAddedMethod(UMLOperationBodyMapper mapper) {
        VariableDeclarationContainer operation1 = mapper.getContainer1();
        List<String> stringRepresentation = operation1.stringRepresentation();
        if (stringRepresentation.size() > 3) {
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getContainer2().equals(addedOperation)) continue;
                OperationBody body = addedOperation.getBody();
                if (body != null && body.getBodyHashCode() == operation1.getBody().getBodyHashCode()) {
                    return true;
                }
                if (!this.equalSignatureWithCommonParameterTypes(operation1, addedOperation)) continue;
                ArrayList<String> commonStatements = new ArrayList<String>();
                List<String> addedOperationStringRepresentation = addedOperation.stringRepresentation();
                for (String statement : addedOperationStringRepresentation) {
                    if (statement.equals("{") || statement.equals("}") || statement.equals("try") || statement.startsWith("catch(") || statement.startsWith("case ") || statement.startsWith("default :") || statement.startsWith("return true;") || statement.startsWith("return false;") || statement.startsWith("return this;") || statement.startsWith("return null;") || statement.startsWith("return;") || !stringRepresentation.contains(statement)) continue;
                    commonStatements.add(statement);
                }
                if (commonStatements.size() <= mapper.exactMatches() * 2) continue;
                return true;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass addedClass : this.modelDiff.getAddedClasses()) {
                    for (UMLOperation addedOperation : addedClass.getOperations()) {
                        OperationBody body = addedOperation.getBody();
                        List<String> parameterNameList = addedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                        return true;
                    }
                }
            }
        } else if (stringRepresentation.size() == 3) {
            int counter = 0;
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getContainer2().equals(addedOperation)) continue;
                OperationBody body = addedOperation.getBody();
                List<String> parameterNameList = addedOperation.getParameterNameList();
                if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                ++counter;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass addedClass : this.modelDiff.getAddedClasses()) {
                    for (UMLOperation addedOperation : addedClass.getOperations()) {
                        OperationBody body = addedOperation.getBody();
                        List<String> parameterNameList = addedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                        ++counter;
                    }
                }
            }
            if (counter == 1 && !this.existingMapperWithIdenticalMapping(stringRepresentation.get(1))) {
                return true;
            }
        }
        return false;
    }

    private boolean identicalBodyWithAnotherRemovedMethod(UMLOperationBodyMapper mapper) {
        VariableDeclarationContainer operation2 = mapper.getContainer2();
        List<String> stringRepresentation = operation2.stringRepresentation();
        if (stringRepresentation.size() > 3) {
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getContainer1().equals(removedOperation)) continue;
                OperationBody body = removedOperation.getBody();
                if (body != null && body.getBodyHashCode() == operation2.getBody().getBodyHashCode()) {
                    return true;
                }
                if (!this.equalSignatureWithCommonParameterTypes(removedOperation, operation2)) continue;
                ArrayList<String> commonStatements = new ArrayList<String>();
                List<String> removedOperationStringRepresentation = removedOperation.stringRepresentation();
                for (String statement : removedOperationStringRepresentation) {
                    if (statement.equals("{") || statement.equals("}") || statement.equals("try") || statement.startsWith("catch(") || statement.startsWith("case ") || statement.startsWith("default :") || statement.startsWith("return true;") || statement.startsWith("return false;") || statement.startsWith("return this;") || statement.startsWith("return null;") || statement.startsWith("return;") || !stringRepresentation.contains(statement)) continue;
                    commonStatements.add(statement);
                }
                if (commonStatements.size() <= mapper.exactMatches() * 2) continue;
                return true;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass removedClass : this.modelDiff.getRemovedClasses()) {
                    for (UMLOperation removedOperation : removedClass.getOperations()) {
                        OperationBody body = removedOperation.getBody();
                        List<String> parameterNameList = removedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                        return true;
                    }
                }
            }
        } else if (stringRepresentation.size() == 3) {
            int counter = 0;
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getContainer1().equals(removedOperation)) continue;
                OperationBody body = removedOperation.getBody();
                List<String> parameterNameList = removedOperation.getParameterNameList();
                if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                ++counter;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass removedClass : this.modelDiff.getRemovedClasses()) {
                    for (UMLOperation removedOperation : removedClass.getOperations()) {
                        OperationBody body = removedOperation.getBody();
                        List<String> parameterNameList = removedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                        ++counter;
                    }
                }
            }
            if (counter == 1 && !this.existingMapperWithIdenticalMapping(stringRepresentation.get(1))) {
                return true;
            }
        }
        return false;
    }

    private boolean existingMapperWithIdenticalMapping(String stringRepresentation) {
        for (int i = this.operationBodyMapperList.size() - 1; i >= 0; --i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)this.operationBodyMapperList.get(i);
            for (AbstractCodeMapping mapping : mapper.getExactMatches()) {
                if (!mapping.getFragment1().getString().equals(stringRepresentation) && !mapping.getFragment2().getString().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (!mapper.getContainer1().getName().equals(rename.getBefore()) || !mapper.getContainer2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean mismatchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (mapper.getContainer1().getName().equals(rename.getBefore()) && !mapper.getContainer2().getName().equals(rename.getAfter())) {
                return true;
            }
            if (mapper.getContainer1().getName().equals(rename.getBefore()) || !mapper.getContainer2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean operationContainsMethodInvocationWithTheSameNameAndCommonArguments(AbstractCall invocation, List<UMLOperation> operations) {
        for (UMLOperation operation : operations) {
            List<AbstractCall> operationInvocations = operation.getAllOperationInvocations();
            for (AbstractCall operationInvocation : operationInvocations) {
                LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(operationInvocation.getArguments());
                argumentIntersection.retainAll(invocation.getArguments());
                if (operationInvocation.getName().equals(invocation.getName()) && !argumentIntersection.isEmpty()) {
                    return true;
                }
                if (argumentIntersection.size() <= 0 || argumentIntersection.size() != invocation.getArguments().size()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean singleUnmatchedStatementCallsAddedOperation(UMLOperationBodyMapper operationBodyMapper) {
        AbstractCodeFragment statementT2;
        AbstractCall invocationT2;
        List<AbstractCodeFragment> nonMappedLeavesT1 = operationBodyMapper.getNonMappedLeavesT1();
        List<AbstractCodeFragment> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        if (nonMappedLeavesT1.size() == 1 && nonMappedLeavesT2.size() == 1 && (invocationT2 = (statementT2 = nonMappedLeavesT2.get(0)).invocationCoveringEntireFragment()) != null) {
            for (UMLOperation addedOperation : this.addedOperations) {
                AbstractCodeFragment statementT1;
                AbstractCall invocationT1;
                if (!invocationT2.matchesOperation(addedOperation, operationBodyMapper.getContainer2(), this.modelDiff) || (invocationT1 = (statementT1 = nonMappedLeavesT1.get(0)).invocationCoveringEntireFragment()) == null || !addedOperation.getAllOperationInvocations().contains(invocationT1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compatibleSignatures(UMLOperation removedOperation, UMLOperation addedOperation, int absoluteDifferenceInPosition) {
        if (addedOperation.compatibleSignature(removedOperation)) {
            return true;
        }
        if ((absoluteDifferenceInPosition == 0 || this.operationsBeforeAndAfterMatch(removedOperation, addedOperation)) && !this.gettersWithDifferentReturnType(removedOperation, addedOperation)) {
            if (addedOperation.getParameterTypeList().equals(removedOperation.getParameterTypeList()) || addedOperation.normalizedNameDistance(removedOperation) <= 0.4) {
                return true;
            }
            if (addedOperation.hasTestAnnotation() && removedOperation.hasTestAnnotation()) {
                return true;
            }
        }
        return false;
    }

    private boolean gettersWithDifferentReturnType(UMLOperation removedOperation, UMLOperation addedOperation) {
        if (removedOperation.isGetter() && addedOperation.isGetter()) {
            UMLType type1 = removedOperation.getReturnParameter().getType();
            UMLType type2 = addedOperation.getReturnParameter().getType();
            if (!removedOperation.equalReturnParameter(addedOperation) && !type1.compatibleTypes(type2)) {
                return true;
            }
        }
        return false;
    }

    private boolean operationsBeforeAndAfterMatch(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLOperation operationBefore1 = null;
        UMLOperation operationAfter1 = null;
        List<UMLOperation> originalClassOperations = this.originalClass.getOperations();
        for (int i = 0; i < originalClassOperations.size(); ++i) {
            UMLOperation current = originalClassOperations.get(i);
            if (!current.equals(removedOperation)) continue;
            if (i > 0) {
                operationBefore1 = originalClassOperations.get(i - 1);
            }
            if (i >= originalClassOperations.size() - 1) continue;
            operationAfter1 = originalClassOperations.get(i + 1);
        }
        UMLOperation operationBefore2 = null;
        UMLOperation operationAfter2 = null;
        List<UMLOperation> nextClassOperations = this.nextClass.getOperations();
        for (int i = 0; i < nextClassOperations.size(); ++i) {
            UMLOperation current = nextClassOperations.get(i);
            if (!current.equals(addedOperation)) continue;
            if (i > 0) {
                operationBefore2 = nextClassOperations.get(i - 1);
            }
            if (i >= nextClassOperations.size() - 1) continue;
            operationAfter2 = nextClassOperations.get(i + 1);
        }
        boolean operationsBeforeMatch = false;
        if (operationBefore1 != null && operationBefore2 != null) {
            operationsBeforeMatch = operationBefore1.equalReturnParameter(operationBefore2) && operationBefore1.equalParameterTypes(operationBefore2) && operationBefore1.getName().equals(operationBefore2.getName()) || this.matchingDataProviderAnnotation(removedOperation, operationBefore1) && this.matchingDataProviderAnnotation(addedOperation, operationBefore2);
        } else if (operationBefore1 == null && operationBefore2 == null) {
            operationsBeforeMatch = true;
        }
        boolean operationsAfterMatch = false;
        if (operationAfter1 != null && operationAfter2 != null) {
            operationsAfterMatch = operationAfter1.equalReturnParameter(operationAfter2) && operationAfter1.equalParameterTypes(operationAfter2) && operationAfter1.getName().equals(operationAfter2.getName()) || this.matchingDataProviderAnnotation(removedOperation, operationAfter1) && this.matchingDataProviderAnnotation(addedOperation, operationAfter2);
        } else if (operationAfter1 == null && operationAfter2 == null) {
            operationsAfterMatch = true;
        }
        return operationsBeforeMatch || operationsAfterMatch;
    }

    private boolean matchingDataProviderAnnotation(UMLOperation operation1, UMLOperation operation2) {
        Map<String, AbstractExpression> dataProviderMemberValuePairs;
        Map<String, AbstractExpression> testMemberValuePairs;
        UMLAnnotation testAnnotation = null;
        UMLAnnotation dataProviderAnnotation = null;
        if (operation1.hasTestAnnotation() && operation2.hasDataProviderAnnotation()) {
            List<UMLAnnotation> annotations1 = operation1.getAnnotations();
            for (UMLAnnotation uMLAnnotation : annotations1) {
                if (!uMLAnnotation.getTypeName().equals("Test")) continue;
                testAnnotation = uMLAnnotation;
                break;
            }
            List<UMLAnnotation> annotations2 = operation2.getAnnotations();
            Iterator iterator = annotations2.iterator();
            while (iterator.hasNext()) {
                UMLAnnotation annotation2 = (UMLAnnotation)iterator.next();
                if (!annotation2.getTypeName().equals("DataProvider")) continue;
                dataProviderAnnotation = annotation2;
                break;
            }
        } else if (operation2.hasTestAnnotation() && operation1.hasDataProviderAnnotation()) {
            List<UMLAnnotation> annotations2 = operation2.getAnnotations();
            for (UMLAnnotation uMLAnnotation : annotations2) {
                if (!uMLAnnotation.getTypeName().equals("Test")) continue;
                testAnnotation = uMLAnnotation;
                break;
            }
            List<UMLAnnotation> annotations1 = operation1.getAnnotations();
            for (UMLAnnotation annotation1 : annotations1) {
                if (!annotation1.getTypeName().equals("DataProvider")) continue;
                dataProviderAnnotation = annotation1;
                break;
            }
        }
        if (testAnnotation != null && dataProviderAnnotation != null && (testMemberValuePairs = testAnnotation.getMemberValuePairs()).containsKey("dataProvider") && (dataProviderMemberValuePairs = dataProviderAnnotation.getMemberValuePairs()).containsKey("name")) {
            return testMemberValuePairs.get("dataProvider").getExpression().equals(dataProviderMemberValuePairs.get("name").getExpression());
        }
        return false;
    }

    private void checkForInlinedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperationBodyMapper> inlinedOperationMappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                InlineOperationDetection detection = new InlineOperationDetection(mapper, this.removedOperations, this, this.modelDiff);
                List<InlineOperationRefactoring> refs = detection.check(removedOperation);
                for (InlineOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    inlinedOperationMappers.add(operationBodyMapper);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(removedOperation);
                }
            }
        }
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            this.optimizeDuplicateMappingsForInline(mapper);
        }
        for (UMLOperationBodyMapper operationBodyMapper : inlinedOperationMappers) {
            this.processMapperRefactorings(operationBodyMapper, this.refactorings);
        }
        this.removedOperations.removeAll(operationsToBeRemoved);
    }

    private void optimizeDuplicateMappingsForInline(UMLOperationBodyMapper parentMapper) {
        if (parentMapper.getChildMappers().size() > 1) {
            List mappers;
            Set mappings;
            HashMap oneToManyMappings = new HashMap();
            HashMap oneToManyMappers = new HashMap();
            for (UMLOperationBodyMapper childMapper : parentMapper.getChildMappers()) {
                for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                    if (oneToManyMappings.containsKey(mapping.getFragment2())) {
                        ((Set)oneToManyMappings.get(mapping.getFragment2())).add(mapping);
                        ((List)oneToManyMappers.get(mapping.getFragment2())).add(childMapper);
                        continue;
                    }
                    mappings = new LinkedHashSet<AbstractCodeMapping>();
                    mappers = new ArrayList<UMLOperationBodyMapper>();
                    mappings.add(mapping);
                    mappers.add(childMapper);
                    oneToManyMappings.put(mapping.getFragment2(), mappings);
                    oneToManyMappers.put(mapping.getFragment2(), mappers);
                }
            }
            for (AbstractCodeFragment fragment : oneToManyMappers.keySet()) {
                if (((Set)oneToManyMappings.get(fragment)).size() != 1) continue;
                oneToManyMappings.remove(fragment);
            }
            TreeSet<AbstractCodeFragment> sortedKeys = new TreeSet<AbstractCodeFragment>(new CodeFragmentComparator());
            sortedKeys.addAll(oneToManyMappings.keySet());
            LinkedHashSet<UMLOperationBodyMapper> updatedMappers = new LinkedHashSet<UMLOperationBodyMapper>();
            for (AbstractCodeFragment fragment : sortedKeys) {
                mappings = (Set)oneToManyMappings.get(fragment);
                mappers = (List)oneToManyMappers.get(fragment);
                Iterator mappingIterator = mappings.iterator();
                Iterator mapperIterator = mappers.iterator();
                ArrayList<Boolean> parentMappingFound = new ArrayList<Boolean>();
                ArrayList<Boolean> parentIsContainerBody = new ArrayList<Boolean>();
                ArrayList<Boolean> identical = new ArrayList<Boolean>();
                while (mappingIterator.hasNext()) {
                    AbstractCodeMapping mapping = (AbstractCodeMapping)mappingIterator.next();
                    UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperIterator.next();
                    parentMappingFound.add(mapper.containsParentMapping(mapping));
                    parentIsContainerBody.add(mapper.parentIsContainerBody(mapping));
                    identical.add(mapping.getFragment1().getString().equals(mapping.getFragment2().getString()));
                }
                LinkedHashSet<Integer> indicesToBeRemoved = new LinkedHashSet<Integer>();
                if (parentMappingFound.contains(true)) {
                    int i;
                    for (i = 0; i < parentMappingFound.size(); ++i) {
                        if (((Boolean)parentMappingFound.get(i)).booleanValue()) continue;
                        indicesToBeRemoved.add(i);
                    }
                    if (indicesToBeRemoved.isEmpty() && identical.contains(true)) {
                        for (i = 0; i < identical.size(); ++i) {
                            if (((Boolean)identical.get(i)).booleanValue()) continue;
                            indicesToBeRemoved.add(i);
                        }
                    }
                } else if (parentIsContainerBody.contains(true)) {
                    int i;
                    for (i = 0; i < parentIsContainerBody.size(); ++i) {
                        if (((Boolean)parentIsContainerBody.get(i)).booleanValue()) continue;
                        indicesToBeRemoved.add(i);
                    }
                    if (indicesToBeRemoved.isEmpty() && identical.contains(true)) {
                        for (i = 0; i < identical.size(); ++i) {
                            if (((Boolean)identical.get(i)).booleanValue()) continue;
                            indicesToBeRemoved.add(i);
                        }
                    }
                }
                mappingIterator = mappings.iterator();
                mapperIterator = mappers.iterator();
                int index = 0;
                while (mappingIterator.hasNext()) {
                    AbstractCodeMapping mapping = (AbstractCodeMapping)mappingIterator.next();
                    UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperIterator.next();
                    if (indicesToBeRemoved.contains(index)) {
                        mapper.removeMapping(mapping);
                        LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                        Set<Refactoring> refactoringsAfterPostProcessing = mapper.getRefactoringsAfterPostProcessing();
                        for (Refactoring r : refactoringsAfterPostProcessing) {
                            ReferenceBasedRefactoring referenceBased;
                            Set<AbstractCodeMapping> references;
                            if (!(r instanceof ReferenceBasedRefactoring) || !(references = (referenceBased = (ReferenceBasedRefactoring)((Object)r)).getReferences()).contains(mapping)) continue;
                            refactoringsToBeRemoved.add(r);
                        }
                        refactoringsAfterPostProcessing.removeAll(refactoringsToBeRemoved);
                        updatedMappers.add(mapper);
                    }
                    ++index;
                }
            }
            LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
            for (Refactoring ref : this.refactorings) {
                Refactoring refactoring;
                if (ref instanceof InlineOperationRefactoring) {
                    refactoring = (InlineOperationRefactoring)ref;
                    if (!updatedMappers.contains(((InlineOperationRefactoring)refactoring).getBodyMapper())) continue;
                    if (((InlineOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                        refactoringsToBeRemoved.add(refactoring);
                        continue;
                    }
                    ((InlineOperationRefactoring)refactoring).updateMapperInfo();
                    continue;
                }
                if (!(ref instanceof ExtractOperationRefactoring) || !updatedMappers.contains(((ExtractOperationRefactoring)(refactoring = (ExtractOperationRefactoring)ref)).getBodyMapper())) continue;
                if (((ExtractOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                    refactoringsToBeRemoved.add(refactoring);
                    continue;
                }
                ((ExtractOperationRefactoring)refactoring).updateMapperInfo();
            }
            this.refactorings.removeAll(refactoringsToBeRemoved);
        }
    }

    private void checkForExtractedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperationBodyMapper> extractedOperationMappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLOperation addedOperation : this.addedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                ExtractOperationDetection detection = new ExtractOperationDetection(mapper, this.addedOperations, this, this.modelDiff);
                List<ExtractOperationRefactoring> refs = detection.check(addedOperation);
                for (ExtractOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    extractedOperationMappers.add(operationBodyMapper);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(addedOperation);
                }
            }
        }
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            this.optimizeDuplicateMappingsForExtract(mapper);
        }
        for (UMLOperationBodyMapper operationBodyMapper : extractedOperationMappers) {
            this.processMapperRefactorings(operationBodyMapper, this.refactorings);
        }
        this.addedOperations.removeAll(operationsToBeRemoved);
    }

    private void optimizeDuplicateMappingsForExtract(UMLOperationBodyMapper parentMapper) {
        if (parentMapper.getChildMappers().size() > 1) {
            List mappers;
            Set mappings;
            HashMap oneToManyMappings = new HashMap();
            HashMap oneToManyMappers = new HashMap();
            for (UMLOperationBodyMapper childMapper : parentMapper.getChildMappers()) {
                for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                    if (oneToManyMappings.containsKey(mapping.getFragment1())) {
                        ((Set)oneToManyMappings.get(mapping.getFragment1())).add(mapping);
                        ((List)oneToManyMappers.get(mapping.getFragment1())).add(childMapper);
                        continue;
                    }
                    mappings = new LinkedHashSet<AbstractCodeMapping>();
                    mappers = new ArrayList<UMLOperationBodyMapper>();
                    mappings.add(mapping);
                    mappers.add(childMapper);
                    oneToManyMappings.put(mapping.getFragment1(), mappings);
                    oneToManyMappers.put(mapping.getFragment1(), mappers);
                }
            }
            for (AbstractCodeFragment fragment : oneToManyMappers.keySet()) {
                if (((Set)oneToManyMappings.get(fragment)).size() != 1) continue;
                oneToManyMappings.remove(fragment);
            }
            TreeSet<AbstractCodeFragment> sortedKeys = new TreeSet<AbstractCodeFragment>(new CodeFragmentComparator());
            sortedKeys.addAll(oneToManyMappings.keySet());
            LinkedHashSet<UMLOperationBodyMapper> updatedMappers = new LinkedHashSet<UMLOperationBodyMapper>();
            for (AbstractCodeFragment fragment : sortedKeys) {
                mappings = (Set)oneToManyMappings.get(fragment);
                mappers = (List)oneToManyMappers.get(fragment);
                Iterator mappingIterator = mappings.iterator();
                Iterator mapperIterator = mappers.iterator();
                ArrayList<Boolean> parentMappingFound = new ArrayList<Boolean>();
                ArrayList<Boolean> parentIsContainerBody = new ArrayList<Boolean>();
                ArrayList<Boolean> nestedMapper = new ArrayList<Boolean>();
                ArrayList<Boolean> identical = new ArrayList<Boolean>();
                while (mappingIterator.hasNext()) {
                    AbstractCodeMapping mapping = (AbstractCodeMapping)mappingIterator.next();
                    UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperIterator.next();
                    parentMappingFound.add(mapper.containsParentMapping(mapping));
                    parentIsContainerBody.add(mapper.parentIsContainerBody(mapping));
                    nestedMapper.add(mapper.isNested());
                    identical.add(mapping.getFragment1().getString().equals(mapping.getFragment2().getString()));
                }
                LinkedHashSet<Integer> indicesToBeRemoved = new LinkedHashSet<Integer>();
                if (parentMappingFound.contains(true)) {
                    int i;
                    for (i = 0; i < parentMappingFound.size(); ++i) {
                        if (((Boolean)parentMappingFound.get(i)).booleanValue()) continue;
                        indicesToBeRemoved.add(i);
                    }
                    if (indicesToBeRemoved.isEmpty()) {
                        if (nestedMapper.contains(false)) {
                            for (i = 0; i < nestedMapper.size(); ++i) {
                                if (!((Boolean)nestedMapper.get(i)).booleanValue()) continue;
                                indicesToBeRemoved.add(i);
                            }
                        }
                        if (identical.contains(true)) {
                            for (i = 0; i < identical.size(); ++i) {
                                if (((Boolean)identical.get(i)).booleanValue()) continue;
                                indicesToBeRemoved.add(i);
                            }
                        }
                    }
                } else if (parentIsContainerBody.contains(true)) {
                    int i;
                    for (i = 0; i < parentIsContainerBody.size(); ++i) {
                        if (((Boolean)parentIsContainerBody.get(i)).booleanValue()) continue;
                        indicesToBeRemoved.add(i);
                    }
                    if (indicesToBeRemoved.isEmpty()) {
                        if (nestedMapper.contains(false)) {
                            for (i = 0; i < nestedMapper.size(); ++i) {
                                if (!((Boolean)nestedMapper.get(i)).booleanValue()) continue;
                                indicesToBeRemoved.add(i);
                            }
                        }
                        if (identical.contains(true)) {
                            for (i = 0; i < identical.size(); ++i) {
                                if (((Boolean)identical.get(i)).booleanValue()) continue;
                                indicesToBeRemoved.add(i);
                            }
                        }
                    }
                }
                mappingIterator = mappings.iterator();
                mapperIterator = mappers.iterator();
                int index = 0;
                while (mappingIterator.hasNext()) {
                    AbstractCodeMapping mapping = (AbstractCodeMapping)mappingIterator.next();
                    UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperIterator.next();
                    if (indicesToBeRemoved.contains(index)) {
                        mapper.removeMapping(mapping);
                        LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                        Set<Refactoring> refactoringsAfterPostProcessing = mapper.getRefactoringsAfterPostProcessing();
                        for (Refactoring r : refactoringsAfterPostProcessing) {
                            ReferenceBasedRefactoring referenceBased;
                            Set<AbstractCodeMapping> references;
                            if (!(r instanceof ReferenceBasedRefactoring) || !(references = (referenceBased = (ReferenceBasedRefactoring)((Object)r)).getReferences()).contains(mapping)) continue;
                            refactoringsToBeRemoved.add(r);
                        }
                        refactoringsAfterPostProcessing.removeAll(refactoringsToBeRemoved);
                        updatedMappers.add(mapper);
                    }
                    ++index;
                }
            }
            LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
            for (Refactoring ref : this.refactorings) {
                Refactoring refactoring;
                if (ref instanceof ExtractOperationRefactoring) {
                    refactoring = (ExtractOperationRefactoring)ref;
                    if (!updatedMappers.contains(((ExtractOperationRefactoring)refactoring).getBodyMapper())) continue;
                    if (((ExtractOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                        refactoringsToBeRemoved.add(refactoring);
                        continue;
                    }
                    ((ExtractOperationRefactoring)refactoring).updateMapperInfo();
                    continue;
                }
                if (!(ref instanceof InlineOperationRefactoring) || !updatedMappers.contains(((InlineOperationRefactoring)(refactoring = (InlineOperationRefactoring)ref)).getBodyMapper())) continue;
                if (((InlineOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                    refactoringsToBeRemoved.add(refactoring);
                    continue;
                }
                ((InlineOperationRefactoring)refactoring).updateMapperInfo();
            }
            this.refactorings.removeAll(refactoringsToBeRemoved);
        }
    }

    public boolean isEmpty() {
        return this.addedOperations.isEmpty() && this.removedOperations.isEmpty() && this.addedAttributes.isEmpty() && this.removedAttributes.isEmpty() && this.addedEnumConstants.isEmpty() && this.removedEnumConstants.isEmpty() && this.attributeDiffList.isEmpty() && this.operationBodyMapperList.isEmpty() && this.enumConstantDiffList.isEmpty() && this.annotationListDiff.isEmpty() && this.typeParameterDiffList.isEmpty() && !this.visibilityChanged && !this.abstractionChanged && !this.finalChanged && !this.staticChanged && !this.superclassChanged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.originalClass.getName()).append(":").append("\n");
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from " + this.oldVisibility + " to " + this.newVisibility).append("\n");
        }
        if (this.abstractionChanged) {
            sb.append("\t").append("abstraction changed from " + (this.oldAbstraction ? "abstract" : "concrete") + " to " + (this.newAbstraction ? "abstract" : "concrete")).append("\n");
        }
        Collections.sort(this.removedOperations);
        for (UMLOperation umlOperation : this.removedOperations) {
            sb.append("operation " + umlOperation + " removed").append("\n");
        }
        Collections.sort(this.addedOperations);
        for (UMLOperation umlOperation : this.addedOperations) {
            sb.append("operation " + umlOperation + " added").append("\n");
        }
        Collections.sort(this.removedAttributes);
        for (UMLAttribute umlAttribute : this.removedAttributes) {
            sb.append("attribute " + umlAttribute + " removed").append("\n");
        }
        Collections.sort(this.addedAttributes);
        for (UMLAttribute umlAttribute : this.addedAttributes) {
            sb.append("attribute " + umlAttribute + " added").append("\n");
        }
        for (UMLAttributeDiff attributeDiff : this.attributeDiffList) {
            sb.append(attributeDiff);
        }
        Collections.sort(this.operationBodyMapperList);
        for (UMLOperationBodyMapper operationBodyMapper : this.operationBodyMapperList) {
            sb.append(operationBodyMapper).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLClassBaseDiff other) {
        if (!this.originalClass.getName().equals(other.originalClass.getName())) {
            return this.originalClass.getName().compareTo(other.originalClass.getName());
        }
        return this.nextClass.getName().compareTo(other.nextClass.getName());
    }

    public boolean samePackage() {
        return this.originalClass.getPackageName().equals(this.nextClass.getPackageName());
    }
}

