/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.diff.AddAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.ModifyAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import java.util.LinkedHashSet;
import java.util.Set;
import org.refactoringminer.api.Refactoring;

public class UMLEnumConstantDiff {
    private UMLEnumConstant removedEnumConstant;
    private UMLEnumConstant addedEnumConstant;
    private boolean renamed;
    private UMLAnnotationListDiff annotationListDiff;

    public UMLEnumConstantDiff(UMLEnumConstant removedEnumConstant, UMLEnumConstant addedEnumConstant) {
        this.removedEnumConstant = removedEnumConstant;
        this.addedEnumConstant = addedEnumConstant;
        if (!removedEnumConstant.getName().equals(addedEnumConstant.getName())) {
            this.renamed = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedEnumConstant.getAnnotations(), addedEnumConstant.getAnnotations());
    }

    public UMLEnumConstant getRemovedEnumConstant() {
        return this.removedEnumConstant;
    }

    public UMLEnumConstant getAddedEnumConstant() {
        return this.addedEnumConstant;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isEmpty() {
        return !this.renamed && this.annotationListDiff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedEnumConstant).append("\n");
        }
        if (this.renamed) {
            sb.append("\t").append("renamed from " + this.removedEnumConstant.getName() + " to " + this.addedEnumConstant.getName()).append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    private Set<Refactoring> getAnnotationRefactorings() {
        Refactoring refactoring;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddAttributeAnnotationRefactoring(annotation, this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveAttributeAnnotationRefactoring(annotation, this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyAttributeAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        return refactorings;
    }

    public Set<Refactoring> getRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        refactorings.addAll(this.getAnnotationRefactorings());
        return refactorings;
    }
}

