/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class UMLImportListDiff {
    private Set<String> removedImports;
    private Set<String> addedImports;
    private Set<String> commonImports;
    private Set<Pair<String, String>> changedImports = new LinkedHashSet<Pair<String, String>>();
    private Map<Set<String>, String> groupedImports;
    private Map<String, Set<String>> unGroupedImports;

    public UMLImportListDiff(List<String> oldImports, List<String> newImports) {
        LinkedHashSet<String> oldImportSet = new LinkedHashSet<String>(oldImports);
        LinkedHashSet<String> newImportSet = new LinkedHashSet<String>(newImports);
        LinkedHashSet<String> intersection = new LinkedHashSet<String>();
        intersection.addAll(oldImportSet);
        intersection.retainAll(newImportSet);
        this.commonImports = intersection;
        oldImportSet.removeAll(intersection);
        this.removedImports = oldImportSet;
        newImportSet.removeAll(intersection);
        this.addedImports = newImportSet;
        this.groupedImports = new HashMap<Set<String>, String>();
        Map<String, Set<String>> groupedRemovedImportsByPrefix = this.groupImportsByPrefix(this.removedImports);
        for (String key : groupedRemovedImportsByPrefix.keySet()) {
            if (!this.addedImports.contains(key)) continue;
            Set<String> value = groupedRemovedImportsByPrefix.get(key);
            this.groupedImports.put(value, key);
            this.addedImports.remove(key);
            this.removedImports.removeAll(value);
        }
        this.unGroupedImports = new HashMap<String, Set<String>>();
        Map<String, Set<String>> groupedAddedImportsByPrefix = this.groupImportsByPrefix(this.addedImports);
        for (String key : groupedAddedImportsByPrefix.keySet()) {
            if (!this.removedImports.contains(key)) continue;
            Set<String> value = groupedAddedImportsByPrefix.get(key);
            this.unGroupedImports.put(key, value);
            this.removedImports.remove(key);
            this.addedImports.removeAll(value);
        }
    }

    private Map<String, Set<String>> groupImportsByPrefix(Set<String> imports) {
        HashMap<String, Set<String>> groupedImportsByPrefix = new HashMap<String, Set<String>>();
        for (String importString : imports) {
            if (!importString.contains(".")) continue;
            String prefix = importString.substring(0, importString.lastIndexOf("."));
            if (groupedImportsByPrefix.containsKey(prefix)) {
                ((Set)groupedImportsByPrefix.get(prefix)).add(importString);
                continue;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(importString);
            groupedImportsByPrefix.put(prefix, set);
        }
        return groupedImportsByPrefix;
    }

    public void findImportChanges(String nameBefore, String nameAfter) {
        if (this.removedImports.contains(nameBefore) && this.addedImports.contains(nameAfter)) {
            Pair pair = Pair.of((Object)nameBefore, (Object)nameAfter);
            this.changedImports.add((Pair<String, String>)pair);
            this.removedImports.remove(nameBefore);
            this.addedImports.remove(nameAfter);
        }
        LinkedHashSet<String> matchedRemovedStaticImports = new LinkedHashSet<String>();
        for (String removedImport : this.removedImports) {
            if (!removedImport.startsWith(nameBefore + ".")) continue;
            matchedRemovedStaticImports.add(removedImport);
        }
        LinkedHashSet<String> matchedAddedStaticImports = new LinkedHashSet<String>();
        for (String addedImport : this.addedImports) {
            if (!addedImport.startsWith(nameAfter + ".")) continue;
            matchedAddedStaticImports.add(addedImport);
        }
        block2: for (String removedImport : matchedRemovedStaticImports) {
            for (String addedImport : matchedAddedStaticImports) {
                String suffix2;
                String suffix1 = removedImport.substring(nameBefore.length());
                if (!suffix1.equals(suffix2 = addedImport.substring(nameAfter.length()))) continue;
                Pair pair = Pair.of((Object)removedImport, (Object)addedImport);
                this.changedImports.add((Pair<String, String>)pair);
                this.removedImports.remove(removedImport);
                this.addedImports.remove(addedImport);
                continue block2;
            }
        }
    }

    public Set<String> getRemovedImports() {
        return this.removedImports;
    }

    public Set<String> getAddedImports() {
        return this.addedImports;
    }

    public Set<String> getCommonImports() {
        return this.commonImports;
    }

    public Set<Pair<String, String>> getChangedImports() {
        return this.changedImports;
    }

    public Map<Set<String>, String> getGroupedImports() {
        return this.groupedImports;
    }

    public Map<String, Set<String>> getUnGroupedImports() {
        return this.unGroupedImports;
    }
}

