/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReferenceExtractor;
import gr.uom.java.xmi.diff.AddMethodAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddMethodModifierRefactoring;
import gr.uom.java.xmi.diff.AddParameterRefactoring;
import gr.uom.java.xmi.diff.AddThrownExceptionTypeRefactoring;
import gr.uom.java.xmi.diff.ChangeOperationAccessModifierRefactoring;
import gr.uom.java.xmi.diff.ChangeReturnTypeRefactoring;
import gr.uom.java.xmi.diff.ChangeThrownExceptionTypeRefactoring;
import gr.uom.java.xmi.diff.ChangeVariableTypeRefactoring;
import gr.uom.java.xmi.diff.MergeVariableRefactoring;
import gr.uom.java.xmi.diff.ModifyMethodAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveMethodAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveMethodModifierRefactoring;
import gr.uom.java.xmi.diff.RemoveParameterRefactoring;
import gr.uom.java.xmi.diff.RemoveThrownExceptionTypeRefactoring;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.ReorderParameterRefactoring;
import gr.uom.java.xmi.diff.SplitVariableRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLParameterDiff;
import gr.uom.java.xmi.diff.UMLTypeParameterListDiff;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.Refactoring;

public class UMLOperationDiff {
    private UMLOperation removedOperation;
    private UMLOperation addedOperation;
    private List<UMLParameter> addedParameters;
    private List<UMLParameter> removedParameters;
    private List<UMLParameterDiff> parameterDiffList;
    private boolean visibilityChanged;
    private boolean abstractionChanged;
    private boolean finalChanged;
    private boolean staticChanged;
    private boolean synchronizedChanged;
    private boolean returnTypeChanged;
    private boolean qualifiedReturnTypeChanged;
    private boolean operationRenamed;
    private boolean parametersReordered;
    private Set<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();
    private Set<Pair<VariableDeclaration, VariableDeclaration>> matchedVariables = new LinkedHashSet<Pair<VariableDeclaration, VariableDeclaration>>();
    private Set<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
    private UMLAbstractClassDiff classDiff;
    private UMLAnnotationListDiff annotationListDiff;
    private UMLTypeParameterListDiff typeParameterListDiff;
    private List<UMLType> addedExceptionTypes;
    private List<UMLType> removedExceptionTypes;
    private Set<Pair<UMLType, UMLType>> commonExceptionTypes;
    private AbstractMap.SimpleEntry<Set<UMLType>, Set<UMLType>> changedExceptionTypes;

    public UMLOperationDiff(UMLOperation removedOperation, UMLOperation addedOperation) {
        this.process(removedOperation, addedOperation);
    }

    private void process(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLParameterDiff parameterDiff;
        UMLParameter addedParameter;
        Iterator<UMLParameter> addedParameterIterator;
        UMLParameter removedParameter;
        this.removedOperation = removedOperation;
        this.addedOperation = addedOperation;
        this.addedParameters = new ArrayList<UMLParameter>();
        this.removedParameters = new ArrayList<UMLParameter>();
        this.parameterDiffList = new ArrayList<UMLParameterDiff>();
        this.addedExceptionTypes = new ArrayList<UMLType>();
        this.removedExceptionTypes = new ArrayList<UMLType>();
        this.commonExceptionTypes = new LinkedHashSet<Pair<UMLType, UMLType>>();
        this.visibilityChanged = false;
        this.abstractionChanged = false;
        this.returnTypeChanged = false;
        this.operationRenamed = false;
        if (!removedOperation.getName().equals(addedOperation.getName())) {
            this.operationRenamed = true;
        }
        if (!removedOperation.getVisibility().equals(addedOperation.getVisibility())) {
            this.visibilityChanged = true;
        }
        if (removedOperation.isAbstract() != addedOperation.isAbstract()) {
            this.abstractionChanged = true;
        }
        if (removedOperation.isFinal() != addedOperation.isFinal()) {
            this.finalChanged = true;
        }
        if (removedOperation.isStatic() != addedOperation.isStatic()) {
            this.staticChanged = true;
        }
        if (removedOperation.isSynchronized() != addedOperation.isSynchronized()) {
            this.synchronizedChanged = true;
        }
        if (!removedOperation.equalReturnParameter(addedOperation)) {
            this.returnTypeChanged = true;
        } else if (!removedOperation.equalQualifiedReturnParameter(addedOperation)) {
            this.qualifiedReturnTypeChanged = true;
        }
        this.processThrownExceptionTypes(removedOperation.getThrownExceptionTypes(), addedOperation.getThrownExceptionTypes());
        this.annotationListDiff = new UMLAnnotationListDiff(removedOperation.getAnnotations(), addedOperation.getAnnotations());
        this.typeParameterListDiff = new UMLTypeParameterListDiff(removedOperation.getTypeParameters(), addedOperation.getTypeParameters());
        List<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> matchedParameters = this.updateAddedRemovedParameters(removedOperation, addedOperation);
        for (AbstractMap.SimpleEntry<UMLParameter, UMLParameter> matchedParameter : matchedParameters) {
            UMLParameter uMLParameter;
            UMLParameter parameter1 = matchedParameter.getKey();
            UMLParameterDiff parameterDiff2 = new UMLParameterDiff(parameter1, uMLParameter = matchedParameter.getValue(), removedOperation, addedOperation, this.mappings, this.refactorings);
            if (parameterDiff2.isEmpty()) continue;
            this.parameterDiffList.add(parameterDiff2);
        }
        int matchedParameterCount = matchedParameters.size() / 2;
        ArrayList<String> parameterNames1 = new ArrayList<String>(removedOperation.getParameterNameList());
        for (UMLParameter uMLParameter : this.removedParameters) {
            parameterNames1.remove(uMLParameter.getName());
        }
        ArrayList<String> parameterNames2 = new ArrayList<String>(addedOperation.getParameterNameList());
        for (UMLParameter addedParameter2 : this.addedParameters) {
            parameterNames2.remove(addedParameter2.getName());
        }
        if (matchedParameterCount == parameterNames1.size() && matchedParameterCount == parameterNames2.size() && parameterNames1.size() == parameterNames2.size() && parameterNames1.size() > 1 && !parameterNames1.equals(parameterNames2)) {
            this.parametersReordered = true;
        }
        Iterator<UMLParameter> iterator = this.removedParameters.iterator();
        block3: while (iterator.hasNext()) {
            removedParameter = iterator.next();
            addedParameterIterator = this.addedParameters.iterator();
            while (addedParameterIterator.hasNext()) {
                addedParameter = addedParameterIterator.next();
                if (!removedParameter.getName().equals(addedParameter.getName())) continue;
                parameterDiff = new UMLParameterDiff(removedParameter, addedParameter, removedOperation, addedOperation, this.mappings, this.refactorings);
                if (!parameterDiff.isEmpty()) {
                    this.parameterDiffList.add(parameterDiff);
                }
                addedParameterIterator.remove();
                iterator.remove();
                continue block3;
            }
        }
        Iterator<UMLParameter> iterator2 = this.removedParameters.iterator();
        block5: while (iterator2.hasNext()) {
            removedParameter = iterator2.next();
            addedParameterIterator = this.addedParameters.iterator();
            while (addedParameterIterator.hasNext()) {
                addedParameter = addedParameterIterator.next();
                if (!removedParameter.getType().equalsQualified(addedParameter.getType()) || this.existsAnotherAddedParameterWithTheSameType(addedParameter)) continue;
                parameterDiff = new UMLParameterDiff(removedParameter, addedParameter, removedOperation, addedOperation, this.mappings, this.refactorings);
                if (!parameterDiff.isEmpty()) {
                    this.parameterDiffList.add(parameterDiff);
                }
                addedParameterIterator.remove();
                iterator2.remove();
                continue block5;
            }
        }
        List<UMLParameter> list = removedOperation.getParametersWithoutReturnType();
        List<UMLParameter> addedParametersWithoutReturnType = addedOperation.getParametersWithoutReturnType();
        if (matchedParameterCount == list.size() - 1 && matchedParameterCount == addedParametersWithoutReturnType.size() - 1) {
            Iterator<UMLParameter> removedParameterIterator2 = this.removedParameters.iterator();
            block7: while (removedParameterIterator2.hasNext()) {
                UMLParameter removedParameter3 = removedParameterIterator2.next();
                int indexOfRemovedParameter = this.indexOfParameter(list, removedParameter3);
                Iterator<UMLParameter> addedParameterIterator2 = this.addedParameters.iterator();
                while (addedParameterIterator2.hasNext()) {
                    UMLParameter addedParameter3 = addedParameterIterator2.next();
                    int indexOfAddedParameter = this.indexOfParameter(addedParametersWithoutReturnType, addedParameter3);
                    if (indexOfRemovedParameter != indexOfAddedParameter || !this.usedParameters(removedOperation, addedOperation, removedParameter3, addedParameter3)) continue;
                    UMLParameterDiff parameterDiff3 = new UMLParameterDiff(removedParameter3, addedParameter3, removedOperation, addedOperation, this.mappings, this.refactorings);
                    if (!parameterDiff3.isEmpty()) {
                        this.parameterDiffList.add(parameterDiff3);
                    }
                    addedParameterIterator2.remove();
                    removedParameterIterator2.remove();
                    continue block7;
                }
            }
        }
    }

    private boolean usedParameters(UMLOperation removedOperation, UMLOperation addedOperation, UMLParameter removedParameter, UMLParameter addedParameter) {
        List<String> removedOperationVariables = removedOperation.getAllVariables();
        List<String> addedOperationVariables = addedOperation.getAllVariables();
        if (removedOperationVariables.contains(removedParameter.getName()) == addedOperationVariables.contains(addedParameter.getName())) {
            if (!removedOperation.isConstructor() && !addedOperation.isConstructor()) {
                return !removedOperationVariables.contains(addedParameter.getName()) && !addedOperationVariables.contains(removedParameter.getName());
            }
            return true;
        }
        return false;
    }

    private int indexOfParameter(List<UMLParameter> parameters, UMLParameter parameter) {
        int index = 0;
        for (UMLParameter p : parameters) {
            if (p.equalsIncludingName(parameter)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public UMLOperationDiff(UMLOperationBodyMapper mapper) {
        this.mappings = mapper.getMappings();
        this.matchedVariables = mapper.getMatchedVariables();
        this.refactorings = mapper.getRefactoringsAfterPostProcessing();
        this.classDiff = mapper.getClassDiff();
        this.process(mapper.getOperation1(), mapper.getOperation2());
    }

    private void processThrownExceptionTypes(List<UMLType> exceptionTypes1, List<UMLType> exceptionTypes2) {
        boolean found;
        LinkedHashSet<UMLType> addedExceptionTypes = new LinkedHashSet<UMLType>();
        LinkedHashSet<UMLType> removedExceptionTypes = new LinkedHashSet<UMLType>();
        for (UMLType exceptionType1 : exceptionTypes1) {
            found = false;
            for (UMLType exceptionType2 : exceptionTypes2) {
                if (!exceptionType1.equals(exceptionType2)) continue;
                found = true;
                this.commonExceptionTypes.add((Pair<UMLType, UMLType>)Pair.of((Object)exceptionType1, (Object)exceptionType2));
                break;
            }
            if (found) continue;
            removedExceptionTypes.add(exceptionType1);
        }
        for (UMLType exceptionType2 : exceptionTypes2) {
            found = false;
            for (UMLType exceptionType1 : exceptionTypes1) {
                if (!exceptionType1.equals(exceptionType2)) continue;
                found = true;
                this.commonExceptionTypes.add((Pair<UMLType, UMLType>)Pair.of((Object)exceptionType1, (Object)exceptionType2));
                break;
            }
            if (found) continue;
            addedExceptionTypes.add(exceptionType2);
        }
        if (removedExceptionTypes.size() > 0 && addedExceptionTypes.size() == 0) {
            this.removedExceptionTypes.addAll(removedExceptionTypes);
        } else if (addedExceptionTypes.size() > 0 && removedExceptionTypes.size() == 0) {
            this.addedExceptionTypes.addAll(addedExceptionTypes);
        } else if (removedExceptionTypes.size() > 0 && addedExceptionTypes.size() > 0) {
            this.changedExceptionTypes = new AbstractMap.SimpleEntry(removedExceptionTypes, addedExceptionTypes);
        }
    }

    private boolean existsAnotherAddedParameterWithTheSameType(UMLParameter parameter) {
        if (this.removedOperation.hasTwoParametersWithTheSameType() && this.addedOperation.hasTwoParametersWithTheSameType()) {
            return false;
        }
        for (UMLParameter addedParameter : this.addedParameters) {
            if (addedParameter.getName().equals(parameter.getName()) || !addedParameter.getType().equalsQualified(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    private List<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> updateAddedRemovedParameters(UMLOperation removedOperation, UMLOperation addedOperation) {
        boolean found;
        ArrayList<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> matchedParameters = new ArrayList<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>>();
        for (UMLParameter parameter1 : removedOperation.getParameters()) {
            if (parameter1.getKind().equals("return")) continue;
            found = false;
            for (UMLParameter parameter2 : addedOperation.getParameters()) {
                if (!parameter1.equalsIncludingName(parameter2)) continue;
                matchedParameters.add(new AbstractMap.SimpleEntry<UMLParameter, UMLParameter>(parameter1, parameter2));
                found = true;
                break;
            }
            if (found) continue;
            this.removedParameters.add(parameter1);
        }
        for (UMLParameter parameter1 : addedOperation.getParameters()) {
            if (parameter1.getKind().equals("return")) continue;
            found = false;
            for (UMLParameter parameter2 : removedOperation.getParameters()) {
                if (!parameter1.equalsIncludingName(parameter2)) continue;
                matchedParameters.add(new AbstractMap.SimpleEntry<UMLParameter, UMLParameter>(parameter2, parameter1));
                found = true;
                break;
            }
            if (found) continue;
            this.addedParameters.add(parameter1);
        }
        return matchedParameters;
    }

    public List<UMLParameterDiff> getParameterDiffList() {
        return this.parameterDiffList;
    }

    public UMLOperation getRemovedOperation() {
        return this.removedOperation;
    }

    public UMLOperation getAddedOperation() {
        return this.addedOperation;
    }

    public List<UMLParameter> getAddedParameters() {
        return this.addedParameters;
    }

    public List<UMLParameter> getRemovedParameters() {
        return this.removedParameters;
    }

    public boolean isOperationRenamed() {
        return this.operationRenamed;
    }

    public boolean isVisibilityChanged() {
        return this.visibilityChanged;
    }

    public boolean isAbstractionChanged() {
        return this.abstractionChanged;
    }

    public boolean isFinalChanged() {
        return this.finalChanged;
    }

    public boolean isStaticChanged() {
        return this.staticChanged;
    }

    public boolean isSynchronizedChanged() {
        return this.synchronizedChanged;
    }

    public boolean isReturnTypeChanged() {
        return this.returnTypeChanged;
    }

    public boolean isQualifiedReturnTypeChanged() {
        return this.qualifiedReturnTypeChanged;
    }

    public boolean isParametersReordered() {
        return this.parametersReordered;
    }

    public Set<Pair<VariableDeclaration, VariableDeclaration>> getMatchedVariables() {
        return this.matchedVariables;
    }

    public UMLAnnotationListDiff getAnnotationListDiff() {
        return this.annotationListDiff;
    }

    public UMLTypeParameterListDiff getTypeParameterListDiff() {
        return this.typeParameterListDiff;
    }

    public List<UMLType> getAddedExceptionTypes() {
        return this.addedExceptionTypes;
    }

    public List<UMLType> getRemovedExceptionTypes() {
        return this.removedExceptionTypes;
    }

    public Set<Pair<UMLType, UMLType>> getCommonExceptionTypes() {
        return this.commonExceptionTypes;
    }

    public AbstractMap.SimpleEntry<Set<UMLType>, Set<UMLType>> getChangedExceptionTypes() {
        return this.changedExceptionTypes;
    }

    public boolean isEmpty() {
        return this.addedParameters.isEmpty() && this.removedParameters.isEmpty() && this.parameterDiffList.isEmpty() && !this.visibilityChanged && !this.abstractionChanged && !this.finalChanged && !this.staticChanged && !this.synchronizedChanged && !this.returnTypeChanged && !this.operationRenamed && this.annotationListDiff.isEmpty() && this.typeParameterListDiff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedOperation).append("\n");
        }
        if (this.operationRenamed) {
            sb.append("\t").append("renamed from " + this.removedOperation.getName() + " to " + this.addedOperation.getName()).append("\n");
        }
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from " + this.removedOperation.getVisibility() + " to " + this.addedOperation.getVisibility()).append("\n");
        }
        if (this.abstractionChanged) {
            sb.append("\t").append("abstraction changed from " + (this.removedOperation.isAbstract() ? "abstract" : "concrete") + " to " + (this.addedOperation.isAbstract() ? "abstract" : "concrete")).append("\n");
        }
        if (this.returnTypeChanged || this.qualifiedReturnTypeChanged) {
            sb.append("\t").append("return type changed from " + this.removedOperation.getReturnParameter() + " to " + this.addedOperation.getReturnParameter()).append("\n");
        }
        for (UMLParameter umlParameter : this.removedParameters) {
            sb.append("\t").append("parameter " + umlParameter + " removed").append("\n");
        }
        for (UMLParameter umlParameter : this.addedParameters) {
            sb.append("\t").append("parameter " + umlParameter + " added").append("\n");
        }
        for (UMLParameterDiff parameterDiff : this.parameterDiffList) {
            sb.append(parameterDiff);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    public Set<Refactoring> getRefactorings() {
        Refactoring refactoring;
        ChangeVariableTypeRefactoring changeType;
        RenameVariableRefactoring rename;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        if (this.returnTypeChanged || this.qualifiedReturnTypeChanged) {
            UMLParameter removedOperationReturnParameter = this.removedOperation.getReturnParameter();
            UMLParameter uMLParameter = this.addedOperation.getReturnParameter();
            if (removedOperationReturnParameter != null && uMLParameter != null) {
                Set<AbstractCodeMapping> references = VariableReferenceExtractor.findReturnReferences(this.mappings);
                ChangeReturnTypeRefactoring refactoring3 = new ChangeReturnTypeRefactoring(removedOperationReturnParameter.getType(), uMLParameter.getType(), this.removedOperation, this.addedOperation, references);
                refactorings.add(refactoring3);
            }
        }
        for (UMLParameterDiff uMLParameterDiff : this.getParameterDiffList()) {
            boolean conflictFound = false;
            for (Pair<VariableDeclaration, VariableDeclaration> pair : this.matchedVariables) {
                RenameVariableRefactoring rename2;
                if (((VariableDeclaration)pair.getLeft()).equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) && !((VariableDeclaration)pair.getRight()).equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) {
                    conflictFound = true;
                    if (!((VariableDeclaration)pair.getLeft()).isParameter() || !((VariableDeclaration)pair.getRight()).isLocalVariable()) break;
                    rename2 = new RenameVariableRefactoring((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.removedOperation, this.addedOperation, VariableReferenceExtractor.findReferences((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.mappings), false);
                    refactorings.add(rename2);
                    AddParameterRefactoring addParameter = new AddParameterRefactoring(uMLParameterDiff.getAddedParameter(), this.removedOperation, this.addedOperation);
                    refactorings.add(addParameter);
                    break;
                }
                if (!((VariableDeclaration)pair.getRight()).equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration()) || ((VariableDeclaration)pair.getLeft()).equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration())) continue;
                conflictFound = true;
                if (!((VariableDeclaration)pair.getLeft()).isLocalVariable() || !((VariableDeclaration)pair.getRight()).isParameter()) break;
                rename2 = new RenameVariableRefactoring((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.removedOperation, this.addedOperation, VariableReferenceExtractor.findReferences((VariableDeclaration)pair.getLeft(), (VariableDeclaration)pair.getRight(), this.mappings), false);
                refactorings.add(rename2);
                RemoveParameterRefactoring removeParameter = new RemoveParameterRefactoring(uMLParameterDiff.getRemovedParameter(), this.removedOperation, this.addedOperation);
                refactorings.add(removeParameter);
                break;
            }
            for (Refactoring refactoring2 : this.refactorings) {
                MergeVariableRefactoring merge;
                if (refactoring2 instanceof RenameVariableRefactoring) {
                    RenameVariableRefactoring rename2 = (RenameVariableRefactoring)refactoring2;
                    if (rename2.getOriginalVariable().equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) && !rename2.getRenamedVariable().equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) {
                        conflictFound = true;
                        break;
                    }
                    if (rename2.getOriginalVariable().equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) || !rename2.getRenamedVariable().equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) continue;
                    conflictFound = true;
                    break;
                }
                if (refactoring2 instanceof ChangeVariableTypeRefactoring) {
                    ChangeVariableTypeRefactoring changeType2 = (ChangeVariableTypeRefactoring)refactoring2;
                    if (changeType2.getOriginalVariable().equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) && !changeType2.getChangedTypeVariable().equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) {
                        conflictFound = true;
                        break;
                    }
                    if (changeType2.getOriginalVariable().equals(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) || !changeType2.getChangedTypeVariable().equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) continue;
                    conflictFound = true;
                    break;
                }
                if (!(refactoring2 instanceof MergeVariableRefactoring) || !(merge = (MergeVariableRefactoring)refactoring2).getMergedVariables().contains(uMLParameterDiff.getRemovedParameter().getVariableDeclaration()) || !merge.getNewVariable().equals(uMLParameterDiff.getAddedParameter().getVariableDeclaration())) continue;
                conflictFound = true;
                break;
            }
            if (conflictFound) continue;
            refactorings.addAll(uMLParameterDiff.getRefactorings());
        }
        this.checkForSplitMergeParameterBasedOnAttributeAssignments(refactorings);
        int exactMappings = 0;
        for (AbstractCodeMapping mapping : this.mappings) {
            if (!mapping.isExact()) continue;
            ++exactMappings;
        }
        if (this.removedParameters.isEmpty() || exactMappings > 0) {
            for (UMLParameter umlParameter : this.addedParameters) {
                boolean conflictFound = false;
                for (Refactoring refactoring4 : this.refactorings) {
                    if (refactoring4 instanceof RenameVariableRefactoring) {
                        rename = (RenameVariableRefactoring)refactoring4;
                        if (!rename.getRenamedVariable().equals(umlParameter.getVariableDeclaration())) continue;
                        conflictFound = true;
                        break;
                    }
                    if (!(refactoring4 instanceof ChangeVariableTypeRefactoring) || !(changeType = (ChangeVariableTypeRefactoring)refactoring4).getChangedTypeVariable().equals(umlParameter.getVariableDeclaration())) continue;
                    conflictFound = true;
                    break;
                }
                if (conflictFound) continue;
                AddParameterRefactoring addParameterRefactoring = new AddParameterRefactoring(umlParameter, this.removedOperation, this.addedOperation);
                refactorings.add(addParameterRefactoring);
            }
        }
        if (this.addedParameters.isEmpty() || exactMappings > 0) {
            for (UMLParameter umlParameter : this.removedParameters) {
                boolean conflictFound = false;
                for (Refactoring refactoring3 : this.refactorings) {
                    if (refactoring3 instanceof RenameVariableRefactoring) {
                        rename = (RenameVariableRefactoring)refactoring3;
                        if (!rename.getOriginalVariable().equals(umlParameter.getVariableDeclaration())) continue;
                        conflictFound = true;
                        break;
                    }
                    if (!(refactoring3 instanceof ChangeVariableTypeRefactoring) || !(changeType = (ChangeVariableTypeRefactoring)refactoring3).getOriginalVariable().equals(umlParameter.getVariableDeclaration())) continue;
                    conflictFound = true;
                    break;
                }
                if (conflictFound) continue;
                RemoveParameterRefactoring removeParameterRefactoring = new RemoveParameterRefactoring(umlParameter, this.removedOperation, this.addedOperation);
                refactorings.add(removeParameterRefactoring);
            }
        }
        if (this.parametersReordered) {
            ReorderParameterRefactoring reorderParameterRefactoring = new ReorderParameterRefactoring(this.removedOperation, this.addedOperation);
            refactorings.add(reorderParameterRefactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddMethodAnnotationRefactoring(annotation, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveMethodAnnotationRefactoring(annotation, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyMethodAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLType exceptionType : this.addedExceptionTypes) {
            refactoring = new AddThrownExceptionTypeRefactoring(exceptionType, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLType exceptionType : this.removedExceptionTypes) {
            refactoring = new RemoveThrownExceptionTypeRefactoring(exceptionType, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        if (this.changedExceptionTypes != null) {
            ChangeThrownExceptionTypeRefactoring changeThrownExceptionTypeRefactoring = new ChangeThrownExceptionTypeRefactoring(this.changedExceptionTypes.getKey(), this.changedExceptionTypes.getValue(), this.removedOperation, this.addedOperation);
            refactorings.add(changeThrownExceptionTypeRefactoring);
        }
        if (this.visibilityChanged) {
            ChangeOperationAccessModifierRefactoring changeOperationAccessModifierRefactoring = new ChangeOperationAccessModifierRefactoring(this.removedOperation.getVisibility(), this.addedOperation.getVisibility(), this.removedOperation, this.addedOperation);
            refactorings.add(changeOperationAccessModifierRefactoring);
        }
        if (this.finalChanged) {
            if (this.addedOperation.isFinal()) {
                AddMethodModifierRefactoring addMethodModifierRefactoring = new AddMethodModifierRefactoring("final", this.removedOperation, this.addedOperation);
                refactorings.add(addMethodModifierRefactoring);
            } else if (this.removedOperation.isFinal()) {
                RemoveMethodModifierRefactoring removeMethodModifierRefactoring = new RemoveMethodModifierRefactoring("final", this.removedOperation, this.addedOperation);
                refactorings.add(removeMethodModifierRefactoring);
            }
        }
        if (this.abstractionChanged) {
            if (this.addedOperation.isAbstract()) {
                AddMethodModifierRefactoring addMethodModifierRefactoring = new AddMethodModifierRefactoring("abstract", this.removedOperation, this.addedOperation);
                refactorings.add(addMethodModifierRefactoring);
            } else if (this.removedOperation.isAbstract()) {
                RemoveMethodModifierRefactoring removeMethodModifierRefactoring = new RemoveMethodModifierRefactoring("abstract", this.removedOperation, this.addedOperation);
                refactorings.add(removeMethodModifierRefactoring);
            }
        }
        if (this.staticChanged) {
            if (this.addedOperation.isStatic()) {
                AddMethodModifierRefactoring addMethodModifierRefactoring = new AddMethodModifierRefactoring("static", this.removedOperation, this.addedOperation);
                refactorings.add(addMethodModifierRefactoring);
            } else if (this.removedOperation.isStatic()) {
                RemoveMethodModifierRefactoring removeMethodModifierRefactoring = new RemoveMethodModifierRefactoring("static", this.removedOperation, this.addedOperation);
                refactorings.add(removeMethodModifierRefactoring);
            }
        }
        if (this.synchronizedChanged) {
            if (this.addedOperation.isSynchronized()) {
                AddMethodModifierRefactoring addMethodModifierRefactoring = new AddMethodModifierRefactoring("synchronized", this.removedOperation, this.addedOperation);
                refactorings.add(addMethodModifierRefactoring);
            } else if (this.removedOperation.isSynchronized()) {
                RemoveMethodModifierRefactoring removeMethodModifierRefactoring = new RemoveMethodModifierRefactoring("synchronized", this.removedOperation, this.addedOperation);
                refactorings.add(removeMethodModifierRefactoring);
            }
        }
        return refactorings;
    }

    /*
     * WARNING - void declaration
     */
    private void checkForSplitMergeParameterBasedOnAttributeAssignments(Set<Refactoring> refactorings) {
        if (this.classDiff != null) {
            void var7_13;
            List<AbstractCodeFragment> removedOperationLeaves = this.removedOperation.getBody() != null ? this.removedOperation.getBody().getCompositeStatement().getLeaves() : Collections.emptyList();
            LinkedHashMap<VariableDeclaration, AbstractCodeFragment> removedFieldAssignmentMap = new LinkedHashMap<VariableDeclaration, AbstractCodeFragment>();
            block0: for (UMLParameter removedParameter : this.removedParameters) {
                for (AbstractCodeFragment abstractCodeFragment : removedOperationLeaves) {
                    if (!abstractCodeFragment.getString().equals("this." + removedParameter.getName() + "=" + removedParameter.getName() + ";\n")) continue;
                    removedFieldAssignmentMap.put(removedParameter.getVariableDeclaration(), abstractCodeFragment);
                    continue block0;
                }
            }
            List<Object> addedOperationLeaves = this.addedOperation.getBody() != null ? this.addedOperation.getBody().getCompositeStatement().getLeaves() : Collections.emptyList();
            LinkedHashMap<VariableDeclaration, AbstractCodeFragment> addedFieldAssignmentMap = new LinkedHashMap<VariableDeclaration, AbstractCodeFragment>();
            block2: for (UMLParameter uMLParameter : this.addedParameters) {
                for (AbstractCodeFragment abstractCodeFragment : addedOperationLeaves) {
                    if (!abstractCodeFragment.getString().equals("this." + uMLParameter.getName() + "=" + uMLParameter.getName() + ";\n")) continue;
                    addedFieldAssignmentMap.put(uMLParameter.getVariableDeclaration(), abstractCodeFragment);
                    continue block2;
                }
            }
            int removedAttributes = 0;
            block4: for (UMLAttribute uMLAttribute : this.classDiff.getRemovedAttributes()) {
                for (Object parameter : removedFieldAssignmentMap.keySet()) {
                    if (!uMLAttribute.getName().equals(((VariableDeclaration)parameter).getVariableName()) || !uMLAttribute.getVariableDeclaration().equalType((VariableDeclaration)parameter)) continue;
                    ++removedAttributes;
                    continue block4;
                }
            }
            boolean bl = false;
            block6: for (UMLAttribute uMLAttribute : this.classDiff.getAddedAttributes()) {
                for (VariableDeclaration parameter : addedFieldAssignmentMap.keySet()) {
                    if (!uMLAttribute.getName().equals(parameter.getVariableName()) || !uMLAttribute.getVariableDeclaration().equalType(parameter)) continue;
                    ++var7_13;
                    continue block6;
                }
            }
            if (!removedFieldAssignmentMap.isEmpty() && !addedFieldAssignmentMap.isEmpty() && removedAttributes == removedFieldAssignmentMap.size() && var7_13 == addedFieldAssignmentMap.size()) {
                LinkedHashSet<AbstractCodeMapping> linkedHashSet = new LinkedHashSet<AbstractCodeMapping>();
                for (AbstractCodeMapping mapping : this.mappings) {
                    if (!removedFieldAssignmentMap.values().contains(mapping.getFragment1()) && !addedFieldAssignmentMap.values().contains(mapping.getFragment2())) continue;
                    linkedHashSet.add(mapping);
                }
                if (removedFieldAssignmentMap.size() == 1 && addedFieldAssignmentMap.size() > 1) {
                    SplitVariableRefactoring splitVariableRefactoring = new SplitVariableRefactoring((VariableDeclaration)removedFieldAssignmentMap.keySet().iterator().next(), addedFieldAssignmentMap.keySet(), this.removedOperation, this.addedOperation, linkedHashSet, false);
                    refactorings.add(splitVariableRefactoring);
                    this.cleanUpParameters(removedFieldAssignmentMap, addedFieldAssignmentMap);
                }
                if (removedFieldAssignmentMap.size() > 1 && addedFieldAssignmentMap.size() == 1) {
                    MergeVariableRefactoring mergeVariableRefactoring = new MergeVariableRefactoring(removedFieldAssignmentMap.keySet(), (VariableDeclaration)addedFieldAssignmentMap.keySet().iterator().next(), this.removedOperation, this.addedOperation, linkedHashSet, false);
                    refactorings.add(mergeVariableRefactoring);
                    this.cleanUpParameters(removedFieldAssignmentMap, addedFieldAssignmentMap);
                }
            }
        }
    }

    private void cleanUpParameters(Map<VariableDeclaration, AbstractCodeFragment> removedFieldAssignmentMap, Map<VariableDeclaration, AbstractCodeFragment> addedFieldAssignmentMap) {
        Iterator<UMLParameter> removedParameterIterator = this.removedParameters.iterator();
        while (removedParameterIterator.hasNext()) {
            UMLParameter removedParameter = removedParameterIterator.next();
            if (!removedFieldAssignmentMap.keySet().contains(removedParameter.getVariableDeclaration())) continue;
            removedParameterIterator.remove();
        }
        Iterator<UMLParameter> addedParameterIterator = this.addedParameters.iterator();
        while (addedParameterIterator.hasNext()) {
            UMLParameter addedParameter = addedParameterIterator.next();
            if (!addedFieldAssignmentMap.keySet().contains(addedParameter.getVariableDeclaration())) continue;
            addedParameterIterator.remove();
        }
    }
}

