/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReferenceExtractor;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.AddParameterRefactoring;
import gr.uom.java.xmi.diff.AddVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddVariableModifierRefactoring;
import gr.uom.java.xmi.diff.ChangeVariableTypeRefactoring;
import gr.uom.java.xmi.diff.ModifyVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveParameterRefactoring;
import gr.uom.java.xmi.diff.RemoveVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveVariableModifierRefactoring;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.refactoringminer.api.Refactoring;

public class UMLParameterDiff {
    private UMLParameter removedParameter;
    private UMLParameter addedParameter;
    private UMLOperation removedOperation;
    private UMLOperation addedOperation;
    private boolean typeChanged;
    private boolean qualifiedTypeChanged;
    private boolean nameChanged;
    private boolean varArgsChanged;
    private boolean finalChanged;
    private Set<AbstractCodeMapping> mappings;
    private UMLAnnotationListDiff annotationListDiff;
    private Set<Refactoring> mapperRefactorings;

    public UMLParameterDiff(UMLParameter removedParameter, UMLParameter addedParameter, UMLOperation removedOperation, UMLOperation addedOperation, Set<AbstractCodeMapping> mappings, Set<Refactoring> mapperRefactorings) {
        this.mappings = mappings;
        this.mapperRefactorings = mapperRefactorings;
        this.removedParameter = removedParameter;
        this.addedParameter = addedParameter;
        this.removedOperation = removedOperation;
        this.addedOperation = addedOperation;
        this.typeChanged = false;
        this.nameChanged = false;
        if (!removedParameter.getType().equals(addedParameter.getType())) {
            this.typeChanged = true;
        } else if (!removedParameter.getType().equalsQualified(addedParameter.getType())) {
            this.qualifiedTypeChanged = true;
        }
        if (!this.typeChanged && !this.qualifiedTypeChanged) {
            if (removedParameter.isVarargs() && !addedParameter.isVarargs()) {
                this.varArgsChanged = true;
            }
            if (!removedParameter.isVarargs() && addedParameter.isVarargs()) {
                this.varArgsChanged = true;
            }
        }
        if (!removedParameter.getName().equals(addedParameter.getName())) {
            this.nameChanged = true;
        }
        if (removedParameter.isFinal() != addedParameter.isFinal()) {
            this.finalChanged = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedParameter.getAnnotations(), addedParameter.getAnnotations());
    }

    public UMLParameter getRemovedParameter() {
        return this.removedParameter;
    }

    public UMLParameter getAddedParameter() {
        return this.addedParameter;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isQualifiedTypeChanged() {
        return this.qualifiedTypeChanged;
    }

    public boolean isVarArgsChanged() {
        return this.varArgsChanged;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public boolean isEmpty() {
        return !this.nameChanged && !this.typeChanged && !this.qualifiedTypeChanged && !this.varArgsChanged && !this.finalChanged && this.annotationListDiff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeChanged || this.nameChanged || this.qualifiedTypeChanged) {
            sb.append("\t\t").append("parameter ").append(this.removedParameter).append(":").append("\n");
        }
        if (this.typeChanged || this.qualifiedTypeChanged) {
            sb.append("\t\t").append("type changed from " + this.removedParameter.getType() + " to " + this.addedParameter.getType()).append("\n");
        }
        if (this.nameChanged) {
            sb.append("\t\t").append("name changed from " + this.removedParameter.getName() + " to " + this.addedParameter.getName()).append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    public Set<Refactoring> getRefactorings() {
        Refactoring refactoring;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        VariableDeclaration originalVariable = this.getRemovedParameter().getVariableDeclaration();
        VariableDeclaration newVariable = this.getAddedParameter().getVariableDeclaration();
        Set<AbstractCodeMapping> references = VariableReferenceExtractor.findReferences(originalVariable, newVariable, this.mappings);
        RenameVariableRefactoring renameRefactoring = null;
        if (this.isNameChanged()) {
            renameRefactoring = new RenameVariableRefactoring(originalVariable, newVariable, this.removedOperation, this.addedOperation, references, false);
            if (!this.inconsistentReplacement(originalVariable, newVariable)) {
                refactorings.add(renameRefactoring);
            } else if (!this.mapperRefactorings.contains(renameRefactoring)) {
                RemoveParameterRefactoring removeParameter = new RemoveParameterRefactoring(this.removedParameter, this.removedOperation, this.addedOperation);
                AddParameterRefactoring addParameter = new AddParameterRefactoring(this.addedParameter, this.removedOperation, this.addedOperation);
                refactorings.add(removeParameter);
                refactorings.add(addParameter);
            }
        }
        if ((this.isTypeChanged() || this.isQualifiedTypeChanged() || this.isVarArgsChanged()) && !this.inconsistentReplacement(originalVariable, newVariable)) {
            Iterator<Object> refactoring2 = new ChangeVariableTypeRefactoring(originalVariable, newVariable, this.removedOperation, this.addedOperation, references, false);
            if (renameRefactoring != null) {
                ((ChangeVariableTypeRefactoring)((Object)refactoring2)).addRelatedRefactoring(renameRefactoring);
            }
            refactorings.add((Refactoring)((Object)refactoring2));
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddVariableAnnotationRefactoring(annotation, originalVariable, newVariable, this.removedOperation, this.addedOperation, false);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveVariableAnnotationRefactoring(annotation, originalVariable, newVariable, this.removedOperation, this.addedOperation, false);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyVariableAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), originalVariable, newVariable, this.removedOperation, this.addedOperation, false);
            refactorings.add(refactoring);
        }
        if (this.finalChanged) {
            Refactoring ref;
            if (newVariable.isFinal()) {
                ref = new AddVariableModifierRefactoring("final", originalVariable, newVariable, this.removedOperation, this.addedOperation, false);
                refactorings.add(ref);
            } else if (originalVariable.isFinal()) {
                ref = new RemoveVariableModifierRefactoring("final", originalVariable, newVariable, this.removedOperation, this.addedOperation, false);
                refactorings.add(ref);
            }
        }
        return refactorings;
    }

    private boolean inconsistentReplacement(VariableDeclaration originalVariable, VariableDeclaration newVariable) {
        if (this.removedOperation.isStatic() || this.addedOperation.isStatic()) {
            for (AbstractCodeMapping mapping : this.mappings) {
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                    if (replacement.getBefore().equals(originalVariable.getVariableName()) && !replacement.getAfter().equals(newVariable.getVariableName())) {
                        return true;
                    }
                    if (replacement.getBefore().equals(originalVariable.getVariableName()) || !replacement.getAfter().equals(newVariable.getVariableName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

