/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.Assert;
import org.junit.Test;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositoryWrapper;
import org.refactoringminer.rm1.GitHistoryRefactoringMinerImpl;

public class GHRepositoryWrapperTest {
    private final GitHistoryRefactoringMinerImpl gitHistoryRefactoringMiner = new GitHistoryRefactoringMinerImpl();
    private static final List<Triple<String, String, Integer>> TEST_CASES_LIST = new ArrayList<Triple<String, String, Integer>>();

    @Test
    public void testNumberOfChangedFiles() {
        int numberOfTestCase = 0;
        for (Triple<String, String, Integer> testCase : TEST_CASES_LIST) {
            Assert.assertEquals((long)((Integer)testCase.getRight()).intValue(), (long)this.getNumberOfChangedFile((String)testCase.getLeft(), (String)testCase.getMiddle()));
            ++numberOfTestCase;
        }
        Assert.assertEquals((long)10L, (long)numberOfTestCase);
    }

    private int getNumberOfChangedFile(String cloneUrl, String commitId) {
        try {
            ArrayList<GHCommit.File> commitFiles = new ArrayList<GHCommit.File>();
            GHRepository ghRepository = this.gitHistoryRefactoringMiner.getGitHubRepository(cloneUrl);
            GHRepositoryWrapper ghRepositoryWrapper = new GHRepositoryWrapper(ghRepository);
            ghRepositoryWrapper.getCommit(commitId, commitFiles);
            return commitFiles.size();
        }
        catch (IOException e) {
            return -1;
        }
    }

    static {
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"9caca0ce37d5a2763d476c6fa2471addcca710ca", (Object)1284));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"37fc401da891544c1596c9b45822a3b1e459e7e2", (Object)531));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"9ae57a6f7addc80c6aa4bb9f55b43baeee47189e", (Object)536));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"825ab027231728f331ada37e1edd44027dc246ee", (Object)103));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"d671fe1391945726e3a8ce1577904b42dda80a4b", (Object)629));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/hibernate/hibernate-orm.git", (Object)"782f023a5a16aba08dc1429f094f1048be434617", (Object)32));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/javaparser/javaparser.git", (Object)"0ac302de4ea549230305c544be78a1570a58d2fa", (Object)491));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/javaparser/javaparser.git", (Object)"6ff3b519de40fc443f79d6a6ecaeadf7dc52f9ed", (Object)659));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/checkstyle/checkstyle.git", (Object)"1e3fb3fae940bf7ea340592f7f0cda3af1b320e3", (Object)948));
        TEST_CASES_LIST.add((Triple<String, String, Integer>)Triple.of((Object)"https://github.com/checkstyle/checkstyle.git", (Object)"6893affeac7285afd16f8a389c7d65023d0c327a", (Object)366));
    }
}

