/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.api;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.CodeRangeProvider;
import org.refactoringminer.api.RefactoringType;

public interface Refactoring
extends Serializable,
CodeRangeProvider {
    public RefactoringType getRefactoringType();

    public String getName();

    public String toString();

    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring();

    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring();

    default public String toJSON() {
        StringBuilder sb = new StringBuilder();
        JsonStringEncoder encoder = JsonStringEncoder.getInstance();
        sb.append("{").append("\n");
        sb.append("\t").append("\"").append("type").append("\"").append(": ").append("\"").append(this.getName()).append("\"").append(",").append("\n");
        sb.append("\t").append("\"").append("description").append("\"").append(": ").append("\"");
        encoder.quoteAsString((CharSequence)this.toString().replace('\t', ' '), sb);
        sb.append("\"").append(",").append("\n");
        sb.append("\t").append("\"").append("leftSideLocations").append("\"").append(": ").append(this.leftSide()).append(",").append("\n");
        sb.append("\t").append("\"").append("rightSideLocations").append("\"").append(": ").append(this.rightSide()).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

