/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.rm1;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLModelASTReader;
import gr.uom.java.xmi.diff.MoveSourceFolderRefactoring;
import gr.uom.java.xmi.diff.MovedClassToAnotherSourceFolder;
import gr.uom.java.xmi.diff.RenamePattern;
import gr.uom.java.xmi.diff.StringDistance;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositoryWrapper;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeEntry;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.refactoringminer.api.Churn;
import org.refactoringminer.api.GitHistoryRefactoringMiner;
import org.refactoringminer.api.GitService;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringHandler;
import org.refactoringminer.api.RefactoringMinerTimedOutException;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.GitServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHistoryRefactoringMinerImpl
implements GitHistoryRefactoringMiner {
    private static final Logger logger = LoggerFactory.getLogger(GitHistoryRefactoringMinerImpl.class);
    private Set<RefactoringType> refactoringTypesToConsider = null;
    private GitHub gitHub;
    private static final String systemFileSeparator = Matcher.quoteReplacement(File.separator);
    private static final String GITHUB_URL = "https://github.com/";
    private static final String BITBUCKET_URL = "https://bitbucket.org/";

    public GitHistoryRefactoringMinerImpl() {
        this.setRefactoringTypesToConsider(RefactoringType.ALL);
    }

    public void setRefactoringTypesToConsider(RefactoringType ... types) {
        this.refactoringTypesToConsider = new HashSet<RefactoringType>();
        for (RefactoringType type : types) {
            this.refactoringTypesToConsider.add(type);
        }
    }

    private void detect(GitService gitService, Repository repository, RefactoringHandler handler, Iterator<RevCommit> i) {
        int commitsCount = 0;
        int errorCommitsCount = 0;
        int refactoringsCount = 0;
        File metadataFolder = repository.getDirectory();
        File projectFolder = metadataFolder.getParentFile();
        String projectName = projectFolder.getName();
        long time = System.currentTimeMillis();
        while (i.hasNext()) {
            RevCommit currentCommit = i.next();
            try {
                List<Refactoring> refactoringsAtRevision = this.detectRefactorings(gitService, repository, handler, currentCommit);
                refactoringsCount += refactoringsAtRevision.size();
            }
            catch (Exception e) {
                logger.warn(String.format("Ignored revision %s due to error", currentCommit.getId().getName()), (Throwable)e);
                handler.handleException(currentCommit.getId().getName(), e);
                ++errorCommitsCount;
            }
            ++commitsCount;
            long time2 = System.currentTimeMillis();
            if (time2 - time <= 20000L) continue;
            time = time2;
            logger.info(String.format("Processing %s [Commits: %d, Errors: %d, Refactorings: %d]", projectName, commitsCount, errorCommitsCount, refactoringsCount));
        }
        handler.onFinish(refactoringsCount, commitsCount, errorCommitsCount);
        logger.info(String.format("Analyzed %s [Commits: %d, Errors: %d, Refactorings: %d]", projectName, commitsCount, errorCommitsCount, refactoringsCount));
    }

    protected List<Refactoring> detectRefactorings(GitService gitService, Repository repository, RefactoringHandler handler, RevCommit currentCommit) throws Exception {
        List<Refactoring> refactoringsAtRevision;
        String commitId = currentCommit.getId().getName();
        LinkedHashSet<String> filePathsBefore = new LinkedHashSet<String>();
        LinkedHashSet<String> filePathsCurrent = new LinkedHashSet<String>();
        HashMap<String, String> renamedFilesHint = new HashMap<String, String>();
        gitService.fileTreeDiff(repository, currentCommit, filePathsBefore, filePathsCurrent, renamedFilesHint);
        LinkedHashSet<String> repositoryDirectoriesBefore = new LinkedHashSet<String>();
        LinkedHashSet<String> repositoryDirectoriesCurrent = new LinkedHashSet<String>();
        LinkedHashMap<String, String> fileContentsBefore = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> fileContentsCurrent = new LinkedHashMap<String, String>();
        try (RevWalk walk = new RevWalk(repository);){
            if (!filePathsBefore.isEmpty() && !filePathsCurrent.isEmpty() && currentCommit.getParentCount() > 0) {
                RevCommit parentCommit = currentCommit.getParent(0);
                GitHistoryRefactoringMinerImpl.populateFileContents(repository, parentCommit, filePathsBefore, fileContentsBefore, repositoryDirectoriesBefore);
                GitHistoryRefactoringMinerImpl.populateFileContents(repository, currentCommit, filePathsCurrent, fileContentsCurrent, repositoryDirectoriesCurrent);
                List<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = GitHistoryRefactoringMinerImpl.processIdenticalFiles(fileContentsBefore, fileContentsCurrent, renamedFilesHint);
                UMLModel parentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsBefore, repositoryDirectoriesBefore);
                UMLModel currentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsCurrent, repositoryDirectoriesCurrent);
                UMLModelDiff modelDiff = parentUMLModel.diff(currentUMLModel);
                refactoringsAtRevision = modelDiff.getRefactorings();
                refactoringsAtRevision.addAll(moveSourceFolderRefactorings);
                refactoringsAtRevision = this.filter(refactoringsAtRevision);
            } else {
                refactoringsAtRevision = Collections.emptyList();
            }
            handler.handle(commitId, refactoringsAtRevision);
            walk.dispose();
        }
        return refactoringsAtRevision;
    }

    public static List<MoveSourceFolderRefactoring> processIdenticalFiles(Map<String, String> fileContentsBefore, Map<String, String> fileContentsCurrent, Map<String, String> renamedFilesHint) throws IOException {
        String fileBefore;
        HashMap<String, String> identicalFiles = new HashMap<String, String>();
        HashMap<Pair, Integer> consistentSourceFolderChanges = new HashMap<Pair, Integer>();
        HashMap<String, String> nonIdenticalFiles = new HashMap<String, String>();
        for (String key : fileContentsBefore.keySet()) {
            String fileAfter;
            if (renamedFilesHint.containsKey(key)) {
                String fileAfter2;
                String renamedFile = renamedFilesHint.get(key);
                fileBefore = fileContentsBefore.get(key);
                if (fileBefore.equals(fileAfter2 = fileContentsCurrent.get(renamedFile)) || StringDistance.trivialCommentChange(fileBefore, fileAfter2)) {
                    identicalFiles.put(key, renamedFile);
                    if (key.contains("/") && renamedFile.contains("/")) {
                        String prefix2;
                        String prefix1 = key.substring(0, key.indexOf("/"));
                        Pair p = Pair.of((Object)prefix1, (Object)(prefix2 = renamedFile.substring(0, renamedFile.indexOf("/"))));
                        if (consistentSourceFolderChanges.containsKey(p)) {
                            consistentSourceFolderChanges.put(p, (Integer)consistentSourceFolderChanges.get(p) + 1);
                        } else {
                            consistentSourceFolderChanges.put(p, 1);
                        }
                    }
                } else {
                    nonIdenticalFiles.put(key, renamedFile);
                }
            }
            if (!fileContentsCurrent.containsKey(key)) continue;
            String fileBefore2 = fileContentsBefore.get(key);
            if (fileBefore2.equals(fileAfter = fileContentsCurrent.get(key)) || StringDistance.trivialCommentChange(fileBefore2, fileAfter)) {
                identicalFiles.put(key, key);
                continue;
            }
            nonIdenticalFiles.put(key, key);
        }
        fileContentsBefore.keySet().removeAll(identicalFiles.keySet());
        fileContentsCurrent.keySet().removeAll(identicalFiles.values());
        for (String key1 : fileContentsBefore.keySet()) {
            if (identicalFiles.containsKey(key1) || nonIdenticalFiles.containsKey(key1)) continue;
            String prefix1 = key1.substring(0, key1.indexOf("/"));
            fileBefore = fileContentsBefore.get(key1);
            boolean matchWithConsistentSourceFolderChangeFound = false;
            ArrayList<String> matches = new ArrayList<String>();
            for (String key2 : fileContentsCurrent.keySet()) {
                if (identicalFiles.containsValue(key2) || nonIdenticalFiles.containsValue(key2)) continue;
                String prefix2 = key2.substring(0, key2.indexOf("/"));
                String fileAfter = fileContentsCurrent.get(key2);
                if (!fileBefore.equals(fileAfter) && !StringDistance.trivialCommentChange(fileBefore, fileAfter)) continue;
                if (consistentSourceFolderChanges.containsKey(Pair.of((Object)prefix1, (Object)prefix2))) {
                    identicalFiles.put(key1, key2);
                    matchWithConsistentSourceFolderChangeFound = true;
                    break;
                }
                matches.add(key2);
            }
            if (matchWithConsistentSourceFolderChangeFound) continue;
            if (matches.size() == 1) {
                identicalFiles.put(key1, (String)matches.get(0));
                continue;
            }
            if (matches.size() <= 1) continue;
            int minEditDistance = key1.length();
            String bestMatch = null;
            for (int i = 0; i < matches.size(); ++i) {
                String key2 = (String)matches.get(i);
                int editDistance = StringDistance.editDistance(key1, key2);
                if (editDistance >= minEditDistance) continue;
                minEditDistance = editDistance;
                bestMatch = key2;
            }
            if (bestMatch == null) continue;
            identicalFiles.put(key1, bestMatch);
        }
        fileContentsBefore.keySet().removeAll(identicalFiles.keySet());
        fileContentsCurrent.keySet().removeAll(identicalFiles.values());
        ArrayList<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = new ArrayList<MoveSourceFolderRefactoring>();
        Iterator iterator = identicalFiles.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String originalPath = key = (String)iterator.next();
            String movedPath = (String)identicalFiles.get(key);
            String originalPathPrefix = "";
            if (originalPath.contains("/")) {
                originalPathPrefix = originalPath.substring(0, originalPath.lastIndexOf(47));
            }
            String movedPathPrefix = "";
            if (movedPath.contains("/")) {
                movedPathPrefix = movedPath.substring(0, movedPath.lastIndexOf(47));
            }
            if (originalPathPrefix.equals(movedPathPrefix) || key.endsWith("package-info.java")) continue;
            MovedClassToAnotherSourceFolder refactoring = new MovedClassToAnotherSourceFolder(null, null, originalPathPrefix, movedPathPrefix);
            RenamePattern renamePattern = refactoring.getRenamePattern();
            boolean foundInMatchingMoveSourceFolderRefactoring = false;
            for (MoveSourceFolderRefactoring moveSourceFolderRefactoring : moveSourceFolderRefactorings) {
                if (!moveSourceFolderRefactoring.getPattern().equals(renamePattern)) continue;
                moveSourceFolderRefactoring.putIdenticalFilePaths(originalPath, movedPath);
                foundInMatchingMoveSourceFolderRefactoring = true;
                break;
            }
            if (foundInMatchingMoveSourceFolderRefactoring) continue;
            MoveSourceFolderRefactoring moveSourceFolderRefactoring = new MoveSourceFolderRefactoring(renamePattern);
            moveSourceFolderRefactoring.putIdenticalFilePaths(originalPath, movedPath);
            moveSourceFolderRefactorings.add(moveSourceFolderRefactoring);
        }
        return moveSourceFolderRefactorings;
    }

    public static void populateFileContents(Repository repository, RevCommit commit, Set<String> filePaths, Map<String, String> fileContents, Set<String> repositoryDirectories) throws Exception {
        logger.info("Processing {} {} ...", (Object)repository.getDirectory().getParent().toString(), (Object)commit.getName());
        RevTree parentTree = commit.getTree();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.addTree((AnyObjectId)parentTree);
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                String pathString = treeWalk.getPathString();
                if (filePaths.contains(pathString)) {
                    ObjectId objectId = treeWalk.getObjectId(0);
                    ObjectLoader loader = repository.open((AnyObjectId)objectId);
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)loader.openStream(), (Writer)writer);
                    fileContents.put(pathString, writer.toString());
                }
                if (!pathString.endsWith(".java") || !pathString.contains("/")) continue;
                String directory = pathString.substring(0, pathString.lastIndexOf("/"));
                repositoryDirectories.add(directory);
                String subDirectory = new String(directory);
                while (subDirectory.contains("/")) {
                    subDirectory = subDirectory.substring(0, subDirectory.lastIndexOf("/"));
                    repositoryDirectories.add(subDirectory);
                }
            }
        }
    }

    protected List<Refactoring> detectRefactorings(RefactoringHandler handler, File projectFolder, String cloneURL, String currentCommitId) {
        List<Refactoring> refactoringsAtRevision = Collections.emptyList();
        try {
            ChangedFileInfo changedFileInfo = this.populateWithGitHubAPI(projectFolder, cloneURL, currentCommitId);
            String parentCommitId = changedFileInfo.getParentCommitId();
            List<String> filesBefore = changedFileInfo.getFilesBefore();
            List<String> filesCurrent = changedFileInfo.getFilesCurrent();
            Map<String, String> renamedFilesHint = changedFileInfo.getRenamedFilesHint();
            File currentFolder = new File(projectFolder.getParentFile(), projectFolder.getName() + "-" + currentCommitId);
            File parentFolder = new File(projectFolder.getParentFile(), projectFolder.getName() + "-" + parentCommitId);
            if (!currentFolder.exists()) {
                this.downloadAndExtractZipFile(projectFolder, cloneURL, currentCommitId);
            }
            if (!parentFolder.exists()) {
                this.downloadAndExtractZipFile(projectFolder, cloneURL, parentCommitId);
            }
            LinkedHashSet<String> repositoryDirectoriesBefore = new LinkedHashSet<String>();
            LinkedHashSet<String> repositoryDirectoriesCurrent = new LinkedHashSet<String>();
            LinkedHashMap<String, String> fileContentsBefore = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> fileContentsCurrent = new LinkedHashMap<String, String>();
            if (currentFolder.exists() && parentFolder.exists()) {
                this.populateFileContents(currentFolder, filesCurrent, fileContentsCurrent, repositoryDirectoriesCurrent);
                this.populateFileContents(parentFolder, filesBefore, fileContentsBefore, repositoryDirectoriesBefore);
                List<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = GitHistoryRefactoringMinerImpl.processIdenticalFiles(fileContentsBefore, fileContentsCurrent, renamedFilesHint);
                UMLModel parentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsBefore, repositoryDirectoriesBefore);
                UMLModel currentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsCurrent, repositoryDirectoriesCurrent);
                UMLModelDiff modelDiff = parentUMLModel.diff(currentUMLModel);
                refactoringsAtRevision = modelDiff.getRefactorings();
                refactoringsAtRevision.addAll(moveSourceFolderRefactorings);
                refactoringsAtRevision = this.filter(refactoringsAtRevision);
            } else {
                logger.warn(String.format("Folder %s not found", currentFolder.getPath()));
            }
        }
        catch (Exception e) {
            logger.warn(String.format("Ignored revision %s due to error", currentCommitId), (Throwable)e);
            handler.handleException(currentCommitId, e);
        }
        handler.handle(currentCommitId, refactoringsAtRevision);
        return refactoringsAtRevision;
    }

    private void populateFileContents(File projectFolder, List<String> filePaths, Map<String, String> fileContents, Set<String> repositoryDirectories) throws IOException {
        for (String path : filePaths) {
            String fullPath = projectFolder + File.separator + path.replaceAll("/", systemFileSeparator);
            String contents = FileUtils.readFileToString((File)new File(fullPath));
            fileContents.put(path, contents);
            String directory = new String(path);
            while (directory.contains("/")) {
                directory = directory.substring(0, directory.lastIndexOf("/"));
                repositoryDirectories.add(directory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndExtractZipFile(File projectFolder, String cloneURL, String commitId) throws IOException {
        String downloadLink = GitHistoryRefactoringMinerImpl.extractDownloadLink(cloneURL, commitId);
        File destinationFile = new File(projectFolder.getParentFile(), projectFolder.getName() + "-" + commitId + ".zip");
        logger.info(String.format("Downloading archive %s", downloadLink));
        FileUtils.copyURLToFile((URL)new URL(downloadLink), (File)destinationFile);
        logger.info(String.format("Unzipping archive %s", downloadLink));
        try (ZipFile zipFile = new ZipFile(destinationFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(projectFolder.getParentFile(), entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
    }

    private ChangedFileInfo populateWithGitHubAPI(File projectFolder, String cloneURL, String currentCommitId) throws IOException {
        logger.info("Processing {} {} ...", (Object)cloneURL, (Object)currentCommitId);
        String jsonFilePath = projectFolder.getName() + "-" + currentCommitId + ".json";
        File jsonFile = new File(projectFolder.getParent(), jsonFilePath);
        if (jsonFile.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            ChangedFileInfo changedFileInfo = (ChangedFileInfo)mapper.readValue(jsonFile, ChangedFileInfo.class);
            return changedFileInfo;
        }
        GHRepository repository = this.getGitHubRepository(cloneURL);
        ArrayList<GHCommit.File> commitFiles = new ArrayList<GHCommit.File>();
        GHCommit commit = new GHRepositoryWrapper(repository).getCommit(currentCommitId, commitFiles);
        String parentCommitId = ((GHCommit)commit.getParents().get(0)).getSHA1();
        ArrayList<String> filesBefore = new ArrayList<String>();
        ArrayList<String> filesCurrent = new ArrayList<String>();
        HashMap<String, String> renamedFilesHint = new HashMap<String, String>();
        for (GHCommit.File commitFile : commitFiles) {
            if (!commitFile.getFileName().endsWith(".java")) continue;
            if (commitFile.getStatus().equals("modified")) {
                filesBefore.add(commitFile.getFileName());
                filesCurrent.add(commitFile.getFileName());
                continue;
            }
            if (commitFile.getStatus().equals("added")) {
                filesCurrent.add(commitFile.getFileName());
                continue;
            }
            if (commitFile.getStatus().equals("removed")) {
                filesBefore.add(commitFile.getFileName());
                continue;
            }
            if (!commitFile.getStatus().equals("renamed")) continue;
            filesBefore.add(commitFile.getPreviousFilename());
            filesCurrent.add(commitFile.getFileName());
            renamedFilesHint.put(commitFile.getPreviousFilename(), commitFile.getFileName());
        }
        ChangedFileInfo changedFileInfo = new ChangedFileInfo(parentCommitId, filesBefore, filesCurrent, renamedFilesHint);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(jsonFile, (Object)changedFileInfo);
        return changedFileInfo;
    }

    private GitHub connectToGitHub() {
        if (this.gitHub == null) {
            try {
                Properties prop = new Properties();
                FileInputStream input = new FileInputStream("github-oauth.properties");
                prop.load(input);
                String oAuthToken = prop.getProperty("OAuthToken");
                if (oAuthToken != null) {
                    this.gitHub = GitHub.connectUsingOAuth((String)oAuthToken);
                    if (this.gitHub.isCredentialValid()) {
                        logger.info("Connected to GitHub with OAuth token");
                    }
                } else {
                    this.gitHub = GitHub.connect();
                }
            }
            catch (FileNotFoundException e) {
                logger.warn("File github-oauth.properties was not found in RefactoringMiner's execution directory", (Throwable)e);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.gitHub;
    }

    protected List<Refactoring> filter(List<Refactoring> refactoringsAtRevision) {
        if (this.refactoringTypesToConsider == null) {
            return refactoringsAtRevision;
        }
        ArrayList<Refactoring> filteredList = new ArrayList<Refactoring>();
        for (Refactoring ref : refactoringsAtRevision) {
            if (!this.refactoringTypesToConsider.contains((Object)ref.getRefactoringType())) continue;
            filteredList.add(ref);
        }
        return filteredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectAll(Repository repository, String branch, final RefactoringHandler handler) throws Exception {
        GitServiceImpl gitService = new GitServiceImpl(){

            @Override
            public boolean isCommitAnalyzed(String sha1) {
                return handler.skipCommit(sha1);
            }
        };
        RevWalk walk = gitService.createAllRevsWalk(repository, branch);
        try {
            this.detect(gitService, repository, handler, walk.iterator());
        }
        finally {
            walk.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndDetectNew(Repository repository, final RefactoringHandler handler) throws Exception {
        GitServiceImpl gitService = new GitServiceImpl(){

            @Override
            public boolean isCommitAnalyzed(String sha1) {
                return handler.skipCommit(sha1);
            }
        };
        RevWalk walk = gitService.fetchAndCreateNewRevsWalk(repository);
        try {
            this.detect(gitService, repository, handler, walk.iterator());
        }
        finally {
            walk.dispose();
        }
    }

    public static UMLModel createModel(Map<String, String> fileContents, Set<String> repositoryDirectories) throws Exception {
        return new UMLModelASTReader(fileContents, repositoryDirectories).getUmlModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectAtCommit(Repository repository, String commitId, RefactoringHandler handler) {
        String cloneURL = repository.getConfig().getString("remote", "origin", "url");
        File metadataFolder = repository.getDirectory();
        File projectFolder = metadataFolder.getParentFile();
        GitServiceImpl gitService = new GitServiceImpl();
        RevWalk walk = new RevWalk(repository);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)repository.resolve(commitId));
            if (commit.getParentCount() > 0) {
                walk.parseCommit((AnyObjectId)commit.getParent(0));
                this.detectRefactorings(gitService, repository, handler, commit);
            } else {
                logger.warn(String.format("Ignored revision %s because it has no parent", commitId));
            }
        }
        catch (MissingObjectException moe) {
            this.detectRefactorings(handler, projectFolder, cloneURL, commitId);
        }
        catch (RefactoringMinerTimedOutException e) {
            logger.warn(String.format("Ignored revision %s due to timeout", commitId), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(String.format("Ignored revision %s due to error", commitId), (Throwable)e);
            handler.handleException(commitId, e);
        }
        finally {
            walk.close();
            walk.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectAtCommit(Repository repository, String commitId, RefactoringHandler handler, int timeout) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<?> f = null;
        try {
            Runnable r = () -> this.detectAtCommit(repository, commitId, handler);
            f = service.submit(r);
            f.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            f.cancel(true);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public String getConfigId() {
        return "RM1";
    }

    @Override
    public void detectBetweenTags(Repository repository, String startTag, String endTag, final RefactoringHandler handler) throws Exception {
        GitServiceImpl gitService = new GitServiceImpl(){

            @Override
            public boolean isCommitAnalyzed(String sha1) {
                return handler.skipCommit(sha1);
            }
        };
        Iterable<RevCommit> walk = gitService.createRevsWalkBetweenTags(repository, startTag, endTag);
        this.detect(gitService, repository, handler, walk.iterator());
    }

    @Override
    public void detectBetweenCommits(Repository repository, String startCommitId, String endCommitId, final RefactoringHandler handler) throws Exception {
        GitServiceImpl gitService = new GitServiceImpl(){

            @Override
            public boolean isCommitAnalyzed(String sha1) {
                return handler.skipCommit(sha1);
            }
        };
        Iterable<RevCommit> walk = gitService.createRevsWalkBetweenCommits(repository, startCommitId, endCommitId);
        this.detect(gitService, repository, handler, walk.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Churn churnAtCommit(Repository repository, String commitId, RefactoringHandler handler) {
        GitServiceImpl gitService = new GitServiceImpl();
        RevWalk walk = new RevWalk(repository);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)repository.resolve(commitId));
            if (commit.getParentCount() > 0) {
                walk.parseCommit((AnyObjectId)commit.getParent(0));
                Churn churn = gitService.churn(repository, commit);
                return churn;
            }
            logger.warn(String.format("Ignored revision %s because it has no parent", commitId));
        }
        catch (MissingObjectException moe) {
            logger.warn(String.format("Ignored revision %s due to missing commit", commitId), (Throwable)moe);
        }
        catch (Exception e) {
            logger.warn(String.format("Ignored revision %s due to error", commitId), (Throwable)e);
            handler.handleException(commitId, e);
        }
        finally {
            walk.close();
            walk.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectAtCommit(String gitURL, String commitId, RefactoringHandler handler, int timeout) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<?> f = null;
        try {
            Runnable r = () -> this.detectRefactorings(handler, gitURL, commitId);
            f = service.submit(r);
            f.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            f.cancel(true);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    protected List<Refactoring> detectRefactorings(RefactoringHandler handler, String gitURL, String currentCommitId) {
        List<Refactoring> refactoringsAtRevision = Collections.emptyList();
        try {
            ConcurrentHashMap.KeySetView repositoryDirectoriesBefore = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap.KeySetView repositoryDirectoriesCurrent = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap<String, String> fileContentsBefore = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> fileContentsCurrent = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> renamedFilesHint = new ConcurrentHashMap<String, String>();
            this.populateWithGitHubAPI(gitURL, currentCommitId, fileContentsBefore, fileContentsCurrent, renamedFilesHint, repositoryDirectoriesBefore, repositoryDirectoriesCurrent);
            List<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = GitHistoryRefactoringMinerImpl.processIdenticalFiles(fileContentsBefore, fileContentsCurrent, renamedFilesHint);
            UMLModel currentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsCurrent, repositoryDirectoriesCurrent);
            UMLModel parentUMLModel = GitHistoryRefactoringMinerImpl.createModel(fileContentsBefore, repositoryDirectoriesBefore);
            UMLModelDiff modelDiff = parentUMLModel.diff(currentUMLModel);
            refactoringsAtRevision = modelDiff.getRefactorings();
            refactoringsAtRevision.addAll(moveSourceFolderRefactorings);
            refactoringsAtRevision = this.filter(refactoringsAtRevision);
        }
        catch (RefactoringMinerTimedOutException e) {
            logger.warn(String.format("Ignored revision %s due to timeout", currentCommitId), (Throwable)e);
            handler.handleException(currentCommitId, e);
        }
        catch (Exception e) {
            logger.warn(String.format("Ignored revision %s due to error", currentCommitId), (Throwable)e);
            handler.handleException(currentCommitId, e);
        }
        handler.handle(currentCommitId, refactoringsAtRevision);
        return refactoringsAtRevision;
    }

    private void populateWithGitHubAPI(String cloneURL, String currentCommitId, Map<String, String> filesBefore, Map<String, String> filesCurrent, Map<String, String> renamedFilesHint, Set<String> repositoryDirectoriesBefore, Set<String> repositoryDirectoriesCurrent) throws IOException, InterruptedException {
        logger.info("Processing {} {} ...", (Object)cloneURL, (Object)currentCommitId);
        GHRepository repository = this.getGitHubRepository(cloneURL);
        ArrayList<GHCommit.File> commitFiles = new ArrayList<GHCommit.File>();
        GHCommit currentCommit = new GHRepositoryWrapper(repository).getCommit(currentCommitId, commitFiles);
        String parentCommitId = ((GHCommit)currentCommit.getParents().get(0)).getSHA1();
        ConcurrentHashMap.KeySetView deletedAndRenamedFileParentDirectories = ConcurrentHashMap.newKeySet();
        ExecutorService pool = Executors.newFixedThreadPool(commitFiles.size());
        for (GHCommit.File commitFile : commitFiles) {
            Runnable r;
            String fileName = commitFile.getFileName();
            if (!commitFile.getFileName().endsWith(".java")) continue;
            if (commitFile.getStatus().equals("modified")) {
                r = () -> {
                    try {
                        URL currentRawURL = commitFile.getRawUrl();
                        InputStream currentRawFileInputStream = currentRawURL.openStream();
                        String currentRawFile = IOUtils.toString((InputStream)currentRawFileInputStream);
                        String rawURLInParentCommit = currentRawURL.toString().replace(currentCommitId, parentCommitId);
                        InputStream parentRawFileInputStream = new URL(rawURLInParentCommit).openStream();
                        String parentRawFile = IOUtils.toString((InputStream)parentRawFileInputStream);
                        filesBefore.put(fileName, parentRawFile);
                        filesCurrent.put(fileName, currentRawFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                };
                pool.submit(r);
                continue;
            }
            if (commitFile.getStatus().equals("added")) {
                r = () -> {
                    try {
                        URL currentRawURL = commitFile.getRawUrl();
                        InputStream currentRawFileInputStream = currentRawURL.openStream();
                        String currentRawFile = IOUtils.toString((InputStream)currentRawFileInputStream);
                        filesCurrent.put(fileName, currentRawFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                };
                pool.submit(r);
                continue;
            }
            if (commitFile.getStatus().equals("removed")) {
                r = () -> {
                    try {
                        URL rawURL = commitFile.getRawUrl();
                        InputStream rawFileInputStream = rawURL.openStream();
                        String rawFile = IOUtils.toString((InputStream)rawFileInputStream);
                        filesBefore.put(fileName, rawFile);
                        if (fileName.contains("/")) {
                            deletedAndRenamedFileParentDirectories.add(fileName.substring(0, fileName.lastIndexOf("/")));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                };
                pool.submit(r);
                continue;
            }
            if (!commitFile.getStatus().equals("renamed")) continue;
            r = () -> {
                try {
                    String previousFilename = commitFile.getPreviousFilename();
                    URL currentRawURL = commitFile.getRawUrl();
                    InputStream currentRawFileInputStream = currentRawURL.openStream();
                    String currentRawFile = IOUtils.toString((InputStream)currentRawFileInputStream);
                    String rawURLInParentCommit = currentRawURL.toString().replace(currentCommitId, parentCommitId).replace(fileName, previousFilename);
                    InputStream parentRawFileInputStream = new URL(rawURLInParentCommit).openStream();
                    String parentRawFile = IOUtils.toString((InputStream)parentRawFileInputStream);
                    filesBefore.put(previousFilename, parentRawFile);
                    filesCurrent.put(fileName, currentRawFile);
                    renamedFilesHint.put(previousFilename, fileName);
                    if (previousFilename.contains("/")) {
                        deletedAndRenamedFileParentDirectories.add(previousFilename.substring(0, previousFilename.lastIndexOf("/")));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            pool.submit(r);
        }
        pool.shutdown();
        pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.repositoryDirectories(currentCommit.getTree(), "", repositoryDirectoriesCurrent, deletedAndRenamedFileParentDirectories);
        repositoryDirectoriesCurrent.addAll(deletedAndRenamedFileParentDirectories);
    }

    private void repositoryDirectories(GHTree tree, String pathFromRoot, Set<String> repositoryDirectories, Set<String> targetPaths) throws IOException {
        for (GHTreeEntry entry : tree.getTree()) {
            Object path = null;
            path = pathFromRoot.equals("") ? entry.getPath() : pathFromRoot + "/" + entry.getPath();
            if (!this.atLeastOneStartsWith(targetPaths, (String)path)) continue;
            if (targetPaths.contains(path)) {
                repositoryDirectories.add((String)path);
                continue;
            }
            repositoryDirectories.add((String)path);
            GHTree asTree = entry.asTree();
            if (asTree == null) continue;
            this.repositoryDirectories(asTree, (String)path, repositoryDirectories, targetPaths);
        }
    }

    private boolean atLeastOneStartsWith(Set<String> targetPaths, String path) {
        for (String targetPath : targetPaths) {
            if (path.endsWith("/") && targetPath.startsWith(path)) {
                return true;
            }
            if (path.endsWith("/") || !targetPath.startsWith(path + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void detectAtPullRequest(String cloneURL, int pullRequestId, RefactoringHandler handler, int timeout) throws IOException {
        GHRepository repository = this.getGitHubRepository(cloneURL);
        GHPullRequest pullRequest = repository.getPullRequest(pullRequestId);
        PagedIterable commits = pullRequest.listCommits();
        for (GHPullRequestCommitDetail commit : commits) {
            this.detectAtCommit(cloneURL, commit.getSha(), handler, timeout);
        }
    }

    public GHRepository getGitHubRepository(String cloneURL) throws IOException {
        GitHub gitHub = this.connectToGitHub();
        String repoName = GitHistoryRefactoringMinerImpl.extractRepositoryName(cloneURL);
        return gitHub.getRepository(repoName);
    }

    private static String extractRepositoryName(String cloneURL) {
        int hostLength = 0;
        if (cloneURL.startsWith(GITHUB_URL)) {
            hostLength = GITHUB_URL.length();
        } else if (cloneURL.startsWith(BITBUCKET_URL)) {
            hostLength = BITBUCKET_URL.length();
        }
        int indexOfDotGit = cloneURL.length();
        if (cloneURL.endsWith(".git")) {
            indexOfDotGit = cloneURL.indexOf(".git");
        } else if (cloneURL.endsWith("/")) {
            indexOfDotGit = cloneURL.length() - 1;
        }
        String repoName = cloneURL.substring(hostLength, indexOfDotGit);
        return repoName;
    }

    public static String extractCommitURL(String cloneURL, String commitId) {
        int indexOfDotGit = cloneURL.length();
        if (cloneURL.endsWith(".git")) {
            indexOfDotGit = cloneURL.indexOf(".git");
        } else if (cloneURL.endsWith("/")) {
            indexOfDotGit = cloneURL.length() - 1;
        }
        String commitResource = "/";
        if (cloneURL.startsWith(GITHUB_URL)) {
            commitResource = "/commit/";
        } else if (cloneURL.startsWith(BITBUCKET_URL)) {
            commitResource = "/commits/";
        }
        String commitURL = cloneURL.substring(0, indexOfDotGit) + commitResource + commitId;
        return commitURL;
    }

    private static String extractDownloadLink(String cloneURL, String commitId) {
        int indexOfDotGit = cloneURL.length();
        if (cloneURL.endsWith(".git")) {
            indexOfDotGit = cloneURL.indexOf(".git");
        } else if (cloneURL.endsWith("/")) {
            indexOfDotGit = cloneURL.length() - 1;
        }
        String downloadResource = "/";
        if (cloneURL.startsWith(GITHUB_URL)) {
            downloadResource = "/archive/";
        } else if (cloneURL.startsWith(BITBUCKET_URL)) {
            downloadResource = "/get/";
        }
        String downloadLink = cloneURL.substring(0, indexOfDotGit) + downloadResource + commitId + ".zip";
        return downloadLink;
    }

    public static class ChangedFileInfo {
        private String parentCommitId;
        private List<String> filesBefore;
        private List<String> filesCurrent;
        private Map<String, String> renamedFilesHint;

        public ChangedFileInfo() {
        }

        public ChangedFileInfo(String parentCommitId, List<String> filesBefore, List<String> filesCurrent, Map<String, String> renamedFilesHint) {
            this.filesBefore = filesBefore;
            this.filesCurrent = filesCurrent;
            this.renamedFilesHint = renamedFilesHint;
            this.parentCommitId = parentCommitId;
        }

        public String getParentCommitId() {
            return this.parentCommitId;
        }

        public List<String> getFilesBefore() {
            return this.filesBefore;
        }

        public List<String> getFilesCurrent() {
            return this.filesCurrent;
        }

        public Map<String, String> getRenamedFilesHint() {
            return this.renamedFilesHint;
        }
    }
}

