/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.test;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.refactoringminer.api.GitHistoryRefactoringMiner;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringHandler;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.rm1.GitHistoryRefactoringMinerImpl;
import org.refactoringminer.test.RefactoringPopulator;
import org.refactoringminer.util.GitServiceImpl;

public class TestBuilder {
    private final String tempDir;
    private final Map<String, ProjectMatcher> map = new HashMap<String, ProjectMatcher>();
    private final GitHistoryRefactoringMiner refactoringDetector;
    private boolean verbose;
    private boolean aggregate;
    private int commitsCount;
    private int errorCommitsCount;
    private Counter c;
    private Map<RefactoringType, Counter> cMap;
    private static final int TP = 0;
    private static final int FP = 1;
    private static final int FN = 2;
    private static final int TN = 3;
    private static final int UNK = 4;
    private BigInteger refactoringFilter;

    public TestBuilder(GitHistoryRefactoringMiner detector, String tempDir) {
        this.refactoringDetector = detector;
        this.tempDir = tempDir;
        this.verbose = false;
        this.aggregate = false;
    }

    public TestBuilder(GitHistoryRefactoringMiner detector, String tempDir, BigInteger refactorings) {
        this(detector, tempDir);
        this.refactoringFilter = refactorings;
    }

    public TestBuilder verbose() {
        this.verbose = true;
        return this;
    }

    public TestBuilder withAggregation() {
        this.aggregate = true;
        return this;
    }

    private void count(int type, String refactoring) {
        int n = type;
        this.c.c[n] = this.c.c[n] + 1;
        RefactoringType refType = RefactoringType.extractFromDescription(refactoring);
        Counter refTypeCounter = this.cMap.get((Object)refType);
        if (refTypeCounter == null) {
            refTypeCounter = new Counter();
            this.cMap.put(refType, refTypeCounter);
        }
        int n2 = type;
        refTypeCounter.c[n2] = refTypeCounter.c[n2] + 1;
    }

    private int get(int type) {
        return this.c.c[type];
    }

    private int get(int type, Counter counter) {
        return counter.c[type];
    }

    public TestBuilder() {
        this(new GitHistoryRefactoringMinerImpl(), "tmp");
    }

    public final ProjectMatcher project(String cloneUrl, String branch) {
        ProjectMatcher projectMatcher = this.map.get(cloneUrl);
        if (projectMatcher == null) {
            projectMatcher = new ProjectMatcher(cloneUrl, branch);
            this.map.put(cloneUrl, projectMatcher);
        }
        return projectMatcher;
    }

    public void assertExpectations(int expectedTPs, int expectedFPs, int expectedFNs) throws Exception {
        boolean bl;
        this.c = new Counter();
        this.cMap = new HashMap<RefactoringType, Counter>();
        this.commitsCount = 0;
        this.errorCommitsCount = 0;
        GitServiceImpl gitService = new GitServiceImpl();
        for (ProjectMatcher projectMatcher : this.map.values()) {
            String folder = this.tempDir + "/" + projectMatcher.cloneUrl.substring(projectMatcher.cloneUrl.lastIndexOf(47) + 1, projectMatcher.cloneUrl.lastIndexOf(46));
            Repository rep = gitService.cloneIfNotExists(folder, projectMatcher.cloneUrl);
            try {
                if (projectMatcher.ignoreNonSpecifiedCommits) {
                    for (String commitId : projectMatcher.getCommits()) {
                        this.refactoringDetector.detectAtCommit(rep, commitId, projectMatcher);
                    }
                    continue;
                }
                this.refactoringDetector.detectAll(rep, projectMatcher.branch, projectMatcher);
            }
            finally {
                if (rep == null) continue;
                rep.close();
            }
        }
        System.out.println(String.format("Commits: %d  Errors: %d", this.commitsCount, this.errorCommitsCount));
        String mainResultMessage = this.buildResultMessage(this.c);
        System.out.println("Total  " + mainResultMessage);
        for (RefactoringType refType : RefactoringType.values()) {
            Counter refTypeCounter = this.cMap.get((Object)refType);
            if (refTypeCounter == null) continue;
            System.out.println(String.format("%-7s", refType.getAbbreviation()) + this.buildResultMessage(refTypeCounter));
        }
        boolean bl2 = bl = this.get(1) == expectedFPs && this.get(2) == expectedFNs && this.get(0) == expectedTPs;
        if (!bl || this.verbose) {
            for (ProjectMatcher m : this.map.values()) {
                m.printResults();
            }
        }
        Assert.assertTrue((String)mainResultMessage, (boolean)bl);
    }

    private String buildResultMessage(Counter c) {
        double precision = (double)this.get(0, c) / (double)(this.get(0, c) + this.get(1, c));
        double recall = (double)this.get(0, c) / (double)(this.get(0, c) + this.get(2, c));
        String mainResultMessage = String.format("TP: %2d  FP: %2d  FN: %2d  TN: %2d  Unk.: %2d  Prec.: %.3f  Recall: %.3f", this.get(0, c), this.get(1, c), this.get(2, c), this.get(3, c), this.get(4, c), precision, recall);
        return mainResultMessage;
    }

    private List<String> normalize(String refactoring) {
        RefactoringType refType = RefactoringType.extractFromDescription(refactoring);
        refactoring = TestBuilder.normalizeSingle(refactoring);
        if (this.aggregate) {
            refactoring = refType.aggregate(refactoring);
        } else {
            int begin = refactoring.indexOf("from classes [");
            if (begin != -1) {
                int end = refactoring.lastIndexOf(93);
                String types = refactoring.substring(begin + "from classes [".length(), end);
                String[] typesArray = types.split(", ");
                ArrayList<String> refactorings = new ArrayList<String>();
                for (String type : typesArray) {
                    refactorings.add(refactoring.substring(0, begin) + "from class " + type);
                }
                return refactorings;
            }
        }
        return Collections.singletonList(refactoring);
    }

    private static String normalizeSingle(String refactoring) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < refactoring.length(); ++i) {
            char c = refactoring.charAt(i);
            if (c == '\t') {
                c = ' ';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public class ProjectMatcher
    extends RefactoringHandler {
        private final String cloneUrl;
        private final String branch;
        private Map<String, CommitMatcher> expected = new HashMap<String, CommitMatcher>();
        private boolean ignoreNonSpecifiedCommits = true;
        private int truePositiveCount = 0;
        private int falsePositiveCount = 0;
        private int falseNegativeCount = 0;
        private int trueNegativeCount = 0;
        private int unknownCount = 0;

        private ProjectMatcher(String cloneUrl, String branch) {
            this.cloneUrl = cloneUrl;
            this.branch = branch;
        }

        public ProjectMatcher atNonSpecifiedCommitsContainsNothing() {
            this.ignoreNonSpecifiedCommits = false;
            return this;
        }

        public CommitMatcher atCommit(String commitId) {
            CommitMatcher m = this.expected.get(commitId);
            if (m == null) {
                m = new CommitMatcher();
                this.expected.put(commitId, m);
            }
            return m;
        }

        public Set<String> getCommits() {
            return this.expected.keySet();
        }

        @Override
        public boolean skipCommit(String commitId) {
            if (this.ignoreNonSpecifiedCommits) {
                return !this.expected.containsKey(commitId);
            }
            return false;
        }

        @Override
        public void handle(String commitId, List<Refactoring> refactorings) {
            CommitMatcher matcher;
            refactorings = this.filterRefactoring(refactorings);
            ++TestBuilder.this.commitsCount;
            if (this.expected.containsKey(commitId)) {
                matcher = this.expected.get(commitId);
            } else if (!this.ignoreNonSpecifiedCommits) {
                matcher = this.atCommit(commitId);
                matcher.containsOnly(new String[0]);
            } else {
                matcher = null;
            }
            if (matcher != null) {
                matcher.analyzed = true;
                HashSet<String> refactoringsFound = new HashSet<String>();
                for (Refactoring refactoring : refactorings) {
                    refactoringsFound.addAll(TestBuilder.this.normalize(refactoring.toString()));
                }
                Iterator<String> iter = matcher.expected.iterator();
                while (iter.hasNext()) {
                    String string = iter.next();
                    if (!refactoringsFound.contains(string)) continue;
                    iter.remove();
                    refactoringsFound.remove(string);
                    ++this.truePositiveCount;
                    TestBuilder.this.count(0, string);
                    matcher.truePositive.add(string);
                }
                iter = matcher.notExpected.iterator();
                while (iter.hasNext()) {
                    String string = iter.next();
                    if (refactoringsFound.contains(string)) {
                        refactoringsFound.remove(string);
                        ++this.falsePositiveCount;
                        TestBuilder.this.count(1, string);
                        continue;
                    }
                    ++this.trueNegativeCount;
                    TestBuilder.this.count(3, string);
                    iter.remove();
                }
                if (matcher.ignoreNonSpecified) {
                    for (String string : refactoringsFound) {
                        matcher.unknown.add(string);
                        ++this.unknownCount;
                        TestBuilder.this.count(4, string);
                    }
                } else {
                    for (String string : refactoringsFound) {
                        matcher.notExpected.add(string);
                        ++this.falsePositiveCount;
                        TestBuilder.this.count(1, string);
                    }
                }
                for (String string : matcher.expected) {
                    ++this.falseNegativeCount;
                    TestBuilder.this.count(2, string);
                }
            }
        }

        private List<Refactoring> filterRefactoring(List<Refactoring> refactorings) {
            ArrayList<Refactoring> filteredRefactorings = new ArrayList<Refactoring>();
            for (Refactoring refactoring : refactorings) {
                BigInteger value = Enum.valueOf(RefactoringPopulator.Refactorings.class, refactoring.getName().replace(" ", "")).getValue();
                if (value.and(TestBuilder.this.refactoringFilter).compareTo(BigInteger.ZERO) != 1) continue;
                filteredRefactorings.add(refactoring);
            }
            return filteredRefactorings;
        }

        @Override
        public void handleException(String commitId, Exception e) {
            if (this.expected.containsKey(commitId)) {
                CommitMatcher matcher = this.expected.get(commitId);
                matcher.error = e.toString();
            }
            ++TestBuilder.this.errorCommitsCount;
        }

        private void printResults() {
            String baseUrl = this.cloneUrl.substring(0, this.cloneUrl.length() - 4) + "/commit/";
            for (Map.Entry<String, CommitMatcher> entry : this.expected.entrySet()) {
                String commitUrl = baseUrl + entry.getKey();
                CommitMatcher matcher = entry.getValue();
                if (matcher.error != null) {
                    System.out.println("error at " + commitUrl + ": " + matcher.error);
                    continue;
                }
                if (TestBuilder.this.verbose || !matcher.expected.isEmpty() || !matcher.notExpected.isEmpty() || !matcher.unknown.isEmpty()) {
                    if (!matcher.analyzed) {
                        System.out.println("at not analyzed " + commitUrl);
                    } else {
                        System.out.println("at " + commitUrl);
                    }
                }
                if (TestBuilder.this.verbose && !matcher.truePositive.isEmpty()) {
                    System.out.println(" true positives");
                    for (String ref : matcher.truePositive) {
                        System.out.println("  " + ref);
                    }
                }
                if (!matcher.notExpected.isEmpty()) {
                    System.out.println(" false positives");
                    for (String ref : matcher.notExpected) {
                        System.out.println("  " + ref);
                    }
                }
                if (!matcher.expected.isEmpty()) {
                    System.out.println(" false negatives");
                    for (String ref : matcher.expected) {
                        System.out.println("  " + ref);
                    }
                }
                if (matcher.unknown.isEmpty()) continue;
                System.out.println(" unknown");
                for (String ref : matcher.unknown) {
                    System.out.println("  " + ref);
                }
            }
        }

        public class CommitMatcher {
            private Set<String> expected = new HashSet<String>();
            private Set<String> notExpected = new HashSet<String>();
            private Set<String> truePositive = new HashSet<String>();
            private Set<String> unknown = new HashSet<String>();
            private boolean ignoreNonSpecified = true;
            private boolean analyzed = false;
            private String error = null;

            private CommitMatcher() {
            }

            public ProjectMatcher contains(String ... refactorings) {
                for (String refactoring : refactorings) {
                    this.expected.addAll(TestBuilder.this.normalize(refactoring));
                }
                return ProjectMatcher.this;
            }

            public ProjectMatcher containsOnly(String ... refactorings) {
                this.ignoreNonSpecified = false;
                this.expected = new HashSet<String>();
                this.notExpected = new HashSet<String>();
                for (String refactoring : refactorings) {
                    this.expected.addAll(TestBuilder.this.normalize(refactoring));
                }
                return ProjectMatcher.this;
            }

            public ProjectMatcher containsNothing() {
                return this.containsOnly(new String[0]);
            }

            public ProjectMatcher notContains(String ... refactorings) {
                for (String refactoring : refactorings) {
                    this.notExpected.addAll(TestBuilder.this.normalize(refactoring));
                }
                return ProjectMatcher.this;
            }
        }
    }

    private static class Counter {
        int[] c = new int[5];

        private Counter() {
        }
    }
}

