/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.refactoringminer.api.Churn;
import org.refactoringminer.api.GitService;
import org.refactoringminer.util.ExternalProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitServiceImpl
implements GitService {
    private static final String REMOTE_REFS_PREFIX = "refs/remotes/origin/";
    Logger logger = LoggerFactory.getLogger(GitServiceImpl.class);
    DefaultCommitsFilter commitsFilter = new DefaultCommitsFilter();

    @Override
    public Repository cloneIfNotExists(String projectPath, String cloneUrl) throws Exception {
        Repository repository;
        File folder = new File(projectPath);
        if (folder.exists()) {
            String[] contents = folder.list();
            boolean dotGitFound = false;
            for (String content : contents) {
                if (!content.equals(".git")) continue;
                dotGitFound = true;
                break;
            }
            RepositoryBuilder builder = new RepositoryBuilder();
            repository = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)builder.setGitDir(dotGitFound ? new File(folder, ".git") : folder)).readEnvironment()).findGitDir()).build();
        } else {
            this.logger.info("Cloning {} ...", (Object)cloneUrl);
            Git git = Git.cloneRepository().setDirectory(folder).setURI(cloneUrl).setCloneAllBranches(true).call();
            repository = git.getRepository();
        }
        return repository;
    }

    @Override
    public Repository openRepository(String repositoryPath) throws Exception {
        boolean dotGitFound;
        File folder = new File(repositoryPath);
        if (folder.exists()) {
            String[] contents = folder.list();
            dotGitFound = false;
            for (String content : contents) {
                if (!content.equals(".git")) continue;
                dotGitFound = true;
                break;
            }
        } else {
            throw new FileNotFoundException(repositoryPath);
        }
        RepositoryBuilder builder = new RepositoryBuilder();
        Repository repository = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)builder.setGitDir(dotGitFound ? new File(folder, ".git") : folder)).readEnvironment()).findGitDir()).build();
        return repository;
    }

    @Override
    public void checkout(Repository repository, String commitId) throws Exception {
        this.logger.info("Checking out {} {} ...", (Object)repository.getDirectory().getParent().toString(), (Object)commitId);
        try (Git git = new Git(repository);){
            CheckoutCommand checkout = git.checkout().setName(commitId);
            checkout.call();
        }
    }

    public void checkout2(Repository repository, String commitId) throws Exception {
        this.logger.info("Checking out {} {} ...", (Object)repository.getDirectory().getParent().toString(), (Object)commitId);
        File workingDir = repository.getDirectory().getParentFile();
        String output = ExternalProcess.execute(workingDir, "git", "checkout", commitId);
        if (output.startsWith("fatal")) {
            throw new RuntimeException("git error " + output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countCommits(Repository repository, String branch) throws Exception {
        RevWalk walk = new RevWalk(repository);
        try {
            Ref ref = repository.findRef(REMOTE_REFS_PREFIX + branch);
            ObjectId objectId = ref.getObjectId();
            RevCommit start = walk.parseCommit((AnyObjectId)objectId);
            walk.setRevFilter(RevFilter.NO_MERGES);
            int n = RevWalkUtils.count((RevWalk)walk, (RevCommit)start, null);
            return n;
        }
        finally {
            walk.dispose();
        }
    }

    private List<TrackingRefUpdate> fetch(Repository repository) throws Exception {
        this.logger.info("Fetching changes of repository {}", (Object)repository.getDirectory().toString());
        try (Git git = new Git(repository);){
            FetchResult result = git.fetch().call();
            Collection updates = result.getTrackingRefUpdates();
            ArrayList<TrackingRefUpdate> remoteRefsChanges = new ArrayList<TrackingRefUpdate>();
            for (TrackingRefUpdate update : updates) {
                String refName = update.getLocalName();
                if (!refName.startsWith(REMOTE_REFS_PREFIX)) continue;
                ObjectId newObjectId = update.getNewObjectId();
                this.logger.info("{} is now at {}", (Object)refName, (Object)newObjectId.getName());
                remoteRefsChanges.add(update);
            }
            if (updates.isEmpty()) {
                this.logger.info("Nothing changed");
            }
            ArrayList<TrackingRefUpdate> arrayList = remoteRefsChanges;
            return arrayList;
        }
    }

    @Override
    public RevWalk fetchAndCreateNewRevsWalk(Repository repository) throws Exception {
        return this.fetchAndCreateNewRevsWalk(repository, null);
    }

    @Override
    public RevWalk fetchAndCreateNewRevsWalk(Repository repository, String branch) throws Exception {
        ArrayList<ObjectId> currentRemoteRefs = new ArrayList<ObjectId>();
        for (Ref ref : repository.getRefDatabase().getRefs()) {
            String refName = ref.getName();
            if (!refName.startsWith(REMOTE_REFS_PREFIX)) continue;
            currentRemoteRefs.add(ref.getObjectId());
        }
        List<TrackingRefUpdate> newRemoteRefs = this.fetch(repository);
        RevWalk walk = new RevWalk(repository);
        for (TrackingRefUpdate newRef : newRemoteRefs) {
            if (branch != null && !newRef.getLocalName().endsWith("/" + branch)) continue;
            walk.markStart(walk.parseCommit((AnyObjectId)newRef.getNewObjectId()));
        }
        for (ObjectId oldRef : currentRemoteRefs) {
            walk.markUninteresting(walk.parseCommit((AnyObjectId)oldRef));
        }
        walk.setRevFilter((RevFilter)this.commitsFilter);
        return walk;
    }

    @Override
    public RevWalk createAllRevsWalk(Repository repository) throws Exception {
        return this.createAllRevsWalk(repository, null);
    }

    @Override
    public RevWalk createAllRevsWalk(Repository repository, String branch) throws Exception {
        ArrayList<ObjectId> currentRemoteRefs = new ArrayList<ObjectId>();
        for (Ref ref : repository.getRefDatabase().getRefs()) {
            String refName = ref.getName();
            if (!refName.startsWith(REMOTE_REFS_PREFIX) || branch != null && !refName.endsWith("/" + branch)) continue;
            currentRemoteRefs.add(ref.getObjectId());
        }
        RevWalk walk = new RevWalk(repository);
        for (ObjectId newRef : currentRemoteRefs) {
            walk.markStart(walk.parseCommit((AnyObjectId)newRef));
        }
        walk.setRevFilter((RevFilter)this.commitsFilter);
        return walk;
    }

    @Override
    public Iterable<RevCommit> createRevsWalkBetweenTags(Repository repository, String startTag, String endTag) throws Exception {
        Ref refFrom = repository.findRef(startTag);
        Ref refTo = repository.findRef(endTag);
        try (Git git = new Git(repository);){
            List<RevCommit> revCommits = StreamSupport.stream(git.log().addRange((AnyObjectId)this.getActualRefObjectId(refFrom), (AnyObjectId)this.getActualRefObjectId(refTo)).call().spliterator(), false).filter(r -> r.getParentCount() == 1).collect(Collectors.toList());
            Collections.reverse(revCommits);
            List<RevCommit> list = revCommits;
            return list;
        }
    }

    private ObjectId getActualRefObjectId(Ref ref) {
        if (ref.getPeeledObjectId() != null) {
            return ref.getPeeledObjectId();
        }
        return ref.getObjectId();
    }

    @Override
    public Iterable<RevCommit> createRevsWalkBetweenCommits(Repository repository, String startCommitId, String endCommitId) throws Exception {
        ObjectId from = repository.resolve(startCommitId);
        ObjectId to = repository.resolve(endCommitId);
        try (Git git = new Git(repository);){
            List<RevCommit> revCommits = StreamSupport.stream(git.log().addRange((AnyObjectId)from, (AnyObjectId)to).call().spliterator(), false).filter(r -> r.getParentCount() == 1).collect(Collectors.toList());
            Collections.reverse(revCommits);
            List<RevCommit> list = revCommits;
            return list;
        }
    }

    public boolean isCommitAnalyzed(String sha1) {
        return false;
    }

    @Override
    public void fileTreeDiff(Repository repository, RevCommit currentCommit, Set<String> javaFilesBefore, Set<String> javaFilesCurrent, Map<String, String> renamedFilesHint) throws Exception {
        if (currentCommit.getParentCount() > 0) {
            RevTree oldTree = currentCommit.getParent(0).getTree();
            RevTree newTree = currentCommit.getTree();
            TreeWalk tw = new TreeWalk(repository);
            tw.setRecursive(true);
            tw.addTree((AnyObjectId)oldTree);
            tw.addTree((AnyObjectId)newTree);
            RenameDetector rd = new RenameDetector(repository);
            rd.setRenameScore(55);
            rd.addAll((Collection)DiffEntry.scan((TreeWalk)tw));
            for (DiffEntry diff : rd.compute(tw.getObjectReader(), null)) {
                DiffEntry.ChangeType changeType = diff.getChangeType();
                String oldPath = diff.getOldPath();
                String newPath = diff.getNewPath();
                if (changeType != DiffEntry.ChangeType.ADD && this.isJavafile(oldPath)) {
                    javaFilesBefore.add(oldPath);
                }
                if (changeType != DiffEntry.ChangeType.DELETE && this.isJavafile(newPath)) {
                    javaFilesCurrent.add(newPath);
                }
                if (changeType != DiffEntry.ChangeType.RENAME || diff.getScore() < rd.getRenameScore() || !this.isJavafile(oldPath) || !this.isJavafile(newPath)) continue;
                renamedFilesHint.put(oldPath, newPath);
            }
        }
    }

    private boolean isJavafile(String path) {
        return path.endsWith(".java");
    }

    @Override
    public Churn churn(Repository repository, RevCommit currentCommit) throws Exception {
        if (currentCommit.getParentCount() > 0) {
            RevTree oldTree = currentCommit.getParent(0).getTree();
            RevTree newTree = currentCommit.getTree();
            TreeWalk tw = new TreeWalk(repository);
            tw.setRecursive(true);
            tw.addTree((AnyObjectId)oldTree);
            tw.addTree((AnyObjectId)newTree);
            List diffs = DiffEntry.scan((TreeWalk)tw);
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            diffFormatter.setRepository(repository);
            diffFormatter.setContext(0);
            int addedLines = 0;
            int deletedLines = 0;
            for (DiffEntry entry : diffs) {
                FileHeader header = diffFormatter.toFileHeader(entry);
                List hunks = header.getHunks();
                for (HunkHeader hunkHeader : hunks) {
                    for (Edit edit : hunkHeader.toEditList()) {
                        if (edit.getType() == Edit.Type.INSERT) {
                            addedLines += edit.getLengthB();
                            continue;
                        }
                        if (edit.getType() == Edit.Type.DELETE) {
                            deletedLines += edit.getLengthA();
                            continue;
                        }
                        if (edit.getType() != Edit.Type.REPLACE) continue;
                        deletedLines += edit.getLengthA();
                        addedLines += edit.getLengthB();
                    }
                }
            }
            diffFormatter.close();
            return new Churn(addedLines, deletedLines);
        }
        return null;
    }

    private class DefaultCommitsFilter
    extends RevFilter {
        private DefaultCommitsFilter() {
        }

        public final boolean include(RevWalk walker, RevCommit c) {
            return c.getParentCount() == 1 && !GitServiceImpl.this.isCommitAnalyzed(c.getName());
        }

        public final RevFilter clone() {
            return this;
        }

        public final boolean requiresCommitBody() {
            return false;
        }

        public String toString() {
            return "RegularCommitsFilter";
        }
    }
}

